/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.storage.ThreadedFileIOBase;

public class FileUtils {
    public static File newFile(File file) {
        if (!file.exists()) {
            try {
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static void save(File file, Iterable<String> list) throws Exception {
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtils.newFile(file)), StandardCharsets.UTF_8);
        BufferedWriter br = new BufferedWriter(fw);
        for (String s : list) {
            br.write(s);
            br.write(10);
        }
        br.close();
        fw.close();
    }

    public static void save(File file, String string) throws Exception {
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtils.newFile(file)), StandardCharsets.UTF_8);
        BufferedWriter br = new BufferedWriter(fw);
        br.write(string);
        br.close();
        fw.close();
    }

    public static void saveSafe(File file, Iterable<String> list) {
        ThreadedFileIOBase.field_75741_a.func_75735_a(() -> {
            try {
                FileUtils.save(file, list);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        });
    }

    public static void saveSafe(File file, String string) {
        ThreadedFileIOBase.field_75741_a.func_75735_a(() -> {
            try {
                FileUtils.save(file, string);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        });
    }

    public static List<File> listTree(File file) {
        ArrayList<File> l = new ArrayList<File>();
        FileUtils.listTree0(l, file);
        return l;
    }

    public static void listTree0(List<File> list, File file) {
        if (file.isDirectory()) {
            File[] fl = file.listFiles();
            if (fl != null && fl.length > 0) {
                for (File aFl : fl) {
                    FileUtils.listTree0(list, aFl);
                }
            }
        } else if (file.isFile()) {
            list.add(file);
        }
    }

    public static long getSize(File file) {
        return FileUtils.getSize(file, SizeUnit.B);
    }

    public static long getSize(File file, SizeUnit sizeUnit) {
        long l;
        long size = FileUtils.getSize0(file);
        if (size == 0L) {
            return 0L;
        }
        switch (sizeUnit) {
            case KB: {
                l = size / SizeUnit.KB.getSize();
                break;
            }
            case MB: {
                l = size / SizeUnit.MB.getSize();
                break;
            }
            case GB: {
                l = size / SizeUnit.GB.getSize();
                break;
            }
            default: {
                l = size;
            }
        }
        return l;
    }

    private static long getSize0(File file) {
        File[] f1;
        if (!file.exists()) {
            return 0L;
        }
        long size = 0L;
        if (file.isFile()) {
            size += file.length();
        } else if (file.isDirectory() && (f1 = file.listFiles()) != null && f1.length > 0) {
            for (File aF1 : f1) {
                size += FileUtils.getSize0(aF1);
            }
        }
        return size;
    }

    public static String getSizeString(double b) {
        if (b >= (double)SizeUnit.GB.getSize()) {
            return String.format("%.1fGB", b / (double)SizeUnit.GB.getSize());
        }
        if (b >= (double)SizeUnit.MB.getSize()) {
            return String.format("%.1fMB", b / (double)SizeUnit.MB.getSize());
        }
        if (b >= (double)SizeUnit.KB.getSize()) {
            return String.format("%.1fKB", b / (double)SizeUnit.KB.getSize());
        }
        return b + "B";
    }

    public static String getSizeString(File file) {
        return FileUtils.getSizeString(FileUtils.getSize(file));
    }

    public static void copyFile(File src, File dst) throws Exception {
        if (src.exists() && !src.equals(dst)) {
            if (src.isDirectory() && dst.isDirectory()) {
                for (File f : FileUtils.listTree(src)) {
                    File dst1 = new File(dst.getAbsolutePath() + File.separatorChar + f.getAbsolutePath().replace(src.getAbsolutePath(), ""));
                    FileUtils.copyFile(f, dst1);
                }
            } else {
                dst = FileUtils.newFile(dst);
                try (FileInputStream fis = new FileInputStream(src);
                     FileOutputStream fos = new FileOutputStream(dst);
                     FileChannel srcC = fis.getChannel();
                     FileChannel dstC = fos.getChannel();){
                    dstC.transferFrom(srcC, 0L, srcC.size());
                }
            }
        }
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        String[] files = file.list();
        if (files != null) {
            for (String s : files) {
                FileUtils.delete(new File(file, s));
            }
        }
        return file.delete();
    }

    public static void deleteSafe(File file) {
        ThreadedFileIOBase.field_75741_a.func_75735_a(() -> {
            try {
                if (file.exists() && !FileUtils.delete(file)) {
                    System.err.println("Failed to safely delete " + file.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        });
    }

    public static String getBaseName(File file) {
        if (file.isDirectory()) {
            return file.getName();
        }
        String name = file.getName();
        int index = name.lastIndexOf(46);
        return index == -1 ? name : name.substring(0, index);
    }

    public static String getRelativePath(File dir, File file) {
        return dir.getName() + File.separator + file.getAbsolutePath().substring(dir.getAbsolutePath().length() + 1);
    }

    public static enum SizeUnit {
        B(1L),
        KB(SizeUnit.B.size * 1024L),
        MB(SizeUnit.KB.size * 1024L),
        GB(SizeUnit.MB.size * 1024L);

        private final long size;

        private SizeUnit(long size) {
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }
    }
}

