/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.DimensionalCoord;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.IGuiTooltipHandler;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.render.BlockPosHighlighter;
import appeng.container.implementations.ContainerCraftingCPU;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCraftingItemInterface;
import appeng.core.sync.packets.PacketCraftingRemainingOperations;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.lwjgl.opengl.GL11;

public class GuiCraftingCPU
extends AEBaseGui
implements ISortSource,
IGuiTooltipHandler {
    protected static final int GUI_HEIGHT = 184;
    protected static final int GUI_WIDTH = 238;
    protected static final int TEXTURE_BELOW_TOP_ROW_Y = 41;
    protected static final int TEXTURE_ABOVE_BOTTOM_ROW_Y = 51;
    protected static final int DISPLAYED_ROWS = 6;
    protected static final int SECTION_LENGTH = 67;
    protected static final int SECTION_HEIGHT = 23;
    protected static final int SCROLLBAR_TOP = 19;
    protected static final int SCROLLBAR_LEFT = 218;
    protected static final int SCROLLBAR_HEIGHT = 137;
    private static final int CANCEL_LEFT_OFFSET = 163;
    private static final int CANCEL_TOP_OFFSET = 25;
    private static final int CANCEL_HEIGHT = 20;
    private static final int CANCEL_WIDTH = 50;
    private static final int TITLE_TOP_OFFSET = 7;
    private static final int TITLE_LEFT_OFFSET = 8;
    private static final int ITEMSTACK_LEFT_OFFSET = 9;
    private static final int ITEMSTACK_TOP_OFFSET = 22;
    private static final int ITEMS_PER_ROW = 3;
    private final ContainerCraftingCPU craftingCpu;
    protected IItemList<IAEItemStack> storage = AEApi.instance().storage().createItemList();
    protected IItemList<IAEItemStack> active = AEApi.instance().storage().createItemList();
    protected IItemList<IAEItemStack> pending = AEApi.instance().storage().createItemList();
    protected int rows = 6;
    protected List<IAEItemStack> visual = new ArrayList<IAEItemStack>();
    private GuiButton cancel;
    private int tooltip = -1;
    private final RemainingOperations remainingOperations = new RemainingOperations();
    private ItemStack hoveredStack;
    private ItemStack hoveredNbtStack;

    public GuiCraftingCPU(InventoryPlayer inventoryPlayer, Object te) {
        this(new ContainerCraftingCPU(inventoryPlayer, te));
    }

    protected GuiCraftingCPU(ContainerCraftingCPU container) {
        super(container);
        this.craftingCpu = container;
        this.field_147000_g = 184;
        this.field_146999_f = 238;
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
    }

    public void clearItems() {
        this.storage = AEApi.instance().storage().createItemList();
        this.active = AEApi.instance().storage().createItemList();
        this.pending = AEApi.instance().storage().createItemList();
        this.visual = new ArrayList<IAEItemStack>();
    }

    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (this.cancel == btn) {
            try {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("TileCrafting.Cancel", "Cancel"));
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        if (this.hoveredNbtStack != null && GuiCraftingCPU.func_146272_n()) {
            NBTTagCompound data = Platform.openNbtData(this.hoveredNbtStack);
            BlockPosHighlighter.highlightBlocks((EntityPlayer)this.field_146297_k.field_71439_g, DimensionalCoord.readAsListFromNBT(data), PlayerMessages.InterfaceHighlighted.getName(), PlayerMessages.InterfaceInOtherDim.getName());
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.setScrollBar();
        this.cancel = new GuiButton(0, this.field_147003_i + 163, this.field_147009_r + this.field_147000_g - 25, 50, 20, GuiText.Cancel.getLocal());
        this.field_146292_n.add(this.cancel);
    }

    private void setScrollBar() {
        int size = this.visual.size();
        this.getScrollBar().setTop(19).setLeft(218).setHeight(137);
        this.getScrollBar().setRange(0, (size + 2) / 3 - this.rows, 1);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float btn) {
        this.cancel.field_146124_l = !this.visual.isEmpty();
        int gx = (this.field_146294_l - this.field_146999_f) / 2;
        int gy = (this.field_146295_m - this.field_147000_g) / 2;
        this.tooltip = -1;
        int offY = 23;
        int y = 0;
        int x = 0;
        for (int z = 0; z <= 3 * this.rows; ++z) {
            int minX = gx + 9 + x * 67;
            int minY = gy + 22 + y * 23;
            if (minX < mouseX && minX + 67 > mouseX && minY < mouseY && minY + 23 > mouseY) {
                this.tooltip = z;
                break;
            }
            if (++x != 3) continue;
            ++y;
            x = 0;
        }
        this.handleTooltip(mouseX, mouseY, this.remainingOperations);
        super.func_73863_a(mouseX, mouseY, btn);
    }

    private void updateRemainingOperations() {
        int interval = 1000;
        if (this.remainingOperations.getRefreshTick() >= this.remainingOperations.getLastWorkingTick() + (long)interval) {
            try {
                NetworkHandler.instance.sendToServer(new PacketCraftingRemainingOperations());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.remainingOperations.setLastWorkingTick(this.remainingOperations.refreshTick);
        } else {
            this.remainingOperations.setRefreshTick(System.currentTimeMillis());
        }
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        String title = this.getGuiDisplayName(GuiText.CraftingStatus.getLocal());
        if (this.craftingCpu.getElapsedTime() > 0L && !this.visual.isEmpty()) {
            long elapsedInMilliseconds = TimeUnit.MILLISECONDS.convert(this.craftingCpu.getElapsedTime(), TimeUnit.NANOSECONDS);
            String elapsedTimeText = DurationFormatUtils.formatDuration((long)elapsedInMilliseconds, (String)GuiText.ETAFormat.getLocal());
            title = title.length() == 0 ? elapsedTimeText : title + " - " + elapsedTimeText;
        }
        this.updateRemainingOperations();
        this.field_146289_q.func_78276_b(String.valueOf(this.remainingOperations.getRemainingOperations()), 208 - this.remainingOperations.getStringWidth(), 7, GuiColors.CraftingCPUTitle.getColor());
        this.field_146289_q.func_78276_b(title, 8, 7, GuiColors.CraftingCPUTitle.getColor());
        int x = 0;
        int y = 0;
        int viewStart = this.getScrollBar().getCurrentScroll() * 3;
        int viewEnd = viewStart + 3 * this.rows;
        String dspToolTip = "";
        LinkedList<String> lineList = new LinkedList<String>();
        int toolPosX = 0;
        int toolPosY = 0;
        this.hoveredStack = null;
        int offY = 23;
        ReadableNumberConverter converter = ReadableNumberConverter.INSTANCE;
        for (int z = viewStart; z < Math.min(viewEnd, this.visual.size()); ++z) {
            int w;
            IAEItemStack refStack = this.visual.get(z);
            if (refStack == null) continue;
            GL11.glPushMatrix();
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            IAEItemStack stored = this.storage.findPrecise(refStack);
            IAEItemStack activeStack = this.active.findPrecise(refStack);
            IAEItemStack pendingStack = this.pending.findPrecise(refStack);
            int lines = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                ++lines;
            }
            boolean active = false;
            if (activeStack != null && activeStack.getStackSize() > 0L) {
                ++lines;
                active = true;
            }
            boolean scheduled = false;
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                ++lines;
                scheduled = true;
            }
            if (AEConfig.instance.useColoredCraftingStatus && (active || scheduled)) {
                int bgColor = active ? GuiColors.CraftingCPUActive.getColor() : GuiColors.CraftingCPUInactive.getColor();
                int startX = (x * 68 + 9) * 2;
                int startY = (y * 23 + 22 - 3) * 2;
                GuiCraftingCPU.func_73734_a((int)startX, (int)startY, (int)(startX + 134), (int)(startY + 46 - 2), (int)bgColor);
            }
            int negY = (lines - 1) * 5 / 2;
            int downY = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                String str = GuiText.Stored.getLocal() + ": " + converter.toWideReadableForm(stored.getStackSize());
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0), (y * 23 + 22 + 6 - negY + downY) * 2, GuiColors.CraftingCPUStored.getColor());
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Stored.getLocal() + ": " + NumberFormat.getInstance().format(stored.getStackSize()));
                }
                downY += 5;
            }
            if (activeStack != null && activeStack.getStackSize() > 0L) {
                String str = GuiText.Crafting.getLocal() + ": " + converter.toWideReadableForm(activeStack.getStackSize());
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0), (y * 23 + 22 + 6 - negY + downY) * 2, GuiColors.CraftingCPUAmount.getColor());
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Crafting.getLocal() + ": " + NumberFormat.getInstance().format(activeStack.getStackSize()));
                }
                downY += 5;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                String str = GuiText.Scheduled.getLocal() + ": " + converter.toWideReadableForm(pendingStack.getStackSize());
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0), (y * 23 + 22 + 6 - negY + downY) * 2, GuiColors.CraftingCPUScheduled.getColor());
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Scheduled.getLocal() + ": " + NumberFormat.getInstance().format(pendingStack.getStackSize()));
                }
            }
            GL11.glPopMatrix();
            int posX = x * 68 + 9 + 67 - 19;
            int posY = y * 23 + 22;
            ItemStack is = refStack.copy().getItemStack();
            if (this.tooltip == z - viewStart) {
                dspToolTip = Platform.getItemDisplayName(is);
                if (lineList.size() > 0) {
                    this.addItemTooltip(refStack, lineList);
                    dspToolTip = dspToolTip + '\n' + Joiner.on((String)"\n").join(lineList);
                }
                toolPosX = x * 68 + 9 + 67 - 8;
                toolPosY = y * 23 + 22;
                this.hoveredStack = is;
            }
            this.drawItem(posX, posY, is);
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        if (this.tooltip >= 0 && dspToolTip.length() > 0) {
            this.drawTooltip(toolPosX, toolPosY + 10, dspToolTip);
        }
    }

    protected void addItemTooltip(IAEItemStack refStack, List<String> lineList) {
        if (GuiCraftingCPU.func_146272_n()) {
            ItemStack is = refStack.copy().getItemStack();
            List l = is.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
            if (!l.isEmpty()) {
                l.remove(0);
            }
            lineList.addAll(l);
            if (this.hoveredNbtStack == null || this.hoveredNbtStack.func_77973_b() != is.func_77973_b()) {
                this.hoveredNbtStack = is;
                try {
                    NetworkHandler.instance.sendToServer(new PacketCraftingItemInterface(refStack.copy()));
                }
                catch (Exception exception) {}
            } else {
                NBTTagCompound data = Platform.openNbtData(this.hoveredNbtStack);
                List<DimensionalCoord> blocks = DimensionalCoord.readAsListFromNBT(data);
                if (blocks.isEmpty()) {
                    return;
                }
                for (DimensionalCoord blockPos : blocks) {
                    lineList.add(String.format("Dim:%s X:%s Y:%s Z:%s", blockPos.getDimension(), blockPos.x, blockPos.y, blockPos.z));
                }
                lineList.add(GuiText.HoldShiftClick_HIGHLIGHT_INTERFACE.getLocal());
            }
        } else {
            this.hoveredNbtStack = null;
            lineList.add(GuiText.HoldShiftForTooltip.getLocal());
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/craftingcpu.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void postUpdate(IAEItemStack is) {
        this.hoveredNbtStack = is.getItemStack();
    }

    public void postUpdate(int remainingOperations) {
        this.remainingOperations.setRemainingOperations(remainingOperations);
    }

    public void postUpdate(List<IAEItemStack> list, byte ref) {
        switch (ref) {
            case 0: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.storage, l);
                }
                break;
            }
            case 1: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.active, l);
                }
                break;
            }
            case 2: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.pending, l);
                }
                break;
            }
        }
        for (IAEItemStack l : list) {
            long amt = this.getTotal(l);
            if (amt <= 0L) {
                this.deleteVisualStack(l);
                continue;
            }
            IAEItemStack is = this.findVisualStack(l);
            is.setStackSize(amt);
        }
        this.setScrollBar();
    }

    private void handleInput(IItemList<IAEItemStack> s, IAEItemStack l) {
        IAEItemStack a = s.findPrecise(l);
        if (l.getStackSize() <= 0L) {
            if (a != null) {
                a.reset();
            }
        } else {
            if (a == null) {
                s.add(l.copy());
                a = s.findPrecise(l);
            }
            if (a != null) {
                a.setStackSize(l.getStackSize());
            }
        }
    }

    private long getTotal(IAEItemStack is) {
        IAEItemStack a = this.storage.findPrecise(is);
        IAEItemStack b = this.active.findPrecise(is);
        IAEItemStack c = this.pending.findPrecise(is);
        long total = 0L;
        if (a != null) {
            total += a.getStackSize();
        }
        if (b != null) {
            total += b.getStackSize();
        }
        if (c != null) {
            total += c.getStackSize();
        }
        return total;
    }

    private void deleteVisualStack(IAEItemStack l) {
        Iterator<IAEItemStack> i = this.visual.iterator();
        while (i.hasNext()) {
            IAEItemStack o = i.next();
            if (!o.equals(l)) continue;
            i.remove();
            return;
        }
    }

    private IAEItemStack findVisualStack(IAEItemStack l) {
        for (IAEItemStack o : this.visual) {
            if (!o.equals(l)) continue;
            return o;
        }
        IAEItemStack stack = l.copy();
        this.visual.add(stack);
        return stack;
    }

    @Override
    public Enum getSortBy() {
        return SortOrder.NAME;
    }

    @Override
    public Enum getSortDir() {
        return SortDir.ASCENDING;
    }

    @Override
    public Enum getSortDisplay() {
        return ViewItems.ALL;
    }

    @Override
    public ItemStack getHoveredStack() {
        return this.hoveredStack;
    }

    private class RemainingOperations
    implements ITooltip {
        private long refreshTick = System.currentTimeMillis();
        private long lastWorkingTick = 0L;
        private int remainingOperations = 0;

        private RemainingOperations() {
        }

        public long getLastWorkingTick() {
            return this.lastWorkingTick;
        }

        public long getRefreshTick() {
            return this.refreshTick;
        }

        public void setLastWorkingTick(long lastWorkingTick) {
            this.lastWorkingTick = lastWorkingTick;
        }

        public void setRefreshTick(long refreshTick) {
            this.refreshTick = refreshTick;
        }

        @Override
        public String getMessage() {
            return GuiText.RemainingOperations.getLocal();
        }

        @Override
        public int xPos() {
            return GuiCraftingCPU.this.field_147003_i + 8 + 200 - this.getStringWidth();
        }

        @Override
        public int yPos() {
            return GuiCraftingCPU.this.field_147009_r + 7;
        }

        @Override
        public int getWidth() {
            return this.getStringWidth();
        }

        @Override
        public int getHeight() {
            return ((GuiCraftingCPU)GuiCraftingCPU.this).field_146289_q.field_78288_b;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        public void setRemainingOperations(int remainingOperations) {
            this.remainingOperations = remainingOperations;
        }

        public int getRemainingOperations() {
            return this.remainingOperations;
        }

        public int getStringWidth() {
            return GuiCraftingCPU.this.field_146289_q.func_78256_a(String.valueOf(this.remainingOperations));
        }
    }
}

