/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.api.recipes.RecipeManagers;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IGT_ItemWithMaterialRenderer;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.common.items.CombType;
import gregtech.common.items.DropType;
import gregtech.common.items.PropolisType;
import gregtech.common.render.items.GeneratedMaterialRenderer;
import gregtech.loaders.misc.GTBees;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemComb
extends Item
implements IGT_ItemWithMaterialRenderer {
    @SideOnly(value=Side.CLIENT)
    private IIcon secondIcon;

    public ItemComb() {
        this.func_77637_a(Tabs.tabApiculture);
        this.func_77627_a(true);
        this.func_77655_b("gt.comb");
        GameRegistry.registerItem((Item)this, (String)"gt.comb", (String)Mods.GregTech.ID);
    }

    public ItemStack getStackForType(CombType type) {
        return new ItemStack((Item)this, 1, type.getId());
    }

    public ItemStack getStackForType(CombType type, int count) {
        return new ItemStack((Item)this, count, type.getId());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List<ItemStack> list) {
        for (CombType type : CombType.values()) {
            if (!type.showInList) continue;
            list.add(this.getStackForType(type));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @Override
    public int getRenderPasses(int meta) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("forestry:beeCombs.0");
        this.secondIcon = iconRegister.func_94245_a("forestry:beeCombs.1");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return pass == 0 ? this.field_77791_bV : this.secondIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        CombType type = CombType.valueOf(stack.func_77960_j());
        return type.getColours()[GTUtility.clamp(pass, 0, 1)];
    }

    public String func_77653_i(ItemStack stack) {
        return CombType.valueOf(stack.func_77960_j()).getName();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean debugInfo) {
        tooltip.add(EnumChatFormatting.DARK_RED + "Forestry can't process it");
    }

    @Override
    public boolean shouldUseCustomRenderer(int aMetaData) {
        return CombType.valueOf((int)aMetaData).material.renderer != null;
    }

    @Override
    public GeneratedMaterialRenderer getMaterialRenderer(int aMetaData) {
        return CombType.valueOf((int)aMetaData).material.renderer;
    }

    @Override
    public boolean allowMaterialRenderer(int aMetaData) {
        return true;
    }

    @Override
    public IIcon getIcon(int aMetaData, int pass) {
        return pass == 0 ? this.field_77791_bV : this.secondIcon;
    }

    @Override
    public IIcon getOverlayIcon(int aMetaData, int pass) {
        return null;
    }

    @Override
    public short[] getRGBa(ItemStack aStack) {
        return CombType.valueOf((int)aStack.func_77960_j()).material.mRGBa;
    }

    public void initCombsRecipes() {
        this.addProcessGT(CombType.LIGNIE, new Materials[]{Materials.Lignite}, Voltage.LV);
        this.addProcessGT(CombType.COAL, new Materials[]{Materials.Coal}, Voltage.LV);
        this.addCentrifugeToItemStack(CombType.STICKY, new ItemStack[]{ItemList.IC2_Resin.get(1L, new Object[0]), ItemList.IC2_Plantball.get(1L, new Object[0]), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{5000, 1500, 5000}, Voltage.ULV);
        this.addProcessGT(CombType.OIL, new Materials[]{Materials.Oilsands}, Voltage.LV);
        this.addProcessGT(CombType.APATITE, new Materials[]{Materials.Apatite}, Voltage.LV);
        this.addCentrifugeToMaterial(CombType.ASH, new Materials[]{Materials.DarkAsh, Materials.Ash}, new int[]{5000, 5000}, new int[0], Voltage.ULV, GTValues.NI, 5000);
        this.addCentrifugeToItemStack(CombType.PHOSPHORUS, new ItemStack[]{Materials.Phosphorus.getDust(1), Materials.TricalciumPhosphate.getDust(2), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{10000, 10000, 10000}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.MICA, new ItemStack[]{Materials.Mica.getDust(2), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{10000, 7500}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.LIGNIE, new ItemStack[]{GTOreDictUnificator.get(OrePrefixes.gem, Materials.Lignite, 1L), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{9000, 5000}, Voltage.ULV);
        this.addCentrifugeToItemStack(CombType.COAL, new ItemStack[]{GTOreDictUnificator.get(OrePrefixes.gem, Materials.Coal, 1L), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 5000}, Voltage.ULV);
        this.addCentrifugeToItemStack(CombType.OIL, new ItemStack[]{ItemList.Crop_Drop_OilBerry.get(6L, new Object[0]), GTBees.drop.getStackForType(DropType.OIL), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{10000, 10000, 5000}, Voltage.ULV);
        this.addCentrifugeToItemStack(CombType.COOLANT, new ItemStack[]{GTBees.drop.getStackForType(DropType.COOLANT), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{10000, 10000}, Voltage.HV, 196);
        this.addCentrifugeToItemStack(CombType.ENERGY, new ItemStack[]{GTBees.drop.getStackForType(DropType.HOT_COOLANT), ItemList.IC2_Energium_Dust.get(1L, new Object[0]), ItemList.FR_RefractoryWax.get(1L, new Object[0])}, new int[]{2000, 2000, 5000}, Voltage.HV, 196);
        this.addCentrifugeToItemStack(CombType.LAPOTRON, new ItemStack[]{GTBees.drop.getStackForType(DropType.LAPIS), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.LapotronDust", 1L, 0), GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 2)}, new int[]{2000, 10000, 4000}, Voltage.HV, 240);
        this.addCentrifugeToMaterial(CombType.PYROTHEUM, new Materials[]{Materials.Blaze, Materials.Pyrotheum}, new int[]{2500, 2000}, new int[0], Voltage.HV, GTValues.NI, 3000);
        this.addCentrifugeToItemStack(CombType.CRYOTHEUM, new ItemStack[]{ItemList.FR_RefractoryWax.get(1L, new Object[0]), Materials.Cryotheum.getDust(1)}, new int[]{5000, 10000}, Voltage.MV);
        this.addCentrifugeToItemStack(CombType.BLIZZ, new ItemStack[]{ItemList.FR_RefractoryWax.get(1L, new Object[0]), Materials.Blizz.getDust(1)}, new int[]{5000, 10000}, Voltage.MV);
        this.addProcessGT(CombType.REDALLOY, new Materials[]{Materials.RedAlloy}, Voltage.LV);
        this.addProcessGT(CombType.REDSTONEALLOY, new Materials[]{Materials.RedstoneAlloy}, Voltage.LV);
        this.addProcessGT(CombType.CONDUCTIVEIRON, new Materials[]{Materials.ConductiveIron}, Voltage.MV);
        this.addProcessGT(CombType.VIBRANTALLOY, new Materials[]{Materials.VibrantAlloy}, Voltage.HV);
        this.addProcessGT(CombType.ENERGETICALLOY, new Materials[]{Materials.EnergeticAlloy}, Voltage.HV);
        this.addProcessGT(CombType.ELECTRICALSTEEL, new Materials[]{Materials.ElectricalSteel}, Voltage.LV);
        this.addProcessGT(CombType.DARKSTEEL, new Materials[]{Materials.DarkSteel}, Voltage.MV);
        this.addProcessGT(CombType.PULSATINGIRON, new Materials[]{Materials.PulsatingIron}, Voltage.HV);
        this.addProcessGT(CombType.STAINLESSSTEEL, new Materials[]{Materials.StainlessSteel}, Voltage.HV);
        this.addProcessGT(CombType.BEDROCKIUM, new Materials[]{Materials.Bedrockium}, Voltage.EV);
        this.addCentrifugeToItemStack(CombType.ENDERIUM, new ItemStack[]{ItemList.FR_RefractoryWax.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.EnderiumBase, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Enderium, 1L)}, new int[]{5000, 3000, 5000}, Voltage.HV);
        this.addCentrifugeToMaterial(CombType.REDALLOY, new Materials[]{Materials.RedAlloy}, new int[]{10000}, new int[0], Voltage.ULV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
        this.addCentrifugeToMaterial(CombType.REDSTONEALLOY, new Materials[]{Materials.RedstoneAlloy}, new int[]{10000}, new int[0], Voltage.ULV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
        this.addCentrifugeToMaterial(CombType.CONDUCTIVEIRON, new Materials[]{Materials.ConductiveIron}, new int[]{9000}, new int[0], Voltage.MV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
        this.addCentrifugeToMaterial(CombType.VIBRANTALLOY, new Materials[]{Materials.VibrantAlloy}, new int[]{7000}, new int[0], Voltage.HV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
        this.addCentrifugeToMaterial(CombType.ENERGETICALLOY, new Materials[]{Materials.EnergeticAlloy}, new int[]{8000}, new int[0], Voltage.HV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
        this.addCentrifugeToMaterial(CombType.ELECTRICALSTEEL, new Materials[]{Materials.ElectricalSteel}, new int[]{10000}, new int[0], Voltage.ULV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
        this.addCentrifugeToMaterial(CombType.DARKSTEEL, new Materials[]{Materials.DarkSteel}, new int[]{10000}, new int[0], Voltage.MV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
        this.addCentrifugeToMaterial(CombType.PULSATINGIRON, new Materials[]{Materials.PulsatingIron}, new int[]{8000}, new int[0], Voltage.HV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
        this.addCentrifugeToMaterial(CombType.STAINLESSSTEEL, new Materials[]{Materials.StainlessSteel}, new int[]{5000}, new int[0], Voltage.HV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
        this.addCentrifugeToMaterial(CombType.BEDROCKIUM, new Materials[]{Materials.Bedrockium}, new int[]{5000}, new int[0], Voltage.EV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
        this.addProcessGT(CombType.THAUMIUMDUST, new Materials[]{Materials.Thaumium}, Voltage.MV);
        this.addCentrifugeToItemStack(CombType.THAUMIUMSHARD, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 1), GTModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 2), GTModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 3), GTModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 4), GTModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 5), GTModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 6), GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0)}, new int[]{2000, 2000, 2000, 2000, 2000, 2000, 5000}, Voltage.ULV);
        this.addProcessGT(CombType.AMBER, new Materials[]{Materials.Amber}, Voltage.LV);
        this.addProcessGT(CombType.QUICKSILVER, new Materials[]{Materials.Cinnabar}, Voltage.LV);
        this.addCentrifugeToItemStack(CombType.SALISMUNDUS, new ItemStack[]{GTModHandler.getModItem(Mods.Thaumcraft.ID, "ItemResource", 1L, 14), GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0)}, new int[]{10000, 5000}, Voltage.MV);
        this.addCentrifugeToItemStack(CombType.TAINTED, new ItemStack[]{GTModHandler.getModItem(Mods.Thaumcraft.ID, "ItemResource", 1L, 11), GTModHandler.getModItem(Mods.Thaumcraft.ID, "ItemResource", 1L, 12), GTModHandler.getModItem(Mods.Thaumcraft.ID, "blockTaintFibres", 1L, 0), GTModHandler.getModItem(Mods.Thaumcraft.ID, "blockTaintFibres", 1L, 1), GTModHandler.getModItem(Mods.Thaumcraft.ID, "blockTaintFibres", 1L, 2), GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0)}, new int[]{1500, 1500, 1500, 1500, 1500, 5000}, Voltage.ULV);
        this.addProcessGT(CombType.MITHRIL, new Materials[]{Materials.Mithril}, Voltage.HV);
        this.addProcessGT(CombType.ASTRALSILVER, new Materials[]{Materials.AstralSilver}, Voltage.HV);
        this.addCentrifugeToMaterial(CombType.ASTRALSILVER, new Materials[]{Materials.AstralSilver, Materials.Silver}, new int[]{2000, 1000}, new int[0], Voltage.HV, GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), 5000);
        this.addCentrifugeToItemStack(CombType.THAUMINITE, new ItemStack[]{GTModHandler.getModItem(Mods.ThaumicBases.ID, "resource", 1L, 0), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Thaumium, 1L), GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0)}, new int[]{2000, 1000, 5000}, Voltage.HV);
        this.addProcessGT(CombType.SHADOWMETAL, new Materials[]{Materials.Shadow}, Voltage.HV);
        this.addCentrifugeToMaterial(CombType.SHADOWMETAL, new Materials[]{Materials.Shadow, Materials.ShadowSteel}, new int[]{2000, 1000}, new int[0], Voltage.HV, GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), 5000);
        this.addProcessGT(CombType.DIVIDED, new Materials[]{Materials.Diamond}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.DIVIDED, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTModHandler.getModItem(Mods.ExtraUtilities.ID, "unstableingot", 1L, 1), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Iron, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Diamond, 1L)}, new int[]{5000, 2000, 1000, 500}, Voltage.HV);
        this.addProcessGT(CombType.SPARKLING, new Materials[]{Materials.NetherStar}, Voltage.EV);
        this.addCentrifugeToItemStack(CombType.SPARKLING, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTModHandler.getModItem(Mods.MagicBees.ID, "miscResources", 2L, 5), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.NetherStar, 1L)}, new int[]{5000, 1000, 1000}, Voltage.EV);
        this.addCentrifugeToMaterial(CombType.THAUMIUMDUST, new Materials[]{Materials.Thaumium}, new int[]{10000}, new int[0], Voltage.MV, GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), 5000);
        this.addCentrifugeToItemStack(CombType.QUICKSILVER, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTModHandler.getModItem(Mods.Thaumcraft.ID, "ItemNugget", 1L, 5)}, new int[]{5000, 10000}, Voltage.ULV);
        this.addProcessGT(CombType.STONE, new Materials[]{Materials.Soapstone}, Voltage.LV);
        this.addProcessGT(CombType.CERTUS, new Materials[]{Materials.CertusQuartz}, Voltage.LV);
        this.addProcessGT(CombType.FLUIX, new Materials[]{Materials.Fluix}, Voltage.LV);
        this.addProcessGT(CombType.REDSTONE, new Materials[]{Materials.Redstone}, Voltage.LV);
        this.addCentrifugeToMaterial(CombType.RAREEARTH, new Materials[]{Materials.RareEarth}, new int[]{10000}, new int[]{1}, Voltage.ULV, GTValues.NI, 3000);
        this.addProcessGT(CombType.LAPIS, new Materials[]{Materials.Lapis}, Voltage.LV);
        this.addProcessGT(CombType.RUBY, new Materials[]{Materials.Ruby}, Voltage.LV);
        this.addProcessGT(CombType.REDGARNET, new Materials[]{Materials.GarnetRed}, Voltage.LV);
        this.addProcessGT(CombType.YELLOWGARNET, new Materials[]{Materials.GarnetYellow}, Voltage.LV);
        this.addProcessGT(CombType.SAPPHIRE, new Materials[]{Materials.Sapphire}, Voltage.LV);
        this.addProcessGT(CombType.DIAMOND, new Materials[]{Materials.Diamond}, Voltage.LV);
        this.addProcessGT(CombType.OLIVINE, new Materials[]{Materials.Olivine}, Voltage.LV);
        this.addProcessGT(CombType.EMERALD, new Materials[]{Materials.Emerald}, Voltage.LV);
        this.addProcessGT(CombType.FIRESTONE, new Materials[]{Materials.Firestone}, Voltage.LV);
        this.addProcessGT(CombType.PYROPE, new Materials[]{Materials.Pyrope}, Voltage.LV);
        this.addProcessGT(CombType.GROSSULAR, new Materials[]{Materials.Grossular}, Voltage.LV);
        this.addCentrifugeToMaterial(CombType.STONE, new Materials[]{Materials.Stone, Materials.GraniteBlack, Materials.GraniteRed, Materials.Basalt, Materials.Marble, Materials.Redrock}, new int[]{7000, 5000, 5000, 5000, 5000, 5000}, new int[]{9, 9, 9, 9, 9, 9}, Voltage.ULV, GTValues.NI, 5000);
        this.addCentrifugeToMaterial(CombType.FLUIX, new Materials[]{Materials.Fluix}, new int[]{2500}, new int[]{9}, Voltage.ULV, GTValues.NI, 3000);
        this.addProcessGT(CombType.SLAG, new Materials[]{Materials.Limestone}, Voltage.LV);
        this.addProcessGT(CombType.COPPER, new Materials[]{Materials.Copper}, Voltage.LV);
        this.addProcessGT(CombType.TIN, new Materials[]{Materials.Tin}, Voltage.LV);
        this.addProcessGT(CombType.LEAD, new Materials[]{Materials.Lead}, Voltage.LV);
        this.addProcessGT(CombType.NICKEL, new Materials[]{Materials.Nickel}, Voltage.LV);
        this.addProcessGT(CombType.ZINC, new Materials[]{Materials.Zinc}, Voltage.LV);
        this.addProcessGT(CombType.SILVER, new Materials[]{Materials.Silver}, Voltage.LV);
        this.addProcessGT(CombType.CRYOLITE, new Materials[]{Materials.Cryolite}, Voltage.LV);
        this.addProcessGT(CombType.GOLD, new Materials[]{Materials.Gold}, Voltage.LV);
        this.addProcessGT(CombType.SULFUR, new Materials[]{Materials.Sulfur}, Voltage.LV);
        this.addProcessGT(CombType.GALLIUM, new Materials[]{Materials.Gallium}, Voltage.LV);
        this.addProcessGT(CombType.ARSENIC, new Materials[]{Materials.Arsenic}, Voltage.LV);
        this.addProcessGT(CombType.IRON, new Materials[]{Materials.Iron}, Voltage.LV);
        this.addProcessGT(CombType.STEEL, new Materials[]{Materials.Steel}, Voltage.LV);
        this.addCentrifugeToMaterial(CombType.SLAG, new Materials[]{Materials.Stone, Materials.GraniteBlack, Materials.GraniteRed}, new int[]{5000, 2000, 2000}, new int[]{9, 9, 9}, Voltage.ULV, GTValues.NI, 3000);
        this.addCentrifugeToMaterial(CombType.COPPER, new Materials[]{Materials.Copper}, new int[]{7000}, new int[0], Voltage.ULV, GTValues.NI, 3000);
        this.addCentrifugeToMaterial(CombType.TIN, new Materials[]{Materials.Tin}, new int[]{6000}, new int[0], Voltage.ULV, GTValues.NI, 3000);
        this.addCentrifugeToMaterial(CombType.LEAD, new Materials[]{Materials.Lead}, new int[]{4500}, new int[0], Voltage.ULV, GTValues.NI, 3000);
        this.addCentrifugeToMaterial(CombType.IRON, new Materials[]{Materials.Iron}, new int[]{3000}, new int[0], Voltage.ULV, GTValues.NI, 3000);
        this.addCentrifugeToMaterial(CombType.STEEL, new Materials[]{Materials.Steel}, new int[]{4000}, new int[0], Voltage.ULV, GTValues.NI, 3000);
        this.addCentrifugeToMaterial(CombType.SILVER, new Materials[]{Materials.Silver}, new int[]{8000}, new int[0], Voltage.ULV, GTValues.NI, 3000);
        this.addCentrifugeToMaterial(CombType.CRYOLITE, new Materials[]{Materials.Cryolite}, new int[]{8000}, new int[0], Voltage.ULV, GTValues.NI, 3000);
        this.addCentrifugeToMaterial(CombType.SULFUR, new Materials[]{Materials.Sulfur}, new int[]{10000}, new int[0], Voltage.ULV, GTValues.NI, 3000);
        this.addProcessGT(CombType.BAUXITE, new Materials[]{Materials.Bauxite}, Voltage.LV);
        this.addProcessGT(CombType.ALUMINIUM, new Materials[]{Materials.Aluminium}, Voltage.LV);
        this.addProcessGT(CombType.MANGANESE, new Materials[]{Materials.Manganese}, Voltage.LV);
        this.addProcessGT(CombType.TITANIUM, new Materials[]{Materials.Titanium}, Voltage.EV);
        this.addProcessGT(CombType.MAGNESIUM, new Materials[]{Materials.Magnesium}, Voltage.LV);
        this.addProcessGT(CombType.CHROME, new Materials[]{Materials.Chrome}, Voltage.HV);
        this.addProcessGT(CombType.TUNGSTEN, new Materials[]{Materials.Tungsten}, Voltage.IV);
        this.addProcessGT(CombType.PLATINUM, new Materials[]{Materials.Platinum}, Voltage.HV);
        this.addProcessGT(CombType.MOLYBDENUM, new Materials[]{Materials.Molybdenum}, Voltage.LV);
        this.addProcessGT(CombType.IRIDIUM, new Materials[]{Materials.Iridium}, Voltage.IV);
        this.addProcessGT(CombType.PALLADIUM, new Materials[]{Materials.Palladium}, Voltage.IV);
        this.addProcessGT(CombType.OSMIUM, new Materials[]{Materials.Osmium}, Voltage.IV);
        this.addProcessGT(CombType.NEODYMIUM, new Materials[]{Materials.Neodymium}, Voltage.MV);
        this.addProcessGT(CombType.EUROPIUM, new Materials[]{Materials.Europium}, Voltage.LuV);
        this.addProcessGT(CombType.LITHIUM, new Materials[]{Materials.Lithium}, Voltage.MV);
        this.addProcessGT(CombType.ELECTROTINE, new Materials[]{Materials.Electrotine}, Voltage.MV);
        this.addProcessGT(CombType.DRACONIC, new Materials[]{Materials.Draconium}, Voltage.IV);
        this.addProcessGT(CombType.AWAKENEDDRACONIUM, new Materials[]{Materials.DraconiumAwakened}, Voltage.ZPM);
        this.addCentrifugeToItemStack(CombType.SALT, new ItemStack[]{GTOreDictUnificator.get(OrePrefixes.dust, Materials.Salt, 6L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.RockSalt, 6L), ItemList.FR_Wax.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Saltpeter, 6L)}, new int[]{10000, 10000, 5000, 2500}, Voltage.MV, 160);
        this.addProcessGT(CombType.ALMANDINE, new Materials[]{Materials.Almandine}, Voltage.LV);
        this.addProcessGT(CombType.URANIUM, new Materials[]{Materials.Uranium}, Voltage.EV);
        this.addProcessGT(CombType.PLUTONIUM, new Materials[]{Materials.Plutonium}, Voltage.EV);
        this.addProcessGT(CombType.NAQUADAH, new Materials[]{Materials.Naquadah}, Voltage.IV);
        this.addProcessGT(CombType.NAQUADRIA, new Materials[]{Materials.Naquadria}, Voltage.LuV);
        this.addProcessGT(CombType.THORIUM, new Materials[]{Materials.Thorium}, Voltage.MV);
        this.addProcessGT(CombType.LUTETIUM, new Materials[]{Materials.Lutetium}, Voltage.IV);
        this.addProcessGT(CombType.AMERICIUM, new Materials[]{Materials.Americium}, Voltage.LuV);
        this.addProcessGT(CombType.NEUTRONIUM, new Materials[]{Materials.Neutronium}, Voltage.UHV);
        this.addCentrifugeToItemStack(CombType.NAGA, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 4), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.NagaScaleChip", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.NagaScaleFragment", 1L, 0), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 3300, 800, 3000}, Voltage.MV);
        this.addCentrifugeToItemStack(CombType.LICH, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 5), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.LichBoneChip", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.LichBoneFragment", 1L, 0), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 3300, 800, 3000}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.HYDRA, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 1), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.FieryBloodDrop", 1L, 0), GTBees.drop.getStackForType(DropType.HYDRA), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 3300, 800, 3000}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.URGHAST, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 2), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CarminiteChip", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CarminiteFragment", 1L, 0), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 3300, 800, 3000}, Voltage.EV);
        this.addCentrifugeToItemStack(CombType.SNOWQUEEN, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 3), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.SnowQueenBloodDrop", 1L, 0), GTBees.drop.getStackForType(DropType.SNOW_QUEEN), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 3300, 800, 3000}, Voltage.EV);
        this.addCentrifugeToItemStack(CombType.ENDDUST, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTBees.propolis.getStackForType(PropolisType.End), GTBees.drop.getStackForType(DropType.ENDERGOO), Materials.Endstone.getBlocks(4)}, new int[]{2000, 1500, 1000, 10000}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.STARDUST, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTBees.propolis.getStackForType(PropolisType.Stardust), GTBees.drop.getStackForType(DropType.ENDERGOO)}, new int[]{2000, 1500, 1000}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.ECTOPLASMA, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTBees.propolis.getStackForType(PropolisType.Ectoplasma), GTBees.drop.getStackForType(DropType.ENDERGOO)}, new int[]{2500, 1000, 1500}, Voltage.EV);
        this.addCentrifugeToItemStack(CombType.ARCANESHARD, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTBees.propolis.getStackForType(PropolisType.Arcaneshard), GTBees.drop.getStackForType(DropType.ENDERGOO)}, new int[]{2500, 1000, 1500}, Voltage.EV);
        this.addCentrifugeToItemStack(CombType.DRAGONESSENCE, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTBees.propolis.getStackForType(PropolisType.Dragonessence), GTBees.drop.getStackForType(DropType.ENDERGOO)}, new int[]{3000, 750, 2000}, Voltage.IV);
        this.addCentrifugeToItemStack(CombType.ENDERMAN, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTBees.propolis.getStackForType(PropolisType.Enderman), GTBees.drop.getStackForType(DropType.ENDERGOO)}, new int[]{3000, 750, 2000}, Voltage.IV);
        this.addCentrifugeToItemStack(CombType.SILVERFISH, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTBees.propolis.getStackForType(PropolisType.Silverfish), GTBees.drop.getStackForType(DropType.ENDERGOO), new ItemStack(Items.field_151063_bx, 1, 60)}, new int[]{2500, 1000, 2000, 1500}, Voltage.EV);
        this.addProcessGT(CombType.ENDIUM, new Materials[]{Materials.HeeEndium}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.RUNEI, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.RuneOfPowerFragment", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.RuneOfAgilityFragment", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.RuneOfVigorFragment", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.RuneOfDefenseFragment", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.RuneOfMagicFragment", 1L, 0)}, new int[]{2500, 500, 500, 500, 500, 500}, Voltage.IV);
        this.addCentrifugeToItemStack(CombType.RUNEII, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.RuneOfVoidFragment", 1L, 0)}, new int[]{5000, 250}, Voltage.IV);
        this.addCentrifugeToItemStack(CombType.FIREESSENSE, new ItemStack[]{GTModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GTBees.propolis.getStackForType(PropolisType.Fireessence), GTBees.drop.getStackForType(DropType.ENDERGOO)}, new int[]{3000, 750, 2000}, Voltage.IV);
        if (Mods.AE2FluidCraft.isModLoaded()) {
            this.addCentrifugeToItemStack(CombType.WALRUS, new ItemStack[]{GTModHandler.getModItem(Mods.AE2FluidCraft.ID, "walrus", 1L, 0)}, new int[]{10000}, Voltage.LV);
        }
        this.addCentrifugeToItemStack(CombType.MACHINIST, new ItemStack[]{GTModHandler.getModItem(Mods.Forestry.ID, "royalJelly", 1L, 0), GTModHandler.getModItem(Mods.Forestry.ID, "pollen", 1L, 0), GTModHandler.getModItem(Mods.Forestry.ID, "honeyDrop", 1L, 0), GTModHandler.getModItem(Mods.ExtraBees.ID, "honeyDrop", 1L, 6), GTModHandler.getModItem(Mods.Forestry.ID, "beeswax", 1L, 0), ItemList.ElectronicsLump.get(1L, new Object[0])}, new int[]{1000, 1000, 2000, 1000, 2000, 500}, Voltage.ULV);
        this.addCentrifugeToItemStack(CombType.SPACE, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), ItemList.FR_RefractoryWax.get(1L, new Object[0]), GTBees.drop.getStackForType(DropType.OXYGEN), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CoinSpace", 1L, 0)}, new int[]{5000, 3000, 1500, 500}, Voltage.HV);
        this.addProcessGT(CombType.METEORICIRON, new Materials[]{Materials.MeteoricIron}, Voltage.HV);
        this.addProcessGT(CombType.DESH, new Materials[]{Materials.Desh}, Voltage.EV);
        this.addProcessGT(CombType.LEDOX, new Materials[]{Materials.Ledox}, Voltage.EV);
        this.addProcessGT(CombType.CALLISTOICE, new Materials[]{Materials.CallistoIce}, Voltage.IV);
        this.addProcessGT(CombType.MYTRYL, new Materials[]{Materials.Mytryl}, Voltage.IV);
        this.addProcessGT(CombType.QUANTIUM, new Materials[]{Materials.Quantium}, Voltage.IV);
        this.addProcessGT(CombType.ORIHARUKON, new Materials[]{Materials.Oriharukon}, Voltage.IV);
        this.addProcessGT(CombType.INFUSEDGOLD, new Materials[]{Materials.InfusedGold}, Voltage.IV);
        this.addCentrifugeToMaterial(CombType.INFUSEDGOLD, new Materials[]{Materials.InfusedGold, Materials.Gold}, new int[]{2000, 1000}, new int[0], Voltage.IV, 200, GTValues.NI, 1000);
        this.addProcessGT(CombType.MYSTERIOUSCRYSTAL, new Materials[]{Materials.MysteriousCrystal}, Voltage.LuV);
        this.addCentrifugeToMaterial(CombType.MYSTERIOUSCRYSTAL, new Materials[]{Materials.MysteriousCrystal}, new int[]{1000, 1500}, new int[0], Voltage.LuV, 512, GTValues.NI, 5000);
        this.addProcessGT(CombType.BLACKPLUTONIUM, new Materials[]{Materials.BlackPlutonium}, Voltage.LuV);
        this.addProcessGT(CombType.TRINIUM, new Materials[]{Materials.Trinium}, Voltage.ZPM);
        this.addCentrifugeToItemStack(CombType.MOON, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MoonStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.MV, 300);
        this.addCentrifugeToItemStack(CombType.MARS, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MarsStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.HV, 300);
        this.addCentrifugeToItemStack(CombType.JUPITER, new ItemStack[]{GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.IoStoneDust", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EuropaIceDust", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EuropaStoneDust", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.GanymedeStoneDust", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CallistoStoneDust", 1L, 0), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.CallistoIce, 1L), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{3000, 3000, 3000, 3000, 3000, 500, 5000}, Voltage.HV, 300);
        this.addCentrifugeToItemStack(CombType.MERCURY, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MercuryCoreDust", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MercuryStoneDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.EV, 300);
        this.addCentrifugeToItemStack(CombType.VENUS, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.VenusStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.EV, 300);
        this.addCentrifugeToItemStack(CombType.SATURN, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EnceladusStoneDust", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TitanStoneDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.IV, 300);
        this.addCentrifugeToItemStack(CombType.URANUS, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MirandaStoneDust", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.OberonStoneDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.IV, 300);
        this.addCentrifugeToItemStack(CombType.NEPTUNE, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.ProteusStoneDust", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TritonStoneDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.IV, 300);
        this.addCentrifugeToItemStack(CombType.PLUTO, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.PlutoStoneDust", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.PlutoIceDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.LuV, 300);
        this.addCentrifugeToItemStack(CombType.HAUMEA, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.HaumeaStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.LuV, 300);
        this.addCentrifugeToItemStack(CombType.MAKEMAKE, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MakeMakeStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.LuV, 300);
        this.addCentrifugeToItemStack(CombType.CENTAURI, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CentauriASurfaceDust", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CentauriAStoneDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.ZPM, 300);
        this.addCentrifugeToItemStack(CombType.TCETI, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TCetiEStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.ZPM, 300);
        this.addCentrifugeToItemStack(CombType.BARNARDA, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.BarnardaEStoneDust", 1L, 0), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.BarnardaFStoneDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.ZPM, 300);
        this.addCentrifugeToItemStack(CombType.VEGA, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.VegaBStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.ZPM, 300);
        if (Mods.GalaxySpace.isModLoaded()) {
            this.addCentrifugeToItemStack(CombType.SEAWEED, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GTModHandler.getModItem(Mods.GalaxySpace.ID, "tcetiedandelions", 1L, 0)}, new int[]{5000, 10000}, Voltage.UV, 100);
        }
        this.addCentrifugeToMaterial(CombType.INFINITYCATALYST, new Materials[]{Materials.InfinityCatalyst, Materials.Neutronium}, new int[]{2500, 2000}, new int[0], Voltage.ZPM, 100, GTValues.NI, 5000);
        this.addFluidExtractorProcess(CombType.HELIUM, Materials.Helium.getGas(250L), Voltage.HV);
        this.addFluidExtractorProcess(CombType.ARGON, Materials.Argon.getGas(250L), Voltage.MV);
        this.addFluidExtractorProcess(CombType.NITROGEN, Materials.Nitrogen.getGas(500L), Voltage.MV);
        this.addFluidExtractorProcess(CombType.HYDROGEN, Materials.Hydrogen.getGas(500L), Voltage.MV);
        this.addFluidExtractorProcess(CombType.FLUORINE, Materials.Fluorine.getGas(250L), Voltage.MV);
        this.addFluidExtractorProcess(CombType.OXYGEN, Materials.Oxygen.getGas(500L), Voltage.MV);
        this.addFluidExtractorProcess(CombType.UNKNOWNLIQUID, FluidRegistry.getFluidStack((String)"unknowwater", (int)250), Voltage.ZPM);
    }

    public void addAutoclaveProcess(CombType comb, Materials aMaterial, Voltage volt, int circuitNumber) {
        if (GTOreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L) == GTValues.NI) {
            return;
        }
        GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
        recipeBuilder.itemInputs(GTUtility.copyAmount(9, this.getStackForType(comb)), GTUtility.getIntegratedCircuit(circuitNumber)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L)).fluidInputs(Materials.UUMatter.getFluid(Math.max(1L, (aMaterial.getMass() + (long)volt.getUUAmplifier()) / 10L))).duration((int)(aMaterial.getMass() * 128L) * 1).eut(volt.getAutoClaveEnergy());
        if (volt.compareTo(Voltage.HV) > 0) {
            recipeBuilder.requiresCleanRoom();
        }
        recipeBuilder.addTo(RecipeMaps.autoclaveRecipes);
    }

    public void addFluidExtractorProcess(CombType comb, FluidStack fluid, Voltage volt) {
        if (fluid == null) {
            return;
        }
        int duration = fluid.getFluid().getDensity() * 128 > 0 ? fluid.getFluid().getDensity() * 100 : 128;
        int eut = volt.getSimpleEnergy() / 2;
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, this.getStackForType(comb))).fluidOutputs(fluid).duration(duration).eut(eut).addTo(RecipeMaps.fluidExtractionRecipes);
    }

    public void addProcessGT(CombType comb, Materials[] aMaterial, Voltage volt) {
        ItemStack tComb = this.getStackForType(comb);
        for (Materials materials : aMaterial) {
            boolean requiresCleanroom;
            int eut;
            int durationTicks;
            FluidStack fluidOutput;
            FluidStack fluidInput;
            ItemStack combOutput;
            ItemStack combInput;
            if (GTOreDictUnificator.get(OrePrefixes.crushedPurified, materials, 4L) == null) continue;
            switch (comb) {
                case NEUTRONIUM: {
                    combInput = GTUtility.copyAmount(4, tComb);
                    combOutput = Materials.Neutronium.getNuggets(1);
                    fluidInput = volt.getFluidAccordingToCombTier();
                    fluidOutput = Materials.Neutronium.getMolten(576L);
                    durationTicks = volt.getComplexTime() * 17;
                    eut = volt.getChemicalEnergy();
                    requiresCleanroom = volt.compareTo(Voltage.IV) > 0;
                    break;
                }
                case OSMIUM: {
                    combInput = GTUtility.copyAmount(4, tComb);
                    combOutput = Materials.Osmium.getNuggets(1);
                    fluidInput = volt.getFluidAccordingToCombTier();
                    fluidOutput = Materials.Osmium.getMolten(288L);
                    durationTicks = volt.getComplexTime() * 17;
                    eut = volt.getChemicalEnergy();
                    requiresCleanroom = volt.compareTo(Voltage.IV) > 0;
                    break;
                }
                case PLATINUM: {
                    combInput = GTUtility.copyAmount(4, tComb);
                    combOutput = Materials.Platinum.getNuggets(1);
                    fluidInput = volt.getFluidAccordingToCombTier();
                    fluidOutput = Materials.Platinum.getMolten(288L);
                    durationTicks = volt.getComplexTime() * 10;
                    eut = volt.getChemicalEnergy();
                    requiresCleanroom = volt.compareTo(Voltage.HV) > 0;
                    break;
                }
                case IRIDIUM: {
                    combInput = GTUtility.copyAmount(4, tComb);
                    combOutput = Materials.Iridium.getNuggets(1);
                    fluidInput = volt.getFluidAccordingToCombTier();
                    fluidOutput = Materials.Iridium.getMolten(288L);
                    durationTicks = volt.getComplexTime() * 14;
                    eut = volt.getChemicalEnergy();
                    requiresCleanroom = volt.compareTo(Voltage.EV) > 0;
                    break;
                }
                default: {
                    combInput = GTUtility.copyAmount(4, tComb);
                    combOutput = GTOreDictUnificator.get(OrePrefixes.crushedPurified, materials, 4L);
                    fluidInput = volt.getFluidAccordingToCombTier();
                    fluidOutput = null;
                    durationTicks = volt.getComplexTime();
                    eut = volt.getChemicalEnergy();
                    requiresCleanroom = volt.compareTo(Voltage.IV) > 0;
                }
            }
            GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
            recipeBuilder.itemInputs(combInput).itemOutputs(combOutput).fluidInputs(fluidInput);
            if (fluidOutput != null) {
                recipeBuilder.fluidOutputs(fluidOutput);
            }
            recipeBuilder.duration(durationTicks).eut(eut).metadata(GTRecipeConstants.CLEANROOM, requiresCleanroom).addTo(GTRecipeConstants.UniversalChemical);
        }
    }

    public void addCentrifugeToMaterial(CombType comb, Materials[] aMaterial, int[] chance, int[] stackSize, Voltage volt, ItemStack beeWax, int waxChance) {
        this.addCentrifugeToMaterial(comb, aMaterial, chance, stackSize, volt, volt.getSimpleTime(), beeWax, waxChance);
    }

    public void addCentrifugeToMaterial(CombType comb, Materials[] aMaterial, int[] chance, int[] stackSize, Voltage volt, int duration, ItemStack beeWax, int waxChance) {
        ItemStack[] aOutPut = new ItemStack[aMaterial.length + 1];
        stackSize = Arrays.copyOf(stackSize, aMaterial.length);
        chance = Arrays.copyOf(chance, aOutPut.length);
        chance[chance.length - 1] = waxChance;
        for (int i = 0; i < aMaterial.length; ++i) {
            if (chance[i] == 0) continue;
            aOutPut[i] = Math.max(1, stackSize[i]) % 9 == 0 ? GTOreDictUnificator.get(OrePrefixes.dust, aMaterial[i], (long)(Math.max(1, stackSize[i]) / 9)) : (Math.max(1, stackSize[i]) % 4 == 0 ? GTOreDictUnificator.get(OrePrefixes.dust, aMaterial[i], (long)(Math.max(1, stackSize[i]) / 4)) : GTOreDictUnificator.get(OrePrefixes.dust, aMaterial[i], (long)Math.max(1, stackSize[i])));
        }
        aOutPut[aOutPut.length - 1] = beeWax != GTValues.NI ? beeWax : ItemList.FR_Wax.get(1L, new Object[0]);
        this.addCentrifugeToItemStack(comb, aOutPut, chance, volt, duration);
    }

    public void addCentrifugeToItemStack(CombType comb, ItemStack[] aItem, int[] chance, Voltage volt) {
        this.addCentrifugeToItemStack(comb, aItem, chance, volt, volt.getSimpleTime());
    }

    public void addCentrifugeToItemStack(CombType comb, ItemStack[] aItem, int[] chance, Voltage volt, int duration) {
        ItemStack tComb = this.getStackForType(comb);
        ImmutableMap.Builder Product = new ImmutableMap.Builder();
        for (int i = 0; i < aItem.length; ++i) {
            if (aItem[i] == GTValues.NI) continue;
            Product.put((Object)aItem[i], (Object)Float.valueOf((float)chance[i] / 10000.0f));
        }
        if (volt.compareTo(Voltage.MV) < 0) {
            RecipeManagers.centrifugeManager.addRecipe(40, tComb, (Map)Product.build());
        }
        GTValues.RA.stdBuilder().itemInputs(tComb).itemOutputs(aItem).outputChances(chance).duration(duration).eut(volt.getSimpleEnergy()).addTo(RecipeMaps.centrifugeRecipes);
    }

    public void registerOreDict() {
        for (CombType comb : CombType.values()) {
            ItemStack tComb = this.getStackForType(comb);
            GTOreDictUnificator.registerOre(OrePrefixes.beeComb.name(), tComb);
            OrePrefixes.beeComb.add(tComb);
            if (comb.voltage == null) continue;
            GTOreDictUnificator.registerOre("comb" + comb.voltage.name(), tComb);
        }
    }

    public static enum Voltage {
        ULV,
        LV,
        MV,
        HV,
        EV,
        IV,
        LuV,
        ZPM,
        UV,
        UHV,
        UEV,
        UIV,
        UMV,
        UXV,
        MAX;


        public int getVoltage() {
            return (int)GTValues.V[this.ordinal()];
        }

        public int getVoltageFromEU() {
            return (int)Math.max(Math.floor(Math.log(2 * this.getVoltage()) / Math.log(4.0) - 1.0), 0.0);
        }

        public int getChemicalEnergy() {
            return this.getVoltage() * 3 / 4;
        }

        public int getAutoClaveEnergy() {
            return (int)((double)(this.getVoltage() * 3 / 4) * Math.max(1.0, Math.pow(2.0, 5 - this.ordinal())));
        }

        public FluidStack getComplexChemical() {
            if (this.compareTo(MV) < 0) {
                return Materials.HydrofluoricAcid.getFluid(this.compareTo(ULV) > 0 ? 1000L : 500L);
            }
            if (this.compareTo(HV) < 0) {
                return GTModHandler.getDistilledWater(1000L);
            }
            if (this.compareTo(LuV) < 0) {
                return Materials.HydrofluoricAcid.getFluid((long)(Math.pow(2.0, this.compareTo(HV)) * 144.0));
            }
            if (this.compareTo(UHV) < 0) {
                return FluidRegistry.getFluidStack((String)"mutagen", (int)((int)(Math.pow(2.0, this.compareTo(LuV)) * 144.0)));
            }
            return GTValues.NF;
        }

        public FluidStack getFluidAccordingToCombTier() {
            FluidStack fluidStack;
            int fluidAmount = this.getFluidAmount();
            switch (this.getVoltageFromEU()) {
                case 0: {
                    fluidStack = Materials.Water.getFluid(fluidAmount);
                    break;
                }
                case 1: {
                    fluidStack = Materials.SulfuricAcid.getFluid(fluidAmount);
                    break;
                }
                case 2: {
                    fluidStack = Materials.HydrochloricAcid.getFluid(fluidAmount);
                    break;
                }
                case 3: {
                    fluidStack = Materials.PhosphoricAcid.getFluid(fluidAmount);
                    break;
                }
                case 4: {
                    fluidStack = Materials.HydrofluoricAcid.getFluid(this.getFluidAmount());
                    break;
                }
                default: {
                    fluidStack = Materials.PhthalicAcid.getFluid(fluidAmount);
                }
            }
            return fluidStack;
        }

        public int getUUAmplifier() {
            return 9 * (this.compareTo(MV) < 0 ? 1 : this.compareTo(MV));
        }

        public int getComplexTime() {
            return 64 + this.ordinal() * 32;
        }

        public int getFluidAmount() {
            return 9 * this.getSimpleTime() / 3;
        }

        public int getSimpleTime() {
            return 128 * Math.max(1, this.ordinal());
        }

        public int getSimpleEnergy() {
            if (this == ULV) {
                return 5;
            }
            return this.getVoltage() / 16 * 15;
        }
    }
}

