/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import cpw.mods.fml.client.registry.ClientRegistry;
import gregtech.common.tileentities.render.TileEntityLaser;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class LaserRenderer
extends TileEntitySpecialRenderer {
    private double zOffset = 0.0;
    private double xOffset = 0.0;
    private final double lineRadius = 0.03;
    private final float lineOpacity = 0.7f;
    private final float laserSpeed = 0.8f;

    public LaserRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaser.class, (TileEntitySpecialRenderer)this);
    }

    private void maths(float counter) {
        float tc = 0.05f * counter;
        this.zOffset = 0.5 + 0.45 * Math.sin(Math.PI * 2 * (double)tc);
        this.xOffset = 0.5 + 0.45 * Math.sin(1.5707963267948966 * (double)tc);
    }

    private void renderFakeLine(TileEntityLaser laser, double x1, double y1, double z1, double x2, double y2, double z2) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(laser.getRed(), laser.getGreen(), laser.getBlue(), 0.7f);
        tessellator.func_78377_a(x1 - 0.03, y1, z1);
        tessellator.func_78377_a(x1 + 0.03, y1, z1);
        tessellator.func_78377_a(x2 + 0.03, y2, z2);
        tessellator.func_78377_a(x2 - 0.03, y2, z2);
        tessellator.func_78377_a(x1, y1, z1 - 0.03);
        tessellator.func_78377_a(x1, y1, z1 + 0.03);
        tessellator.func_78377_a(x2, y2, z2 + 0.03);
        tessellator.func_78377_a(x2, y2, z2 - 0.03);
        tessellator.func_78381_a();
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        TileEntityLaser ltile = (TileEntityLaser)tile;
        if (ltile.getShouldRender().booleanValue()) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GL11.glRotated((double)ltile.rotationAngle, (double)ltile.rotAxisX, (double)ltile.rotAxisY, (double)ltile.rotAxisZ);
            GL11.glTranslated((double)(-x - 0.5), (double)(-y - 0.5), (double)(-z - 0.5));
            if (ltile.realism) {
                this.renderFakeLine(ltile, x + this.xOffset, y + 4.0, z + this.zOffset, x + this.xOffset, y + 0.5, z + this.zOffset);
            } else {
                this.renderFakeLine(ltile, x + 0.5, y + 4.0, z + 0.5, x + this.xOffset, y + 0.5, z + this.zOffset);
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            this.maths(ltile.counter);
            ltile.counter += 0.8f;
            if (ltile.counter >= 80.0f) {
                ltile.counter = 0.0f;
            }
        }
    }
}

