/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;

public class ProcessingDirty
implements IOreRecipeRegistrator {
    private boolean didPersulfate = false;
    private boolean didMercury = false;

    public ProcessingDirty() {
        OrePrefixes.clump.add(this);
        OrePrefixes.shard.add(this);
        OrePrefixes.crushed.add(this);
        OrePrefixes.dirtyGravel.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aMaterial.contains(SubTag.NO_ORE_PROCESSING)) {
            return;
        }
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustImpure, aMaterial.mMacerateInto, 1L)).duration(10).eut(16).addTo(RecipeMaps.hammerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustImpure, (Object)aMaterial.mMacerateInto, GTOreDictUnificator.get(OrePrefixes.dust, aMaterial.mMacerateInto, 1L), 1L), GTOreDictUnificator.get(OrePrefixes.dust, GTUtility.selectItemInList(0, aMaterial.mMacerateInto, aMaterial.mOreByProducts), 1L)).outputChances(10000, 1000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(aPrefix == OrePrefixes.crushed ? OrePrefixes.crushedPurified : OrePrefixes.dustPure, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dust, GTUtility.selectItemInList(0, aMaterial.mMacerateInto, aMaterial.mOreByProducts), 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L)).outputChances(10000, 1111, 10000).fluidInputs(GTModHandler.getWater(1000L)).duration(500).eut(16).addTo(RecipeMaps.oreWasherRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(aPrefix == OrePrefixes.crushed ? OrePrefixes.crushedPurified : OrePrefixes.dustPure, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dust, GTUtility.selectItemInList(0, aMaterial.mMacerateInto, aMaterial.mOreByProducts), 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L)).outputChances(10000, 1111, 10000).fluidInputs(GTModHandler.getDistilledWater(200L)).duration(300).eut(16).addTo(RecipeMaps.oreWasherRecipes);
        OrePrefixes prefix = aPrefix == OrePrefixes.crushed ? OrePrefixes.crushedCentrifuged : OrePrefixes.dust;
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(prefix, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dust, GTUtility.selectItemInList(1, aMaterial.mMacerateInto, aMaterial.mOreByProducts), 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L)).outputChances(10000, 1111, 10000).duration(500).eut(48).addTo(RecipeMaps.thermalCentrifugeRecipes);
        this.didPersulfate = false;
        this.didMercury = false;
        this.addChemicalBathRecipes(aMaterial, aMaterial, aStack, aPrefix);
        for (Materials tMaterial : aMaterial.mOreByProducts) {
            this.addChemicalBathRecipes(aMaterial, tMaterial, aStack, aPrefix);
        }
    }

    private void addChemicalBathRecipes(Materials material, Materials byproduct, ItemStack stack, OrePrefixes prefix) {
        OrePrefixes chemicalBathPrefix;
        OrePrefixes orePrefixes = chemicalBathPrefix = prefix == OrePrefixes.crushed ? OrePrefixes.crushedPurified : OrePrefixes.dustPure;
        if (byproduct.contains(SubTag.WASHING_MERCURY) && !this.didMercury) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, stack)).itemOutputs(GTOreDictUnificator.get(chemicalBathPrefix, material, 1L), GTOreDictUnificator.get(OrePrefixes.dust, byproduct.mMacerateInto, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L)).outputChances(10000, 7000, 4000).fluidInputs(Materials.Mercury.getFluid(1000L)).duration(800).eut(8).addTo(RecipeMaps.chemicalBathRecipes);
            this.didMercury = true;
        }
        if (byproduct.contains(SubTag.WASHING_MERCURY_99_PERCENT) && !this.didMercury) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, stack)).itemOutputs(GTOreDictUnificator.get(chemicalBathPrefix, material, 1L), GTOreDictUnificator.get(OrePrefixes.dust, byproduct.mMacerateInto, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L)).outputChances(10000, 9900, 4000).fluidInputs(Materials.Mercury.getFluid(1000L)).duration(800).eut(8).addTo(RecipeMaps.chemicalBathRecipes);
            this.didMercury = true;
        }
        if (byproduct.contains(SubTag.WASHING_SODIUMPERSULFATE) && !this.didPersulfate) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, stack)).itemOutputs(GTOreDictUnificator.get(chemicalBathPrefix, material, 1L), GTOreDictUnificator.get(OrePrefixes.dust, byproduct.mMacerateInto, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L)).outputChances(10000, 7000, 4000).fluidInputs(Materials.SodiumPersulfate.getFluid(100L)).duration(800).eut(8).addTo(RecipeMaps.chemicalBathRecipes);
            this.didPersulfate = true;
        }
    }
}

