/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general.spawn;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemCustomSpawnEgg
extends ItemMonsterPlacer {
    private static final HashMap<Integer, IIcon> mIconMap = new HashMap();
    private static int mTotalMetaItems = 0;
    private static final HashMap<Integer, Integer> mMaxStackSizeMap = new HashMap();
    private static final HashMap<Integer, EnumRarity> mRarityMap = new HashMap();
    private static final HashMap<Integer, ArrayList<String>> mOreDictNames = new HashMap();
    private static final HashMap<Integer, Integer> mColourBaseMap = new HashMap();
    private static final HashMap<Integer, Integer> mColourSpotsMap = new HashMap();
    private static final HashMap<Integer, String> mEntityNameMap = new HashMap();
    private static final HashMap<Integer, String> mEntityFullNameMap = new HashMap();
    private static final HashMap<String, Integer> mReverseEntityMap = new HashMap();
    protected EntityLiving entityToSpawn = null;

    public static void registerEntityForSpawnEgg(int aMetaID, String parEntityToSpawnName, int aPrimaryColor, int aSecondaryColor) {
        ItemCustomSpawnEgg.registerEntityForSpawnEgg(aMetaID, parEntityToSpawnName, aPrimaryColor, aSecondaryColor, EnumRarity.common, new ArrayList<String>());
    }

    public static void registerEntityForSpawnEgg(int aMetaID, String parEntityToSpawnName, int aPrimaryColor, int aSecondaryColor, EnumRarity aRarity, ArrayList<String> aOreDictNames) {
        ++mTotalMetaItems;
        mMaxStackSizeMap.put(aMetaID, 64);
        mRarityMap.put(aMetaID, aRarity);
        mOreDictNames.put(aMetaID, aOreDictNames);
        mColourBaseMap.put(aMetaID, aPrimaryColor);
        mColourSpotsMap.put(aMetaID, aSecondaryColor);
        mReverseEntityMap.put(parEntityToSpawnName, aMetaID);
        ItemCustomSpawnEgg.setEntityToSpawnName(aMetaID, parEntityToSpawnName);
    }

    public ItemCustomSpawnEgg() {
        this.setNoRepair();
        this.func_77625_d(64);
        this.func_77656_e(0);
        this.func_77655_b("BasicMetaSpawnEgg");
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        Entity entity;
        if (par3World.field_72995_K) {
            return true;
        }
        Block block = par3World.func_147439_a(par4, par5, par6);
        par4 += Facing.field_71586_b[par7];
        par5 += Facing.field_71587_c[par7];
        par6 += Facing.field_71585_d[par7];
        double d0 = 0.0;
        if (par7 == 1 && block.func_149645_b() == 11) {
            d0 = 0.5;
        }
        if ((entity = this.spawnEntity(par1ItemStack, par3World, (double)par4 + 0.5, (double)par5 + d0, (double)par6 + 0.5)) != null) {
            if (entity instanceof EntityLivingBase && par1ItemStack.func_82837_s()) {
                ((EntityLiving)entity).func_94058_c(par1ItemStack.func_82833_r());
            }
            if (!par2EntityPlayer.field_71075_bZ.field_75098_d) {
                --par1ItemStack.field_77994_a;
            }
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par2World.field_72995_K) {
            return par1ItemStack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(par2World, par3EntityPlayer, true);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Entity entity;
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            if (!par2World.func_72962_a(par3EntityPlayer, i, j, k)) {
                return par1ItemStack;
            }
            if (!par3EntityPlayer.func_82247_a(i, j, k, movingobjectposition.field_72310_e, par1ItemStack)) {
                return par1ItemStack;
            }
            if (par2World.func_147439_a(i, j, k) instanceof BlockLiquid && (entity = this.spawnEntity(par1ItemStack, par2World, i, j, k)) != null) {
                if (entity instanceof EntityLivingBase && par1ItemStack.func_82837_s()) {
                    ((EntityLiving)entity).func_94058_c(par1ItemStack.func_82833_r());
                }
                if (!par3EntityPlayer.field_71075_bZ.field_75098_d) {
                    --par1ItemStack.field_77994_a;
                }
            }
        }
        return par1ItemStack;
    }

    public Entity spawnEntity(ItemStack par1ItemStack, World parWorld, double parX, double parY, double parZ) {
        if (!parWorld.field_72995_K) {
            int aDamage = par1ItemStack.func_77960_j();
            String entityToSpawnNameFull = mEntityFullNameMap.get(aDamage);
            String entityToSpawnName = mEntityNameMap.get(aDamage);
            if (EntityList.field_75625_b.containsKey(entityToSpawnNameFull)) {
                this.entityToSpawn = (EntityLiving)EntityList.func_75620_a((String)entityToSpawnNameFull, (World)parWorld);
                this.entityToSpawn.func_70012_b(parX, parY, parZ, MathHelper.func_76142_g((float)(parWorld.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                parWorld.func_72838_d((Entity)this.entityToSpawn);
                this.entityToSpawn.func_110161_a(null);
                this.entityToSpawn.func_70642_aH();
            } else {
                System.out.println("Entity not found " + entityToSpawnName);
            }
        }
        return this.entityToSpawn;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs p_150895_2_, List aList) {
        for (int aMeta : mReverseEntityMap.values()) {
            aList.add(ItemUtils.simpleMetaStack(aItem, aMeta, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int parColorType) {
        int aID = par1ItemStack.func_77960_j();
        return parColorType == 0 ? mColourBaseMap.get(aID) : mColourSpotsMap.get(aID);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        return StatCollector.func_74837_a((String)"item.ItemCustomSpawnEgg.name", (Object[])new Object[]{StatCollector.func_74838_a((String)("entity." + mEntityNameMap.get(par1ItemStack.func_77960_j()) + ".name"))});
    }

    public void func_94581_a(IIconRegister u) {
        mIconMap.put(0, u.func_94245_a(Mods.GTPlusPlus.ID + ":spawn_egg"));
        mIconMap.put(1, u.func_94245_a(Mods.GTPlusPlus.ID + ":spawn_egg_overlay"));
    }

    public IIcon func_77618_c(int damage, int renderPass) {
        return mIconMap.get(renderPass);
    }

    public IIcon func_77617_a(int damage) {
        return this.func_77618_c(0, 0);
    }

    public IIcon getIcon(ItemStack aStack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return this.func_77618_c(0, renderPass);
    }

    public IIcon getIcon(ItemStack aStack, int renderPass) {
        return this.func_77618_c(0, renderPass);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77960_j();
    }

    public static void setEntityToSpawnName(int aMetaID, String parEntityToSpawnName) {
        mEntityNameMap.put(aMetaID, parEntityToSpawnName);
        mEntityFullNameMap.put(aMetaID, Mods.GTPlusPlus.ID + "." + parEntityToSpawnName);
    }
}

