/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import gregtech.api.enums.Materials;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.recipe.maps.FuelBackend;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TurbineStatCalculator;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.MTELargerTurbineBase;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTELargeTurbineGas
extends MTELargerTurbineBase {
    private static final HashSet<Fluid> BLACKLIST = new HashSet();

    public MTELargeTurbineGas(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeTurbineGas(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargeTurbineGas(this.mName);
    }

    @Override
    public int getCasingMeta() {
        return 3;
    }

    @Override
    public int getCasingTextureIndex() {
        return 58;
    }

    @Override
    protected boolean requiresOutputHatch() {
        return false;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return 4000;
    }

    @Override
    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        GTRecipe tFuel = this.getRecipeMap().getBackend().findFuel(aLiquid);
        if (tFuel != null) {
            return tFuel.mSpecialValue;
        }
        return 0;
    }

    public RecipeMap<FuelBackend> getRecipeMap() {
        return RecipeMaps.gasTurbineFuels;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -20;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ArrayList<FluidStack> fluids = this.getStoredFluids();
        for (FluidStack fluid : fluids) {
            if (fluid == null || !BLACKLIST.contains(fluid.getFluid())) continue;
            return SimpleCheckRecipeResult.ofFailure("fuel_blacklisted");
        }
        return super.checkProcessing();
    }

    @Override
    long fluidIntoPower(ArrayList<FluidStack> aFluids, TurbineStatCalculator turbine) {
        if (!aFluids.isEmpty()) {
            int tEU = 0;
            int actualOptimalFlow = 0;
            FluidStack firstFuelType = new FluidStack(aFluids.get(0), 0);
            int fuelValue = this.getFuelValue(firstFuelType);
            if (turbine.getOptimalGasEUt() < (float)fuelValue) {
                this.realOptFlow = 1.0;
                this.depleteInput(new FluidStack(firstFuelType, 1));
                ++this.storedFluid;
                return GTUtility.safeInt((long)turbine.getOptimalGasEUt());
            }
            actualOptimalFlow = GTUtility.safeInt((long)((float)this.getSpeedMultiplier() * ((this.isLooseMode() ? turbine.getOptimalLooseGasFlow() : turbine.getOptimalGasFlow()) / (float)fuelValue)));
            this.realOptFlow = actualOptimalFlow;
            int remainingFlow = GTUtility.safeInt((long)((float)actualOptimalFlow * 1.25f));
            int flow = 0;
            int totalFlow = 0;
            this.storedFluid = 0;
            for (FluidStack aFluid : aFluids) {
                if (!aFluid.isFluidEqual(firstFuelType)) continue;
                flow = Math.min(aFluid.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluid, flow));
                this.storedFluid += aFluid.amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            if (totalFlow <= 0) {
                return 0L;
            }
            tEU = GTUtility.safeInt((long)totalFlow * (long)fuelValue);
            if (totalFlow != actualOptimalFlow) {
                float efficiency = 1.0f - Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
                tEU = (int)((float)tEU * efficiency);
            }
            tEU = GTUtility.safeInt((long)((float)tEU * (this.isLooseMode() ? turbine.getLooseGasEfficiency() : turbine.getGasEfficiency())));
            return tEU;
        }
        return 0L;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return GTPPCore.RANDOM.nextInt(4) == 0 ? 0 : 1;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public String getMachineType() {
        return "Large Gas Turbine, XLGT";
    }

    @Override
    protected String getTurbineType() {
        return "Gas";
    }

    @Override
    protected String getCasingName() {
        return "Reinforced Gas Turbine Casing";
    }

    @Override
    protected boolean isDenseSteam() {
        return false;
    }

    static {
        BLACKLIST.add(Materials.Benzene.getFluid(0L).getFluid());
    }
}

