/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debug;

import java.io.IOException;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.debug.LogWindow;
import net.minecraft.entity.player.EntityPlayer;

public class SendNewLogLine
extends ModernPacket {
    private int windowID;
    private String line;

    public SendNewLogLine(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.windowID = data.readInt();
        this.line = data.readUTF();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogWindow.getWindow(this.windowID).newLine(this.line);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeInt(this.windowID);
        data.writeUTF(this.line);
    }

    @Override
    public ModernPacket template() {
        return new SendNewLogLine(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public int getWindowID() {
        return this.windowID;
    }

    public SendNewLogLine setWindowID(int windowID) {
        this.windowID = windowID;
        return this;
    }

    public String getLine() {
        return this.line;
    }

    public SendNewLogLine setLine(String line) {
        this.line = line;
        return this;
    }
}

