/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Mixins;

import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import lumien.randomthings.Configuration.VanillaChanges;
import lumien.randomthings.Mixins.TargetedMod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum Mixins {
    BLOCK_MAGICAL_LEAVES(new Builder("Thaumcraft Fast Leaf Decay").setSide(Side.BOTH).addTargetedMod(TargetedMod.THAUMCRAFT).setPhase(Phase.LATE).setApplyIf(() -> VanillaChanges.FASTER_LEAVEDECAY).addMixinClasses("MixinBlockMagicalLeaves"));

    private final List<String> mixinClasses;
    private final List<TargetedMod> targetedMods;
    private final List<TargetedMod> excludedMods;
    private final Supplier<Boolean> applyIf;
    private final Phase phase;
    private final Side side;
    public static final Logger LOGGER;

    private Mixins(Builder builder) {
        this.mixinClasses = builder.mixinClasses;
        this.targetedMods = builder.targetedMods;
        this.excludedMods = builder.excludedMods;
        this.applyIf = builder.applyIf;
        this.phase = builder.phase;
        this.side = builder.side;
        if (this.mixinClasses.isEmpty()) {
            throw new RuntimeException("No mixin class specified for Mixin : " + this.name());
        }
        if (this.targetedMods.isEmpty()) {
            throw new RuntimeException("No targeted mods specified for Mixin : " + this.name());
        }
        if (this.applyIf == null) {
            throw new RuntimeException("No ApplyIf function specified for Mixin : " + this.name());
        }
        if (this.phase == null) {
            throw new RuntimeException("No Phase specified for Mixin : " + this.name());
        }
        if (this.side == null) {
            throw new RuntimeException("No Side function specified for Mixin : " + this.name());
        }
    }

    public static List<String> getEarlyMixins(Set<String> loadedCoreMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        ArrayList<String> notLoading = new ArrayList<String>();
        for (Mixins mixin : Mixins.values()) {
            if (mixin.phase != Phase.EARLY) continue;
            if (mixin.shouldLoad(loadedCoreMods, Collections.emptySet())) {
                mixins.addAll(mixin.mixinClasses);
                continue;
            }
            notLoading.addAll(mixin.mixinClasses);
        }
        LOGGER.info("Not loading the following EARLY mixins: {}", new Object[]{((Object)notLoading).toString()});
        return mixins;
    }

    public static List<String> getLateMixins(Set<String> loadedMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        ArrayList<String> notLoading = new ArrayList<String>();
        for (Mixins mixin : Mixins.values()) {
            if (mixin.phase != Phase.LATE) continue;
            if (mixin.shouldLoad(Collections.emptySet(), loadedMods)) {
                mixins.addAll(mixin.mixinClasses);
                continue;
            }
            notLoading.addAll(mixin.mixinClasses);
        }
        LOGGER.info("Not loading the following LATE mixins: {}", new Object[]{((Object)notLoading).toString()});
        return mixins;
    }

    private boolean shouldLoadSide() {
        return this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient();
    }

    private boolean allModsLoaded(List<TargetedMod> targetedMods, Set<String> loadedCoreMods, Set<String> loadedMods) {
        if (targetedMods.isEmpty()) {
            return false;
        }
        for (TargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA) continue;
            if (!loadedCoreMods.isEmpty() && target.coreModClass != null && !loadedCoreMods.contains(target.coreModClass)) {
                return false;
            }
            if (loadedMods.isEmpty() || target.modId == null || loadedMods.contains(target.modId)) continue;
            return false;
        }
        return true;
    }

    private boolean noModsLoaded(List<TargetedMod> targetedMods, Set<String> loadedCoreMods, Set<String> loadedMods) {
        if (targetedMods.isEmpty()) {
            return true;
        }
        for (TargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA) continue;
            if (!loadedCoreMods.isEmpty() && target.coreModClass != null && loadedCoreMods.contains(target.coreModClass)) {
                return false;
            }
            if (loadedMods.isEmpty() || target.modId == null || !loadedMods.contains(target.modId)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldLoad(Set<String> loadedCoreMods, Set<String> loadedMods) {
        return this.shouldLoadSide() && this.applyIf.get() != false && this.allModsLoaded(this.targetedMods, loadedCoreMods, loadedMods) && this.noModsLoaded(this.excludedMods, loadedCoreMods, loadedMods);
    }

    static {
        LOGGER = LogManager.getLogger((String)"RandomThings");
    }

    private static enum Phase {
        EARLY,
        LATE;

    }

    private static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }

    private static class Builder {
        private final String name;
        private final List<String> mixinClasses = new ArrayList<String>();
        private final List<TargetedMod> targetedMods = new ArrayList<TargetedMod>();
        private final List<TargetedMod> excludedMods = new ArrayList<TargetedMod>();
        private Supplier<Boolean> applyIf = null;
        private Phase phase = null;
        private Side side = null;

        public Builder(String name) {
            this.name = name;
        }

        public Builder addMixinClasses(String ... mixinClasses) {
            this.mixinClasses.addAll(Arrays.asList(mixinClasses));
            return this;
        }

        public Builder setPhase(Phase phase) {
            if (this.phase != null) {
                throw new RuntimeException("Trying to define Phase twice for " + this.name);
            }
            this.phase = phase;
            return this;
        }

        public Builder setSide(Side side) {
            if (this.side != null) {
                throw new RuntimeException("Trying to define Side twice for " + this.name);
            }
            this.side = side;
            return this;
        }

        public Builder setApplyIf(Supplier<Boolean> applyIf) {
            this.applyIf = applyIf;
            return this;
        }

        public Builder addTargetedMod(TargetedMod mod) {
            this.targetedMods.add(mod);
            return this;
        }

        public Builder addExcludedMod(TargetedMod mod) {
            this.excludedMods.add(mod);
            return this;
        }
    }
}

