/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Color;

public class HueBar
implements IDrawable {
    private static final int[] COLORS = new int[]{Color.ofHSV(60.0f, 1.0f, 1.0f, 1.0f), Color.ofHSV(120.0f, 1.0f, 1.0f, 1.0f), Color.ofHSV(180.0f, 1.0f, 1.0f, 1.0f), Color.ofHSV(240.0f, 1.0f, 1.0f, 1.0f), Color.ofHSV(300.0f, 1.0f, 1.0f, 1.0f), Color.ofHSV(0.0f, 1.0f, 1.0f, 1.0f)};
    private final GuiAxis axis;

    public HueBar(GuiAxis axis) {
        this.axis = axis;
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        int size = this.axis.isHorizontal() ? width : height;
        float step = (float)size / 6.0f;
        int previous = COLORS[5];
        for (int i = 0; i < 6; ++i) {
            int current = COLORS[i];
            if (this.axis.isHorizontal()) {
                GuiDraw.drawHorizontalGradientRect((float)x + step * (float)i, y, step, height, previous, current);
            } else {
                GuiDraw.drawVerticalGradientRect(x, (float)y + step * (float)i, width, step, previous, current);
            }
            previous = current;
        }
    }
}

