/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.gui;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiScrollableList<T> {
    protected final int slotHeight;
    private final Minecraft mc = Minecraft.func_71410_x();
    protected final int originX;
    protected final int originY;
    protected final int width;
    protected final int height;
    protected int minY;
    protected int maxY;
    protected int minX;
    protected int maxX;
    protected int mouseX;
    protected int mouseY;
    protected int selectedIndex = -1;
    protected int margin = 4;
    protected final List<ListSelectionListener<T>> listeners = new CopyOnWriteArrayList<ListSelectionListener<T>>();
    private int scrollUpButtonID;
    private int scrollDownButtonID;
    private float initialClickY = -2.0f;
    private float scrollMultiplier;
    private float amountScrolled;
    private long lastClickedTime;
    private boolean showSelectionBox = true;

    public GuiScrollableList(int width, int height, int originX, int originY, int slotHeight) {
        this.width = width;
        this.height = height;
        this.originX = originX;
        this.originY = originY;
        this.slotHeight = slotHeight;
        this.minY = originY;
        this.maxY = this.minY + height;
        this.minX = originX;
        this.maxX = this.minX + width;
    }

    public void onGuiInit(IGuiScreen gui) {
        this.minY = this.originY + gui.getGuiTop();
        this.maxY = this.minY + this.height;
        this.minX = this.originX + gui.getGuiLeft();
        this.maxX = this.minX + this.width;
    }

    public void addSelectionListener(ListSelectionListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(ListSelectionListener<T> listener) {
        this.listeners.remove(listener);
    }

    public T getSelectedElement() {
        return this.getElementAt(this.selectedIndex);
    }

    public void setSelection(T selection) {
        this.setSelection(this.getIndexOf(selection));
    }

    public void setSelection(int index) {
        if (index == this.selectedIndex) {
            return;
        }
        this.selectedIndex = index;
        for (ListSelectionListener<T> listener : this.listeners) {
            listener.selectionChanged(this, this.selectedIndex);
        }
    }

    public int getIndexOf(T element) {
        if (element == null) {
            return -1;
        }
        for (int i = 0; i < this.getNumElements(); ++i) {
            if (!element.equals(this.getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    public abstract T getElementAt(int var1);

    public abstract int getNumElements();

    protected abstract void drawElement(int var1, int var2, int var3, int var4, Tessellator var5, boolean var6);

    protected boolean elementClicked(int elementIndex, boolean doubleClick, int mXRelative, int mYRelative) {
        return true;
    }

    public void setShowSelectionBox(boolean val) {
        this.showSelectionBox = val;
    }

    protected int getContentHeight() {
        return this.getNumElements() * this.slotHeight;
    }

    public void setScrollButtonIds(int scrollUpButtonID, int scrollDownButtonID) {
        this.scrollUpButtonID = scrollUpButtonID;
        this.scrollDownButtonID = scrollDownButtonID;
    }

    private void clampScrollToBounds() {
        int i = this.getContentOverhang();
        if (i < 0) {
            i *= -1;
        }
        if (this.amountScrolled < 0.0f) {
            this.amountScrolled = 0.0f;
        }
        if (this.amountScrolled > (float)i) {
            this.amountScrolled = i;
        }
    }

    public int getContentOverhang() {
        return this.getContentHeight() - (this.height - this.margin);
    }

    public void actionPerformed(GuiButton b) {
        if (b.field_146124_l) {
            if (b.field_146127_k == this.scrollUpButtonID) {
                this.amountScrolled -= (float)this.slotHeight * 2.0f / 3.0f;
                this.initialClickY = -2.0f;
                this.clampScrollToBounds();
            } else if (b.field_146127_k == this.scrollDownButtonID) {
                this.amountScrolled += (float)this.slotHeight * 2.0f / 3.0f;
                this.initialClickY = -2.0f;
                this.clampScrollToBounds();
            }
        }
    }

    public void drawScreen(int mX, int mY, float partialTick) {
        this.mouseX = mX;
        this.mouseY = mY;
        this.processMouseEvents();
        this.maxX = this.getContentOverhang() > 0 ? this.minX + this.width - 6 : this.minX + this.width;
        this.clampScrollToBounds();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        ScaledResolution sr = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int sx = this.minX * sr.func_78325_e();
        int sw = this.width * sr.func_78325_e();
        int sy = this.mc.field_71440_d - this.maxY * sr.func_78325_e();
        int sh = this.height * sr.func_78325_e();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
        Tessellator tessellator = Tessellator.field_78398_a;
        this.drawContainerBackground(tessellator);
        int amountScrolled = (int)this.amountScrolled;
        int contentYOffset = this.minY + this.margin - amountScrolled;
        boolean hoveringPrecondition = mX >= this.minX && mX <= this.maxX && mY >= this.minY && mY <= this.maxY;
        this.prepareDrawElements();
        for (int i = 0; i < this.getNumElements(); ++i) {
            int elementY = contentYOffset + i * this.slotHeight;
            int slotHeight = this.slotHeight - this.margin;
            if (elementY > this.maxY || elementY + slotHeight < this.minY) continue;
            if (this.showSelectionBox && i == this.selectedIndex) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                tessellator.func_78378_d(0x808080);
                tessellator.func_78374_a((double)this.minX, (double)(elementY + slotHeight + 2), 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)this.maxX, (double)(elementY + slotHeight + 2), 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)this.maxX, (double)(elementY - 2), 0.0, 1.0, 0.0);
                tessellator.func_78374_a((double)this.minX, (double)(elementY - 2), 0.0, 0.0, 0.0);
                tessellator.func_78378_d(0);
                tessellator.func_78374_a((double)(this.minX + 1), (double)(elementY + slotHeight + 1), 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)(this.maxX - 1), (double)(elementY + slotHeight + 1), 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)(this.maxX - 1), (double)(elementY - 1), 0.0, 1.0, 0.0);
                tessellator.func_78374_a((double)(this.minX + 1), (double)(elementY - 1), 0.0, 0.0, 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
            }
            boolean isHovering = hoveringPrecondition && elementY - 2 <= mY && mY < elementY + slotHeight + 2;
            this.drawElement(i, this.minX, elementY, slotHeight, tessellator, isHovering);
        }
        GL11.glDisable((int)3089);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        tessellator.func_78384_a(0, 0);
        tessellator.func_78374_a((double)this.minX, (double)(this.minY + this.margin), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)this.maxX, (double)(this.minY + this.margin), 0.0, 1.0, 1.0);
        tessellator.func_78384_a(0, 255);
        tessellator.func_78374_a((double)this.maxX, (double)this.minY, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)this.minX, (double)this.minY, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78384_a(0, 255);
        tessellator.func_78374_a((double)this.minX, (double)this.maxY, 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)this.maxX, (double)this.maxY, 0.0, 1.0, 1.0);
        tessellator.func_78384_a(0, 0);
        tessellator.func_78374_a((double)this.maxX, (double)(this.maxY - this.margin), 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)this.minX, (double)(this.maxY - this.margin), 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        this.renderScrollBar(tessellator);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    protected void prepareDrawElements() {
    }

    protected void renderScrollBar(Tessellator tessellator) {
        int contentHeightOverBounds = this.getContentOverhang();
        if (contentHeightOverBounds > 0) {
            int y;
            int clear = (this.maxY - this.minY) * (this.maxY - this.minY) / this.getContentHeight();
            if (clear < 32) {
                clear = 32;
            }
            if (clear > this.maxY - this.minY - 8) {
                clear = this.maxY - this.minY - 8;
            }
            if ((y = (int)this.amountScrolled * (this.maxY - this.minY - clear) / contentHeightOverBounds + this.minY) < this.minY) {
                y = this.minY;
            }
            GL11.glDisable((int)3553);
            int scrollBarMinX = this.getScrollBarX();
            int scrollBarMaxX = scrollBarMinX + 6;
            tessellator.func_78382_b();
            tessellator.func_78384_a(0, 255);
            tessellator.func_78374_a((double)scrollBarMinX, (double)this.maxY, 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)scrollBarMaxX, (double)this.maxY, 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)scrollBarMaxX, (double)this.minY, 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)scrollBarMinX, (double)this.minY, 0.0, 0.0, 0.0);
            tessellator.func_78369_a(0.3f, 0.3f, 0.3f, 1.0f);
            tessellator.func_78374_a((double)scrollBarMinX, (double)(y + clear), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)scrollBarMaxX, (double)(y + clear), 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)scrollBarMaxX, (double)y, 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)scrollBarMinX, (double)y, 0.0, 0.0, 0.0);
            tessellator.func_78369_a(0.7f, 0.7f, 0.7f, 1.0f);
            tessellator.func_78374_a((double)scrollBarMinX, (double)(y + clear - 1), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)(scrollBarMaxX - 1), (double)(y + clear - 1), 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)(scrollBarMaxX - 1), (double)y, 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)scrollBarMinX, (double)y, 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
        }
    }

    private void processMouseEvents() {
        if (Mouse.isButtonDown((int)0)) {
            this.processMouseBown();
        } else {
            this.initialClickY = -1.0f;
        }
    }

    public void handleDWheel(int mouseWheelDelta) {
        if (!Mouse.isButtonDown((int)0)) {
            this.amountScrolled = mouseWheelDelta > 0 ? (this.amountScrolled -= (float)this.slotHeight / 2.0f) : (this.amountScrolled += (float)this.slotHeight / 2.0f);
        }
    }

    private void processMouseBown() {
        if (this.initialClickY == -1.0f) {
            if (this.mouseY >= this.minY && this.mouseY <= this.maxY && this.mouseX >= this.minX && this.mouseX <= this.maxX + 6) {
                boolean clickInBounds = true;
                int y = this.mouseY - this.minY + (int)this.amountScrolled - this.margin;
                int mouseOverElement = y / this.slotHeight;
                if (this.mouseX >= this.minX && this.mouseX <= this.maxX && mouseOverElement >= 0 && y >= 0 && mouseOverElement < this.getNumElements()) {
                    boolean doubleClick;
                    boolean bl = doubleClick = mouseOverElement == this.selectedIndex && Minecraft.func_71386_F() - this.lastClickedTime < 250L;
                    if (this.elementClicked(mouseOverElement, doubleClick, this.mouseX - this.minX, y - this.slotHeight * mouseOverElement)) {
                        this.setSelection(mouseOverElement);
                        this.lastClickedTime = Minecraft.func_71386_F();
                    }
                } else if (this.mouseX >= this.minX && this.mouseX <= this.maxX && y < 0) {
                    clickInBounds = false;
                }
                int scrollBarMinX = this.getScrollBarX();
                int scrollBarMaxX = scrollBarMinX + 6;
                if (this.mouseX >= scrollBarMinX && this.mouseX <= scrollBarMaxX) {
                    int empty;
                    this.scrollMultiplier = -1.0f;
                    int contentHeightOverBounds = this.getContentOverhang();
                    if (contentHeightOverBounds < 1) {
                        contentHeightOverBounds = 1;
                    }
                    if ((empty = (int)((float)((this.maxY - this.minY) * (this.maxY - this.minY)) / (float)this.getContentHeight())) < 32) {
                        empty = 32;
                    }
                    if (empty > this.maxY - this.minY - 8) {
                        empty = this.maxY - this.minY - 8;
                    }
                    this.scrollMultiplier /= (float)(this.maxY - this.minY - empty) / (float)contentHeightOverBounds;
                } else {
                    this.scrollMultiplier = 1.0f;
                }
                this.initialClickY = clickInBounds ? (float)this.mouseY : -2.0f;
            } else {
                this.initialClickY = -2.0f;
            }
        } else if (this.initialClickY >= 0.0f) {
            this.amountScrolled -= ((float)this.mouseY - this.initialClickY) * this.scrollMultiplier;
            this.initialClickY = this.mouseY;
        }
    }

    protected int getScrollBarX() {
        return this.maxX;
    }

    protected void drawContainerBackground(Tessellator tess) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3553);
        tess.func_78382_b();
        tess.func_78378_d(0x202020);
        tess.func_78377_a((double)this.minX, (double)this.maxY, 0.0);
        tess.func_78377_a((double)this.maxX, (double)this.maxY, 0.0);
        tess.func_78377_a((double)this.maxX, (double)this.minY, 0.0);
        tess.func_78377_a((double)this.minX, (double)this.minY, 0.0);
        tess.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static interface IGuiScreen {
        public int getGuiLeft();

        public int getGuiTop();

        public int getXSize();

        public int getYSize();

        public void addButton(GuiButton var1);

        public void removeButton(GuiButton var1);

        public int getOverlayOffsetX();

        public void doActionPerformed(GuiButton var1);
    }

    public static interface ListSelectionListener<T> {
        public void selectionChanged(GuiScrollableList<T> var1, int var2);
    }
}

