/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.loader.extras;

import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobRecipe;
import com.kuba6000.mobsinfo.loader.extras.IExtraLoader;
import com.kuba6000.mobsinfo.loader.extras.Translations;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Nonnull;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.info.ItemInfo;
import lycanite.lycanitesmobs.api.info.Subspecies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LycanitesMobs
implements IExtraLoader {
    @Override
    public void process(String k, ArrayList<MobDrop> drops, MobRecipe recipe) {
        EntityCreatureBase ent;
        if (recipe.entity instanceof EntityCreatureBase && !(ent = (EntityCreatureBase)recipe.entity).isMinion() && !ent.isBoundPet()) {
            int subspeciesScale = 1;
            if (ent.getSubspeciesIndex() > 2) {
                subspeciesScale = Subspecies.rareDropScale;
            } else if (ent.getSubspeciesIndex() > 0) {
                subspeciesScale = Subspecies.uncommonDropScale;
            }
            for (Object drop : ent.drops) {
                if (drop.subspeciesID != -1 && drop.subspeciesID != ent.getSubspeciesIndex()) continue;
                MobDrop mobDrop = new MobDrop(drop.getItemStack((EntityLivingBase)ent, 1), MobDrop.DropType.Normal, (int)(MobDrop.getChanceBasedOnFromTo(drop.minAmount, drop.maxAmount) * (double)drop.chance * (drop.subspeciesID == -1 ? (double)subspeciesScale : 1.0) * (ent.extraMobBehaviour != null && ent.extraMobBehaviour.itemDropMultiplierOverride != 1.0 ? ent.extraMobBehaviour.itemDropMultiplierOverride : 1.0) * 10000.0), null, null, true, false);
                mobDrop.clampChance();
                drops.add(mobDrop);
            }
        }
        if (ItemInfo.seasonalItemDropChance > 0.0) {
            Object drop;
            boolean alwaysDrop = false;
            if (recipe.entity instanceof EntityCreatureBase) {
                if (((EntityCreatureBase)recipe.entity).isMinion()) {
                    return;
                }
                if (((EntityCreatureBase)recipe.entity).getSubspecies() != null) {
                    alwaysDrop = true;
                }
            }
            double chance = alwaysDrop ? 100.0 : (double)((int)(ItemInfo.seasonalItemDropChance * 100.0));
            drop = new MobDrop(new ItemStack(ObjectManager.getItem((String)"halloweentreat"), 1), MobDrop.DropType.Additional, (int)(chance * 100.0), null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.add(new IChanceModifier.NormalChance(chance));
            drop.chanceModifiers.add(new LycanitesMobsOnlyHalloween());
            drops.add((MobDrop)drop);
            chance = alwaysDrop ? 100.0 : (double)((int)(ItemInfo.seasonalItemDropChance * 100.0));
            drop = new MobDrop(new ItemStack(ObjectManager.getItem((String)"wintergift"), 1), MobDrop.DropType.Additional, (int)(chance * 100.0), null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.add(new IChanceModifier.NormalChance(chance));
            drop.chanceModifiers.add(new LycanitesMobsOnlyYuletide());
            drop.chanceModifiers.add(new LycanitesMobsOrOnYuletideDay(chance * 0.5));
            drops.add((MobDrop)drop);
            chance = (alwaysDrop ? 100.0 : (double)((int)(ItemInfo.seasonalItemDropChance * 100.0))) * 0.5;
            drop = new MobDrop(new ItemStack(ObjectManager.getItem((String)"wintergiftlarge"), 1), MobDrop.DropType.Additional, (int)(chance * 100.0), null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.add(new IChanceModifier.NormalChance(chance));
            drop.chanceModifiers.add(new LycanitesMobsOnlyYuletideDay());
            drops.add((MobDrop)drop);
        }
    }

    private static class LycanitesMobsOnlyHalloween
    implements IChanceModifier {
        private LycanitesMobsOnlyHalloween() {
        }

        @Override
        public String getDescription() {
            return Translations.HALLOWEEN_ONLY.get();
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            Calendar calendar = Calendar.getInstance();
            if (calendar.get(5) == 31 && calendar.get(2) == 9 || calendar.get(5) == 1 && calendar.get(2) == 10) {
                return chance;
            }
            return 0.0;
        }
    }

    private static class LycanitesMobsOnlyYuletide
    implements IChanceModifier {
        private LycanitesMobsOnlyYuletide() {
        }

        @Override
        public String getDescription() {
            return Translations.YULETIDE_ONLY.get();
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            Calendar calendar = Calendar.getInstance();
            if (calendar.get(2) == 11 && calendar.get(5) > 9 && calendar.get(5) < 26) {
                return chance;
            }
            return 0.0;
        }

        @Override
        public int getPriority() {
            return 10;
        }
    }

    private static class LycanitesMobsOrOnYuletideDay
    implements IChanceModifier {
        double chance;

        public LycanitesMobsOrOnYuletideDay(double chance) {
            this.chance = chance;
        }

        @Override
        public String getDescription() {
            return Translations.LYCANITES_MOBS_OR_ON_YULETIDE_DAY.get(this.chance);
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            Calendar calendar = Calendar.getInstance();
            if (calendar.get(2) == 11 && calendar.get(5) == 25) {
                return this.chance;
            }
            return chance;
        }

        @Override
        public void writeToByteBuf(ByteBuf byteBuf) {
            byteBuf.writeDouble(this.chance);
        }

        @Override
        public void readFromByteBuf(ByteBuf byteBuf) {
            this.chance = byteBuf.readDouble();
        }
    }

    private static class LycanitesMobsOnlyYuletideDay
    implements IChanceModifier {
        private LycanitesMobsOnlyYuletideDay() {
        }

        @Override
        public String getDescription() {
            return Translations.YULETIDE_DAY_ONLY.get();
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            Calendar calendar = Calendar.getInstance();
            if (calendar.get(2) == 11 && calendar.get(5) == 25) {
                return chance;
            }
            return 0.0;
        }
    }
}

