/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.implementaion;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.localization.PlayerMessages;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.IThEInteractionHelper;
import thaumicenergistics.api.IThEWirelessEssentiaTerminal;
import thaumicenergistics.api.entities.IGolemHookHandler;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.client.gui.GuiArcaneCraftingTerminal;
import thaumicenergistics.common.ThEGuiHandler;
import thaumicenergistics.common.container.ContainerPartArcaneCraftingTerminal;
import thaumicenergistics.common.grid.WirelessAELink;
import thaumicenergistics.common.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.common.integration.tc.GolemHooks;
import thaumicenergistics.common.inventory.HandlerWirelessEssentiaTerminal;
import thaumicenergistics.common.network.packet.server.Packet_S_ArcaneCraftingTerminal;
import thaumicenergistics.common.storage.AspectStack;
import thaumicenergistics.common.utils.ThELog;

public class ThEInteractionHelper
implements IThEInteractionHelper {
    @Override
    public long convertEssentiaAmountToFluidAmount(long essentiaAmount) {
        return EssentiaConversionHelper.INSTANCE.convertEssentiaAmountToFluidAmount(essentiaAmount);
    }

    @Override
    public long convertFluidAmountToEssentiaAmount(long milibuckets) {
        return EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(milibuckets);
    }

    @Override
    public IAspectStack createAspectStack(Aspect aspect, long stackSize) {
        return new AspectStack(aspect, stackSize);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Class<?> getArcaneCraftingTerminalGUIClass() {
        return GuiArcaneCraftingTerminal.class;
    }

    @Override
    public void openWirelessTerminalGui(EntityPlayer player) {
        if (player == null || player instanceof FakePlayer) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack wirelessTerminal = player.func_70694_bm();
        if (wirelessTerminal == null) {
            return;
        }
        if (!(wirelessTerminal.func_77973_b() instanceof IThEWirelessEssentiaTerminal)) {
            return;
        }
        IThEWirelessEssentiaTerminal terminalInterface = (IThEWirelessEssentiaTerminal)wirelessTerminal.func_77973_b();
        if (terminalInterface.getAECurrentPower(wirelessTerminal) == 0.0) {
            player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
            return;
        }
        if (!HandlerWirelessEssentiaTerminal.isTerminalLinked(terminalInterface, wirelessTerminal)) {
            player.func_145747_a(PlayerMessages.CommunicationError.get());
            return;
        }
        String encKey = terminalInterface.getEncryptionKey(wirelessTerminal);
        ArrayList<IWirelessAccessPoint> accessPoints = WirelessAELink.locateAPsInRangeOfPlayer(player, encKey);
        if (accessPoints == null) {
            player.func_145747_a(PlayerMessages.CommunicationError.get());
        } else if (accessPoints.isEmpty()) {
            player.func_145747_a(PlayerMessages.OutOfRange.get());
        } else {
            ThEGuiHandler.launchGui(40, player, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, new Object[]{new HandlerWirelessEssentiaTerminal(player, encKey, terminalInterface, wirelessTerminal)});
        }
    }

    @Override
    @Deprecated
    public void openWirelessTerminalGui(EntityPlayer player, IThEWirelessEssentiaTerminal terminalInterface) {
        this.openWirelessTerminalGui(player);
    }

    @Override
    public void registerGolemHookHandler(IGolemHookHandler handler) {
        try {
            GolemHooks.registerHandler(handler);
        }
        catch (Exception e) {
            ThELog.warning("Caught Exception During API call to registerGolemHookHandler", new Object[0]);
            ThELog.warning(e.toString(), new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setArcaneCraftingTerminalRecipe(ItemStack[] itemsVanilla) {
        try {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (!(player.field_71070_bA instanceof ContainerPartArcaneCraftingTerminal)) {
                return;
            }
            boolean hasItems = false;
            if (itemsVanilla == null || itemsVanilla.length != 9) {
                return;
            }
            IAEItemStack[] items = new IAEItemStack[9];
            for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
                if (itemsVanilla[slotIndex] == null) continue;
                items[slotIndex] = AEApi.instance().storage().createItemStack(itemsVanilla[slotIndex]);
                hasItems = true;
            }
            if (hasItems) {
                Packet_S_ArcaneCraftingTerminal.sendSetCrafting_NEI((EntityPlayer)player, items);
            }
        }
        catch (Exception e) {
            ThELog.warning("Caught Exception During API call to setArcaneCraftingTerminalRecipe", new Object[0]);
            ThELog.warning(e.toString(), new Object[0]);
            e.printStackTrace();
        }
    }
}

