/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.helpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class HttpPost
implements Callable<String> {
    private static final String ENCODING = "UTF-8";
    private HashMap<String, String> postData = new HashMap();
    private String url;

    public HttpPost(String url) {
        this.url = url;
    }

    public void put(String key, String value) {
        try {
            this.postData.put(URLEncoder.encode(key, ENCODING), URLEncoder.encode(value, ENCODING).replaceAll("%00", ""));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String getPost() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.postData.entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append('&');
        }
        if (this.postData.size() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return new String(builder);
    }

    public String getContents() {
        try {
            String line;
            URL url = new URL(this.url);
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream());
            wr.write(this.getPost());
            wr.flush();
            wr.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (builder.length() > 0) {
                    builder.append('\n');
                }
                builder.append(line);
            }
            reader.close();
            return new String(builder);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed link: " + e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch contents from link: " + e);
        }
    }

    @Override
    public String call() throws Exception {
        return this.getContents();
    }
}

