/*
 * Decompiled with CFR 0.152.
 */
package bartworks.util;

import bartworks.util.BWUtil;
import bartworks.util.MathUtils;
import gregtech.api.enums.Materials;

public class BWRecipes {
    public static long calcDecayTicks(int x) {
        long ret = x == 43 ? 5000L : (x == 61 ? 4500L : (x <= 100 ? MathUtils.ceilLong((8000.0 * Math.tanh((double)(-x) / 20.0) + 8000.0) * 1000.0) : MathUtils.ceilLong(8000.0 * Math.tanh((double)(-x) / 65.0) + 8000.0)));
        return ret;
    }

    public static int computeSieverts(int givenSievert, int glassTier, boolean requiresExactSieverts, boolean cleanroom, boolean lowGravity) {
        int specialValue = 0;
        if (cleanroom && lowGravity) {
            specialValue = 3;
        } else if (cleanroom) {
            specialValue = 2;
        } else if (lowGravity) {
            specialValue = 1;
        }
        int sievertValue = 0;
        if (givenSievert >= 83 || givenSievert == 61 || givenSievert == 43) {
            sievertValue += givenSievert;
        }
        sievertValue <<= 1;
        sievertValue |= requiresExactSieverts ? 1 : 0;
        sievertValue <<= 2;
        sievertValue |= specialValue;
        sievertValue <<= 4;
        return sievertValue |= glassTier;
    }

    public static int computeSieverts(Materials material, int glassTier, boolean requiresExactSieverts, boolean cleanroom, boolean lowGravity) {
        int specialValue = 0;
        if (cleanroom && lowGravity) {
            specialValue = 3;
        } else if (cleanroom) {
            specialValue = 2;
        } else if (lowGravity) {
            specialValue = 1;
        }
        int aSievert = 0;
        if (material.getProtons() >= 83L || material.getProtons() == 61L || material.getProtons() == 43L) {
            aSievert += BWUtil.calculateSv(material);
        }
        aSievert <<= 1;
        aSievert |= requiresExactSieverts ? 1 : 0;
        aSievert <<= 2;
        aSievert |= specialValue;
        aSievert <<= 4;
        return aSievert |= glassTier;
    }
}

