/*
 * Decompiled with CFR 0.152.
 */
package bartworks.util;

import bartworks.util.BWColorUtil;
import bartworks.util.BWUtil;
import bartworks.util.BioDNA;
import bartworks.util.BioData;
import bartworks.util.BioPlasmid;
import bartworks.util.MurmurHash3;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.util.GTLanguageManager;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.item.EnumRarity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BioCulture
extends BioData
implements IColorModulationContainer {
    public static final ArrayList<BioCulture> BIO_CULTURE_ARRAY_LIST = new ArrayList();
    public static final BioCulture NULLCULTURE = BioCulture.createAndRegisterBioCulture(Color.BLUE, "", BioPlasmid.NULLPLASMID, BioDNA.NULLDNA, false);
    Color color;
    BioPlasmid plasmid;
    BioDNA dDNA;
    boolean bBreedable;
    Fluid mFluid;

    public String getLocalisedName() {
        return GTLanguageManager.getTranslation(this.getName());
    }

    public void setLocalisedName(String localisedName) {
        GTLanguageManager.addStringLocalization(this.getName(), localisedName);
    }

    protected BioCulture(Color color, String name, int ID, BioPlasmid plasmid, BioDNA dDNA, EnumRarity rarity, boolean bBreedable) {
        super(name, ID, rarity);
        this.color = color;
        this.plasmid = plasmid;
        this.dDNA = dDNA;
        this.bBreedable = bBreedable;
    }

    protected BioCulture(Color color, String name, int ID, BioPlasmid plasmid, BioDNA dDNA) {
        super(name, ID, dDNA.getRarity());
        this.color = color;
        this.plasmid = plasmid;
        this.dDNA = dDNA;
    }

    public static BioCulture createAndRegisterBioCulture(Color color, String name, BioPlasmid plasmid, BioDNA dna, EnumRarity rarity, boolean breedable) {
        BioCulture ret = new BioCulture(color, name, BIO_CULTURE_ARRAY_LIST.size(), plasmid, dna, rarity, breedable);
        BIO_CULTURE_ARRAY_LIST.add(ret);
        return ret;
    }

    public static BioCulture createAndRegisterBioCulture(Color color, String name, BioPlasmid plasmid, BioDNA dna, boolean breedable) {
        BioCulture ret = new BioCulture(color, name, BIO_CULTURE_ARRAY_LIST.size(), plasmid, dna, dna.getRarity(), breedable);
        BIO_CULTURE_ARRAY_LIST.add(ret);
        return ret;
    }

    public static NBTTagCompound getNBTTagFromCulture(BioCulture bioCulture) {
        if (bioCulture == null) {
            return new NBTTagCompound();
        }
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74778_a("Name", bioCulture.name);
        ret.func_74783_a("Color", new int[]{bioCulture.color.getRed(), bioCulture.color.getGreen(), bioCulture.color.getBlue()});
        ret.func_74782_a("Plasmid", (NBTBase)BioData.getNBTTagFromBioData(BioData.convertBioPlasmidToBioData(bioCulture.plasmid)));
        ret.func_74782_a("DNA", (NBTBase)BioData.getNBTTagFromBioData(BioData.convertBioDNAToBioData(bioCulture.dDNA)));
        ret.func_74757_a("Breedable", bioCulture.bBreedable);
        ret.func_74774_a("Rarety", BWUtil.getByteFromRarity(bioCulture.rarity));
        if (bioCulture.bBreedable) {
            ret.func_74778_a("Fluid", bioCulture.getFluid().getName());
        }
        return ret;
    }

    public static BioCulture getBioCultureFromNBTTag(NBTTagCompound tag) {
        if (tag == null || tag.func_74759_k("Color").length == 0) {
            return null;
        }
        BioCulture ret = BioCulture.getBioCulture(tag.func_74779_i("Name"));
        if (ret == null) {
            ret = BioCulture.createAndRegisterBioCulture(new Color(tag.func_74759_k("Color")[0], tag.func_74759_k("Color")[1], tag.func_74759_k("Color")[2]), tag.func_74779_i("Name"), BioPlasmid.convertDataToPlasmid(BioCulture.getBioDataFromNBTTag(tag.func_74775_l("Plasmid"))), BioDNA.convertDataToDNA(BioCulture.getBioDataFromNBTTag(tag.func_74775_l("DNA"))), BWUtil.getRarityFromByte(tag.func_74771_c("Rarety")), tag.func_74767_n("Breedable"));
        }
        if (ret.bBreedable) {
            ret.setFluid(FluidRegistry.getFluid((String)tag.func_74779_i("Fluid")));
        }
        if (ret.getFluidNotSet()) {
            ret.setbBreedable(false);
        }
        return ret;
    }

    public static BioCulture getBioCulture(String Name2) {
        if (Name2 == null || Name2.isEmpty()) {
            return null;
        }
        for (BioCulture b : BIO_CULTURE_ARRAY_LIST) {
            if (!b.name.equals(Name2)) continue;
            return b;
        }
        return null;
    }

    public static BioCulture getBioCulture(BioDNA DNA) {
        for (BioCulture b : BIO_CULTURE_ARRAY_LIST) {
            if (!b.getdDNA().equals(DNA)) continue;
            return b;
        }
        return null;
    }

    public Fluid getFluid() {
        if (this.mFluid == null) {
            throw new IllegalStateException("Fluid has not been set yet! The issuring Culture is: " + this.name);
        }
        return this.mFluid;
    }

    public void setFluid(Fluid mFluid) {
        this.mFluid = mFluid;
    }

    public boolean getFluidNotSet() {
        return this.mFluid == null && this.isBreedable();
    }

    public boolean isBreedable() {
        return this.bBreedable;
    }

    public void setbBreedable(boolean bBreedable) {
        this.bBreedable = bBreedable;
    }

    public int getColorRGB() {
        return BWColorUtil.getColorFromRGBArray(new int[]{this.color.getRed(), this.color.getGreen(), this.color.getBlue()});
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public BioPlasmid getPlasmid() {
        return this.plasmid;
    }

    public BioCulture setPlasmid(BioPlasmid plasmid) {
        return this.checkForExisting(new BioCulture(this.color, this.name, this.ID, plasmid, this.dDNA, this.rarity, this.bBreedable));
    }

    private BioCulture checkForExisting(BioCulture culture) {
        if (culture == null) {
            return null;
        }
        for (BioCulture bc : BIO_CULTURE_ARRAY_LIST) {
            if (!culture.getdDNA().equals(bc.getdDNA()) || !culture.getPlasmid().equals(bc.getPlasmid())) continue;
            return bc;
        }
        return culture;
    }

    public BioCulture setPlasmidUnsafe(BioPlasmid plasmid) {
        this.plasmid = plasmid;
        return this;
    }

    public BioDNA getdDNA() {
        return this.dDNA;
    }

    public BioCulture setdDNA(BioDNA dDNA) {
        return this.checkForExisting(new BioCulture(this.color, this.name, this.ID, this.plasmid, dDNA, this.rarity, this.bBreedable));
    }

    public BioCulture setdDNAUnsafe(BioDNA dDNA) {
        this.dDNA = dDNA;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        BioCulture culture = (BioCulture)o;
        return this.isBreedable() == culture.isBreedable() && Objects.equals(this.getColor(), culture.getColor()) && Objects.equals(this.getPlasmid(), culture.getPlasmid()) && Objects.equals(this.getdDNA(), culture.getdDNA()) && Objects.equals(this.mFluid, culture.mFluid);
    }

    @Override
    public int hashCode() {
        return MurmurHash3.murmurhash3_x86_32(ByteBuffer.allocate(17).putInt(MurmurHash3.murmurhash3_x86_32(this.getName(), 0, this.getName().length(), 31)).putInt(this.getColorRGB()).putInt(this.getPlasmid().ID).putInt(this.getdDNA().ID).put((byte)(this.isBreedable() ? 1 : 0)).array(), 0, 17, 31);
    }

    @Override
    public short[] getRGBA() {
        return new short[]{(short)this.getColor().getRed(), (short)this.getColor().getGreen(), (short)this.getColor().getBlue(), (short)this.getColor().getAlpha()};
    }
}

