/*
 * Decompiled with CFR 0.152.
 */
package bwcrossmod.tectech.tileentites.tiered;

import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.pipe.IConnectsToEnergyTunnel;
import tectech.thing.metaTileEntity.pipe.MTEPipeEnergy;

public interface LowPowerLaser
extends IMetaTileEntity,
IConnectsToEnergyTunnel {
    public boolean isSender();

    public boolean isReceiver();

    public boolean isTunnel();

    default public boolean isConnectedCorrectly(ForgeDirection side) {
        return false;
    }

    default public void setEUVar(long aEnergy) {
    }

    default public long getAMPERES() {
        return -1L;
    }

    default public long maxEUInput() {
        return -1L;
    }

    default public long maxEUOutput() {
        return -1L;
    }

    default public long maxEUStore() {
        return -1L;
    }

    default public long getTotalPower() {
        return this.getAMPERES() * Math.max(this.maxEUOutput(), this.maxEUInput()) - this.getAMPERES() / 20L;
    }

    default public void moveAroundLowPower(IGregTechTileEntity aBaseMetaTileEntity) {
        byte color = this.getBaseMetaTileEntity().getColorization();
        if (color >= 0) {
            ForgeDirection front = aBaseMetaTileEntity.getFrontFacing();
            ForgeDirection opposite = front.getOpposite();
            for (int dist = 1; dist < 250; dist = (int)((short)(dist + 1))) {
                LowPowerLaser lowPowerLaser;
                IGregTechTileEntity tGTTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSideAndDistance(front, dist);
                if (tGTTileEntity == null || tGTTileEntity.getColorization() != color) {
                    return;
                }
                IMetaTileEntity aMetaTileEntity = tGTTileEntity.getMetaTileEntity();
                if (aMetaTileEntity == null) {
                    return;
                }
                if (aMetaTileEntity instanceof LowPowerLaser && (lowPowerLaser = (LowPowerLaser)aMetaTileEntity).isReceiver() && opposite == tGTTileEntity.getFrontFacing()) {
                    if (this.maxEUOutput() > lowPowerLaser.maxEUInput() || this.getAMPERES() > lowPowerLaser.getAMPERES()) {
                        aMetaTileEntity.doExplosion(this.maxEUOutput());
                        this.setEUVar(aBaseMetaTileEntity.getStoredEU() - this.maxEUOutput());
                        return;
                    }
                    if (this.maxEUOutput() == lowPowerLaser.maxEUInput()) {
                        long diff = Math.min(this.getAMPERES() * 20L * this.maxEUOutput(), Math.min(lowPowerLaser.maxEUStore() - aMetaTileEntity.getBaseMetaTileEntity().getStoredEU(), aBaseMetaTileEntity.getStoredEU()));
                        this.setEUVar(aBaseMetaTileEntity.getStoredEU() - diff);
                        lowPowerLaser.setEUVar(aMetaTileEntity.getBaseMetaTileEntity().getStoredEU() + diff);
                    }
                    return;
                }
                if (!(aMetaTileEntity instanceof LowPowerLaser && (lowPowerLaser = (LowPowerLaser)aMetaTileEntity).isTunnel() || aMetaTileEntity instanceof MTEPipeEnergy)) {
                    return;
                }
                if (aMetaTileEntity instanceof MTEPipeEnergy) {
                    MTEPipeEnergy tePipeEnergy = (MTEPipeEnergy)aMetaTileEntity;
                    if (tePipeEnergy.connectionCount < 2) {
                        return;
                    }
                    tePipeEnergy.markUsed();
                    return;
                }
                if (!(aMetaTileEntity instanceof LowPowerLaser) || !(lowPowerLaser = (LowPowerLaser)aMetaTileEntity).isTunnel() || lowPowerLaser.isConnectedCorrectly(front)) continue;
                return;
            }
        }
    }
}

