/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.loader;

import bartworks.system.material.WerkstoffLoader;
import bartworks.system.material.gtenhancement.PlatinumSludgeOverHaul;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.items.GGMaterial;
import goodgenerator.util.CrackRecipeAdder;
import goodgenerator.util.ItemRefer;
import goodgenerator.util.MyRecipeAdder;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.common.items.CombType;
import gregtech.common.items.MetaGeneratedItem01;
import gregtech.loaders.misc.GTBees;
import gregtech.mixin.interfaces.accessors.IRecipeMutableAccess;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.item.chemistry.GenericChem;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class NaquadahReworkRecipeLoader {
    public static void RecipeLoad() {
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.naquadahEarth.get(OrePrefixes.dust, 32), Materials.Sodium.getDust(64), Materials.Carbon.getDust(1), GTUtility.copyAmount(0, GenericChem.mSimpleNaquadahCatalyst)).itemOutputs(GGMaterial.inertNaquadah.get(OrePrefixes.dust, 1), Materials.Titanium.getDust(64), Materials.Adamantium.getDust(64), Materials.Gallium.getDust(64)).fluidInputs(Materials.Hydrogen.getGas(64000L), Materials.Fluorine.getGas(64000L), Materials.Oxygen.getGas(100L)).duration(200).eut(GTValues.VP[10]).metadata(GTRecipeConstants.QFT_FOCUS_TIER, 2).addTo(GTPPRecipeMaps.quantumForceTransformerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 32), Materials.Zinc.getDust(64), Materials.Carbon.getDust(1), GTUtility.copyAmount(0, GenericChem.mSimpleNaquadahCatalyst)).itemOutputs(GGMaterial.inertEnrichedNaquadah.get(OrePrefixes.dust, 1), Materials.Trinium.getDust(64)).fluidInputs(Materials.SulfuricAcid.getFluid(16000L), Materials.Oxygen.getGas(100L)).fluidOutputs(GGMaterial.wasteLiquid.getFluidOrGas(32000)).duration(200).eut(GTValues.VP[11]).metadata(GTRecipeConstants.QFT_FOCUS_TIER, 2).addTo(GTPPRecipeMaps.quantumForceTransformerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 32), Materials.Magnesium.getDust(64), GTUtility.copyAmount(0, GenericChem.mAdvancedNaquadahCatalyst)).itemOutputs(GGMaterial.inertNaquadria.get(OrePrefixes.dust, 1), Materials.Barium.getDust(64), Materials.Indium.getDust(64), ItemList.NaquadriaSupersolid.get(1L, new Object[0])).fluidInputs(Materials.PhosphoricAcid.getFluid(16000L), Materials.SulfuricAcid.getFluid(16000L), Materials.Oxygen.getGas(100L)).duration(100).eut(GTValues.VP[12]).metadata(GTRecipeConstants.QFT_FOCUS_TIER, 3).addTo(GTPPRecipeMaps.quantumForceTransformerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.inertNaquadah.get(OrePrefixes.dust, 64), GGMaterial.inertNaquadah.get(OrePrefixes.dust, 32)).itemOutputs(Materials.Nickel.getDust(16)).fluidInputs(Materials.Nickel.getPlasma(2304L)).fluidOutputs(Materials.Naquadah.getMolten(0x144000L)).duration(2000).eut(0).metadata(GTRecipeConstants.NKE_RANGE, MyRecipeAdder.computeRangeNKE(600, 500)).noOptimize().addTo(GoodGeneratorRecipeMaps.neutronActivatorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.inertEnrichedNaquadah.get(OrePrefixes.dust, 64), GGMaterial.inertEnrichedNaquadah.get(OrePrefixes.dust, 32)).itemOutputs(Materials.Titanium.getDust(16)).fluidInputs(Materials.Titanium.getPlasma(2304L)).fluidOutputs(Materials.NaquadahEnriched.getMolten(0x144000L)).duration(2000).eut(0).metadata(GTRecipeConstants.NKE_RANGE, MyRecipeAdder.computeRangeNKE(900, 850)).noOptimize().addTo(GoodGeneratorRecipeMaps.neutronActivatorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.inertNaquadria.get(OrePrefixes.dust, 64), GGMaterial.inertNaquadria.get(OrePrefixes.dust, 32)).itemOutputs(Materials.Americium.getDust(16)).fluidInputs(Materials.Americium.getPlasma(2304L)).fluidOutputs(Materials.Naquadria.getMolten(0x144000L)).duration(2000).eut(0).metadata(GTRecipeConstants.NKE_RANGE, MyRecipeAdder.computeRangeNKE(1100, 1080)).noOptimize().addTo(GoodGeneratorRecipeMaps.neutronActivatorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.naquadahEarth.get(OrePrefixes.dust, 2), GTUtility.getIntegratedCircuit(1)).fluidInputs(GGMaterial.fluoroantimonicAcid.getFluidOrGas(3000)).fluidOutputs(GGMaterial.lowQualityNaquadahEmulsion.getFluidOrGas(2000)).itemOutputs(GGMaterial.titaniumTrifluoride.get(OrePrefixes.dust, 4)).duration(100).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.COIL_HEAT, 3000).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.titaniumTrifluoride.get(OrePrefixes.dust, 4), GTUtility.getIntegratedCircuit(1)).fluidInputs(Materials.Hydrogen.getGas(3000L)).fluidOutputs(Materials.HydrofluoricAcid.getFluid(3000L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.ingotHot, Materials.Titanium, 1L)).duration(120).eut(TierEU.RECIPE_EV).metadata(GTRecipeConstants.COIL_HEAT, 2000).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(0, GTOreDictUnificator.get(OrePrefixes.plate, Materials.Copper, 1L)), Materials.Hydrogen.getCells(8)).fluidInputs(FluidRegistry.getFluidStack((String)"seedoil", (int)3000)).itemOutputs(ItemList.Cell_Empty.get(8L, new Object[0])).fluidOutputs(GGMaterial.towEthyl1Hexanol.getFluidOrGas(1000)).duration(400).eut(TierEU.RECIPE_HV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Sodium, 2L)).fluidInputs(GGMaterial.towEthyl1Hexanol.getFluidOrGas(2000), Materials.PhosphoricAcid.getFluid(1000L), Materials.Ethanol.getFluid(2000L)).fluidOutputs(GGMaterial.P507.getFluidOrGas(1000)).duration(1200).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.lowQualityNaquadahSolution.get(OrePrefixes.cell, 36), GGMaterial.P507.get(OrePrefixes.cell, 4)).itemOutputs(GGMaterial.naquadahAdamantiumSolution.get(OrePrefixes.cell, 30), ItemList.Cell_Empty.get(10L, new Object[0])).fluidOutputs(GGMaterial.fluorineRichWasteLiquid.getFluidOrGas(10000)).duration(4000).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.chemicalReactorRecipes);
        GTValues.RA.stdBuilder().fluidInputs(GGMaterial.P507.getFluidOrGas(4000), GGMaterial.lowQualityNaquadahSolution.getFluidOrGas(36000)).fluidOutputs(GGMaterial.fluorineRichWasteLiquid.getFluidOrGas(10000), GGMaterial.naquadahAdamantiumSolution.getFluidOrGas(30000)).duration(4000).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Quicklime, 40L)).fluidInputs(GGMaterial.fluorineRichWasteLiquid.getFluidOrGas(1500)).fluidOutputs(GGMaterial.wasteLiquid.getFluidOrGas(1000)).itemOutputs(WerkstoffLoader.Fluorspar.get(OrePrefixes.dust, 60)).duration(1000).eut(TierEU.RECIPE_MV).addTo(GTRecipeConstants.UniversalChemical);
        CrackRecipeAdder.addUniversalDistillationRecipe(GGMaterial.wasteLiquid.getFluidOrGas(10000), new FluidStack[]{Materials.SaltWater.getFluid(3000L), FluidRegistry.getFluidStack((String)"phenol", (int)2000), Materials.HydrochloricAcid.getFluid(5000L)}, GTOreDictUnificator.get(OrePrefixes.dust, Materials.Chrome, 3L), 300, TierEU.RECIPE_HV);
        GTValues.RA.stdBuilder().itemOutputs(GGMaterial.adamantine.get(OrePrefixes.dust, 4), GGMaterial.naquadahEarth.get(OrePrefixes.dust, 2), GGMaterial.concentratedEnrichedNaquadahSludge.get(OrePrefixes.dust, 1)).fluidInputs(GGMaterial.naquadahAdamantiumSolution.getFluidOrGas(3000)).fluidOutputs(GGMaterial.naquadahRichSolution.getFluidOrGas(2000)).duration(100).eut(0).metadata(GTRecipeConstants.NKE_RANGE, MyRecipeAdder.computeRangeNKE(230, 200)).noOptimize().addTo(GoodGeneratorRecipeMaps.neutronActivatorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.SodiumHydroxide, 27L)).fluidInputs(GGMaterial.naquadahRichSolution.getFluidOrGas(5000)).itemOutputs(GGMaterial.naquadahine.get(OrePrefixes.dust, 30)).fluidOutputs(GGMaterial.P507.getFluidOrGas(1000)).duration(1000).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.autoclaveRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.naquadahine.get(OrePrefixes.dust, 3), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Carbon, 1L)).fluidOutputs(Materials.CarbonDioxide.getGas(1000L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.ingotHot, Materials.Naquadah, 1L)).duration(40).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COIL_HEAT, 5000).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.SodiumHydroxide, 27L), GTUtility.getIntegratedCircuit(1)).fluidInputs(GGMaterial.lowQualityNaquadahEmulsion.getFluidOrGas(10000)).itemOutputs(GGMaterial.galliumHydroxide.get(OrePrefixes.dust, 64), GGMaterial.galliumHydroxide.get(OrePrefixes.dust, 48), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Antimony, 15L)).outputChances(6250, 6250, 10000).fluidOutputs(GGMaterial.lowQualityNaquadahSolution.getFluidOrGas(9000)).duration(1000).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.centrifugeRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 4)).fluidInputs(GGMaterial.P507.getFluidOrGas(1000), Materials.SulfuricAcid.getFluid(18000L)).fluidOutputs(GGMaterial.enrichedNaquadahRichSolution.getFluidOrGas(4000), GGMaterial.wasteLiquid.getFluidOrGas(1000)).itemOutputs(GGMaterial.naquadahEarth.get(OrePrefixes.dust, 1), GGMaterial.triniumSulphate.get(OrePrefixes.dust, 1)).duration(400).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.ZincSulfate.get(OrePrefixes.dust, 6)).fluidInputs(Materials.Hydrogen.getGas(2000L)).fluidOutputs(Materials.SulfuricAcid.getFluid(1000L)).itemOutputs(Materials.Zinc.getDust(1)).duration(30).eut(TierEU.RECIPE_ULV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.SodiumHydroxide, 60L)).fluidInputs(GGMaterial.enrichedNaquadahRichSolution.getFluidOrGas(10000)).itemOutputs(GGMaterial.concentratedEnrichedNaquadahSludge.get(OrePrefixes.dust, 8)).fluidOutputs(GGMaterial.P507.getFluidOrGas(2500)).duration(1000).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.autoclaveRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.concentratedEnrichedNaquadahSludge.get(OrePrefixes.dust, 16)).itemOutputs(GGMaterial.enrichedNaquadahSulphate.get(OrePrefixes.dust, 64), GGMaterial.enrichedNaquadahSulphate.get(OrePrefixes.dust, 64), GGMaterial.enrichedNaquadahSulphate.get(OrePrefixes.dust, 37), WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 64), WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 64), WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 12), GGMaterial.lowQualityNaquadriaSulphate.get(OrePrefixes.dust, 2)).duration(120).eut(0).metadata(GTRecipeConstants.NKE_RANGE, MyRecipeAdder.computeRangeNKE(480, 460)).noOptimize().addTo(GoodGeneratorRecipeMaps.neutronActivatorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.enrichedNaquadahSulphate.get(OrePrefixes.dust, 11), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Zinc, 2L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.ingotHot, Materials.NaquadahEnriched, 1L), WerkstoffLoader.ZincSulfate.get(OrePrefixes.dust, 12)).duration(100).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COIL_HEAT, 7500).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.triniumSulphate.get(OrePrefixes.dust, 6)).fluidInputs(Materials.Hydrogen.getGas(2000L)).fluidOutputs(Materials.SulfuricAcid.getFluid(1000L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Trinium, 1L)).duration(120).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 4)).fluidInputs(Materials.PhosphoricAcid.getFluid(4000L)).itemOutputs(GGMaterial.indiumPhosphate.get(OrePrefixes.dust, 6), GGMaterial.lowQualityNaquadriaPhosphate.get(OrePrefixes.dust, 4)).outputChances(2000, 10000).duration(400).eut(TierEU.RECIPE_ZPM).addTo(RecipeMaps.centrifugeRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.galliumHydroxide.get(OrePrefixes.dust, 7), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Sodium, 3L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Gallium, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.SodiumHydroxide, 9L)).duration(40).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1), GGMaterial.indiumPhosphate.get(OrePrefixes.dust, 12), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Calcium, 3L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Indium, 2L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.TricalciumPhosphate, 5L)).duration(20).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.lowQualityNaquadriaPhosphate.get(OrePrefixes.dust, 10), Materials.SulfuricAcid.getCells(30)).fluidOutputs(GGMaterial.naquadriaRichSolution.getFluidOrGas(9000)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Barite, 1L), ItemList.Cell_Empty.get(30L, new Object[0])).duration(1000).eut(TierEU.RECIPE_IV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemOutputs(GGMaterial.naquadriaSulphate.get(OrePrefixes.dust, 44), GGMaterial.lowQualityNaquadriaSulphate.get(OrePrefixes.dust, 6)).fluidInputs(GGMaterial.naquadriaRichSolution.getFluidOrGas(9000)).duration(100).eut(0).metadata(GTRecipeConstants.NKE_RANGE, MyRecipeAdder.computeRangeNKE(1100, 1050)).noOptimize().addTo(GoodGeneratorRecipeMaps.neutronActivatorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.lowQualityNaquadriaSulphate.get(OrePrefixes.dust, 3), Materials.Water.getCells(3)).fluidInputs(GGMaterial.P507.getFluidOrGas(500)).fluidOutputs(GGMaterial.lowQualityNaquadriaSolution.getFluidOrGas(3500)).itemOutputs(ItemList.Cell_Empty.get(3L, new Object[0])).duration(500).eut(TierEU.RECIPE_EV).addTo(GTRecipeConstants.UniversalChemical);
        CrackRecipeAdder.addUniversalDistillationRecipe(GGMaterial.lowQualityNaquadriaSolution.getFluidOrGas(7000), new FluidStack[]{GGMaterial.P507.getFluidOrGas(1000), GGMaterial.naquadriaRichSolution.getFluidOrGas(5400), Materials.DilutedSulfuricAcid.getFluid(12000L)}, GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 2), 500, TierEU.RECIPE_IV);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.naquadriaSulphate.get(OrePrefixes.dust, 11), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Magnesium, 2L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.ingotHot, Materials.Naquadria, 1L), GGMaterial.magnesiumSulphate.get(OrePrefixes.dust, 12)).duration(100).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.COIL_HEAT, 9100).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.indiumPhosphate.get(OrePrefixes.dust, 6), GGMaterial.galliumHydroxide.get(OrePrefixes.dust, 7), GTUtility.getIntegratedCircuit(2)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.IndiumGalliumPhosphide, 3L)).duration(15).eut(TierEU.RECIPE_ULV).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Ball.get(0L, new Object[0])).fluidInputs(GGMaterial.naquadahGoo.getFluidOrGas(72)).itemOutputs(ItemRefer.Naquadah_Mass.get(1)).duration(100).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.fluidSolidifierRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Ball.get(0L, new Object[0])).fluidInputs(GGMaterial.enrichedNaquadahGoo.getFluidOrGas(72)).itemOutputs(ItemRefer.Enriched_Naquadah_Mass.get(1)).duration(100).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.fluidSolidifierRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Ball.get(0L, new Object[0])).fluidInputs(GGMaterial.naquadriaGoo.getFluidOrGas(72)).itemOutputs(ItemRefer.Naquadria_Mass.get(1)).duration(100).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.fluidSolidifierRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemRefer.Naquadah_Mass.get(1)).itemOutputs(GGMaterial.naquadahEarth.get(OrePrefixes.dust, 1), GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1)).outputChances(10000, 100).duration(100).eut(2).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemRefer.Enriched_Naquadah_Mass.get(1)).itemOutputs(GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1), GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 1)).outputChances(10000, 100).duration(100).eut(2).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemRefer.Naquadria_Mass.get(1)).itemOutputs(GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 1), GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 1)).outputChances(10000, 100).duration(100).eut(2).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.block, Materials.SiliconSG, 16L), GGMaterial.naquadahine.get(OrePrefixes.dust, 3), ItemList.GalliumArsenideCrystal.get(1L, new Object[0])).fluidInputs(Materials.Argon.getGas(8000L)).itemOutputs(ItemList.Circuit_Silicon_Ingot3.get(1L, new Object[0])).duration(1000).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COIL_HEAT, 4484).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.naquadahine.get(OrePrefixes.dust, 3), Materials.Sodium.getDust(4)).itemOutputs(Materials.Naquadah.getDust(1), Materials.SodiumOxide.getDust(6)).duration(100).eut(TierEU.RECIPE_EV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GGMaterial.naquadahEarth.get(OrePrefixes.dust, 2), GTUtility.getIntegratedCircuit(2)).fluidInputs(Materials.Nitrogen.getGas(1000L)).itemOutputs(Materials.Naquadah.getNuggets(1)).duration(2400).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COIL_HEAT, 5000).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(24)).fluidInputs(Materials.Ethylene.getGas(1000L), FluidRegistry.getFluidStack((String)"steam", (int)2000)).fluidOutputs(Materials.Ethanol.getFluid(1000L)).duration(400).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(Materials.Ethylene.getCells(1), GTUtility.getIntegratedCircuit(24)).fluidInputs(FluidRegistry.getFluidStack((String)"steam", (int)2000)).itemOutputs(Materials.Ethanol.getCells(1)).duration(400).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.chemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.ingotHot, Materials.Naquadah, 1L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Naquadah, 1L)).duration(320).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.vacuumFreezerRecipes);
    }

    public static String displayRecipe(GTRecipe recipe) {
        StringBuilder result = new StringBuilder();
        result.append("Item inputs: ");
        for (ItemStack itemStack : recipe.mInputs) {
            if (itemStack == null) {
                result.append("nullstack, ");
                continue;
            }
            result.append(itemStack.func_77977_a());
            result.append(", ");
        }
        result.append(" Fluid inputs: ");
        for (ItemStack itemStack : recipe.mFluidInputs) {
            if (itemStack == null) {
                result.append("nullstack, ");
                continue;
            }
            result.append(itemStack.getUnlocalizedName());
            result.append(", ");
        }
        result.append(" Item outputs: ");
        for (ItemStack itemStack : recipe.mOutputs) {
            if (itemStack == null) {
                result.append("nullstack, ");
                continue;
            }
            result.append(itemStack.func_77977_a());
            result.append(", ");
        }
        result.append(" Fluid outputs: ");
        for (ItemStack itemStack : recipe.mFluidOutputs) {
            if (itemStack == null) {
                result.append("nullstack, ");
                continue;
            }
            result.append(itemStack.getUnlocalizedName());
            result.append(", ");
        }
        return result.toString();
    }

    public static void Remover() {
        int i;
        int i2;
        boolean modified;
        GTRecipe tRecipe;
        String oredictName;
        int n;
        int modified2;
        int[] oreDict;
        ItemStack input;
        String oredictName2;
        int[] oreDict2;
        ItemStack input2;
        GTLog.out.print("GoodGenerator: Begin to remove pure Naquadah, Enriched Naquadah and Naquadria.\n");
        HashSet<GTRecipe> remove = new HashSet<GTRecipe>(5000);
        HashSet<GTRecipe> reAdd = new HashSet<GTRecipe>(5000);
        block0: for (GTRecipe recipe : RecipeMaps.maceratorRecipes.getAllRecipes()) {
            input2 = recipe.mInputs[0];
            if (!GTUtility.isStackValid(input2)) continue;
            for (int oreDictID : oreDict2 = OreDictionary.getOreIDs((ItemStack)input2)) {
                String oreDictName = OreDictionary.getOreName((int)oreDictID);
                if (!oreDictName.startsWith("ore") && !oreDictName.startsWith("rawOre") && !oreDictName.startsWith("crushed") || !oreDictName.contains("Naq")) continue;
                NaquadahReworkRecipeLoader.processRecipe(remove, reAdd, recipe);
                continue block0;
            }
        }
        RecipeMaps.maceratorRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(RecipeMaps.maceratorRecipes::add);
        RecipeMaps.maceratorRecipes.getBackend().reInit();
        GTLog.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GTLog.out.print("Crusher done!\n");
        block2: for (GTRecipe recipe : RecipeMaps.oreWasherRecipes.getAllRecipes()) {
            input2 = recipe.mInputs[0];
            if (!GTUtility.isStackValid(input2)) continue;
            for (int oreDictID : oreDict2 = OreDictionary.getOreIDs((ItemStack)input2)) {
                oredictName2 = OreDictionary.getOreName((int)oreDictID);
                if (!oredictName2.startsWith("crushed") || !oredictName2.contains("Naq")) continue;
                NaquadahReworkRecipeLoader.processRecipe(remove, reAdd, recipe);
                continue block2;
            }
        }
        RecipeMaps.oreWasherRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(RecipeMaps.oreWasherRecipes::add);
        RecipeMaps.oreWasherRecipes.getBackend().reInit();
        GTLog.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GTLog.out.print("Washer done!\n");
        for (GTRecipe recipe : RecipeMaps.thermalCentrifugeRecipes.getAllRecipes()) {
            input2 = recipe.mInputs[0];
            if (!GTUtility.isStackValid(input2)) continue;
            for (int oreDictID : oreDict2 = OreDictionary.getOreIDs((ItemStack)input2)) {
                oredictName2 = OreDictionary.getOreName((int)oreDictID);
                if (!oredictName2.startsWith("crushed") || !oredictName2.contains("Naq")) continue;
                NaquadahReworkRecipeLoader.processRecipe(remove, reAdd, recipe);
            }
        }
        RecipeMaps.thermalCentrifugeRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(RecipeMaps.thermalCentrifugeRecipes::add);
        RecipeMaps.thermalCentrifugeRecipes.getBackend().reInit();
        GTLog.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GTLog.out.print("Thermal Centrifuge done!\n");
        boolean checkCombs = Mods.Forestry.isModLoaded();
        block6: for (GTRecipe recipe : RecipeMaps.centrifugeRecipes.getAllRecipes()) {
            Object tRecipe2;
            input = null;
            if (recipe.mInputs.length > 0) {
                input = recipe.mInputs[0];
            }
            if (!GTUtility.isStackValid(input)) continue;
            oreDict = OreDictionary.getOreIDs((ItemStack)input);
            if (checkCombs && input.func_77969_a(GTBees.combs.getStackForType(CombType.DOB))) {
                tRecipe2 = recipe.copy();
                modified2 = 0;
                for (int i3 = 0; i3 < tRecipe2.mOutputs.length; ++i3) {
                    if (!GTUtility.isStackValid(tRecipe2.mOutputs[i3]) || !tRecipe2.mOutputs[i3].func_77969_a(Materials.Naquadah.getDustTiny(1))) continue;
                    tRecipe2.mOutputs[i3] = GTUtility.copyAmount((long)tRecipe2.mOutputs[i3].field_77994_a * 2L, GGMaterial.naquadahEarth.get(OrePrefixes.dustTiny, 1));
                    modified2 = 1;
                }
                if (modified2 == 0) continue;
                GTLog.err.println("recipe edited: " + NaquadahReworkRecipeLoader.displayRecipe((GTRecipe)tRecipe2));
                reAdd.add((GTRecipe)tRecipe2);
                remove.add(recipe);
                continue;
            }
            tRecipe2 = oreDict;
            modified2 = ((int[])tRecipe2).length;
            for (n = 0; n < modified2; ++n) {
                int oreDictID = tRecipe2[n];
                oredictName = OreDictionary.getOreName((int)oreDictID);
                if (!oredictName.startsWith("dustPureNaq") && !oredictName.startsWith("dustImpureNaq") && !oredictName.startsWith("dustSpace") && !oredictName.startsWith("dustNaq")) continue;
                tRecipe = recipe.copy();
                modified = false;
                for (i2 = 0; i2 < tRecipe.mOutputs.length; ++i2) {
                    if (!GTUtility.isStackValid(tRecipe.mOutputs[i2])) continue;
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDustTiny(1))) {
                        tRecipe.mOutputs[i2] = GTUtility.copyAmount(tRecipe.mOutputs[i2].field_77994_a * 2, GGMaterial.naquadahEarth.get(OrePrefixes.dustTiny, 1));
                    } else if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDustTiny(1))) {
                        tRecipe.mOutputs[i2] = GTUtility.copyAmount(tRecipe.mOutputs[i2].field_77994_a * 2, GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dustTiny, 1));
                    } else if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDustTiny(1))) {
                        tRecipe.mOutputs[i2] = GTUtility.copyAmount(tRecipe.mOutputs[i2].field_77994_a * 2, GGMaterial.naquadriaEarth.get(OrePrefixes.dustTiny, 1));
                    } else if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDust(1))) {
                        tRecipe.mOutputs[i2] = GTUtility.copyAmount(tRecipe.mOutputs[i2].field_77994_a * 2, GGMaterial.naquadahEarth.get(OrePrefixes.dust, 1));
                    } else if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDust(1))) {
                        tRecipe.mOutputs[i2] = GTUtility.copyAmount(tRecipe.mOutputs[i2].field_77994_a * 2, GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1));
                    } else if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDust(1))) {
                        tRecipe.mOutputs[i2] = GTUtility.copyAmount(tRecipe.mOutputs[i2].field_77994_a * 2, GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 1));
                    } else if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDustSmall(1))) {
                        tRecipe.mOutputs[i2] = GTUtility.copyAmount(tRecipe.mOutputs[i2].field_77994_a * 2, GGMaterial.naquadahEarth.get(OrePrefixes.dustSmall, 1));
                    } else if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDustSmall(1))) {
                        tRecipe.mOutputs[i2] = GTUtility.copyAmount(tRecipe.mOutputs[i2].field_77994_a * 2, GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dustSmall, 1));
                    } else {
                        if (!tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDustSmall(1))) continue;
                        tRecipe.mOutputs[i2] = GTUtility.copyAmount(tRecipe.mOutputs[i2].field_77994_a * 2, GGMaterial.naquadriaEarth.get(OrePrefixes.dustSmall, 1));
                    }
                    modified = true;
                }
                if (!modified) continue block6;
                GTLog.err.println("recipe edited: " + NaquadahReworkRecipeLoader.displayRecipe(tRecipe));
                reAdd.add(tRecipe);
                remove.add(recipe);
                continue block6;
            }
        }
        RecipeMaps.centrifugeRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(RecipeMaps.centrifugeRecipes::add);
        RecipeMaps.centrifugeRecipes.getBackend().reInit();
        GTLog.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GTLog.out.print("Centrifuge done!\n");
        for (GTRecipe recipe : RecipeMaps.hammerRecipes.getAllRecipes()) {
            input = recipe.mInputs[0];
            if (!GTUtility.isStackValid(input)) continue;
            int[] tRecipe2 = oreDict = OreDictionary.getOreIDs((ItemStack)input);
            modified2 = tRecipe2.length;
            for (n = 0; n < modified2; ++n) {
                int oreDictID = tRecipe2[n];
                oredictName = OreDictionary.getOreName((int)oreDictID);
                if (!oredictName.startsWith("crushed") || !oredictName.contains("Naq")) continue;
                NaquadahReworkRecipeLoader.processRecipe(remove, reAdd, recipe);
            }
        }
        RecipeMaps.hammerRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(RecipeMaps.hammerRecipes::add);
        RecipeMaps.hammerRecipes.getBackend().reInit();
        GTLog.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GTLog.out.print("Hammer done!\n");
        for (GTRecipe recipe : RecipeMaps.chemicalReactorRecipes.getAllRecipes()) {
            if (recipe.mFluidOutputs == null) continue;
            boolean isAny = false;
            for (int i4 = 0; i4 < recipe.mFluidOutputs.length; ++i4) {
                if (recipe.mFluidOutputs[i4] == null || !recipe.mFluidOutputs[i4].isFluidEqual(Materials.Naquadah.getMolten(1L)) && !recipe.mFluidOutputs[i4].isFluidEqual(Materials.NaquadahEnriched.getMolten(1L)) && !recipe.mFluidOutputs[i4].isFluidEqual(Materials.Naquadria.getMolten(1L))) continue;
                isAny = true;
                break;
            }
            if (!isAny) continue;
            GTRecipe tRecipe3 = recipe.copy();
            boolean modified3 = false;
            for (i = 0; i < recipe.mFluidOutputs.length; ++i) {
                if (recipe.mFluidOutputs[i] == null) continue;
                if (recipe.mFluidOutputs[i].isFluidEqual(Materials.Naquadah.getMolten(1L))) {
                    tRecipe3.mFluidOutputs[i] = GGMaterial.naquadahGoo.getFluidOrGas(recipe.mFluidOutputs[i].amount * 2);
                    modified3 = true;
                    continue;
                }
                if (recipe.mFluidOutputs[i].isFluidEqual(Materials.NaquadahEnriched.getMolten(1L))) {
                    tRecipe3.mFluidOutputs[i] = GGMaterial.enrichedNaquadahGoo.getFluidOrGas(recipe.mFluidOutputs[i].amount * 2);
                    modified3 = true;
                    continue;
                }
                if (!recipe.mFluidOutputs[i].isFluidEqual(Materials.Naquadria.getMolten(1L))) continue;
                tRecipe3.mFluidOutputs[i] = GGMaterial.naquadriaGoo.getFluidOrGas(recipe.mFluidOutputs[i].amount * 2);
                modified3 = true;
            }
            if (!modified3) continue;
            GTLog.err.println("recipe edited: " + NaquadahReworkRecipeLoader.displayRecipe(tRecipe3));
            reAdd.add(tRecipe3);
            remove.add(recipe);
        }
        RecipeMaps.chemicalReactorRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(RecipeMaps.chemicalReactorRecipes::add);
        RecipeMaps.chemicalReactorRecipes.getBackend().reInit();
        GTLog.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GTLog.out.print("Chemical Reactor done!\n");
        for (GTRecipe recipe : RecipeMaps.multiblockChemicalReactorRecipes.getAllRecipes()) {
            if (recipe.mFluidOutputs == null) continue;
            boolean isAny = false;
            for (int i5 = 0; i5 < recipe.mFluidOutputs.length; ++i5) {
                if (recipe.mFluidOutputs[i5] == null || !recipe.mFluidOutputs[i5].isFluidEqual(Materials.Naquadah.getMolten(1L)) && !recipe.mFluidOutputs[i5].isFluidEqual(Materials.NaquadahEnriched.getMolten(1L)) && !recipe.mFluidOutputs[i5].isFluidEqual(Materials.Naquadria.getMolten(1L))) continue;
                isAny = true;
                break;
            }
            if (!isAny) continue;
            GTRecipe tRecipe4 = recipe.copy();
            boolean modified4 = false;
            for (i = 0; i < recipe.mFluidOutputs.length; ++i) {
                if (recipe.mFluidOutputs[i] == null) continue;
                if (recipe.mFluidOutputs[i].isFluidEqual(Materials.Naquadah.getMolten(1L))) {
                    tRecipe4.mFluidOutputs[i] = GGMaterial.naquadahGoo.getFluidOrGas(recipe.mFluidOutputs[i].amount * 2);
                    modified4 = true;
                    continue;
                }
                if (recipe.mFluidOutputs[i].isFluidEqual(Materials.NaquadahEnriched.getMolten(1L))) {
                    tRecipe4.mFluidOutputs[i] = GGMaterial.enrichedNaquadahGoo.getFluidOrGas(recipe.mFluidOutputs[i].amount * 2);
                    modified4 = true;
                    continue;
                }
                if (!recipe.mFluidOutputs[i].isFluidEqual(Materials.Naquadria.getMolten(1L))) continue;
                tRecipe4.mFluidOutputs[i] = GGMaterial.naquadriaGoo.getFluidOrGas(recipe.mFluidOutputs[i].amount * 2);
                modified4 = true;
            }
            if (!modified4) continue;
            GTLog.err.println("recipe edited: " + NaquadahReworkRecipeLoader.displayRecipe(tRecipe4));
            reAdd.add(tRecipe4);
            remove.add(recipe);
        }
        RecipeMaps.multiblockChemicalReactorRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(RecipeMaps.multiblockChemicalReactorRecipes::add);
        RecipeMaps.multiblockChemicalReactorRecipes.getBackend().reInit();
        GTLog.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GTLog.out.print("Multi Chemical Reactor done!\n");
        block18: for (GTRecipe recipe : GTPPRecipeMaps.simpleWasherRecipes.getAllRecipes()) {
            int[] oreDict3;
            ItemStack input3 = recipe.mInputs[0];
            if (!GTUtility.isStackValid(input3)) continue;
            for (int oreDictID : oreDict3 = OreDictionary.getOreIDs((ItemStack)input3)) {
                oredictName = OreDictionary.getOreName((int)oreDictID);
                if (!oredictName.startsWith("dustImpureNaq") && !oredictName.startsWith("dustPureNaq")) continue;
                tRecipe = recipe.copy();
                modified = false;
                for (i2 = 0; i2 < tRecipe.mOutputs.length; ++i2) {
                    if (!GTUtility.isStackValid(tRecipe.mOutputs[i2])) continue;
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDust(1))) {
                        tRecipe.mOutputs[i2] = GTUtility.copyAmount(tRecipe.mOutputs[i2].field_77994_a, GGMaterial.naquadahEarth.get(OrePrefixes.dust, 1));
                        modified = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDust(1))) {
                        tRecipe.mOutputs[i2] = GTUtility.copyAmount(tRecipe.mOutputs[i2].field_77994_a, GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1));
                        modified = true;
                        continue;
                    }
                    if (!tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDust(1))) continue;
                    tRecipe.mOutputs[i2] = GTUtility.copyAmount(tRecipe.mOutputs[i2].field_77994_a, GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 1));
                    modified = true;
                }
                if (!modified) continue block18;
                GTLog.err.println("recipe edited: " + NaquadahReworkRecipeLoader.displayRecipe(tRecipe));
                reAdd.add(tRecipe);
                remove.add(recipe);
                continue block18;
            }
        }
        GTPPRecipeMaps.simpleWasherRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(GTPPRecipeMaps.simpleWasherRecipes::add);
        GTPPRecipeMaps.simpleWasherRecipes.getBackend().reInit();
        GTLog.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GTLog.out.print("Simple Washer done!\n");
        MetaGeneratedItem01.registerCauldronCleaningFor(Materials.Naquadah, GGMaterial.naquadahEarth.getBridgeMaterial());
        MetaGeneratedItem01.registerCauldronCleaningFor(Materials.NaquadahEnriched, GGMaterial.enrichedNaquadahEarth.getBridgeMaterial());
        MetaGeneratedItem01.registerCauldronCleaningFor(Materials.Naquadria, GGMaterial.naquadriaEarth.getBridgeMaterial());
        GTLog.out.print("GoodGenerator: Replace 3! ");
        GTLog.out.print("Cauldron Wash done!\n");
        CraftingManager.func_77594_a().func_77592_b().forEach(NaquadahReworkRecipeLoader::replaceInCraftTable);
        GTLog.out.print("GoodGenerator: Replace Unknown! ");
        GTLog.out.print("Crafting Table done!\n");
    }

    private static void processRecipe(HashSet<GTRecipe> remove, HashSet<GTRecipe> reAdd, GTRecipe recipe) {
        GTRecipe tRecipe = recipe.copy();
        boolean modified = false;
        for (int i = 0; i < tRecipe.mOutputs.length; ++i) {
            if (!GTUtility.isStackValid(tRecipe.mOutputs[i])) continue;
            if (tRecipe.mOutputs[i].func_77969_a(Materials.Naquadah.getDust(1))) {
                tRecipe.mOutputs[i] = GTUtility.copyAmount(tRecipe.mOutputs[i].field_77994_a * 2, GGMaterial.naquadahEarth.get(OrePrefixes.dust, 1));
                modified = true;
                continue;
            }
            if (tRecipe.mOutputs[i].func_77969_a(Materials.NaquadahEnriched.getDust(1))) {
                tRecipe.mOutputs[i] = GTUtility.copyAmount(tRecipe.mOutputs[i].field_77994_a * 2, GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1));
                modified = true;
                continue;
            }
            if (!tRecipe.mOutputs[i].func_77969_a(Materials.Naquadria.getDust(1))) continue;
            tRecipe.mOutputs[i] = GTUtility.copyAmount(tRecipe.mOutputs[i].field_77994_a * 2, GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 1));
            modified = true;
        }
        if (modified) {
            GTLog.err.println("recipe edited: " + NaquadahReworkRecipeLoader.displayRecipe(tRecipe));
            reAdd.add(tRecipe);
            remove.add(recipe);
        }
    }

    public static void replaceInCraftTable(Object obj) {
        IRecipe recipe = (IRecipe)obj;
        ItemStack result = recipe.func_77571_b();
        if (!(recipe instanceof IRecipeMutableAccess)) {
            return;
        }
        IRecipeMutableAccess mutableRecipe = (IRecipeMutableAccess)recipe;
        Object input = mutableRecipe.gt5u$getRecipeInputs();
        if (GTUtility.areStacksEqual(result, Materials.Naquadah.getDust(1), true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Naquadah)) {
                return;
            }
            mutableRecipe.gt5u$setRecipeOutputItem(GGMaterial.naquadahEarth.get(OrePrefixes.dust, 2));
        } else if (GTUtility.areStacksEqual(result, Materials.NaquadahEnriched.getDust(1), true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.NaquadahEnriched)) {
                return;
            }
            mutableRecipe.gt5u$setRecipeOutputItem(GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 2));
        } else if (GTUtility.areStacksEqual(result, Materials.Naquadria.getDust(1), true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Naquadria)) {
                return;
            }
            mutableRecipe.gt5u$setRecipeOutputItem(GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 2));
        }
    }
}

