/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.gui.GUIColorOverride;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.gui.widgets.CoverTickRateButton;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTTooltipDataCache;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.CoverInfo;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public abstract class CoverBehaviorBase<T extends ISerializableObject> {
    public WeakReference<EntityPlayer> lastPlayer = null;
    private final Class<T> typeToken;
    private final ITexture coverFGTexture;
    protected GTTooltipDataCache mTooltipCache = new GTTooltipDataCache();
    protected GUIColorOverride colorOverride;
    private static final String guiTexturePath = "gregtech:textures/gui/GuiCover.png";

    protected CoverBehaviorBase(Class<T> typeToken) {
        this(typeToken, null);
    }

    protected CoverBehaviorBase(Class<T> typeToken, ITexture coverTexture) {
        this.typeToken = typeToken;
        this.coverFGTexture = coverTexture;
        this.reloadColorOverride();
    }

    public void reloadColorOverride() {
        this.colorOverride = GUIColorOverride.get(guiTexturePath);
    }

    public abstract T createDataObject(int var1);

    public abstract T createDataObject();

    public final T createDataObject(NBTBase aNBT) {
        if (aNBT instanceof NBTTagInt) {
            return this.createDataObject(((NBTTagInt)aNBT).func_150287_d());
        }
        T ret = this.createDataObject();
        ret.loadDataFromNBT(aNBT);
        return ret;
    }

    public final T cast(ISerializableObject aData) {
        if (this.typeToken.isInstance(aData)) {
            return this.forceCast(aData);
        }
        return null;
    }

    private T forceCast(ISerializableObject aData) {
        try {
            return (T)((ISerializableObject)this.typeToken.cast(aData));
        }
        catch (Exception e) {
            throw new RuntimeException("Casting data in " + this.getClass() + ", data " + aData, e);
        }
    }

    public final Block getFacadeBlock(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getFacadeBlockImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final int getFacadeMeta(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getFacadeMetaImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final ItemStack getDisplayStack(int aCoverID, ISerializableObject aCoverVariable) {
        return this.getDisplayStackImpl(aCoverID, this.forceCast(aCoverVariable));
    }

    public final ITexture getSpecialCoverFGTexture(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getSpecialCoverFGTextureImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final ITexture getSpecialCoverTexture(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getSpecialCoverTextureImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean isDataNeededOnClient(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.isDataNeededOnClientImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final void onDataChanged(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        this.onDataChangedImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final void preDataChanged(ForgeDirection side, int aCoverID, int aNewCoverId, ISerializableObject aCoverVariable, ISerializableObject aNewCoverVariable, ICoverable aTileEntity) {
        this.preDataChangedImpl(side, aCoverID, aNewCoverId, this.forceCast(aCoverVariable), this.forceCast(aNewCoverVariable), aTileEntity);
    }

    public final void onDropped(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        this.onDroppedImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean isRedstoneSensitive(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return this.isRedstoneSensitiveImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aTimer);
    }

    public final T doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return this.doCoverThingsImpl(side, aInputRedstone, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aTimer);
    }

    public final boolean onCoverRightClick(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return this.onCoverRightClickImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aPlayer, aX, aY, aZ);
    }

    public final T onCoverScrewdriverClick(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return this.onCoverScrewdriverClickImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aPlayer, aX, aY, aZ);
    }

    public final boolean onCoverShiftRightClick(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer) {
        return this.onCoverShiftRightClickImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aPlayer);
    }

    public final boolean onCoverRemoval(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        return this.onCoverRemovalImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aForced);
    }

    public final void onBaseTEDestroyed(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        this.onBaseTEDestroyedImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final String getDescription(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getDescriptionImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public void onCoverUnload(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        this.onCoverUnloadImpl(side, aCoverID, (ISerializableObject)this.forceCast(aCoverVariable), aTileEntity);
    }

    public final float getBlastProofLevel(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getBlastProofLevelImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsRedstoneGoIn(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsRedstoneGoInImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsRedstoneGoOut(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsRedstoneGoOutImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsEnergyIn(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsEnergyInImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsEnergyOut(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsEnergyOutImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsFluidIn(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.letsFluidInImpl(side, aCoverID, this.forceCast(aCoverVariable), aFluid, aTileEntity);
    }

    public final boolean letsFluidOut(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.letsFluidOutImpl(side, aCoverID, this.forceCast(aCoverVariable), aFluid, aTileEntity);
    }

    public final boolean letsItemsIn(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return this.letsItemsInImpl(side, aCoverID, this.forceCast(aCoverVariable), aSlot, aTileEntity);
    }

    public final boolean letsItemsOut(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return this.letsItemsOutImpl(side, aCoverID, this.forceCast(aCoverVariable), aSlot, aTileEntity);
    }

    public final boolean isGUIClickable(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.isGUIClickableImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean manipulatesSidedRedstoneOutput(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.manipulatesSidedRedstoneOutputImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean alwaysLookConnected(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.alwaysLookConnectedImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final byte getRedstoneInput(ForgeDirection side, byte aInputRedstone, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getRedstoneInputImpl(side, aInputRedstone, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final int getTickRate(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getTickRateImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final byte getLensColor(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getLensColorImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final ItemStack getDrop(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getDropImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public void onPlayerAttach(EntityPlayer player, ItemStack aCover, ICoverable aTileEntity, ForgeDirection side) {
    }

    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new UIFactory(buildContext).createWindow();
    }

    protected Block getFacadeBlockImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return null;
    }

    protected int getFacadeMetaImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return 0;
    }

    protected ItemStack getDisplayStackImpl(int aCoverID, T aCoverVariable) {
        return GTUtility.intToStack(aCoverID);
    }

    protected ITexture getSpecialCoverFGTextureImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return this.coverFGTexture;
    }

    protected ITexture getSpecialCoverTextureImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return null;
    }

    protected boolean isDataNeededOnClientImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected void onDataChangedImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
    }

    protected void preDataChangedImpl(ForgeDirection side, int aCoverID, int aNewCoverId, T aCoverVariable, T aNewCoverVariable, ICoverable aTileEntity) {
    }

    protected void onDroppedImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
    }

    protected void onBaseTEDestroyedImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
    }

    protected void onCoverUnloadImpl(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
    }

    protected boolean isRedstoneSensitiveImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    protected T doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, T aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return aCoverVariable;
    }

    protected boolean onCoverRightClickImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    protected T onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return aCoverVariable;
    }

    protected boolean onCoverShiftRightClickImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer) {
        if (this.hasCoverGUI() && aPlayer instanceof EntityPlayerMP) {
            this.lastPlayer = new WeakReference<EntityPlayer>(aPlayer);
            GTUIInfos.openCoverUI(aTileEntity, aPlayer, side);
            return true;
        }
        return false;
    }

    protected boolean onCoverRemovalImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        return true;
    }

    protected String getDescriptionImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return "";
    }

    protected float getBlastProofLevelImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return 10.0f;
    }

    protected boolean letsRedstoneGoInImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsRedstoneGoOutImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsEnergyInImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsEnergyOutImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsFluidInImpl(ForgeDirection side, int aCoverID, T aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsFluidOutImpl(ForgeDirection side, int aCoverID, T aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsItemsInImpl(ForgeDirection side, int aCoverID, T aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsItemsOutImpl(ForgeDirection side, int aCoverID, T aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return false;
    }

    protected boolean isGUIClickableImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    protected boolean manipulatesSidedRedstoneOutputImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean alwaysLookConnectedImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected byte getRedstoneInputImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return this.letsRedstoneGoIn(side, aCoverID, (ISerializableObject)aCoverVariable, aTileEntity) ? aInputRedstone : (byte)0;
    }

    protected int getTickRateImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return 0;
    }

    protected byte getLensColorImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return -1;
    }

    protected ItemStack getDropImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return GTOreDictUnificator.get(true, aTileEntity.getCoverItemAtSide(side));
    }

    public boolean isCoverPlaceable(ForgeDirection side, ItemStack aStack, ICoverable aTileEntity) {
        return true;
    }

    public boolean hasCoverGUI() {
        return false;
    }

    public boolean onCoverRightclickClient(ForgeDirection side, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    public boolean isSimpleCover() {
        return false;
    }

    public void placeCover(ForgeDirection side, ItemStack aCover, ICoverable aTileEntity) {
        aTileEntity.setCoverIDAtSide(side, GTUtility.stackToInt(aCover));
    }

    public boolean allowsCopyPasteTool() {
        return true;
    }

    public boolean allowsTickRateAddition() {
        return true;
    }

    @NotNull
    public final List<String> getAdditionalTooltip(ISerializableObject coverData) {
        return this.getAdditionalTooltipImpl(this.forceCast(coverData));
    }

    protected List<String> getAdditionalTooltipImpl(T coverData) {
        return ImmutableList.of();
    }

    protected class UIFactory {
        private final CoverUIBuildContext uiBuildContext;
        protected final Supplier<Integer> COLOR_TITLE = () -> this.getTextColorOrDefault("title", 0x222222);
        protected final Supplier<Integer> COLOR_TEXT_GRAY = () -> this.getTextColorOrDefault("text_gray", 0x555555);
        protected final Supplier<Integer> COLOR_TEXT_WARN = () -> this.getTextColorOrDefault("text_warn", 0xFF0000);

        public UIFactory(CoverUIBuildContext buildContext) {
            this.uiBuildContext = buildContext;
        }

        public ModularWindow createWindow() {
            ModularWindow.Builder builder = ModularWindow.builder((int)this.getGUIWidth(), (int)this.getGUIHeight());
            builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
            builder.setGuiTint(this.getUIBuildContext().getGuiColorization());
            this.maybeBindPlayerInventory(builder);
            this.addTitleToUI(builder);
            this.addUIWidgets(builder);
            if (this.getUIBuildContext().isAnotherWindow()) {
                builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(this.getGUIWidth() - 15, 3));
            }
            CoverInfo coverInfo = this.uiBuildContext.getTile().getCoverInfoAtSide(this.uiBuildContext.getCoverSide());
            CoverBehaviorBase<?> behavior = coverInfo.getCoverBehavior();
            if (coverInfo.getMinimumTickRate() > 0 && behavior.allowsTickRateAddition()) {
                builder.widget(new CoverTickRateButton(coverInfo, (IWidgetBuilder<?>)builder).setPos(this.getGUIWidth() - 24, this.getGUIHeight() - 24));
            }
            return builder.build();
        }

        protected void maybeBindPlayerInventory(ModularWindow.Builder builder) {
            if (this.doesBindPlayerInventory() && !this.getUIBuildContext().isAnotherWindow()) {
                builder.bindPlayerInventory(this.getUIBuildContext().getPlayer(), 7, (IDrawable)GUITextureSet.DEFAULT.getItemSlot());
            }
        }

        protected void addUIWidgets(ModularWindow.Builder builder) {
        }

        public CoverUIBuildContext getUIBuildContext() {
            return this.uiBuildContext;
        }

        @Nullable
        public T getCoverData() {
            if (this.isCoverValid()) {
                return CoverBehaviorBase.this.forceCast(this.getUIBuildContext().getTile().getComplexCoverDataAtSide(this.getUIBuildContext().getCoverSide()));
            }
            return null;
        }

        public boolean setCoverData(T data) {
            if (this.isCoverValid()) {
                this.getUIBuildContext().getTile().receiveCoverData(this.getUIBuildContext().getCoverSide(), this.getUIBuildContext().getCoverID(), (ISerializableObject)data, this.getUIBuildContext().getPlayer() instanceof EntityPlayerMP ? (EntityPlayerMP)this.getUIBuildContext().getPlayer() : null);
                return true;
            }
            return false;
        }

        public boolean isCoverValid() {
            return !this.getUIBuildContext().getTile().isDead() && this.getUIBuildContext().getTile().getCoverBehaviorAtSideNew(this.getUIBuildContext().getCoverSide()) != GregTechAPI.sNoBehavior;
        }

        protected void addTitleToUI(ModularWindow.Builder builder) {
            ItemStack coverItem = GTUtility.intToStack(this.getUIBuildContext().getCoverID());
            if (coverItem != null) {
                ((ModularWindow.Builder)builder.widget(new ItemDrawable(coverItem).asWidget().setPos(5, 5).setSize(16, 16))).widget(new TextWidget(coverItem.func_82833_r()).setDefaultColor(this.COLOR_TITLE.get().intValue()).setPos(25, 9));
            }
        }

        protected int getGUIWidth() {
            return 176;
        }

        protected int getGUIHeight() {
            return 107;
        }

        protected boolean doesBindPlayerInventory() {
            return false;
        }

        protected int getTextColorOrDefault(String textType, int defaultColor) {
            return CoverBehaviorBase.this.colorOverride.getTextColorOrDefault(textType, defaultColor);
        }
    }
}

