/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.eventhandler.Event;
import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetricsExporter;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechDeviceInformation;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.ISerializableObject;
import gregtech.common.events.MetricsCoverDataEvent;
import gregtech.common.events.MetricsCoverSelfDestructEvent;
import gregtech.common.misc.GlobalMetricsCoverDatabase;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverMetricsTransmitter
extends CoverBehaviorBase<MetricsTransmitterData> {
    public static final String FREQUENCY_MSB_KEY = "gt.metricscover.freq_msb";
    public static final String FREQUENCY_LSB_KEY = "gt.metricscover.freq_lsb";
    public static final String MACHINE_KEY = "machine_name";
    public static final String CARD_STATE_KEY = "card_state";

    public CoverMetricsTransmitter() {
        this((ITexture)null);
    }

    public CoverMetricsTransmitter(ITexture coverTexture) {
        super(MetricsTransmitterData.class, coverTexture);
    }

    @Override
    public MetricsTransmitterData createDataObject(int aLegacyData) {
        return new MetricsTransmitterData();
    }

    @Override
    public MetricsTransmitterData createDataObject() {
        return new MetricsTransmitterData();
    }

    @Override
    protected int getTickRateImpl(ForgeDirection side, int aCoverID, MetricsTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return 20;
    }

    @Override
    public boolean isCoverPlaceable(ForgeDirection side, ItemStack aStack, ICoverable aTileEntity) {
        IGregTechDeviceInformation device;
        return aTileEntity instanceof IGregTechDeviceInformation && (device = (IGregTechDeviceInformation)((Object)aTileEntity)).isGivingInformation();
    }

    @Override
    protected MetricsTransmitterData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, MetricsTransmitterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        BaseMetaTileEntity baseMTE;
        if (aTileEntity instanceof BaseMetaTileEntity && (baseMTE = (BaseMetaTileEntity)aTileEntity).isGivingInformation()) {
            Object payload;
            IMetaTileEntity iMetaTileEntity = baseMTE.getMetaTileEntity();
            if (iMetaTileEntity instanceof IMetricsExporter) {
                IMetricsExporter metricsExporter = (IMetricsExporter)((Object)iMetaTileEntity);
                payload = metricsExporter.reportMetrics();
            } else {
                payload = ImmutableList.copyOf((Object[])baseMTE.getInfoData());
            }
            MinecraftForge.EVENT_BUS.post((Event)new MetricsCoverDataEvent(aCoverVariable.frequency, (List<String>)payload, new GlobalMetricsCoverDatabase.Coordinates(baseMTE.getWorld().field_73011_w.func_80007_l(), baseMTE.getXCoord(), baseMTE.getYCoord(), baseMTE.getZCoord())));
        }
        return aCoverVariable;
    }

    @Override
    protected void onDroppedImpl(ForgeDirection side, int aCoverID, MetricsTransmitterData aCoverVariable, ICoverable aTileEntity) {
        MinecraftForge.EVENT_BUS.post((Event)new MetricsCoverSelfDestructEvent(aCoverVariable.frequency));
    }

    @Override
    public void onPlayerAttach(EntityPlayer player, ItemStack aCover, ICoverable aTileEntity, ForgeDirection side) {
        BaseMetaTileEntity baseMTE;
        ItemStack baseMTEStack;
        UUID newFrequency = UUID.randomUUID();
        ItemStack cardStack = ItemList.NC_AdvancedSensorCard.get(1L, new Object[0]);
        if (cardStack == null) {
            return;
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74772_a(FREQUENCY_MSB_KEY, newFrequency.getMostSignificantBits());
        tagCompound.func_74772_a(FREQUENCY_LSB_KEY, newFrequency.getLeastSignificantBits());
        tagCompound.func_74768_a(CARD_STATE_KEY, GlobalMetricsCoverDatabase.State.OPERATIONAL.getType());
        if (aTileEntity instanceof BaseMetaTileEntity && (baseMTEStack = (baseMTE = (BaseMetaTileEntity)aTileEntity).getStackForm(1L)) != null) {
            tagCompound.func_74782_a(MACHINE_KEY, (NBTBase)baseMTEStack.func_77955_b(new NBTTagCompound()));
        }
        cardStack.func_77982_d(tagCompound);
        aTileEntity.getCoverInfoAtSide(side).setCoverData(new MetricsTransmitterData(newFrequency));
        EntityItem cardEntity = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, cardStack);
        cardEntity.field_145804_b = 0;
        player.field_70170_p.func_72838_d((Entity)cardEntity);
    }

    @Override
    public boolean allowsCopyPasteTool() {
        return false;
    }

    @Override
    public List<String> getAdditionalTooltipImpl(MetricsTransmitterData data) {
        return ImmutableList.of((Object)StatCollector.func_74837_a((String)"gt.item.adv_sensor_card.tooltip.frequency", (Object[])new Object[]{EnumChatFormatting.UNDERLINE.toString() + EnumChatFormatting.YELLOW + data.frequency.toString()}));
    }

    public static class MetricsTransmitterData
    implements ISerializableObject {
        private UUID frequency;

        public MetricsTransmitterData() {
            this.frequency = UUID.randomUUID();
        }

        public MetricsTransmitterData(@NotNull UUID frequency) {
            this.frequency = frequency;
        }

        @NotNull
        public UUID getFrequency() {
            return this.frequency;
        }

        @Override
        @NotNull
        public ISerializableObject copy() {
            return new MetricsTransmitterData(this.frequency);
        }

        @Override
        @NotNull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a(CoverMetricsTransmitter.FREQUENCY_MSB_KEY, this.frequency.getMostSignificantBits());
            tag.func_74772_a(CoverMetricsTransmitter.FREQUENCY_LSB_KEY, this.frequency.getLeastSignificantBits());
            return tag;
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            if (aNBT instanceof NBTTagCompound) {
                NBTTagCompound tag = (NBTTagCompound)aNBT;
                this.frequency = new UUID(tag.func_74763_f(CoverMetricsTransmitter.FREQUENCY_MSB_KEY), tag.func_74763_f(CoverMetricsTransmitter.FREQUENCY_LSB_KEY));
            }
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeLong(this.frequency.getMostSignificantBits());
            aBuf.writeLong(this.frequency.getLeastSignificantBits());
        }

        @Override
        @NotNull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, @Nullable EntityPlayerMP aPlayer) {
            return new MetricsTransmitterData(new UUID(aBuf.readLong(), aBuf.readLong()));
        }
    }
}

