/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.objects.ItemData;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.UndergroundOil;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.TileEntityOres;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;

public class MTEAdvSeismicProspector
extends MTEBasicMachine {
    boolean ready = false;
    final int radius;
    final int step;
    int cX;
    int cZ;

    public MTEAdvSeismicProspector(int aID, String aName, String aNameRegional, int aTier, int aRadius, int aStep) {
        super(aID, aName, aNameRegional, aTier, 1, "", 1, 1, TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER_GLOW).glow().build()));
        this.radius = aRadius;
        this.step = aStep;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Place, activate with explosives", "2 Powderbarrels, 4 Glyceryl Trinitrate, 16 TNT, or 8 ITNT", "Use Data Stick, Scan Data Stick, Print Data Stick, Bind Pages into Book", "Ore prospecting area = " + this.radius * 2 + "x" + this.radius * 2 + " ONLY blocks below prospector", "Oil prospecting area 3x3 oilfields, each is 8x8 chunks"};
    }

    protected MTEAdvSeismicProspector(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, int aRadius, int aStep) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1);
        this.radius = aRadius;
        this.step = aStep;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEAdvSeismicProspector(this.mName, this.mTier, this.mDescriptionArray, this.mTextures, this.radius, this.step);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ItemStack aStack = aPlayer.func_71045_bC();
            if (!this.ready && (GTUtility.consumeItems(aPlayer, aStack, Item.func_150898_a((Block)Blocks.field_150335_W), 16) || GTUtility.consumeItems(aPlayer, aStack, Ic2Items.industrialTnt.func_77973_b(), 8) || GTUtility.consumeItems(aPlayer, aStack, Materials.Glyceryl, 4) || GTUtility.consumeItems(aPlayer, aStack, ItemList.Block_Powderbarrel.getItem(), 2))) {
                this.ready = true;
                this.mMaxProgresstime = aPlayer.field_71075_bZ.field_75098_d ? 20 : 800;
            } else if (this.ready && this.mMaxProgresstime == 0 && aStack != null && aStack.field_77994_a == 1 && aStack.func_77973_b() == ItemList.Tool_DataStick.getItem()) {
                this.ready = false;
                HashMap<String, Integer> tOres = new HashMap<String, Integer>(36);
                this.prospectOres(tOres);
                ArrayList<String> tOils = new ArrayList<String>();
                this.prospectOils(tOils);
                GTUtility.ItemNBT.setAdvancedProspectionData(this.mTier, aStack, this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g, tOils, GTUtility.sortByValueToList(tOres), this.radius);
            }
        }
        return true;
    }

    private void prospectOils(ArrayList<String> aOils) {
        int xChunk = this.getBaseMetaTileEntity().getXCoord() >> 7 << 3;
        int zChunk = this.getBaseMetaTileEntity().getZCoord() >> 7 << 3;
        LinkedHashMap<ChunkCoordIntPair, FluidStack> tFluids = new LinkedHashMap<ChunkCoordIntPair, FluidStack>();
        int oilFieldCount = 0;
        try {
            int oilfieldSize = 8;
            for (int z = -1; z <= 1; ++z) {
                for (int x = -1; x <= 1; ++x) {
                    ChunkCoordIntPair cInts = new ChunkCoordIntPair(x, z);
                    int min = Integer.MAX_VALUE;
                    int max = Integer.MIN_VALUE;
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            Chunk tChunk = this.getBaseMetaTileEntity().getWorld().func_72964_e(xChunk + i + x * 8, zChunk + j + z * 8);
                            FluidStack tFluid = UndergroundOil.undergroundOilReadInformation(tChunk);
                            if (tFluid == null) continue;
                            if (tFluid.amount > max) {
                                max = tFluid.amount;
                            }
                            if (tFluid.amount < min) {
                                min = tFluid.amount;
                            }
                            if (tFluids.containsKey(cInts)) continue;
                            tFluids.put(cInts, tFluid);
                        }
                    }
                    aOils.add(++oilFieldCount + "," + min + "-" + max + "," + ((FluidStack)tFluids.get(cInts)).getLocalizedName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void prospectOres(Map<String, Integer> aOres) {
        int tLeftXBound = this.getBaseMetaTileEntity().getXCoord() - this.radius;
        int tRightXBound = tLeftXBound + 2 * this.radius;
        int tLeftZBound = this.getBaseMetaTileEntity().getZCoord() - this.radius;
        int tRightZBound = tLeftZBound + 2 * this.radius;
        for (int i = tLeftXBound; i <= tRightXBound; i += this.step) {
            if (Math.abs(i >> 4) % 3 != 1) continue;
            for (int k = tLeftZBound; k <= tRightZBound; k += this.step) {
                if (Math.abs(k >> 4) % 3 != 1) continue;
                this.cX = i >> 4 << 4;
                this.cZ = k >> 4 << 4;
                String separator = this.cX + 8 + "," + (this.cZ + 8) + " --------";
                aOres.put(separator, 1);
                this.prospectHole(i, k, aOres);
            }
        }
    }

    private void prospectHole(int i, int k, Map<String, Integer> aOres) {
        for (int j = this.getBaseMetaTileEntity().getYCoord(); j > 0; --j) {
            String tFoundOre = this.checkForOre(i, j, k);
            if (tFoundOre == null) continue;
            MTEAdvSeismicProspector.countOre(aOres, tFoundOre, this.cX, this.cZ);
        }
    }

    private String checkForOre(int x, int y, int z) {
        Block tBlock = this.getBaseMetaTileEntity().getBlock(x, y, z);
        if (tBlock instanceof BlockOresAbstract) {
            Materials tMaterial;
            TileEntity tTileEntity = this.getBaseMetaTileEntity().getWorld().func_147438_o(x, y, z);
            if (tTileEntity instanceof TileEntityOres && ((TileEntityOres)tTileEntity).mMetaData < 16000 && (tMaterial = GregTechAPI.sGeneratedMaterials[((TileEntityOres)tTileEntity).mMetaData % 1000]) != null && tMaterial != Materials._NULL) {
                return tMaterial.mDefaultLocalName;
            }
        } else {
            int tMetaID = this.getBaseMetaTileEntity().getWorld().func_72805_g(x, y, z);
            ItemStack is = new ItemStack(tBlock, 1, tMetaID);
            ItemData association = GTOreDictUnificator.getAssociation(is);
            if (association != null && association.mPrefix.toString().startsWith("ore")) {
                return association.mMaterial.mMaterial.mDefaultLocalName;
            }
            if (GTUtility.isOre(tBlock, tMetaID)) {
                return tBlock.func_149732_F();
            }
        }
        return null;
    }

    private static void countOre(Map<String, Integer> map, String ore, int cCX, int cCZ) {
        ore = cCX + 8 + "," + (cCZ + 8) + " has " + ore;
        Integer oldCount = map.get(ore);
        oldCount = oldCount == null ? 0 : oldCount;
        map.put(ore, oldCount + 1);
    }
}

