/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import bartworks.API.BorosilicateGlass;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings10;
import gregtech.common.tileentities.render.TileEntityLaser;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoTunnel;

public class MTEIndustrialLaserEngraver
extends MTEExtendedPowerMultiBlockBase<MTEIndustrialLaserEngraver>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEIndustrialLaserEngraver> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", (String[][])new String[][]{{"  f  ", "     ", "     ", "     ", " a~a "}, {" fsf ", "  g  ", "  g  ", "a g a", "aaraa"}, {"faaaf", "f   f", "f   f", "a   a", "aaaaa"}, {"aaaaa", "a a a", "a a a", "a a a", "aaaaa"}, {"aaaaa", "aaaaa", "aaaaa", "aaaaa", "aaaaa"}}).addElement('a', GTStructureUtility.buildHatchAdder(MTEIndustrialLaserEngraver.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Maintenance, HatchElement.Energy).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(1)).dot(1).buildAndChain(StructureUtility.onElementPass(MTEIndustrialLaserEngraver::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)1)))).addElement('f', GTStructureUtility.ofFrame(Materials.TungstenSteel)).addElement('g', BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier)).addElement('r', StructureUtility.ofBlock((Block)GregTechAPI.sLaserRender, (int)0)).addElement('s', GTStructureUtility.buildHatchAdder(MTEIndustrialLaserEngraver.class).adder(MTEIndustrialLaserEngraver::addLaserSource).hatchClass(MTEHatchDynamoTunnel.class).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(1)).dot(3).build()).build();
    protected TileEntityLaser renderer;
    private byte glassTier = 0;
    private MTEHatchDynamoTunnel laserSource = null;
    private int laserAmps = 0;
    private int laserTier = 0;
    private String tierName = "LV";
    private boolean stopAllRendering = false;
    private int mCasingAmount;
    private static final Map<String, Colors> lensColors = new HashMap<String, Colors>();

    private boolean addLaserSource(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity;
        if (aTileEntity != null && (aMetaTileEntity = aTileEntity.getMetaTileEntity()) instanceof MTEHatchDynamoTunnel) {
            this.laserSource = (MTEHatchDynamoTunnel)aMetaTileEntity;
            this.laserSource.updateTexture(aBaseCasingIndex);
            switch (this.getRotation()) {
                case NORMAL: {
                    this.laserSource.getBaseMetaTileEntity().setFrontFacing(ForgeDirection.DOWN);
                    break;
                }
                case UPSIDE_DOWN: {
                    this.laserSource.getBaseMetaTileEntity().setFrontFacing(ForgeDirection.UP);
                    break;
                }
                case CLOCKWISE: {
                    this.laserSource.getBaseMetaTileEntity().setFrontFacing(this.getDirection().getRotation(ForgeDirection.UP));
                    break;
                }
                default: {
                    this.laserSource.getBaseMetaTileEntity().setFrontFacing(this.getDirection().getRotation(ForgeDirection.DOWN));
                }
            }
            this.laserAmps = (int)Math.cbrt(this.laserSource.maxAmperesOut());
            this.laserTier = (int)this.laserSource.getOutputTier();
            this.tierName = GTValues.VN[this.laserTier + 1];
            return true;
        }
        return false;
    }

    public MTEIndustrialLaserEngraver(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialLaserEngraver(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTEIndustrialLaserEngraver> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialLaserEngraver(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 1)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ENGRAVER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ENGRAVER_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 1)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ENGRAVER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ENGRAVER_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 1))};
        return rTexture;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        boolean bl = this.stopAllRendering = !this.stopAllRendering;
        if (this.stopAllRendering) {
            PlayerUtils.messagePlayer(aPlayer, "Rendering off");
            if (this.renderer != null) {
                this.renderer.setShouldRender(false);
            }
        } else {
            PlayerUtils.messagePlayer(aPlayer, "Rendering on");
        }
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        if (this.renderer != null) {
            this.renderer.toggleRealism();
            PlayerUtils.messagePlayer(aPlayer, "Toggling realism!");
            return true;
        }
        return false;
    }

    @Override
    public void onBlockDestroyed() {
        if (this.renderer != null) {
            this.renderer.setShouldRender(false);
        }
        super.onBlockDestroyed();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Laser Engraver, HILE").addInfo("200% faster than single block machines of the same voltage").addInfo("Uses 80% of the EU normally required").addInfo("Laser source hatch determines maximum recipe tier and parallels").addInfo("Can perform recipes up to laser source tier + 1").addInfo("Parallels equal to the cube root of laser source amperage input").addInfo("Glass tier determines maximum laser source tier").addInfo("UMV glass accepts all laser source hatches").addInfo("Use screwdriver to disable laser rendering").addInfo("Use wire cutter to toggle realism mode if you hate angled lasers").beginStructureBlock(5, 5, 5, false).addController("Front Center").addCasingInfoMin("Laser Containment Casing", 35, false).addCasingInfoExactly("Tungstensteel Frame Box", 9, false).addCasingInfoExactly("Glass", 3, true).addOtherStructurePart("Laser Resistant Plate", "x1").addOtherStructurePart("Laser Source Hatch", "x1", 3).addInputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addOutputBus("Any Casing", 1).addOutputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).toolTipFinisher(GTValues.AuthorFourIsTheNumber);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 4, 0, elementBudget, env, false, true);
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    private boolean findLaserRenderer(World w, int x, int y, int z) {
        ForgeDirection opposite = this.getDirection().getOpposite();
        TileEntity tileEntity = w.func_147438_o(x += opposite.offsetX, y += opposite.offsetY, z += opposite.offsetZ);
        if (tileEntity instanceof TileEntityLaser) {
            TileEntityLaser laser;
            this.renderer = laser = (TileEntityLaser)tileEntity;
            this.renderer.setRotationFields(this.getDirection(), this.getRotation(), this.getFlip());
            return true;
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingAmount = 0;
        this.glassTier = 0;
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 4, 0)) {
            return false;
        }
        if (this.mCasingAmount < 35) {
            return false;
        }
        if (this.laserSource == null) {
            return false;
        }
        if (!this.findLaserRenderer(base.getWorld(), base.getXCoord(), base.getYCoord(), base.getZCoord())) {
            return false;
        }
        return this.glassTier >= 12 || this.laserSource.mTier <= this.glassTier;
    }

    private static String getUniqueIdentifier(ItemStack is) {
        return is.func_77973_b().func_77658_a() + is.func_77960_j();
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)((ProcessingLogic)new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (MTEIndustrialLaserEngraver.this.laserTier < 13 && (long)recipe.mEUt > GTValues.V[MTEIndustrialLaserEngraver.this.laserTier + 1]) {
                    return SimpleCheckRecipeResult.ofFailure("laser_insufficient");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected CheckRecipeResult onRecipeStart(@NotNull GTRecipe recipe) {
                if (!MTEIndustrialLaserEngraver.this.stopAllRendering) {
                    Colors c = Colors.Red;
                    for (int i = 0; i < recipe.mInputs.length; ++i) {
                        String uid = MTEIndustrialLaserEngraver.getUniqueIdentifier(recipe.mInputs[i]);
                        if (!lensColors.containsKey(uid)) continue;
                        c = (Colors)((Object)lensColors.get(uid));
                    }
                    if (MTEIndustrialLaserEngraver.this.renderer != null) {
                        MTEIndustrialLaserEngraver.this.renderer.setColors(c.r, c.g, c.b);
                        MTEIndustrialLaserEngraver.this.renderer.setShouldRender(true);
                    }
                }
                return super.onRecipeStart(recipe);
            }

            @Override
            public ProcessingLogic clear() {
                if (MTEIndustrialLaserEngraver.this.renderer != null) {
                    MTEIndustrialLaserEngraver.this.renderer.setShouldRender(false);
                }
                return super.clear();
            }
        }.setSpeedBonus(0.3333333432674408)).setEuModifier(0.8f)).setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    public boolean isRotationChangeAllowed() {
        return true;
    }

    private int getMaxParallelRecipes() {
        return this.laserAmps;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.laserEngraverRecipes;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -10;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GTUtility.roundUpVoltage(this.getMaxInputVoltage()));
        logic.setAvailableAmperage(1L);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("stopAllRendering", this.stopAllRendering);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("stopAllRendering")) {
            this.stopAllRendering = aNBT.func_74767_n("stopAllRendering");
        }
        super.loadNBTData(aNBT);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("laserAmps", this.laserAmps);
        tag.func_74778_a("tierName", this.tierName);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.WHITE + tag.func_74762_e("laserAmps") + EnumChatFormatting.RESET);
        currentTip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.maxtier") + ": " + EnumChatFormatting.WHITE + tag.func_74779_i("tierName") + EnumChatFormatting.RESET);
    }

    static {
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Forcicium, 1L)), Colors.Black);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Forcillium, 1L)), Colors.Black);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.InfusedEntropy, 1L)), Colors.Black);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.NetherStar, 1L)), Colors.White);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Dilithium, 1L)), Colors.White);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Glass, 1L)), Colors.White);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Diamond, 1L)), Colors.Cyan);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.InfusedOrder, 1L)), Colors.White);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Emerald, 1L)), Colors.Green);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Olivine, 1L)), Colors.Green);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.GreenSapphire, 1L)), Colors.Green);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.InfusedEarth, 1L)), Colors.Green);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Ruby, 1L)), Colors.Red);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Firestone, 1L)), Colors.Red);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Jasper, 1L)), Colors.Red);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.FoolsRuby, 1L)), Colors.Red);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.GarnetRed, 1L)), Colors.Red);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.InfusedFire, 1L)), Colors.Red);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.BlueTopaz, 1L)), Colors.Blue);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Opal, 1L)), Colors.Blue);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.InfusedWater, 1L)), Colors.Blue);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.GarnetYellow, 1L)), Colors.Yellow);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Force, 1L)), Colors.Yellow);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.InfusedAir, 1L)), Colors.Yellow);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Amethyst, 1L)), Colors.Purple);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Tanzanite, 1L)), Colors.Purple);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Sapphire, 1L)), Colors.Purple);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.EnderEye, 1L)), Colors.Cyan);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.EnderPearl, 1L)), Colors.Cyan);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Topaz, 1L)), Colors.Orange);
        lensColors.put(MTEIndustrialLaserEngraver.getUniqueIdentifier(GTOreDictUnificator.get(OrePrefixes.lens, Materials.Amber, 1L)), Colors.Orange);
        lensColors.put("gt.bwMetaGeneratedlens1", Colors.Yellow);
        lensColors.put("gt.bwMetaGeneratedlens4", Colors.White);
        lensColors.put("gt.bwMetaGeneratedlens5", Colors.Black);
        lensColors.put("gt.bwMetaGeneratedlens7", Colors.Green);
        lensColors.put("gt.bwMetaGeneratedlens8", Colors.Green);
        lensColors.put("gt.bwMetaGeneratedlens9", Colors.White);
        lensColors.put("gt.bwMetaGeneratedlens19", Colors.Red);
        lensColors.put("gt.bwMetaGeneratedlens20", Colors.White);
        lensColors.put("gt.bwMetaGeneratedlens21", Colors.Brown);
        lensColors.put("gt.bwMetaGeneratedlens22", Colors.Orange);
        lensColors.put("gt.bwMetaGeneratedlens23", Colors.Black);
        lensColors.put("gt.bwMetaGeneratedlens24", Colors.White);
        lensColors.put("gt.bwMetaGeneratedlens25", Colors.Green);
        lensColors.put("gt.bwMetaGeneratedlens35", Colors.Yellow);
        lensColors.put("gt.bwMetaGeneratedlens36", Colors.Purple);
        lensColors.put("gt.bwMetaGeneratedlens43", Colors.Green);
        lensColors.put("gt.bwMetaGeneratedlens89", Colors.Green);
        lensColors.put("gt.bwMetaGeneratedlens91", Colors.Purple);
        lensColors.put("gt.bwMetaGeneratedlens10023", Colors.Red);
        lensColors.put("gt.bwMetaGeneratedlens11499", Colors.Green);
        lensColors.put("gt.bwMetaGeneratedlens11358", Colors.Red);
        lensColors.put("MU-metaitem.0132140", Colors.Purple);
    }

    private static enum Colors {
        White(1.0f, 1.0f, 1.0f),
        Red(1.0f, 0.0f, 0.0f),
        Green(0.0f, 1.0f, 0.0f),
        Blue(0.0f, 0.0f, 1.0f),
        Yellow(1.0f, 1.0f, 0.0f),
        Purple(1.0f, 0.0f, 1.0f),
        Cyan(0.0f, 1.0f, 1.0f),
        Orange(1.0f, 0.5f, 0.0f),
        Black(0.0f, 0.0f, 0.0f),
        Brown(0.647f, 0.164f, 0.164f);

        final float r;
        final float g;
        final float b;

        private Colors(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

