/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.GTProxy;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ProcessingShaping
implements IOreRecipeRegistrator {
    public ProcessingShaping() {
        OrePrefixes.ingot.add(this);
        OrePrefixes.dust.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aMaterial == Materials.Calcium || aMaterial == Materials.Magnesia) {
            return;
        }
        if (!(aMaterial != Materials.Glass && GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L) == null || aMaterial.contains(SubTag.NO_SMELTING))) {
            long aMaterialMass = aMaterial.getMass();
            int tAmount = (int)(aPrefix.mMaterialAmount / 3628800L);
            if (tAmount > 0 && tAmount <= 64 && aPrefix.mMaterialAmount % 3628800L == 0L) {
                int tVoltageMultiplier = aMaterial.mBlastFurnaceTemp >= 2800 ? 60 : 15;
                int tTrueVoltage = aMaterial.getProcessingMaterialTierEU();
                if (aMaterial.contains(SubTag.NO_SMASHING)) {
                    tVoltageMultiplier /= 4;
                } else if (aPrefix.name().startsWith(OrePrefixes.dust.name())) {
                    return;
                }
                if (!OrePrefixes.block.isIgnored(aMaterial.mSmeltInto) && GTOreDictUnificator.get(OrePrefixes.block, aMaterial.mSmeltInto, 1L) != null && aMaterial != Materials.Ichorium) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, aStack), ItemList.Shape_Extruder_Block.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.block, aMaterial.mSmeltInto, (long)tAmount)).duration(10 * tAmount * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                    if ((long)tTrueVoltage < TierEU.IV) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, aStack), ItemList.Shape_Mold_Block.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.block, aMaterial.mSmeltInto, (long)tAmount)).duration(5 * tAmount * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 4 * tVoltageMultiplier)).recipeCategory(RecipeCategories.alloySmelterMolding).addTo(RecipeMaps.alloySmelterRecipes);
                    }
                }
                if ((aPrefix != OrePrefixes.ingot || aMaterial != aMaterial.mSmeltInto) && GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Ingot.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial.mSmeltInto, (long)tAmount)).duration(10).eut(GTUtility.calculateRecipeEU(aMaterial, 4 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.pipeTiny, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Pipe_Tiny.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.pipeTiny, aMaterial.mSmeltInto, (long)(tAmount * 2))).duration(4 * tAmount * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Pipe_Small.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial.mSmeltInto, (long)tAmount)).duration(8 * tAmount * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack), ItemList.Shape_Extruder_Pipe_Medium.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial.mSmeltInto, (long)tAmount)).duration(24 * tAmount * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.pipeLarge, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(6, aStack), ItemList.Shape_Extruder_Pipe_Large.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.pipeLarge, aMaterial.mSmeltInto, (long)tAmount)).duration(48 * tAmount * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.pipeHuge, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(12, aStack), ItemList.Shape_Extruder_Pipe_Huge.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.pipeHuge, aMaterial.mSmeltInto, (long)tAmount)).duration(96 * tAmount * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Plate.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.gearGtSmall, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Small_Gear.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gearGtSmall, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(6, aStack), ItemList.Shape_Extruder_Turbine_Blade.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (aMaterial != Materials.AnnealedCopper && aMaterial != Materials.WroughtIron && !aMaterial.contains(SubTag.NO_SMELTING) && aPrefix == OrePrefixes.ingot && aMaterial.mStandardMoltenFluid != null) {
                    if (GTOreDictUnificator.get(OrePrefixes.ring, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Ring.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.ring, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(36L)).duration(100).eut(GTUtility.calculateRecipeEU(aMaterial, 4 * tVoltageMultiplier)).addTo(RecipeMaps.fluidSolidifierRecipes);
                    }
                    if (GTOreDictUnificator.get(OrePrefixes.screw, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Screw.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.screw, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(18L)).duration(50).eut(GTUtility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).addTo(RecipeMaps.fluidSolidifierRecipes);
                    }
                    if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Rod.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(72L)).duration(150).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.fluidSolidifierRecipes);
                    }
                    if (GTOreDictUnificator.get(OrePrefixes.bolt, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Bolt.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.bolt, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(18L)).duration(50).eut(GTUtility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).addTo(RecipeMaps.fluidSolidifierRecipes);
                    }
                    if (GTOreDictUnificator.get(OrePrefixes.round, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Round.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.round, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(18L)).duration(50).eut(GTUtility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).addTo(RecipeMaps.fluidSolidifierRecipes);
                    }
                    if (GTOreDictUnificator.get(OrePrefixes.stickLong, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Rod_Long.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.stickLong, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(144L)).duration(300).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.fluidSolidifierRecipes);
                    }
                    if (GTOreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Turbine_Blade.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(864L)).duration(400).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.fluidSolidifierRecipes);
                    }
                    if (GTOreDictUnificator.get(OrePrefixes.pipeTiny, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Tiny.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.pipeTiny, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(72L)).duration(20).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.fluidSolidifierRecipes);
                    }
                    if (GTOreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Small.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(144L)).duration(40).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.fluidSolidifierRecipes);
                    }
                    if (GTOreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Medium.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(432L)).duration(80).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.fluidSolidifierRecipes);
                    }
                    if (GTOreDictUnificator.get(OrePrefixes.pipeLarge, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Large.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.pipeLarge, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(864L)).duration(160).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.fluidSolidifierRecipes);
                    }
                    if (GTOreDictUnificator.get(OrePrefixes.pipeHuge, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Huge.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.pipeHuge, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(1728L)).duration(320).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.fluidSolidifierRecipes);
                    }
                }
                if (tAmount * 2 <= 64 && aMaterial != Materials.Obsidian) {
                    if (aMaterial != Materials.Aluminium) {
                        if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mSmeltInto, 1L) != null) {
                            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Rod.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mSmeltInto, (long)(tAmount * 2))).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 6 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                        }
                    } else if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mSmeltInto, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Rod.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mSmeltInto, (long)(tAmount * 2))).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                    }
                }
                if (tAmount * 2 <= 64 && GTOreDictUnificator.get(OrePrefixes.wireGt01, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Wire.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt01, aMaterial.mSmeltInto, (long)(tAmount * 2))).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 6 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (tAmount * 8 <= 64 && GTOreDictUnificator.get(OrePrefixes.bolt, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Bolt.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.bolt, aMaterial.mSmeltInto, (long)(tAmount * 8))).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (tAmount * 4 <= 64) {
                    if (GTOreDictUnificator.get(OrePrefixes.ring, aMaterial.mSmeltInto, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Ring.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.ring, aMaterial.mSmeltInto, (long)(tAmount * 4))).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 6 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                    }
                    if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aMaterial.contains(SubTag.NO_SMASHING) && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV && GTOreDictUnificator.get(OrePrefixes.ring, aMaterial, 1L) != null) {
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.ring, aMaterial, 1L), GTProxy.tBits, new Object[]{"h ", "fX", Character.valueOf('X'), OrePrefixes.stick.get(aMaterial)});
                    }
                }
                if (GTOreDictUnificator.get(OrePrefixes.toolHeadSword, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(2, aStack), ItemList.Shape_Extruder_Sword.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.toolHeadSword, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.toolHeadPickaxe, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack), ItemList.Shape_Extruder_Pickaxe.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.toolHeadPickaxe, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 3L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.toolHeadShovel, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Shovel.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.toolHeadShovel, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 1L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.toolHeadAxe, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack), ItemList.Shape_Extruder_Axe.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.toolHeadAxe, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 3L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.toolHeadHoe, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(2, aStack), ItemList.Shape_Extruder_Hoe.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.toolHeadHoe, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.toolHeadHammer, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(6, aStack), ItemList.Shape_Extruder_Hammer.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.toolHeadHammer, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 6L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.toolHeadFile, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(2, aStack), ItemList.Shape_Extruder_File.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.toolHeadFile, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.toolHeadSaw, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(2, aStack), ItemList.Shape_Extruder_Saw.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.toolHeadSaw, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.gearGt, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(4, aStack), ItemList.Shape_Extruder_Gear.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gearGt, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 5L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(RecipeMaps.extruderRecipes);
                }
                if (aMaterial != Materials.StyreneButadieneRubber && aMaterial != Materials.Silicone) {
                    if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV && GTOreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(2, aStack), ItemList.Shape_Mold_Plate.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).recipeCategory(RecipeCategories.alloySmelterMolding).addTo(RecipeMaps.alloySmelterRecipes);
                    }
                } else if ((long)tTrueVoltage < TierEU.IV && GTOreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Mold_Plate.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).recipeCategory(RecipeCategories.alloySmelterMolding).addTo(RecipeMaps.alloySmelterRecipes);
                }
                if ((long)tTrueVoltage < TierEU.IV && GTOreDictUnificator.get(OrePrefixes.gearGt, aMaterial.mSmeltInto, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(8, aStack), ItemList.Shape_Mold_Gear.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gearGt, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 10L * (long)tAmount, (long)tAmount) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).recipeCategory(RecipeCategories.alloySmelterMolding).addTo(RecipeMaps.alloySmelterRecipes);
                }
                switch (aMaterial.mSmeltInto.mName) {
                    case "Glass": {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Bottle.get(0L, new Object[0])).itemOutputs(new ItemStack(Items.field_151069_bo, 1)).duration(tAmount * 32 * 1).eut(16).addTo(RecipeMaps.extruderRecipes);
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Mold_Bottle.get(0L, new Object[0])).itemOutputs(new ItemStack(Items.field_151069_bo, 1)).duration(tAmount * 64 * 1).eut(4).addTo(RecipeMaps.alloySmelterRecipes);
                        break;
                    }
                    case "Steel": {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Cell.get(0L, new Object[0])).itemOutputs(ItemList.Cell_Empty.get(tAmount, new Object[0])).duration(tAmount * 128 * 1).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.extruderRecipes);
                        break;
                    }
                    case "Iron": 
                    case "WroughtIron": {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Cell.get(0L, new Object[0])).itemOutputs(GTModHandler.getIC2Item("fuelRod", tAmount)).duration(tAmount * 128 * 1).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.extruderRecipes);
                        if (tAmount * 31 > 64) break;
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(31, aStack), ItemList.Shape_Mold_Anvil.get(0L, new Object[0])).itemOutputs(new ItemStack(Blocks.field_150467_bQ, 1, 0)).duration(tAmount * 512 * 1).eut(4 * tVoltageMultiplier).addTo(RecipeMaps.alloySmelterRecipes);
                        break;
                    }
                    case "Tin": {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(2, aStack), ItemList.Shape_Extruder_Cell.get(0L, new Object[0])).itemOutputs(ItemList.Cell_Empty.get(tAmount, new Object[0])).duration(tAmount * 128 * 1).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.extruderRecipes);
                        break;
                    }
                    case "Polytetrafluoroethylene": {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), ItemList.Shape_Extruder_Cell.get(0L, new Object[0])).itemOutputs(ItemList.Cell_Empty.get(tAmount * 4, new Object[0])).duration(tAmount * 128 * 1).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.extruderRecipes);
                    }
                }
            }
        }
    }
}

