/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.network.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.network.handler.AbstractClientMessageHandler;
import gtPlusPlus.core.network.packet.AbstractPacket;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchTurbine;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketTurbineHatchUpdate
extends AbstractClientMessageHandler<PacketTurbineHatchUpdate>
implements AbstractPacket {
    private int x;
    private int y;
    private int z;
    private boolean hasTurbine;
    private boolean formed;
    private BlockPos controller;

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeBoolean(this.hasTurbine);
        buf.writeBoolean(this.formed);
        if (this.controller != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.controller.xPos);
            buf.writeInt(this.controller.yPos);
            buf.writeInt(this.controller.zPos);
        } else {
            buf.writeBoolean(false);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.hasTurbine = buf.readBoolean();
        this.formed = buf.readBoolean();
        this.controller = buf.readBoolean() ? new BlockPos(buf.readInt(), buf.readInt(), buf.readInt(), 0) : null;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public boolean isHasTurbine() {
        return this.hasTurbine;
    }

    public void setHasTurbine(boolean hasTurbine) {
        this.hasTurbine = hasTurbine;
    }

    public boolean isFormed() {
        return this.formed;
    }

    public void setFormed(boolean formed) {
        this.formed = formed;
    }

    public BlockPos getController() {
        return this.controller;
    }

    public void setController(BlockPos controller) {
        this.controller = controller;
    }

    @Override
    public String getPacketName() {
        return "Packet_VoluemtricFlaskSetter_ToClient";
    }

    @Override
    public IMessage handleClientMessage(EntityPlayer player, PacketTurbineHatchUpdate message, MessageContext ctx) {
        TileEntity te = player.func_130014_f_().func_147438_o(message.x, message.y, message.z);
        if (!(te instanceof BaseMetaTileEntity)) {
            return null;
        }
        BaseMetaTileEntity mteHost = (BaseMetaTileEntity)te;
        IMetaTileEntity mte = mteHost.getMetaTileEntity();
        if (!(mte instanceof MTEHatchTurbine)) {
            return null;
        }
        MTEHatchTurbine hatch = (MTEHatchTurbine)mte;
        hatch.receiveUpdate(message);
        return null;
    }
}

