/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.integration.waila;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import makeo.gadomancy.common.blocks.tiles.TileStickyJar;
import makeo.gadomancy.common.utils.ColorHelper;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class StickyJarProvider
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler config) {
        TileStickyJar stickyJar;
        if (data.getTileEntity() instanceof TileStickyJar && (stickyJar = (TileStickyJar)data.getTileEntity()).isValid()) {
            ItemStack stack = new ItemStack(stickyJar.getParentBlock(), 1, stickyJar.func_145832_p());
            for (IWailaDataProvider provider : this.getParentProviders(ModuleRegistrar.instance().stackBlockProviders, stickyJar.getParentBlock().getClass(), stickyJar.getParent().getClass())) {
                stack = provider.getWailaStack(data, config);
            }
            return stack;
        }
        return null;
    }

    private List<IWailaDataProvider> getParentProviders(LinkedHashMap<Class, ArrayList<IWailaDataProvider>> providerMap, Class ... classes) {
        ArrayList<IWailaDataProvider> providers = new ArrayList<IWailaDataProvider>();
        for (Class parent : classes) {
            ArrayList<IWailaDataProvider> providerList = providerMap.get(parent);
            if (providerList == null) continue;
            providers.addAll(providerList);
        }
        return providers;
    }

    public List<String> getWailaHead(final ItemStack stack, final List<String> strings, final IWailaDataAccessor data, final IWailaConfigHandler config) {
        TileStickyJar tile = (TileStickyJar)data.getTileEntity();
        if (tile != null && tile.isValid()) {
            this.callParentProviders(ModuleRegistrar.instance().getBodyProviders((Object)tile.getParentBlock()), new Callable<IWailaDataProvider>(){

                @Override
                public void call(IWailaDataProvider provider) {
                    provider.getWailaHead(stack, strings, data, config);
                }
            });
        }
        return strings;
    }

    public List<String> getWailaBody(final ItemStack stack, final List<String> strings, final IWailaDataAccessor data, final IWailaConfigHandler config) {
        TileStickyJar tile = (TileStickyJar)data.getTileEntity();
        if (tile != null && tile.isValid()) {
            this.callParentProviders(ModuleRegistrar.instance().getBodyProviders((Object)tile.getParentBlock()), new Callable<IWailaDataProvider>(){

                @Override
                public void call(IWailaDataProvider provider) {
                    provider.getWailaBody(stack, strings, data, config);
                }
            });
        }
        return strings;
    }

    public List<String> getWailaTail(final ItemStack stack, final List<String> strings, final IWailaDataAccessor data, final IWailaConfigHandler config) {
        TileStickyJar tile = (TileStickyJar)data.getTileEntity();
        if (tile != null && tile.isValid()) {
            this.callParentProviders(ModuleRegistrar.instance().getBodyProviders((Object)tile.getParentBlock()), new Callable<IWailaDataProvider>(){

                @Override
                public void call(IWailaDataProvider provider) {
                    provider.getWailaTail(stack, strings, data, config);
                }
            });
        }
        if (data.getTileEntity() instanceof TileStickyJar && strings.size() > 0) {
            String oldMod = strings.get(strings.size() - 1);
            String mod = ColorHelper.extractColors(oldMod) + "Gadomancy";
            strings.remove(strings.size() - 1);
            strings.add(mod);
        }
        return strings;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP paramEntityPlayerMP, TileEntity paramTileEntity, NBTTagCompound paramNBTTagCompound, World paramWorld, int paramInt1, int paramInt2, int paramInt3) {
        return null;
    }

    private void callParentProviders(Map<Integer, List<IWailaDataProvider>> providers, Callable<IWailaDataProvider> callable) {
        for (Map.Entry<Integer, List<IWailaDataProvider>> entry : providers.entrySet()) {
            for (IWailaDataProvider provider : entry.getValue()) {
                callable.call(provider);
            }
        }
    }

    private static abstract class Callable<T> {
        private Callable() {
        }

        public abstract void call(IWailaDataProvider var1);
    }
}

