/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Realtimers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Addons.Mobdetectors.ModuleMobdetector;
import vswe.stevescarts.Modules.ModuleBase;
import vswe.stevescarts.Modules.Realtimers.ModuleShooter;

public class ModuleShooterAdv
extends ModuleShooter {
    private ArrayList<ModuleMobdetector> detectors;
    private EntityNearestTarget sorter = new EntityNearestTarget((Entity)this.getCart());
    private float detectorAngle;

    public ModuleShooterAdv(MinecartModular cart) {
        super(cart);
    }

    @Override
    public void preInit() {
        super.preInit();
        this.detectors = new ArrayList();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleMobdetector)) continue;
            this.detectors.add((ModuleMobdetector)module);
        }
    }

    @Override
    protected void generatePipes(ArrayList<Integer> list) {
        list.add(1);
    }

    @Override
    protected int guiExtraWidth() {
        return 100;
    }

    @Override
    protected int guiRequiredHeight() {
        return 10 + 10 * this.detectors.size();
    }

    private int[] getSelectionBox(int id) {
        return new int[]{90, id * 10 + (this.guiHeight() - 10 * this.detectors.size()) / 2, 8, 8};
    }

    @Override
    protected void generateInterfaceRegions() {
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ATTACHMENTS.SHOOTER.translate(new String[0]), 8, 6, 0x404040);
        for (int i = 0; i < this.detectors.size(); ++i) {
            int[] box = this.getSelectionBox(i);
            this.drawString(gui, this.detectors.get(i).getName(), box[0] + 12, box[1], 0x404040);
        }
    }

    @Override
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/mobdetector.png");
        for (int i = 0; i < this.detectors.size(); ++i) {
            int srcX = this.isOptionActive(i) ? 0 : 8;
            int srcY = this.inRect(x, y, this.getSelectionBox(i)) ? 8 : 0;
            this.drawImage(gui, this.getSelectionBox(i), srcX, srcY);
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            for (int i = 0; i < this.detectors.size(); ++i) {
                if (!this.inRect(x, y, this.getSelectionBox(i))) continue;
                this.sendPacket(0, (byte)i);
                break;
            }
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
    }

    @Override
    public int numberOfGuiData() {
        return 0;
    }

    @Override
    protected void checkGuiData(Object[] info) {
    }

    @Override
    protected void Shoot() {
        this.setTimeToNext(15);
        if (!this.getCart().hasFuel()) {
            return;
        }
        Entity target = this.getTarget();
        if (target != null) {
            if (this.hasProjectileItem()) {
                this.shootAtTarget(target);
            } else {
                this.getCart().field_70170_p.func_72926_e(1001, (int)this.getCart().field_70165_t, (int)this.getCart().field_70163_u, (int)this.getCart().field_70161_v, 0);
            }
        }
    }

    private void shootAtTarget(Entity target) {
        if (target == null) {
            return;
        }
        Entity projectile = this.getProjectile(target, this.getProjectileItem(true));
        projectile.field_70163_u = this.getCart().field_70163_u + (double)this.getCart().func_70047_e() - (double)0.1f;
        double disX = target.field_70165_t - this.getCart().field_70165_t;
        double disY = target.field_70163_u + (double)target.func_70047_e() - (double)0.7f - projectile.field_70163_u;
        double disZ = target.field_70161_v - this.getCart().field_70161_v;
        double dis = MathHelper.func_76133_a((double)(disX * disX + disZ * disZ));
        if (dis >= 1.0E-7) {
            float theta = (float)(Math.atan2(disZ, disX) * 180.0 / Math.PI) - 90.0f;
            float phi = (float)(-(Math.atan2(disY, dis) * 180.0 / Math.PI));
            this.setRifleDirection((float)Math.atan2(disZ, disX));
            double disPX = disX / dis;
            double disPZ = disZ / dis;
            projectile.func_70012_b(this.getCart().field_70165_t + disPX * 1.5, projectile.field_70163_u, this.getCart().field_70161_v + disPZ * 1.5, theta, phi);
            projectile.field_70129_M = 0.0f;
            float disD5 = (float)dis * 0.2f;
            this.setHeading(projectile, disX, disY + (double)disD5, disZ, 1.6f, 0.0f);
        }
        this.getCart().field_70170_p.func_72956_a((Entity)this.getCart(), "random.bow", 1.0f, 1.0f / (this.getCart().field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.setProjectileDamage(projectile);
        this.setProjectileOnFire(projectile);
        this.setProjectileKnockback(projectile);
        this.getCart().field_70170_p.func_72838_d(projectile);
        this.damageEnchant();
    }

    protected int getTargetDistance() {
        return 16;
    }

    private Entity getTarget() {
        List entities = this.getCart().field_70170_p.func_72872_a(Entity.class, this.getCart().field_70121_D.func_72314_b((double)this.getTargetDistance(), 4.0, (double)this.getTargetDistance()));
        Collections.sort(entities, this.sorter);
        for (Entity target : entities) {
            if (target == this.getCart() || !this.canSee(target)) continue;
            for (int i = 0; i < this.detectors.size(); ++i) {
                ModuleMobdetector detector;
                if (!this.isOptionActive(i) || !(detector = this.detectors.get(i)).isValidTarget(target)) continue;
                return target;
            }
        }
        return null;
    }

    private boolean canSee(Entity target) {
        if (target == null) {
            return false;
        }
        return this.getCart().field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.getCart().field_70165_t, (double)(this.getCart().field_70163_u + (double)this.getCart().func_70047_e()), (double)this.getCart().field_70161_v), Vec3.func_72443_a((double)target.field_70165_t, (double)(target.field_70163_u + (double)target.func_70047_e()), (double)target.field_70161_v)) == null;
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.switchOption(data[0]);
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public int numberOfDataWatchers() {
        return 2;
    }

    @Override
    public void initDw() {
        this.addDw(0, 0);
        this.addDw(1, 0);
    }

    private void switchOption(int id) {
        byte val = this.getDw(0);
        val = (byte)(val ^ 1 << id);
        this.updateDw(0, val);
    }

    public void setOptions(byte val) {
        this.updateDw(0, val);
    }

    public byte selectedOptions() {
        return this.getDw(0);
    }

    private boolean isOptionActive(int id) {
        return (this.selectedOptions() & 1 << id) != 0;
    }

    @Override
    protected boolean isPipeActive(int id) {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getIsPipeActive();
        }
        return this.selectedOptions() != 0;
    }

    public float getDetectorAngle() {
        return this.detectorAngle;
    }

    @Override
    public void update() {
        super.update();
        if (this.isPipeActive(0)) {
            this.detectorAngle = (float)((double)(this.detectorAngle + 0.1f) % (Math.PI * 2));
        }
    }

    private void setRifleDirection(float val) {
        val /= (float)Math.PI * 2;
        val *= 256.0f;
        if ((val %= 256.0f) < 0.0f) {
            val += 256.0f;
        }
        this.updateDw(1, (byte)val);
    }

    public float getRifleDirection() {
        float val = this.isPlaceholder() ? 0.0f : (float)this.getDw(1);
        val /= 256.0f;
        return val *= (float)Math.PI * 2;
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74774_a(this.generateNBTName("Options", id), this.selectedOptions());
        this.saveTick(tagCompound, id);
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.setOptions(tagCompound.func_74771_c(this.generateNBTName("Options", id)));
        this.loadTick(tagCompound, id);
    }

    private static class EntityNearestTarget
    implements Comparator {
        private Entity entity;

        public EntityNearestTarget(Entity entity) {
            this.entity = entity;
        }

        public int compareDistanceSq(Entity entity1, Entity entity2) {
            double distance2;
            double distance1 = this.entity.func_70068_e(entity1);
            return distance1 < (distance2 = this.entity.func_70068_e(entity2)) ? -1 : (distance1 > distance2 ? 1 : 0);
        }

        public int compare(Object obj1, Object obj2) {
            return this.compareDistanceSq((Entity)obj1, (Entity)obj2);
        }
    }
}

