/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.personalspace.world;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import me.eigenraven.personalspace.CommonProxy;
import me.eigenraven.personalspace.Config;
import me.eigenraven.personalspace.PersonalSpaceMod;
import me.eigenraven.personalspace.world.DimensionConfig;
import me.eigenraven.personalspace.world.PersonalChunkProvider;
import net.minecraft.entity.Entity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManagerHell;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class PersonalWorldProvider
extends WorldProvider {
    DimensionConfig config;
    DimensionConfig.SkyType lastSkyType = null;

    public void setDimension(int dim) {
        super.setDimension(dim);
    }

    public DimensionConfig getConfig() {
        if (this.config == null) {
            boolean isClient;
            boolean bl = isClient = this.field_76579_a != null ? this.field_76579_a.field_72995_K : FMLCommonHandler.instance().getEffectiveSide().isClient();
            if (Config.debugLogging) {
                PersonalSpaceMod.LOG.info("PersonalWorldProvider loading config for dim {}, client {}", new Object[]{this.field_76574_g, isClient, new Throwable()});
            }
            this.config = DimensionConfig.getForDimension(this.field_76574_g, isClient);
            if (this.config == null) {
                PersonalSpaceMod.LOG.fatal("PersonalSpace couldn't find dimension config for dimension {}, detected side: {}\nknown client dimension IDs: {}\nknown server dimension IDs: {}\n", new Object[]{this.field_76574_g, isClient ? "CLIENT" : "SERVER", Arrays.toString(CommonProxy.getDimensionConfigObjects(true).keys()), Arrays.toString(CommonProxy.getDimensionConfigObjects(false).keys()), new Throwable()});
            }
        }
        return this.config;
    }

    public String func_80007_l() {
        return "Personal World " + this.field_76574_g;
    }

    public void func_76572_b() {
        this.getConfig();
        this.field_76578_c = new WorldChunkManagerHell(BiomeGenBase.field_76772_c, 1.0f);
    }

    public IChunkProvider func_76555_c() {
        return new PersonalChunkProvider(this, this.field_76579_a.func_72905_C());
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float sunAngle, float timeSinceLastTick) {
        if (this.getConfig().getDaylightCycle() == DimensionConfig.DaylightCycle.CYCLE) {
            return super.func_76562_b(sunAngle, timeSinceLastTick);
        }
        int baseColor = this.config.getSkyColor();
        float red = (float)(baseColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(baseColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(baseColor & 0xFF) / 255.0f;
        return Vec3.func_72443_a((double)red, (double)green, (double)blue);
    }

    public ChunkCoordinates getSpawnPoint() {
        return new ChunkCoordinates(8, this.getConfig().getGroundLevel() + 2, 8);
    }

    public ChunkCoordinates getRandomizedSpawnPoint() {
        return this.getSpawnPoint();
    }

    public Vec3 getSkyColor(Entity cameraEntity, float partialTicks) {
        if (this.getConfig().getDaylightCycle() == DimensionConfig.DaylightCycle.CYCLE) {
            return super.getSkyColor(cameraEntity, partialTicks);
        }
        return this.func_76562_b(0.0f, partialTicks);
    }

    public boolean func_76567_e() {
        return false;
    }

    public boolean func_76569_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return this.getConfig().isCloudsEnabled() ? 256.0f : Float.NEGATIVE_INFINITY;
    }

    public boolean func_76566_a(int x, int z) {
        return this.field_76579_a.func_147474_b(x, z).func_149688_o().func_76230_c();
    }

    public int func_76557_i() {
        return this.getConfig().getGroundLevel();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public boolean func_76564_j() {
        return false;
    }

    public double func_76565_k() {
        return 1.0;
    }

    public String getSaveFolder() {
        String name = this.getConfig().getSaveDir(this.field_76574_g);
        if (Config.debugLogging) {
            PersonalSpaceMod.LOG.info("Save folder for dim id {} is {}", new Object[]{this.field_76574_g, name, new Throwable()});
        }
        return name;
    }

    public boolean isDaytime() {
        if (this.getConfig().getDaylightCycle() == DimensionConfig.DaylightCycle.CYCLE) {
            return super.isDaytime();
        }
        return !this.getConfig().isNightTime();
    }

    public float getSunBrightnessFactor(float par1) {
        if (this.getConfig().getDaylightCycle() == DimensionConfig.DaylightCycle.CYCLE) {
            return super.getSunBrightnessFactor(par1);
        }
        return this.getConfig().isNightTime() ? 0.0f : 1.0f;
    }

    public float getSunBrightness(float par1) {
        if (this.getConfig().getDaylightCycle() == DimensionConfig.DaylightCycle.CYCLE) {
            return super.getSunBrightness(par1);
        }
        return this.getConfig().isNightTime() ? 0.2f : 1.0f;
    }

    public float getStarBrightness(float par1) {
        if (this.getConfig().getDaylightCycle() == DimensionConfig.DaylightCycle.CYCLE) {
            return super.getStarBrightness(par1);
        }
        return this.getConfig().getStarBrightness();
    }

    public float func_76563_a(long p_76563_1_, float p_76563_3_) {
        if (this.getConfig().getDaylightCycle() == DimensionConfig.DaylightCycle.CYCLE) {
            return super.func_76563_a(p_76563_1_, p_76563_3_);
        }
        return this.getConfig().isNightTime() ? 0.5f : 0.0f;
    }

    public void calculateInitialWeather() {
        if (this.getConfig().isWeatherEnabled()) {
            super.calculateInitialWeather();
        } else {
            this.field_76579_a.field_73004_o = 0.0f;
            this.field_76579_a.field_73017_q = 0.0f;
            this.field_76579_a.field_73003_n = 0.0f;
            this.field_76579_a.field_73018_p = 0.0f;
            this.field_76579_a.func_72912_H().func_76084_b(false);
            this.field_76579_a.func_72912_H().func_76069_a(false);
        }
    }

    public void updateWeather() {
        if (!this.field_76579_a.field_72995_K && !this.getConfig().isWeatherEnabled()) {
            this.resetRainAndThunder();
            this.field_76579_a.field_73004_o = 0.0f;
            this.field_76579_a.field_73017_q = 0.0f;
            this.field_76579_a.field_73003_n = 0.0f;
            this.field_76579_a.field_73018_p = 0.0f;
        } else {
            super.updateWeather();
        }
    }

    public boolean canDoLightning(Chunk chunk) {
        return this.getConfig().isWeatherEnabled();
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.getConfig().isWeatherEnabled();
    }

    public boolean canBlockFreeze(int x, int y, int z, boolean byWater) {
        return this.getConfig().isWeatherEnabled() && super.canBlockFreeze(x, y, z, byWater);
    }

    public boolean canSnowAt(int x, int y, int z, boolean checkLight) {
        return this.getConfig().isWeatherEnabled() && super.canSnowAt(x, y, z, checkLight);
    }

    public ChunkCoordinates func_76554_h() {
        return new ChunkCoordinates(8, this.func_76557_i(), 8);
    }

    private void updateSkyType() {
        if (this.field_76579_a == null || !this.field_76579_a.field_72995_K) {
            return;
        }
        DimensionConfig.SkyType currentSkyType = this.getConfig().getSkyType();
        if (this.lastSkyType != currentSkyType) {
            this.lastSkyType = currentSkyType;
            this.setSkyRenderer((IRenderHandler)this.lastSkyType.makeSkyProvider());
            this.setCloudRenderer((IRenderHandler)this.lastSkyType.makeCloudProvider());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        this.updateSkyType();
        return super.getSkyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        this.updateSkyType();
        return super.getCloudRenderer();
    }
}

