/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.client.gui;

import com.github.lunatrius.ingameinfo.Alignment;
import com.github.lunatrius.ingameinfo.InGameInfoCore;
import com.github.lunatrius.ingameinfo.client.gui.Info;
import com.github.lunatrius.ingameinfo.reference.Reference;
import com.github.lunatrius.ingameinfo.value.Value;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class InfoText
extends Info {
    private static final String ICON_START = "{ICON|";
    private final Map<String, Info> attachedValues = new LinkedHashMap<String, Info>();
    private String text;
    private final List<Value> values;
    private final Alignment alignment;
    private final int index;

    public InfoText(int index, Alignment alignment, List<Value> values) {
        super(0, 0);
        this.values = values;
        this.alignment = alignment;
        this.index = index;
        for (Value value : values) {
            value.setParent(this);
        }
    }

    public void update() {
        StringBuilder builder = new StringBuilder();
        for (Value value : this.values) {
            builder.append(this.getValue(value));
        }
        this.updateChildren(builder);
        this.text = builder.toString();
        this.updatePosition();
    }

    @Override
    public void drawInfo() {
        fontRenderer.func_78261_a(this.text, this.getX(), this.getY(), 0xFFFFFF);
        for (Info child : this.attachedValues.values()) {
            child.offsetX = this.x;
            child.offsetY = this.y;
            child.draw();
        }
    }

    private void updateChildren(StringBuilder builder) {
        if (builder.length() == 0 && !this.attachedValues.isEmpty()) {
            this.attachedValues.clear();
            return;
        }
        if (builder.indexOf(ICON_START) == -1) {
            return;
        }
        for (Info child : this.attachedValues.values()) {
            if (child.hasPosition) continue;
            int iconStart = builder.indexOf(ICON_START);
            int widthStart = builder.indexOf("|", iconStart) + 1;
            child.hasPosition = true;
            child.x = fontRenderer.func_78256_a(builder.substring(0, iconStart));
            builder.replace(iconStart, widthStart, "");
            builder.deleteCharAt(builder.indexOf("}"));
        }
    }

    private void updatePosition() {
        int scaledWidth = InGameInfoCore.INSTANCE.scaledWidth;
        int scaledHeight = InGameInfoCore.INSTANCE.scaledHeight;
        this.x = this.alignment.getX(scaledWidth, fontRenderer.func_78256_a(this.text));
        this.y = this.alignment.getY(scaledHeight, this.getHeight());
    }

    @Nullable
    public Info getAttachedValue(String tag) {
        return this.attachedValues.get(tag);
    }

    public void removeAttachedValue(String tag) {
        this.attachedValues.remove(tag);
    }

    public void attachValue(@NotNull String tag, @NotNull Info value) {
        this.attachedValues.put(tag, value);
    }

    @Override
    public int getWidth() {
        return fontRenderer.func_78256_a(this.text);
    }

    @Override
    public int getHeight() {
        if (this.alignment.ordinal() >= Alignment.BOTTOMLEFT.ordinal()) {
            return (this.index + 1) * (InfoText.fontRenderer.field_78288_b + 1);
        }
        return this.index * (InfoText.fontRenderer.field_78288_b + 1);
    }

    private String getValue(Value value) {
        try {
            if (value.isValidSize()) {
                return value.getReplacedValue();
            }
        }
        catch (Exception e) {
            Reference.logger.debug("Failed to get value!", (Throwable)e);
            return "null";
        }
        return "";
    }

    @Override
    public String toString() {
        return String.format("InfoText{text: %s, x: %d, y: %d, offsetX: %d, offsetY: %d, children: %s}", this.text, this.x, this.y, this.offsetX, this.offsetY, this.children);
    }
}

