/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.client.gui.GuiEssentiaTerminal;
import com.glodblock.github.client.gui.GuiFluidIO;
import com.glodblock.github.client.gui.GuiFluidInterface;
import com.glodblock.github.client.gui.GuiFluidLevelEmitter;
import com.glodblock.github.client.gui.GuiFluidStorageBus;
import com.glodblock.github.client.gui.GuiFluidTerminal;
import com.glodblock.github.client.gui.GuiIngredientBuffer;
import com.glodblock.github.client.gui.GuiLargeIngredientBuffer;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;

public class SPacketFluidUpdate
implements IMessage {
    private Map<Integer, IAEFluidStack> list;
    private IAEItemStack itemStack;

    public SPacketFluidUpdate() {
    }

    public SPacketFluidUpdate(Map<Integer, IAEFluidStack> data) {
        this.list = data;
        this.itemStack = null;
    }

    public SPacketFluidUpdate(Map<Integer, IAEFluidStack> data, IAEItemStack itemStack) {
        this.list = data;
        this.itemStack = itemStack;
    }

    public SPacketFluidUpdate(Map<Integer, IAEFluidStack> data, ItemStack itemStack) {
        this.list = data;
        this.itemStack = AEItemStack.create((ItemStack)itemStack);
    }

    public void fromBytes(ByteBuf buf) {
        this.list = new HashMap<Integer, IAEFluidStack>();
        try {
            Util.readFluidMapFromBuf(this.list, buf);
            if (buf.readBoolean()) {
                this.itemStack = AEItemStack.loadItemStackFromPacket((ByteBuf)buf);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            Util.writeFluidMapToBuf(this.list, buf);
            if (this.itemStack != null) {
                buf.writeBoolean(true);
                this.itemStack.writeToPacket(buf);
            } else {
                buf.writeBoolean(false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Handler
    implements IMessageHandler<SPacketFluidUpdate, IMessage> {
        public IMessage onMessage(SPacketFluidUpdate message, MessageContext ctx) {
            block11: {
                GuiScreen gs;
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block10: {
                                            gs = Minecraft.func_71410_x().field_71462_r;
                                            if (!(gs instanceof GuiIngredientBuffer)) break block10;
                                            for (Map.Entry e : message.list.entrySet()) {
                                                ((GuiIngredientBuffer)gs).update((Integer)e.getKey(), (IAEFluidStack)e.getValue());
                                            }
                                            break block11;
                                        }
                                        if (!(gs instanceof GuiLargeIngredientBuffer)) break block12;
                                        for (Map.Entry e : message.list.entrySet()) {
                                            ((GuiLargeIngredientBuffer)gs).update((Integer)e.getKey(), (IAEFluidStack)e.getValue());
                                        }
                                        break block11;
                                    }
                                    if (!(gs instanceof GuiFluidIO)) break block13;
                                    for (Map.Entry e : message.list.entrySet()) {
                                        ((GuiFluidIO)gs).update((Integer)e.getKey(), (IAEFluidStack)e.getValue());
                                    }
                                    break block11;
                                }
                                if (!(gs instanceof GuiFluidInterface)) break block14;
                                for (Map.Entry e : message.list.entrySet()) {
                                    ((GuiFluidInterface)gs).update((Integer)e.getKey(), (IAEFluidStack)e.getValue());
                                }
                                break block11;
                            }
                            if (!(gs instanceof GuiFluidTerminal)) break block15;
                            if (message.itemStack != null) {
                                ((GuiFluidTerminal)gs).update(message.itemStack.getItemStack());
                            } else {
                                ((GuiFluidTerminal)gs).update(null);
                            }
                            break block11;
                        }
                        if (!(gs instanceof GuiEssentiaTerminal)) break block16;
                        if (message.itemStack != null) {
                            ((GuiEssentiaTerminal)gs).update(message.itemStack.getItemStack());
                        } else {
                            ((GuiEssentiaTerminal)gs).update(null);
                        }
                        break block11;
                    }
                    if (!(gs instanceof GuiFluidStorageBus)) break block17;
                    for (Map.Entry e : message.list.entrySet()) {
                        ((GuiFluidStorageBus)gs).update((Integer)e.getKey(), (IAEFluidStack)e.getValue());
                    }
                    break block11;
                }
                if (!(gs instanceof GuiFluidLevelEmitter)) break block11;
                for (Map.Entry e : message.list.entrySet()) {
                    ((GuiFluidLevelEmitter)gs).update((Integer)e.getKey(), (IAEFluidStack)e.getValue());
                }
            }
            return null;
        }
    }
}

