/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.content;

import chylex.hee.gui.GuiEnderCompendium;
import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.objects.IKnowledgeObjectInstance;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;

public abstract class KnowledgeFragment {
    private static final TIntObjectMap<KnowledgeFragment> allFragments = new TIntObjectHashMap();
    public final int globalID;
    private int price;
    private boolean unlockOnDiscovery;
    private int[] unlockRequirements = ArrayUtils.EMPTY_INT_ARRAY;
    private int[] unlockCascade = ArrayUtils.EMPTY_INT_ARRAY;
    private KnowledgeObject<? extends IKnowledgeObjectInstance<?>> unlockRedirect;

    public static final Collection<KnowledgeFragment> getAllFragments() {
        return Collections.unmodifiableCollection(allFragments.valueCollection());
    }

    public static final KnowledgeFragment getById(int globalID) {
        return (KnowledgeFragment)allFragments.get(globalID);
    }

    public KnowledgeFragment(int globalID) {
        this.globalID = globalID;
        if (allFragments.putIfAbsent(globalID, (Object)this) != null) {
            throw new IllegalArgumentException("Could not initialize Knowledge Fragments, global fragment ID " + globalID + " is already taken!");
        }
    }

    public KnowledgeFragment setPrice(int price) {
        this.price = price;
        return this;
    }

    public int getPrice() {
        return this.price;
    }

    public KnowledgeFragment setNonBuyable() {
        this.price = -1;
        return this;
    }

    public KnowledgeFragment setNonBuyableRedirect(KnowledgeObject<? extends IKnowledgeObjectInstance<?>> unlockRedirect) {
        this.price = -1;
        this.unlockRedirect = unlockRedirect;
        return this;
    }

    public boolean isBuyable() {
        return this.price != -1;
    }

    public KnowledgeObject<? extends IKnowledgeObjectInstance<?>> getUnlockRedirect() {
        return this.unlockRedirect;
    }

    public KnowledgeFragment setUnlockOnDiscovery() {
        this.unlockOnDiscovery = true;
        return this;
    }

    public boolean isUnlockedOnDiscovery() {
        return this.unlockOnDiscovery;
    }

    public KnowledgeFragment setUnlockRequirements(int ... requirements) {
        this.unlockRequirements = requirements;
        return this;
    }

    public int[] getUnlockRequirements() {
        return this.unlockRequirements;
    }

    public KnowledgeFragment setUnlockCascade(int ... cascade) {
        this.unlockCascade = cascade;
        return this;
    }

    public int[] getUnlockCascade() {
        return this.unlockCascade;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract int getHeight(GuiEnderCompendium var1, boolean var2);

    @SideOnly(value=Side.CLIENT)
    public abstract boolean onClick(GuiEnderCompendium var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    @SideOnly(value=Side.CLIENT)
    public abstract void onRender(GuiEnderCompendium var1, int var2, int var3, int var4, int var5, boolean var6);

    public final boolean equals(Object o) {
        return o instanceof KnowledgeFragment && ((KnowledgeFragment)o).globalID == this.globalID;
    }

    public final int hashCode() {
        return this.globalID;
    }
}

