/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.energy;

import chylex.hee.mechanics.energy.EnergyChunkData;
import chylex.hee.mechanics.energy.EnergyValues;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.EnergySavefile;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.util.Direction;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public final class EnergyEvents {
    private static final EnergyEvents instance = new EnergyEvents();
    private byte updateTimer;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        FMLCommonHandler.instance().bus().register((Object)instance);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.START || e.world.field_73011_w.field_76574_g != 1 || e.world.field_72995_K || (this.updateTimer = (byte)(this.updateTimer + 1)) <= 4) {
            return;
        }
        Stopwatch.timeAverage("EnergyEvents - WorldTick", 80);
        ArrayList chunks = new ArrayList(((ChunkProviderServer)e.world.func_72863_F()).field_73245_g);
        HashSet<EnergyChunkData> usedData = new HashSet<EnergyChunkData>();
        EnergySavefile file = (EnergySavefile)WorldDataHandler.get(EnergySavefile.class);
        for (Chunk chunk : chunks) {
            EnergyChunkData data = file.getFromChunkCoords(e.world, chunk.field_76635_g, chunk.field_76647_h, true);
            if (usedData.contains(data)) continue;
            data.onUpdate(e.world, e.world.field_73012_v);
            for (int a = 0; a < 4; ++a) {
                data.onAdjacentInteract(e.world.field_73012_v, file.getFromChunkCoords(e.world, chunk.field_76635_g + Direction.offsetX[a] * EnergySavefile.sectionSize, chunk.field_76647_h + Direction.offsetZ[a] * EnergySavefile.sectionSize, true));
            }
            usedData.add(data);
        }
        this.updateTimer = 0;
        Stopwatch.finish("EnergyEvents - WorldTick");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDeath(LivingDeathEvent e) {
        if (e.entity.field_70170_p.field_72995_K || e.entity.field_71093_bK != 1) {
            return;
        }
        float energy = EnergyValues.getMobEnergy(e.entityLiving);
        if (MathUtil.floatEquals(energy, 0.0f)) {
            return;
        }
        ((EnergySavefile)WorldDataHandler.get(EnergySavefile.class)).getFromBlockCoords(e.entity.field_70170_p, MathUtil.floor(e.entity.field_70165_t), MathUtil.floor(e.entity.field_70161_v), true).addEnergy(energy);
    }

    private EnergyEvents() {
    }
}

