/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.render.entity;

import chylex.hee.entity.mob.EntityMobLouse;
import chylex.hee.proxy.ModClientProxy;
import chylex.hee.render.model.ModelLouse;
import chylex.hee.tileentity.spawner.LouseRavagedSpawnerLogic;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderMobLouse
extends RenderLiving {
    private static final ResourceLocation texLouse = new ResourceLocation("hardcoreenderexpansion:textures/entity/louse.png");
    private static final ResourceLocation[] texLouseRuneBottom = new ResourceLocation[]{new ResourceLocation("hardcoreenderexpansion:textures/entity/louse_b1.png"), new ResourceLocation("hardcoreenderexpansion:textures/entity/louse_b2.png"), new ResourceLocation("hardcoreenderexpansion:textures/entity/louse_b3.png"), new ResourceLocation("hardcoreenderexpansion:textures/entity/louse_b4.png")};
    private static final ResourceLocation[] texLouseRuneTop = new ResourceLocation[]{new ResourceLocation("hardcoreenderexpansion:textures/entity/louse_t1.png"), new ResourceLocation("hardcoreenderexpansion:textures/entity/louse_t2.png"), new ResourceLocation("hardcoreenderexpansion:textures/entity/louse_t3.png"), new ResourceLocation("hardcoreenderexpansion:textures/entity/louse_t4.png")};

    public RenderMobLouse() {
        super((ModelBase)new ModelLouse(), 0.4f);
    }

    private RuneColor getColorFromAttribute(LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute attribute) {
        switch (attribute) {
            case ATTACK: {
                return RuneColor.RED;
            }
            case SPEED: {
                return RuneColor.YELLOW;
            }
            case HEALTH: {
                return RuneColor.GREEN;
            }
            case ARMOR: {
                return RuneColor.BLUE;
            }
            case TELEPORT: {
                return RuneColor.PURPLE;
            }
        }
        return RuneColor.RED;
    }

    protected void func_77041_b(EntityLivingBase entity, float partialTickTime) {
        GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
    }

    protected int func_77032_a(EntityLivingBase entity, int pass, float partialTickTime) {
        if (pass == 1 || pass == 2) {
            LouseRavagedSpawnerLogic.LouseSpawnData louseData = ((EntityMobLouse)entity).getSpawnData();
            if (louseData == null) {
                return -1;
            }
            Set<LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute> attributes = louseData.getAttributeSet();
            Set<LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAbility> abilities = louseData.getAbilitySet();
            if (attributes.isEmpty() && abilities.isEmpty()) {
                return -1;
            }
            RuneColor color = RuneColor.RED;
            if (abilities.isEmpty()) {
                if (attributes.size() == 1 || pass == 1) {
                    color = this.getColorFromAttribute(attributes.iterator().next());
                } else if (pass == 2 && attributes.size() == 2) {
                    Iterator<LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute> iter = attributes.iterator();
                    iter.next();
                    color = this.getColorFromAttribute(iter.next());
                }
            } else if (attributes.size() == 1) {
                if (pass == 1) {
                    color = this.getColorFromAttribute(attributes.iterator().next());
                } else if (pass == 2) {
                    color = RuneColor.GRAY;
                }
            }
            Random rand = ModClientProxy.seedableRand;
            rand.setSeed(42L);
            for (LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute attribute : attributes) {
                rand.nextInt(1 + attribute.ordinal());
            }
            for (LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAbility ability : abilities) {
                rand.nextInt(1 + ability.ordinal());
            }
            ResourceLocation res = pass == 1 ? texLouseRuneBottom[rand.nextInt(texLouseRuneBottom.length)] : texLouseRuneTop[rand.nextInt(texLouseRuneTop.length)];
            this.func_110776_a(res);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            this.func_77042_a(this.field_77045_g);
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glColor4f((float)color.red, (float)color.green, (float)color.blue, (float)1.0f);
            return 1;
        }
        if (pass == 3) {
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
        }
        return -1;
    }

    protected int func_77035_b(EntityLivingBase entity, int pass, float partialTickTime) {
        return -1;
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return texLouse;
    }

    private static enum RuneColor {
        RED(0.4922f, 0.0f, 0.0f),
        YELLOW(0.4922f, 0.4922f, 0.0f),
        GREEN(0.0f, 0.4922f, 0.0f),
        BLUE(0.0f, 0.369f, 0.4922f),
        PURPLE(0.327f, 0.0f, 0.4922f),
        GRAY(0.4922f, 0.4922f, 0.4922f);

        public final float red;
        public final float green;
        public final float blue;

        private RuneColor(float red, float green, float blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }
    }
}

