/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.DimensionCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;

public abstract class WorldCache {
    protected final Int2ObjectMap<DimensionCache> dimensions = new Int2ObjectOpenHashMap();
    private boolean needsSaving = false;
    protected File worldCache;
    private boolean isLoaded = false;

    protected abstract File getStorageDirectory();

    public boolean loadVeinCache(String worldId) {
        if (this.isLoaded) {
            return true;
        }
        this.isLoaded = true;
        this.worldCache = new File(this.getStorageDirectory(), worldId);
        if (this.loadLegacyVeinCache(this.worldCache)) {
            return true;
        }
        File[] dimensionFiles = this.worldCache.listFiles();
        if (dimensionFiles == null || dimensionFiles.length == 0) {
            return false;
        }
        boolean loadedAny = false;
        for (File dimensionFile : dimensionFiles) {
            NBTTagCompound dimCompound;
            String fileName = dimensionFile.getName();
            if (!dimensionFile.isFile() || !fileName.endsWith(".dat") || (dimCompound = Utils.readNBT(dimensionFile)) == null) continue;
            int dimensionId = dimCompound.func_74762_e("dim");
            DimensionCache dimension = (DimensionCache)this.dimensions.computeIfAbsent(dimensionId, DimensionCache::new);
            dimension.loadFromNbt(dimCompound);
            loadedAny = true;
        }
        return loadedAny;
    }

    private boolean loadLegacyVeinCache(File worldCacheDirectory) {
        File oreVeinCacheDirectory = new File(worldCacheDirectory, "ore/");
        File undergroundFluidCacheDirectory = new File(worldCacheDirectory, "fluids/");
        if (!oreVeinCacheDirectory.exists() && !undergroundFluidCacheDirectory.exists()) {
            return false;
        }
        Map<Integer, ByteBuffer> oreVeinDimensionBuffers = Utils.getLegacyDimFiles(oreVeinCacheDirectory);
        Map<Integer, ByteBuffer> undergroundFluidDimensionBuffers = Utils.getLegacyDimFiles(undergroundFluidCacheDirectory);
        HashSet<Integer> dimensionsIds = new HashSet<Integer>();
        dimensionsIds.addAll(oreVeinDimensionBuffers.keySet());
        dimensionsIds.addAll(undergroundFluidDimensionBuffers.keySet());
        dimensionsIds.addAll((Collection<Integer>)this.dimensions.keySet());
        if (dimensionsIds.isEmpty()) {
            return false;
        }
        Iterator iterator = dimensionsIds.iterator();
        while (iterator.hasNext()) {
            int dimensionId = (Integer)iterator.next();
            DimensionCache dimension = (DimensionCache)this.dimensions.get(dimensionId);
            if (dimension == null) {
                dimension = new DimensionCache(dimensionId);
            }
            dimension.loadLegacy(oreVeinDimensionBuffers.get(dimensionId), undergroundFluidDimensionBuffers.get(dimensionId));
            dimension.markDirty();
            this.dimensions.put(dimensionId, (Object)dimension);
        }
        Utils.deleteDirectoryRecursively(oreVeinCacheDirectory);
        Utils.deleteDirectoryRecursively(undergroundFluidCacheDirectory);
        this.needsSaving = true;
        this.saveVeinCache();
        return true;
    }

    public void saveVeinCache() {
        if (this.needsSaving) {
            for (DimensionCache dimension : this.dimensions.values()) {
                if (!dimension.isDirty()) continue;
                File dimFile = new File(this.worldCache, "DIM" + dimension.dimensionId + ".dat");
                Utils.writeNBT(dimFile, dimension.saveToNbt());
            }
            this.needsSaving = false;
        }
    }

    public void reset() {
        this.dimensions.clear();
        this.needsSaving = false;
        this.isLoaded = false;
    }

    public void resetSome(int dimID, int startX, int startZ, int endX, int endZ) {
        DimensionCache dim = (DimensionCache)this.dimensions.get(dimID);
        if (dim != null) {
            dim.clearOreVeins(startX, startZ, endX, endZ);
            this.needsSaving = true;
            this.isLoaded = false;
        }
    }

    public void resetSpawnChunks(ChunkCoordinates spawn, int dimID) {
        int spawnChunkX = Utils.coordBlockToChunk(spawn.field_71574_a);
        int spawnChunkZ = Utils.coordBlockToChunk(spawn.field_71573_c);
        int spawnChunksRadius = 8;
        int startX = spawnChunkX - spawnChunksRadius;
        int startZ = spawnChunkZ - spawnChunksRadius;
        int endX = spawnChunkX + spawnChunksRadius;
        int endZ = spawnChunkZ + spawnChunksRadius;
        this.resetSome(dimID, startX, startZ, endX, endZ);
    }

    private DimensionCache.UpdateResult updateSaveFlag(DimensionCache.UpdateResult updateResult) {
        this.needsSaving |= updateResult != DimensionCache.UpdateResult.AlreadyKnown;
        return updateResult;
    }

    protected DimensionCache.UpdateResult putOreVein(OreVeinPosition oreVeinPosition) {
        DimensionCache dimension = (DimensionCache)this.dimensions.computeIfAbsent(oreVeinPosition.dimensionId, DimensionCache::new);
        return this.updateSaveFlag(dimension.putOreVein(oreVeinPosition));
    }

    protected void toggleOreVein(int dimensionId, int chunkX, int chunkZ) {
        DimensionCache dimension = (DimensionCache)this.dimensions.get(dimensionId);
        if (dimension != null) {
            dimension.toggleOreVein(chunkX, chunkZ);
        }
        this.needsSaving = true;
    }

    public OreVeinPosition getOreVein(int dimensionId, int chunkX, int chunkZ) {
        DimensionCache dimension = (DimensionCache)this.dimensions.get(dimensionId);
        if (dimension == null) {
            return OreVeinPosition.EMPTY_VEIN;
        }
        return dimension.getOreVein(chunkX, chunkZ);
    }

    protected DimensionCache.UpdateResult putUndergroundFluids(UndergroundFluidPosition undergroundFluid) {
        DimensionCache dimension = (DimensionCache)this.dimensions.computeIfAbsent(undergroundFluid.dimensionId, DimensionCache::new);
        return this.updateSaveFlag(dimension.putUndergroundFluid(undergroundFluid));
    }

    public UndergroundFluidPosition getUndergroundFluid(int dimensionId, int chunkX, int chunkZ) {
        DimensionCache dimension = (DimensionCache)this.dimensions.get(dimensionId);
        if (dimension == null) {
            return UndergroundFluidPosition.NOT_PROSPECTED;
        }
        return dimension.getUndergroundFluid(chunkX, chunkZ);
    }
}

