/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.products;

import binnie.Binnie;
import binnie.core.item.IItemEnum;
import binnie.core.util.I18N;
import binnie.extrabees.ExtraBees;
import forestry.api.recipes.RecipeManagers;
import java.awt.Color;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public enum EnumPropolis implements IItemEnum
{
    WATER(new Color(2405321), new Color(12762791), "Water"),
    OIL(new Color(1519411), new Color(12762791), "oil"),
    FUEL(new Color(10718482), new Color(12762791), "fuel"),
    CREOSOTE(new Color(8877313), new Color(12428819), "creosote");

    public final int secondaryColor;
    public final int primaryColor;
    public final String liquidName;

    private EnumPropolis(Color primaryColor, Color secondaryColor, String liquidName) {
        this.primaryColor = primaryColor.getRGB();
        this.secondaryColor = secondaryColor.getRGB();
        this.liquidName = liquidName;
    }

    public static EnumPropolis get(ItemStack itemStack) {
        int i = itemStack.func_77960_j();
        if (i >= 0 && i < EnumPropolis.values().length) {
            return EnumPropolis.values()[i];
        }
        return EnumPropolis.values()[0];
    }

    public void addRecipe() {
        FluidStack liquid = Binnie.Liquid.getLiquidStack(this.liquidName, 500);
        if (liquid == null) {
            return;
        }
        RecipeManagers.squeezerManager.addRecipe(20, new ItemStack[]{this.get(1)}, liquid, null, 0);
    }

    @Override
    public boolean isActive() {
        return Binnie.Liquid.getLiquidStack(this.liquidName, 100) != null;
    }

    @Override
    public ItemStack get(int count) {
        return new ItemStack(ExtraBees.propolis, count, this.ordinal());
    }

    @Override
    public String getName(ItemStack itemStack) {
        return I18N.localise("extrabees.item.propolis." + this.name().toLowerCase());
    }
}

