/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.worldgen;

import binnie.extratrees.worldgen.WorldGenTree;
import forestry.api.world.ITreeGenData;

public class WorldGenLoblollyPine
extends WorldGenTree {
    public WorldGenLoblollyPine(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        float leafSpawn = this.height + 2;
        float bottom = (float)this.height * this.randBetween(0.65f, 0.7f);
        float width = (float)this.height * this.randBetween(0.25f, 0.3f);
        if (width > 7.0f) {
            width = 7.0f;
        }
        float f = leafSpawn;
        leafSpawn = f - 1.0f;
        this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.6f * width, 1, this.leaf, false);
        while (leafSpawn > bottom) {
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), width, 1, this.leaf, false);
        }
        this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.7f * width, 1, this.leaf, false);
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(6, 2);
        this.girth = this.determineGirth(this.treeGen.getGirth(this.world, this.startX, this.startY, this.startZ));
    }
}

