/*
 * Decompiled with CFR 0.152.
 */
package com.github.namikon.blocklimiter.command;

import com.github.namikon.blocklimiter.BlockLimiter;
import com.github.namikon.blocklimiter.auxiliary.BlockInfo;
import com.github.namikon.blocklimiter.auxiliary.ItemInfo;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class BlockLimiterCommand
implements ICommand {
    private List aliases = new ArrayList();

    public BlockLimiterCommand() {
        this.aliases.add("blimit");
    }

    public int compareTo(Object arg0) {
        return 0;
    }

    public String func_71517_b() {
        return "blimit";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "/blimit reload|blockinfo|iteminfo";
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public void func_71515_b(ICommandSender pCmdSender, String[] pArgs) {
        if (pArgs.length < 1) {
            PlayerChatHelper.SendError((ICommandSender)pCmdSender, (String)"Usage: /blimit reload|blockinfo|iteminfo");
            return;
        }
        if (pArgs[0].equalsIgnoreCase("reload")) {
            if (!this.isOpOrAdmin(pCmdSender)) {
                PlayerChatHelper.SendError((ICommandSender)pCmdSender, (String)"You need to be op or admin to reload the config");
                return;
            }
            if (!BlockLimiter.Config.Reload()) {
                PlayerChatHelper.SendError((ICommandSender)pCmdSender, (String)"Blocks could not be reloaded properly. Please check the console output and fix the config file");
            } else {
                PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)"Blocklimiter config reloaded. Now monitoring:");
                PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)String.format(" - %d Block(s)", BlockLimiter.Config.LimitedBlocks.size()));
                PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)String.format(" - %d Item(s)", BlockLimiter.Config.LimitedItems.size()));
            }
        } else if (pArgs[0].equalsIgnoreCase("blockinfo")) {
            if (BlockLimiter.Config.LimitedBlocks.size() == 0) {
                PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)String.format("There are currently no forbidden Blocks", new Object[0]));
            } else {
                PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)String.format("The following Blocks are monitored by BlockLimiter:", new Object[0]));
                for (BlockInfo bi : BlockLimiter.Config.LimitedBlocks) {
                    PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)bi.getInfoString());
                }
            }
        } else if (pArgs[0].equalsIgnoreCase("iteminfo")) {
            if (BlockLimiter.Config.LimitedItems.size() == 0) {
                PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)String.format("There are currently no forbidden Items", new Object[0]));
            } else {
                PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)String.format("The following Items are monitored by BlockLimiter:", new Object[0]));
                for (ItemInfo bi : BlockLimiter.Config.LimitedItems) {
                    PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)bi.getInfoString());
                }
            }
        } else {
            PlayerChatHelper.SendError((ICommandSender)pCmdSender, (String)"Usage: /blimit reload|blockinfo|iteminfo");
        }
    }

    private void ProcessDenyinDims(EntityPlayer tEp, ItemStack inHand, String[] pArgs) {
    }

    public boolean func_71519_b(ICommandSender pCommandSender) {
        return true;
    }

    private boolean isOpOrAdmin(ICommandSender pCommandSender) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S()) {
            return true;
        }
        if (pCommandSender instanceof EntityPlayerMP) {
            EntityPlayerMP tEP = (EntityPlayerMP)pCommandSender;
            return MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(tEP.func_146103_bH());
        }
        return false;
    }

    public List func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
        return null;
    }

    public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
        return false;
    }
}

