/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.rituals;

import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.LifeEssenceNetwork;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

public class RitualEffectWithering
extends RitualEffect {
    public static final int reductusDrain = 15;
    public static final int virtusDrain = 15;
    public static final int praesidiumDrain = 5;

    public void performEffect(IMasterRitualStone ritualStone) {
        int potency;
        WorldServer worldSave = MinecraftServer.func_71276_C().field_71305_c[0];
        String owner = ritualStone.getOwner();
        LifeEssenceNetwork data = (LifeEssenceNetwork)worldSave.func_72943_a(LifeEssenceNetwork.class, owner);
        if (data == null) {
            data = new LifeEssenceNetwork(owner);
            worldSave.func_72823_a(owner, (WorldSavedData)data);
        }
        int currentEssence = data.currentEssence;
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        int timeDelay = 50;
        if (world.func_72820_D() % (long)timeDelay != 0L) {
            return;
        }
        boolean hasPraesidium = this.canDrainReagent(ritualStone, ReagentRegistry.praesidiumReagent, 5, false);
        int range = 15 * (hasPraesidium ? 3 : 1);
        int vertRange = 15 * (hasPraesidium ? 3 : 1);
        List list = SpellHelper.getLivingEntitiesInRange((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (double)range, (double)vertRange);
        int entityCount = 0;
        for (EntityLivingBase livingEntity : list) {
            if (livingEntity instanceof EntityPlayer) {
                entityCount += 10;
                continue;
            }
            ++entityCount;
        }
        boolean hasVirtus = this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 15, false);
        int cost = this.getCostPerRefresh() * (hasVirtus ? 3 : 1);
        int n = potency = hasVirtus ? 1 : 0;
        if (currentEssence < cost * entityCount) {
            SoulNetworkHandler.causeNauseaToPlayer((String)owner);
        } else {
            entityCount = 0;
            boolean hasReductus = this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 15, false);
            for (EntityLivingBase livingEntity : list) {
                PotionEffect effect;
                boolean bl = hasReductus = hasReductus && this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 15, false);
                if (hasReductus && !(livingEntity instanceof EntityPlayer) || (effect = livingEntity.func_70660_b(Potion.field_82731_v)) != null && (effect == null || effect.func_76458_c() > potency || effect.func_76459_b() > timeDelay) || hasVirtus && !this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 15, false)) continue;
                livingEntity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, timeDelay + 2, potency));
                if (hasReductus) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 15, true);
                }
                if (hasVirtus) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 15, true);
                }
                if (livingEntity instanceof EntityPlayer) {
                    entityCount += 10;
                    continue;
                }
                ++entityCount;
            }
            if (entityCount > 0) {
                if (hasPraesidium) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.praesidiumReagent, 5, true);
                }
                data.currentEssence = currentEssence - cost * entityCount;
                data.func_76185_a();
            }
        }
    }

    public int getCostPerRefresh() {
        return 30;
    }

    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> witherRitual = new ArrayList<RitualComponent>();
        witherRitual.add(new RitualComponent(1, 0, -1, 5));
        witherRitual.add(new RitualComponent(-1, 0, -1, 5));
        witherRitual.add(new RitualComponent(-1, 0, 1, 5));
        witherRitual.add(new RitualComponent(1, 0, 1, 5));
        witherRitual.add(new RitualComponent(0, 0, -2, 5));
        witherRitual.add(new RitualComponent(0, 0, 2, 5));
        witherRitual.add(new RitualComponent(2, 0, 0, 5));
        witherRitual.add(new RitualComponent(-2, 0, 0, 5));
        witherRitual.add(new RitualComponent(1, 0, -3, 2));
        witherRitual.add(new RitualComponent(1, 0, 3, 2));
        witherRitual.add(new RitualComponent(3, 0, 1, 2));
        witherRitual.add(new RitualComponent(3, 0, -1, 2));
        witherRitual.add(new RitualComponent(-3, 0, -1, 2));
        witherRitual.add(new RitualComponent(-3, 0, 1, 2));
        witherRitual.add(new RitualComponent(-1, 0, -3, 2));
        witherRitual.add(new RitualComponent(-1, 0, 3, 2));
        witherRitual.add(new RitualComponent(1, 3, 0, 2));
        witherRitual.add(new RitualComponent(-1, 3, 0, 2));
        witherRitual.add(new RitualComponent(0, 3, -1, 2));
        witherRitual.add(new RitualComponent(-2, 3, 2, 1));
        witherRitual.add(new RitualComponent(-2, 3, -2, 1));
        witherRitual.add(new RitualComponent(2, 3, 2, 1));
        witherRitual.add(new RitualComponent(2, 3, -2, 1));
        witherRitual.add(new RitualComponent(0, 3, 1, 2));
        witherRitual.add(new RitualComponent(4, 1, 0, 4));
        witherRitual.add(new RitualComponent(0, 1, -4, 4));
        witherRitual.add(new RitualComponent(-4, 1, 0, 4));
        witherRitual.add(new RitualComponent(0, 1, 4, 4));
        witherRitual.add(new RitualComponent(4, 0, -4, 3));
        witherRitual.add(new RitualComponent(-4, 0, -4, 3));
        witherRitual.add(new RitualComponent(4, 0, 4, 3));
        witherRitual.add(new RitualComponent(-4, 0, 4, 3));
        witherRitual.add(new RitualComponent(-3, 1, 3, 4));
        witherRitual.add(new RitualComponent(3, 1, -3, 4));
        witherRitual.add(new RitualComponent(3, 1, 3, 4));
        witherRitual.add(new RitualComponent(-3, 1, -3, 4));
        witherRitual.add(new RitualComponent(3, 2, 0, 5));
        witherRitual.add(new RitualComponent(-3, 2, 0, 5));
        witherRitual.add(new RitualComponent(0, 2, -3, 5));
        witherRitual.add(new RitualComponent(0, 2, 3, 5));
        witherRitual.add(new RitualComponent(3, 2, -3, 5));
        witherRitual.add(new RitualComponent(3, 2, 3, 5));
        witherRitual.add(new RitualComponent(-3, 2, -3, 5));
        witherRitual.add(new RitualComponent(-3, 2, 3, 5));
        witherRitual.add(new RitualComponent(3, 0, -4, 1));
        witherRitual.add(new RitualComponent(3, 0, 4, 1));
        witherRitual.add(new RitualComponent(4, 0, -3, 1));
        witherRitual.add(new RitualComponent(4, 0, 3, 1));
        witherRitual.add(new RitualComponent(-3, 0, 4, 1));
        witherRitual.add(new RitualComponent(-3, 0, -4, 1));
        witherRitual.add(new RitualComponent(-4, 0, 3, 1));
        witherRitual.add(new RitualComponent(-4, 0, -3, 1));
        witherRitual.add(new RitualComponent(-5, 0, 0, 5));
        witherRitual.add(new RitualComponent(0, 0, 5, 5));
        witherRitual.add(new RitualComponent(0, 0, -5, 5));
        witherRitual.add(new RitualComponent(5, 0, 0, 5));
        return witherRitual;
    }
}

