/*
 * Decompiled with CFR 0.152.
 */
package squeek.tictooltips.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.tools.items.Pattern;

public class PatternHelper {
    public static boolean isBowstringPattern(Item item, int meta) {
        return PatternHelper.getPatternName(item, meta).equals("bowstring");
    }

    public static boolean isFletchingPattern(Item item, int meta) {
        return PatternHelper.getPatternName(item, meta).equals("fletching");
    }

    public static String getPatternName(Item item, int meta) {
        if (item instanceof Pattern) {
            return ((Pattern)item).unlocalizedNames[meta];
        }
        return "";
    }

    public static List<String> getValidCustomMaterialsOfType(Class<? extends CustomMaterial> matClass) {
        ArrayList<String> validMats = new ArrayList<String>();
        for (CustomMaterial customMat : TConstructRegistry.customMaterials) {
            String name;
            String line;
            ArrayList items;
            customMat = TConstructRegistry.getCustomMaterial((int)customMat.materialID, matClass);
            if (customMat == null) continue;
            if (customMat.input != null && !validMats.contains(customMat.input.func_82833_r())) {
                validMats.add(customMat.input.func_82833_r());
                continue;
            }
            if (customMat.input != null || customMat.oredict == null || (items = OreDictionary.getOres((String)customMat.oredict)) == null || items.isEmpty()) continue;
            ItemStack itemStackToGetNameOf = (ItemStack)items.get(0);
            if (itemStackToGetNameOf.func_77960_j() == Short.MAX_VALUE) {
                itemStackToGetNameOf = itemStackToGetNameOf.func_77946_l();
                itemStackToGetNameOf.func_77964_b(0);
            }
            if (validMats.contains(line = String.format("%s (%s)", name = itemStackToGetNameOf.func_82833_r(), customMat.oredict))) continue;
            validMats.add(line);
        }
        return validMats;
    }
}

