/*
 * Decompiled with CFR 0.152.
 */
package squeek.tictooltips.helpers;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.items.tools.FryingPan;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.tools.HarvestTool;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.library.weaponry.AmmoWeapon;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.tools.TinkerTools;

public class ToolHelper {
    public static final int INFINITE_DURABILITY = Integer.MAX_VALUE;

    public static void init() {
    }

    public static boolean hasToolTag(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("InfiTool");
    }

    public static NBTTagCompound getToolTag(ItemStack tool) {
        NBTTagCompound tag = tool.func_77978_p().func_74775_l("InfiTool");
        return tag;
    }

    public static ToolMaterial getHeadMaterial(NBTTagCompound toolTag) {
        ToolMaterial mat = null;
        int matID = toolTag.func_74762_e("Head");
        if (matID >= 0) {
            mat = TConstructRegistry.getMaterial((int)matID);
        }
        return mat;
    }

    public static boolean hasToolCategory(ToolCore tool, String searchCategory) {
        for (String category : tool.getTraits()) {
            if (!category.equals(searchCategory)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWeapon(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "weapon");
    }

    public static boolean isBow(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "bow");
    }

    public static boolean isAmmo(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "ammo");
    }

    public static boolean isDualHarvestTool(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "dualharvest");
    }

    public static boolean isHarvestTool(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "harvest");
    }

    public static boolean isUtilityTool(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "utility");
    }

    public static boolean isThrown(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "thrown");
    }

    public static boolean isProjectile(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "projectile");
    }

    public static boolean hasAmmoCount(Item item) {
        return item instanceof IAmmo;
    }

    public static boolean hasDurability(Item item) {
        return !ToolHelper.hasAmmoCount(item) && item instanceof ToolCore || item instanceof ArmorCore;
    }

    public static int getUsedDurability(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("Damage");
    }

    public static int getMaxDurability(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("TotalDurability");
    }

    public static int getEffectiveDurability(NBTTagCompound toolTag) {
        int reinforcedLevel = ToolHelper.getReinforcedLevel(toolTag);
        if (ToolHelper.isUnbreakable(reinforcedLevel)) {
            return Integer.MAX_VALUE;
        }
        return (int)((float)ToolHelper.getMaxDurability(toolTag) / (1.0f - (float)reinforcedLevel / 10.0f));
    }

    public static int getReinforcedLevel(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("Unbreaking");
    }

    public static boolean isUnbreakable(NBTTagCompound toolTag) {
        return ToolHelper.isUnbreakable(ToolHelper.getReinforcedLevel(toolTag));
    }

    public static boolean isUnbreakable(int reinforcedLevel) {
        return reinforcedLevel >= 10;
    }

    public static float getStonebound(NBTTagCompound toolTag) {
        return toolTag.func_74760_g("Shoddy");
    }

    public static int getRawDamage(ToolCore tool, NBTTagCompound toolTag) {
        int rawDamage = toolTag.func_74762_e("Attack") - tool.getDamageVsEntity(null);
        return rawDamage;
    }

    public static int getBaseDamage(ToolCore tool, NBTTagCompound toolTag) {
        if (tool instanceof AmmoItem && toolTag.func_74764_b("BaseAttack")) {
            return toolTag.func_74762_e("BaseAttack");
        }
        return -1;
    }

    public static int getDamage(ToolCore tool, NBTTagCompound toolTag, float damageModifier) {
        return (int)ToolHelper.getPreciseDamage(tool, toolTag, damageModifier);
    }

    public static float getPreciseDamage(ToolCore tool, NBTTagCompound toolTag, float damageModifier) {
        float attack;
        if (tool instanceof AmmoItem && toolTag.func_74764_b("BaseAttack")) {
            float baseAttack = toolTag.func_74762_e("BaseAttack");
            float totalAttack = toolTag.func_74762_e("Attack");
            attack = baseAttack * damageModifier;
            attack += totalAttack - baseAttack;
            attack = Math.max(0.0f, attack - totalAttack / 2.0f);
        } else {
            attack = (float)toolTag.func_74762_e("Attack") * damageModifier;
        }
        attack += ToolHelper.getShoddinessDamageBonus(tool, toolTag);
        attack *= tool.getDamageModifier();
        if (tool instanceof AmmoWeapon) {
            attack *= ((AmmoWeapon)tool).getProjectileSpeed();
        }
        if (attack < 1.0f) {
            attack = 1.0f;
        }
        return attack;
    }

    public static int getDamage(ToolCore tool, NBTTagCompound toolTag) {
        return (int)ToolHelper.getPreciseDamage(tool, toolTag);
    }

    public static float getPreciseDamage(ToolCore tool, NBTTagCompound toolTag) {
        return ToolHelper.getPreciseDamage(tool, toolTag, 1.0f);
    }

    public static float[] getCriticalDamageRange(ToolCore tool, NBTTagCompound toolTag, float damageModifier) {
        float attack = ToolHelper.getPreciseDamage(tool, toolTag, damageModifier);
        float minCritDamage = 0.0f;
        float maxCritDamage = 1.0f * (attack / 2.0f + 2.0f);
        return new float[]{minCritDamage, maxCritDamage};
    }

    public static int getSprintDamage(ToolCore tool, NBTTagCompound toolTag) {
        int attack = ToolHelper.getDamage(tool, toolTag);
        float lunge = tool.chargeAttack();
        if (lunge > 1.0f) {
            attack = (int)((float)attack * lunge);
        }
        return attack;
    }

    public static int[] getSmiteDamageRange(ToolCore tool, NBTTagCompound toolTag) {
        int staticBonus = 0;
        int variableBonus = 0;
        if (TinkerTools.hammer.getClass().isInstance(tool)) {
            int level = 2;
            staticBonus += level * 2;
            variableBonus += level * 2 + 1;
        }
        if (toolTag.func_74764_b("ModSmite")) {
            int[] array = toolTag.func_74759_k("ModSmite");
            int base = array[0] / 18;
            staticBonus += 1 + base;
            variableBonus += base + 1;
        }
        return new int[]{staticBonus, staticBonus + variableBonus};
    }

    public static int[] getAntiSpiderDamageRange(ToolCore tool, NBTTagCompound toolTag) {
        int staticBonus = 0;
        int variableBonus = 0;
        if (toolTag.func_74764_b("ModAntiSpider")) {
            int[] array = toolTag.func_74759_k("ModAntiSpider");
            int base = array[0] / 2;
            staticBonus += 1 + base;
            variableBonus += base + 1;
        }
        return new int[]{staticBonus, staticBonus + variableBonus};
    }

    public static int getBurnDuration(ToolCore tool, NBTTagCompound toolTag) {
        int burnDuration = 0;
        if (toolTag.func_74764_b("Fiery")) {
            burnDuration += toolTag.func_74762_e("Fiery") / 5 + 1;
        }
        if (toolTag.func_74767_n("Lava")) {
            burnDuration += 3;
        }
        return burnDuration;
    }

    public static float getChanceToBehead(ToolCore tool, NBTTagCompound toolTag) {
        float chanceToBehead = toolTag.func_74762_e("Beheading");
        if (TinkerTools.cleaver.getClass().isInstance(tool)) {
            chanceToBehead += 2.0f;
        }
        return Math.min(1.0f, chanceToBehead /= 10.0f);
    }

    public static float getKnockback(ToolCore tool, NBTTagCompound toolTag) {
        float knockback = 0.0f;
        if (tool instanceof FryingPan) {
            knockback += 1.7f;
        }
        if (toolTag.func_74764_b("Knockback")) {
            float level = toolTag.func_74760_g("Knockback");
            knockback += level;
        }
        return knockback;
    }

    public static float getSprintKnockback(ToolCore tool, NBTTagCompound toolTag) {
        float knockback = ToolHelper.getKnockback(tool, toolTag);
        knockback += 1.0f;
        float lunge = tool.chargeAttack();
        if (lunge > 1.0f) {
            knockback += lunge - 1.0f;
        }
        return knockback;
    }

    public static float getShoddinessDamageBonus(ToolCore tool, NBTTagCompound toolTag) {
        return -ToolHelper.getShoddinessBonus(ToolHelper.getUsedDurability(toolTag), ToolHelper.getStonebound(toolTag), ToolHelper.getShoddinessModifierConstant(tool));
    }

    public static float getMaxShoddinessDamageBonus(ToolCore tool, NBTTagCompound toolTag) {
        return -ToolHelper.getShoddinessBonus(ToolHelper.getMaxDurability(toolTag), ToolHelper.getStonebound(toolTag), ToolHelper.getShoddinessModifierConstant(tool));
    }

    public static float getShoddinessModifierConstant(ToolCore tool) {
        if (tool == null || !(tool instanceof HarvestTool)) {
            return 72.0f;
        }
        return ((HarvestTool)tool).stoneboundModifier();
    }

    public static float getShoddinessBonus(int usedDurability, float shoddiness, float modifierConstant) {
        return (float)Math.log((float)usedDurability / modifierConstant + 1.0f) * 2.0f * shoddiness;
    }

    public static float getShoddinessSpeedBonus(ToolCore tool, NBTTagCompound toolTag) {
        return ToolHelper.getShoddinessBonus(ToolHelper.getUsedDurability(toolTag), ToolHelper.getStonebound(toolTag), ToolHelper.getShoddinessModifierConstant(tool));
    }

    public static float getMaxShoddinessSpeedBonus(ToolCore tool, NBTTagCompound toolTag) {
        return ToolHelper.getShoddinessBonus(ToolHelper.getMaxDurability(toolTag), ToolHelper.getStonebound(toolTag), ToolHelper.getShoddinessModifierConstant(tool));
    }

    public static int getDrawSpeed(ToolCore tool, NBTTagCompound toolTag) {
        return toolTag.func_74762_e("DrawSpeed");
    }

    public static float getArrowSpeed(ToolCore tool, NBTTagCompound toolTag) {
        return toolTag.func_74760_g("FlightSpeed");
    }

    public static int getAmmoDamage(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("Attack");
    }

    public static float getWeight(NBTTagCompound toolTag) {
        return toolTag.func_74760_g("Mass");
    }

    public static float getAccuracy(NBTTagCompound toolTag) {
        return toolTag.func_74760_g("Accuracy");
    }

    public static float getBreakChance(NBTTagCompound toolTag) {
        return toolTag.func_74760_g("BreakChance");
    }

    public static float getMiningSpeedModifier(ToolCore tool) {
        if (tool == null || !(tool instanceof HarvestTool)) {
            return 1.0f;
        }
        return ((HarvestTool)tool).breakSpeedModifier();
    }

    public static int getPrimaryMiningSpeed(ToolCore tool, NBTTagCompound toolTag) {
        return (int)((float)toolTag.func_74762_e("MiningSpeed") * ToolHelper.getMiningSpeedModifier(tool));
    }

    public static int getSecondaryMiningSpeed(ToolCore tool, NBTTagCompound toolTag) {
        return (int)((float)toolTag.func_74762_e("MiningSpeed2") * ToolHelper.getMiningSpeedModifier(tool));
    }

    public static int getTotalMiningSpeed(ToolCore tool, NBTTagCompound toolTag) {
        int mineSpeed = toolTag.func_74762_e("MiningSpeed");
        int heads = 1;
        if (toolTag.func_74764_b("MiningSpeed2")) {
            mineSpeed += toolTag.func_74762_e("MiningSpeed2");
            ++heads;
        }
        if (toolTag.func_74764_b("MiningSpeedHandle")) {
            mineSpeed += toolTag.func_74762_e("MiningSpeedHandle");
            ++heads;
        }
        if (toolTag.func_74764_b("MiningSpeedExtra")) {
            mineSpeed += toolTag.func_74762_e("MiningSpeedExtra");
            ++heads;
        }
        return (int)((float)mineSpeed / (float)heads * ToolHelper.getMiningSpeedModifier(tool));
    }

    public static int getPrimaryHarvestLevel(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("HarvestLevel");
    }

    public static int getSecondaryHarvestLevel(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("HarvestLevel2");
    }
}

