/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm;

import com.gtnewhorizon.gtnhlib.client.renderer.stacks.IStateStack;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VBOManager;
import com.gtnewhorizons.angelica.AngelicaMod;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.glsm.Feature;
import com.gtnewhorizons.angelica.glsm.GLDebug;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import com.gtnewhorizons.angelica.glsm.Vendor;
import com.gtnewhorizons.angelica.glsm.stacks.AlphaStateStack;
import com.gtnewhorizons.angelica.glsm.stacks.BlendStateStack;
import com.gtnewhorizons.angelica.glsm.stacks.BooleanStateStack;
import com.gtnewhorizons.angelica.glsm.stacks.Color4Stack;
import com.gtnewhorizons.angelica.glsm.stacks.ColorMaskStack;
import com.gtnewhorizons.angelica.glsm.stacks.DepthStateStack;
import com.gtnewhorizons.angelica.glsm.stacks.FogStateStack;
import com.gtnewhorizons.angelica.glsm.stacks.IntegerStateStack;
import com.gtnewhorizons.angelica.glsm.stacks.LightModelStateStack;
import com.gtnewhorizons.angelica.glsm.stacks.LightStateStack;
import com.gtnewhorizons.angelica.glsm.stacks.MaterialStateStack;
import com.gtnewhorizons.angelica.glsm.stacks.MatrixModeStack;
import com.gtnewhorizons.angelica.glsm.stacks.TextureBindingStack;
import com.gtnewhorizons.angelica.glsm.stacks.ViewPortStateStack;
import com.gtnewhorizons.angelica.glsm.states.Color4;
import com.gtnewhorizons.angelica.glsm.states.ISettableState;
import com.gtnewhorizons.angelica.glsm.states.TextureBinding;
import com.gtnewhorizons.angelica.glsm.states.TextureUnitArray;
import com.gtnewhorizons.angelica.glsm.texture.TextureInfo;
import com.gtnewhorizons.angelica.glsm.texture.TextureInfoCache;
import com.gtnewhorizons.angelica.glsm.texture.TextureTracker;
import com.gtnewhorizons.angelica.hudcaching.HUDCaching;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import cpw.mods.fml.relauncher.ReflectionHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import lombok.Generated;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gbuffer_overrides.state.StateTracker;
import net.coderbot.iris.gl.blending.AlphaTestStorage;
import net.coderbot.iris.gl.blending.BlendModeStorage;
import net.coderbot.iris.gl.blending.DepthColorStorage;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.minecraft.client.renderer.OpenGlHelper;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;

public class GLStateManager {
    public static ContextCapabilities capabilities;
    protected static boolean poppingAttributes;
    public static boolean BYPASS_CACHE;
    public static final int MAX_ATTRIB_STACK_DEPTH;
    public static final int MAX_MODELVIEW_STACK_DEPTH;
    public static final int MAX_PROJECTION_STACK_DEPTH;
    public static final int MAX_TEXTURE_STACK_DEPTH;
    public static final int MAX_TEXTURE_UNITS;
    public static final int MAX_CLIP_PLANES;
    public static final GLFeatureSet HAS_MULTIPLE_SET;
    private static Vendor VENDOR;
    public static final int DEFAULT_DRAW_BUFFER;
    private static final IntStack attribs;
    protected static final IntegerStateStack activeTextureUnit;
    protected static final IntegerStateStack shadeModelState;
    protected static final TextureUnitArray textures;
    protected static final BlendStateStack blendState;
    protected static final BooleanStateStack blendMode;
    protected static final BooleanStateStack scissorTest;
    protected static final DepthStateStack depthState;
    protected static final BooleanStateStack depthTest;
    protected static final FogStateStack fogState;
    protected static final BooleanStateStack fogMode;
    protected static final Color4Stack color;
    protected static final Color4Stack clearColor;
    protected static final ColorMaskStack colorMask;
    protected static final IntegerStateStack drawBuffer;
    protected static final BooleanStateStack cullState;
    protected static final AlphaStateStack alphaState;
    protected static final BooleanStateStack alphaTest;
    protected static final BooleanStateStack lightingState;
    protected static final BooleanStateStack rescaleNormalState;
    protected static final BooleanStateStack normalizeState;
    protected static final BooleanStateStack ditherState;
    protected static final BooleanStateStack stencilTest;
    protected static final BooleanStateStack lineSmoothState;
    protected static final BooleanStateStack lineStippleState;
    protected static final BooleanStateStack pointSmoothState;
    protected static final BooleanStateStack polygonSmoothState;
    protected static final BooleanStateStack polygonStippleState;
    protected static final BooleanStateStack multisampleState;
    protected static final BooleanStateStack sampleAlphaToCoverageState;
    protected static final BooleanStateStack sampleAlphaToOneState;
    protected static final BooleanStateStack sampleCoverageState;
    protected static final BooleanStateStack colorLogicOpState;
    protected static final BooleanStateStack indexLogicOpState;
    protected static final BooleanStateStack polygonOffsetPointState;
    protected static final BooleanStateStack polygonOffsetLineState;
    protected static final BooleanStateStack polygonOffsetFillState;
    protected static final BooleanStateStack autoNormalState;
    protected static final BooleanStateStack map1Color4State;
    protected static final BooleanStateStack map1IndexState;
    protected static final BooleanStateStack map1NormalState;
    protected static final BooleanStateStack map1TextureCoord1State;
    protected static final BooleanStateStack map1TextureCoord2State;
    protected static final BooleanStateStack map1TextureCoord3State;
    protected static final BooleanStateStack map1TextureCoord4State;
    protected static final BooleanStateStack map1Vertex3State;
    protected static final BooleanStateStack map1Vertex4State;
    protected static final BooleanStateStack map2Color4State;
    protected static final BooleanStateStack map2IndexState;
    protected static final BooleanStateStack map2NormalState;
    protected static final BooleanStateStack map2TextureCoord1State;
    protected static final BooleanStateStack map2TextureCoord2State;
    protected static final BooleanStateStack map2TextureCoord3State;
    protected static final BooleanStateStack map2TextureCoord4State;
    protected static final BooleanStateStack map2Vertex3State;
    protected static final BooleanStateStack map2Vertex4State;
    protected static final BooleanStateStack[] clipPlaneStates;
    protected static final MatrixModeStack matrixMode;
    protected static final Matrix4fStack modelViewMatrix;
    protected static final Matrix4fStack projectionMatrix;
    protected static final BooleanStateStack[] lightStates;
    protected static final LightStateStack[] lightDataStates;
    protected static final BooleanStateStack colorMaterial;
    protected static final IntegerStateStack colorMaterialFace;
    protected static final IntegerStateStack colorMaterialParameter;
    protected static final LightModelStateStack lightModel;
    protected static final MaterialStateStack frontMaterial;
    protected static final MaterialStateStack backMaterial;
    private static final MethodHandle MAT4_STACK_CURR_DEPTH;
    protected static final ViewPortStateStack viewportState;
    protected static int activeProgram;
    private static Runnable blendFuncListener;
    private static Runnable fogToggleListener;
    private static Runnable fogModeListener;
    private static Runnable fogStartListener;
    private static Runnable fogEndListener;
    private static Runnable fogDensityListener;
    private static final Thread MainThread;
    private static Thread CurrentThread;
    private static boolean runningSplash;
    private static int glListMode;
    private static int glListNesting;
    private static int glListId;
    private static final Map<IStateStack<?>, ISettableState<?>> glListStates;
    private static final Int2ObjectMap<Set<Map.Entry<IStateStack<?>, ISettableState<?>>>> glListChanges;
    private static final Color4 DirtyColor;
    private static final Matrix4f tempMatrix4f;
    public static final Matrix4d conversionMatrix4d;
    public static final Matrix4f conversionMatrix4f;
    private static final Vector3f rotation;
    private static final Matrix4f perspectiveMatrix;
    private static final FloatBuffer perspectiveBuffer;

    public static void reset() {
        runningSplash = true;
        while (!attribs.isEmpty()) {
            attribs.popInt();
        }
        List<IStateStack<?>> stacks = Feature.maskToFeatures(1048575);
        int size = stacks.size();
        for (int i = 0; i < size; ++i) {
            IStateStack<?> stack = stacks.get(i);
            while (!stack.isEmpty()) {
                stack.pop();
            }
        }
        modelViewMatrix.clear();
        projectionMatrix.clear();
    }

    public static void preInit() {
        capabilities = GLContext.getCapabilities();
        HAS_MULTIPLE_SET.addFeature(2944).addFeature(32773).addFeature(3106).addFeature(3107).addFeature(2816).addFeature(2818).addFeature(2820).addFeature(2823).addFeature(2822).addFeature(2819).addFeature(2928).addFeature(2918).addFeature(2899).addFeature(2850).addFeature(3536).addFeature(3538).addFeature(3539).addFeature(3386).addFeature(2982).addFeature(2834).addFeature(2880).addFeature(2983).addFeature(3088).addFeature(8705).addFeature(2984).addFeature(2978);
        String glVendor = GL11.glGetString((int)7936);
        VENDOR = Vendor.getVendor(glVendor.toLowerCase());
        if (GLStateManager.vendorIsAMD()) {
            GL11.glMatrixMode((int)5888);
        }
    }

    public static void init() {
        RenderSystem.initRenderer();
        if (AngelicaConfig.enableIris) {
            StateUpdateNotifiers.blendFuncNotifier = listener -> {
                blendFuncListener = listener;
            };
            StateUpdateNotifiers.fogToggleNotifier = listener -> {
                fogToggleListener = listener;
            };
            StateUpdateNotifiers.fogModeNotifier = listener -> {
                fogModeListener = listener;
            };
            StateUpdateNotifiers.fogStartNotifier = listener -> {
                fogStartListener = listener;
            };
            StateUpdateNotifiers.fogEndNotifier = listener -> {
                fogEndListener = listener;
            };
            StateUpdateNotifiers.fogDensityNotifier = listener -> {
                fogDensityListener = listener;
            };
        }
        if (BYPASS_CACHE) {
            AngelicaTweaker.LOGGER.info("GLStateManager cache bypassed");
        }
        if (AngelicaMod.lwjglDebug) {
            AngelicaTweaker.LOGGER.info("Enabling additional LWJGL debug output");
            GLDebug.setupDebugMessageCallback();
            GLDebug.initDebugState();
            GLDebug.debugMessage("Angelica Debug Annotator Initialized");
        }
    }

    public static boolean isMainThread() {
        return Thread.currentThread() == MainThread;
    }

    public static void assertMainThread() {
        if (Thread.currentThread() != CurrentThread && !runningSplash) {
            AngelicaTweaker.LOGGER.info("Call from not the Current Thread! - " + Thread.currentThread().getName() + " Current thread: " + CurrentThread.getName());
        }
    }

    public static boolean shouldBypassCache() {
        return BYPASS_CACHE || runningSplash;
    }

    public static void glEnable(int cap) {
        if (cap >= 12288 && cap < 12288 + MAX_CLIP_PLANES) {
            clipPlaneStates[cap - 12288].enable();
            return;
        }
        switch (cap) {
            case 3008: {
                GLStateManager.enableAlphaTest();
                break;
            }
            case 3456: {
                autoNormalState.enable();
                break;
            }
            case 3042: {
                GLStateManager.enableBlend();
                break;
            }
            case 2903: {
                GLStateManager.enableColorMaterial();
                break;
            }
            case 3058: {
                colorLogicOpState.enable();
                break;
            }
            case 2884: {
                GLStateManager.enableCull();
                break;
            }
            case 2929: {
                GLStateManager.enableDepthTest();
                break;
            }
            case 3024: {
                ditherState.enable();
                break;
            }
            case 2912: {
                GLStateManager.enableFog();
                break;
            }
            case 3057: {
                indexLogicOpState.enable();
                break;
            }
            case 2896: {
                GLStateManager.enableLighting();
                break;
            }
            case 16384: {
                GLStateManager.enableLight(0);
                break;
            }
            case 16385: {
                GLStateManager.enableLight(1);
                break;
            }
            case 16386: {
                GLStateManager.enableLight(2);
                break;
            }
            case 16387: {
                GLStateManager.enableLight(3);
                break;
            }
            case 16388: {
                GLStateManager.enableLight(4);
                break;
            }
            case 16389: {
                GLStateManager.enableLight(5);
                break;
            }
            case 16390: {
                GLStateManager.enableLight(6);
                break;
            }
            case 16391: {
                GLStateManager.enableLight(7);
                break;
            }
            case 2848: {
                lineSmoothState.enable();
                break;
            }
            case 2852: {
                lineStippleState.enable();
                break;
            }
            case 3472: {
                map1Color4State.enable();
                break;
            }
            case 3473: {
                map1IndexState.enable();
                break;
            }
            case 3474: {
                map1NormalState.enable();
                break;
            }
            case 3475: {
                map1TextureCoord1State.enable();
                break;
            }
            case 3476: {
                map1TextureCoord2State.enable();
                break;
            }
            case 3477: {
                map1TextureCoord3State.enable();
                break;
            }
            case 3478: {
                map1TextureCoord4State.enable();
                break;
            }
            case 3479: {
                map1Vertex3State.enable();
                break;
            }
            case 3480: {
                map1Vertex4State.enable();
                break;
            }
            case 3504: {
                map2Color4State.enable();
                break;
            }
            case 3505: {
                map2IndexState.enable();
                break;
            }
            case 3506: {
                map2NormalState.enable();
                break;
            }
            case 3507: {
                map2TextureCoord1State.enable();
                break;
            }
            case 3508: {
                map2TextureCoord2State.enable();
                break;
            }
            case 3509: {
                map2TextureCoord3State.enable();
                break;
            }
            case 3510: {
                map2TextureCoord4State.enable();
                break;
            }
            case 3511: {
                map2Vertex3State.enable();
                break;
            }
            case 3512: {
                map2Vertex4State.enable();
                break;
            }
            case 32925: {
                multisampleState.enable();
                break;
            }
            case 2977: {
                normalizeState.enable();
                break;
            }
            case 2832: {
                pointSmoothState.enable();
                break;
            }
            case 10753: {
                polygonOffsetPointState.enable();
                break;
            }
            case 10754: {
                polygonOffsetLineState.enable();
                break;
            }
            case 32823: {
                polygonOffsetFillState.enable();
                break;
            }
            case 2881: {
                polygonSmoothState.enable();
                break;
            }
            case 2882: {
                polygonStippleState.enable();
                break;
            }
            case 32826: {
                GLStateManager.enableRescaleNormal();
                break;
            }
            case 32926: {
                sampleAlphaToCoverageState.enable();
                break;
            }
            case 32927: {
                sampleAlphaToOneState.enable();
                break;
            }
            case 32928: {
                sampleCoverageState.enable();
                break;
            }
            case 3089: {
                GLStateManager.enableScissorTest();
                break;
            }
            case 2960: {
                stencilTest.enable();
                break;
            }
            case 3552: {
                textures.getTexture1DStates(activeTextureUnit.getValue()).enable();
                break;
            }
            case 3553: {
                GLStateManager.enableTexture();
                break;
            }
            case 32879: {
                textures.getTexture3DStates(activeTextureUnit.getValue()).enable();
                break;
            }
            case 3168: {
                textures.getTexGenSStates(activeTextureUnit.getValue()).enable();
                break;
            }
            case 3169: {
                textures.getTexGenTStates(activeTextureUnit.getValue()).enable();
                break;
            }
            case 3170: {
                textures.getTexGenRStates(activeTextureUnit.getValue()).enable();
                break;
            }
            case 3171: {
                textures.getTexGenQStates(activeTextureUnit.getValue()).enable();
                break;
            }
            default: {
                GL11.glEnable((int)cap);
            }
        }
    }

    public static void glDisable(int cap) {
        if (cap >= 12288 && cap < 12288 + MAX_CLIP_PLANES) {
            clipPlaneStates[cap - 12288].disable();
            return;
        }
        switch (cap) {
            case 3008: {
                GLStateManager.disableAlphaTest();
                break;
            }
            case 3456: {
                autoNormalState.disable();
                break;
            }
            case 3042: {
                GLStateManager.disableBlend();
                break;
            }
            case 2903: {
                GLStateManager.disableColorMaterial();
                break;
            }
            case 3058: {
                colorLogicOpState.disable();
                break;
            }
            case 2884: {
                GLStateManager.disableCull();
                break;
            }
            case 2929: {
                GLStateManager.disableDepthTest();
                break;
            }
            case 3024: {
                ditherState.disable();
                break;
            }
            case 2912: {
                GLStateManager.disableFog();
                break;
            }
            case 3057: {
                indexLogicOpState.disable();
                break;
            }
            case 2896: {
                GLStateManager.disableLighting();
                break;
            }
            case 16384: {
                GLStateManager.disableLight(0);
                break;
            }
            case 16385: {
                GLStateManager.disableLight(1);
                break;
            }
            case 16386: {
                GLStateManager.disableLight(2);
                break;
            }
            case 16387: {
                GLStateManager.disableLight(3);
                break;
            }
            case 16388: {
                GLStateManager.disableLight(4);
                break;
            }
            case 16389: {
                GLStateManager.disableLight(5);
                break;
            }
            case 16390: {
                GLStateManager.disableLight(6);
                break;
            }
            case 16391: {
                GLStateManager.disableLight(7);
                break;
            }
            case 2848: {
                lineSmoothState.disable();
                break;
            }
            case 2852: {
                lineStippleState.disable();
                break;
            }
            case 3472: {
                map1Color4State.disable();
                break;
            }
            case 3473: {
                map1IndexState.disable();
                break;
            }
            case 3474: {
                map1NormalState.disable();
                break;
            }
            case 3475: {
                map1TextureCoord1State.disable();
                break;
            }
            case 3476: {
                map1TextureCoord2State.disable();
                break;
            }
            case 3477: {
                map1TextureCoord3State.disable();
                break;
            }
            case 3478: {
                map1TextureCoord4State.disable();
                break;
            }
            case 3479: {
                map1Vertex3State.disable();
                break;
            }
            case 3480: {
                map1Vertex4State.disable();
                break;
            }
            case 3504: {
                map2Color4State.disable();
                break;
            }
            case 3505: {
                map2IndexState.disable();
                break;
            }
            case 3506: {
                map2NormalState.disable();
                break;
            }
            case 3507: {
                map2TextureCoord1State.disable();
                break;
            }
            case 3508: {
                map2TextureCoord2State.disable();
                break;
            }
            case 3509: {
                map2TextureCoord3State.disable();
                break;
            }
            case 3510: {
                map2TextureCoord4State.disable();
                break;
            }
            case 3511: {
                map2Vertex3State.disable();
                break;
            }
            case 3512: {
                map2Vertex4State.disable();
                break;
            }
            case 32925: {
                multisampleState.disable();
                break;
            }
            case 2977: {
                normalizeState.disable();
                break;
            }
            case 2832: {
                pointSmoothState.disable();
                break;
            }
            case 10753: {
                polygonOffsetPointState.disable();
                break;
            }
            case 10754: {
                polygonOffsetLineState.disable();
                break;
            }
            case 32823: {
                polygonOffsetFillState.disable();
                break;
            }
            case 2881: {
                polygonSmoothState.disable();
                break;
            }
            case 2882: {
                polygonStippleState.disable();
                break;
            }
            case 32826: {
                GLStateManager.disableRescaleNormal();
                break;
            }
            case 32926: {
                sampleAlphaToCoverageState.disable();
                break;
            }
            case 32927: {
                sampleAlphaToOneState.disable();
                break;
            }
            case 32928: {
                sampleCoverageState.disable();
                break;
            }
            case 3089: {
                GLStateManager.disableScissorTest();
                break;
            }
            case 2960: {
                stencilTest.disable();
                break;
            }
            case 3552: {
                textures.getTexture1DStates(activeTextureUnit.getValue()).disable();
                break;
            }
            case 3553: {
                GLStateManager.disableTexture();
                break;
            }
            case 32879: {
                textures.getTexture3DStates(activeTextureUnit.getValue()).disable();
                break;
            }
            case 3168: {
                textures.getTexGenSStates(activeTextureUnit.getValue()).disable();
                break;
            }
            case 3169: {
                textures.getTexGenTStates(activeTextureUnit.getValue()).disable();
                break;
            }
            case 3170: {
                textures.getTexGenRStates(activeTextureUnit.getValue()).disable();
                break;
            }
            case 3171: {
                textures.getTexGenQStates(activeTextureUnit.getValue()).disable();
                break;
            }
            default: {
                GL11.glDisable((int)cap);
            }
        }
    }

    public static boolean glIsEnabled(int cap) {
        boolean bl;
        if (GLStateManager.shouldBypassCache()) {
            return GL11.glIsEnabled((int)cap);
        }
        if (cap >= 12288 && cap < 12288 + MAX_CLIP_PLANES) {
            return clipPlaneStates[cap - 12288].isEnabled();
        }
        switch (cap) {
            case 3008: {
                bl = alphaTest.isEnabled();
                break;
            }
            case 3456: {
                bl = autoNormalState.isEnabled();
                break;
            }
            case 3042: {
                bl = blendMode.isEnabled();
                break;
            }
            case 2903: {
                bl = colorMaterial.isEnabled();
                break;
            }
            case 3058: {
                bl = colorLogicOpState.isEnabled();
                break;
            }
            case 2884: {
                bl = cullState.isEnabled();
                break;
            }
            case 2929: {
                bl = depthTest.isEnabled();
                break;
            }
            case 3024: {
                bl = ditherState.isEnabled();
                break;
            }
            case 2912: {
                bl = fogMode.isEnabled();
                break;
            }
            case 3057: {
                bl = indexLogicOpState.isEnabled();
                break;
            }
            case 2896: {
                bl = lightingState.isEnabled();
                break;
            }
            case 16384: {
                bl = lightStates[0].isEnabled();
                break;
            }
            case 16385: {
                bl = lightStates[1].isEnabled();
                break;
            }
            case 16386: {
                bl = lightStates[2].isEnabled();
                break;
            }
            case 16387: {
                bl = lightStates[3].isEnabled();
                break;
            }
            case 16388: {
                bl = lightStates[4].isEnabled();
                break;
            }
            case 16389: {
                bl = lightStates[5].isEnabled();
                break;
            }
            case 16390: {
                bl = lightStates[6].isEnabled();
                break;
            }
            case 16391: {
                bl = lightStates[7].isEnabled();
                break;
            }
            case 2848: {
                bl = lineSmoothState.isEnabled();
                break;
            }
            case 2852: {
                bl = lineStippleState.isEnabled();
                break;
            }
            case 3472: {
                bl = map1Color4State.isEnabled();
                break;
            }
            case 3473: {
                bl = map1IndexState.isEnabled();
                break;
            }
            case 3474: {
                bl = map1NormalState.isEnabled();
                break;
            }
            case 3475: {
                bl = map1TextureCoord1State.isEnabled();
                break;
            }
            case 3476: {
                bl = map1TextureCoord2State.isEnabled();
                break;
            }
            case 3477: {
                bl = map1TextureCoord3State.isEnabled();
                break;
            }
            case 3478: {
                bl = map1TextureCoord4State.isEnabled();
                break;
            }
            case 3479: {
                bl = map1Vertex3State.isEnabled();
                break;
            }
            case 3480: {
                bl = map1Vertex4State.isEnabled();
                break;
            }
            case 3504: {
                bl = map2Color4State.isEnabled();
                break;
            }
            case 3505: {
                bl = map2IndexState.isEnabled();
                break;
            }
            case 3506: {
                bl = map2NormalState.isEnabled();
                break;
            }
            case 3507: {
                bl = map2TextureCoord1State.isEnabled();
                break;
            }
            case 3508: {
                bl = map2TextureCoord2State.isEnabled();
                break;
            }
            case 3509: {
                bl = map2TextureCoord3State.isEnabled();
                break;
            }
            case 3510: {
                bl = map2TextureCoord4State.isEnabled();
                break;
            }
            case 3511: {
                bl = map2Vertex3State.isEnabled();
                break;
            }
            case 3512: {
                bl = map2Vertex4State.isEnabled();
                break;
            }
            case 32925: {
                bl = multisampleState.isEnabled();
                break;
            }
            case 2977: {
                bl = normalizeState.isEnabled();
                break;
            }
            case 2832: {
                bl = pointSmoothState.isEnabled();
                break;
            }
            case 10753: {
                bl = polygonOffsetPointState.isEnabled();
                break;
            }
            case 10754: {
                bl = polygonOffsetLineState.isEnabled();
                break;
            }
            case 32823: {
                bl = polygonOffsetFillState.isEnabled();
                break;
            }
            case 2881: {
                bl = polygonSmoothState.isEnabled();
                break;
            }
            case 2882: {
                bl = polygonStippleState.isEnabled();
                break;
            }
            case 32826: {
                bl = rescaleNormalState.isEnabled();
                break;
            }
            case 32926: {
                bl = sampleAlphaToCoverageState.isEnabled();
                break;
            }
            case 32927: {
                bl = sampleAlphaToOneState.isEnabled();
                break;
            }
            case 32928: {
                bl = sampleCoverageState.isEnabled();
                break;
            }
            case 3089: {
                bl = scissorTest.isEnabled();
                break;
            }
            case 2960: {
                bl = stencilTest.isEnabled();
                break;
            }
            case 3552: {
                bl = textures.getTexture1DStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            case 3553: {
                bl = textures.getTextureUnitStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            case 32879: {
                bl = textures.getTexture3DStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            case 3168: {
                bl = textures.getTexGenSStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            case 3169: {
                bl = textures.getTexGenTStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            case 3170: {
                bl = textures.getTexGenRStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            case 3171: {
                bl = textures.getTexGenQStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            default: {
                bl = GL11.glIsEnabled((int)cap);
            }
        }
        return bl;
    }

    public static boolean glGetBoolean(int pname) {
        boolean bl;
        if (GLStateManager.shouldBypassCache()) {
            return GL11.glGetBoolean((int)pname);
        }
        if (pname >= 12288 && pname < 12288 + MAX_CLIP_PLANES) {
            return clipPlaneStates[pname - 12288].isEnabled();
        }
        switch (pname) {
            case 3008: {
                bl = alphaTest.isEnabled();
                break;
            }
            case 3456: {
                bl = autoNormalState.isEnabled();
                break;
            }
            case 3042: {
                bl = blendMode.isEnabled();
                break;
            }
            case 2903: {
                bl = colorMaterial.isEnabled();
                break;
            }
            case 3058: {
                bl = colorLogicOpState.isEnabled();
                break;
            }
            case 2884: {
                bl = cullState.isEnabled();
                break;
            }
            case 2929: {
                bl = depthTest.isEnabled();
                break;
            }
            case 2930: {
                bl = depthState.isEnabled();
                break;
            }
            case 3024: {
                bl = ditherState.isEnabled();
                break;
            }
            case 2912: {
                bl = fogMode.isEnabled();
                break;
            }
            case 3057: {
                bl = indexLogicOpState.isEnabled();
                break;
            }
            case 2896: {
                bl = lightingState.isEnabled();
                break;
            }
            case 16384: {
                bl = lightStates[0].isEnabled();
                break;
            }
            case 16385: {
                bl = lightStates[1].isEnabled();
                break;
            }
            case 16386: {
                bl = lightStates[2].isEnabled();
                break;
            }
            case 16387: {
                bl = lightStates[3].isEnabled();
                break;
            }
            case 16388: {
                bl = lightStates[4].isEnabled();
                break;
            }
            case 16389: {
                bl = lightStates[5].isEnabled();
                break;
            }
            case 16390: {
                bl = lightStates[6].isEnabled();
                break;
            }
            case 16391: {
                bl = lightStates[7].isEnabled();
                break;
            }
            case 2848: {
                bl = lineSmoothState.isEnabled();
                break;
            }
            case 2852: {
                bl = lineStippleState.isEnabled();
                break;
            }
            case 3472: {
                bl = map1Color4State.isEnabled();
                break;
            }
            case 3473: {
                bl = map1IndexState.isEnabled();
                break;
            }
            case 3474: {
                bl = map1NormalState.isEnabled();
                break;
            }
            case 3475: {
                bl = map1TextureCoord1State.isEnabled();
                break;
            }
            case 3476: {
                bl = map1TextureCoord2State.isEnabled();
                break;
            }
            case 3477: {
                bl = map1TextureCoord3State.isEnabled();
                break;
            }
            case 3478: {
                bl = map1TextureCoord4State.isEnabled();
                break;
            }
            case 3479: {
                bl = map1Vertex3State.isEnabled();
                break;
            }
            case 3480: {
                bl = map1Vertex4State.isEnabled();
                break;
            }
            case 3504: {
                bl = map2Color4State.isEnabled();
                break;
            }
            case 3505: {
                bl = map2IndexState.isEnabled();
                break;
            }
            case 3506: {
                bl = map2NormalState.isEnabled();
                break;
            }
            case 3507: {
                bl = map2TextureCoord1State.isEnabled();
                break;
            }
            case 3508: {
                bl = map2TextureCoord2State.isEnabled();
                break;
            }
            case 3509: {
                bl = map2TextureCoord3State.isEnabled();
                break;
            }
            case 3510: {
                bl = map2TextureCoord4State.isEnabled();
                break;
            }
            case 3511: {
                bl = map2Vertex3State.isEnabled();
                break;
            }
            case 3512: {
                bl = map2Vertex4State.isEnabled();
                break;
            }
            case 32925: {
                bl = multisampleState.isEnabled();
                break;
            }
            case 2977: {
                bl = normalizeState.isEnabled();
                break;
            }
            case 2832: {
                bl = pointSmoothState.isEnabled();
                break;
            }
            case 10753: {
                bl = polygonOffsetPointState.isEnabled();
                break;
            }
            case 10754: {
                bl = polygonOffsetLineState.isEnabled();
                break;
            }
            case 32823: {
                bl = polygonOffsetFillState.isEnabled();
                break;
            }
            case 2881: {
                bl = polygonSmoothState.isEnabled();
                break;
            }
            case 2882: {
                bl = polygonStippleState.isEnabled();
                break;
            }
            case 32826: {
                bl = rescaleNormalState.isEnabled();
                break;
            }
            case 32926: {
                bl = sampleAlphaToCoverageState.isEnabled();
                break;
            }
            case 32927: {
                bl = sampleAlphaToOneState.isEnabled();
                break;
            }
            case 32928: {
                bl = sampleCoverageState.isEnabled();
                break;
            }
            case 3089: {
                bl = scissorTest.isEnabled();
                break;
            }
            case 2960: {
                bl = stencilTest.isEnabled();
                break;
            }
            case 3552: {
                bl = textures.getTexture1DStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            case 3553: {
                bl = textures.getTextureUnitStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            case 32879: {
                bl = textures.getTexture3DStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            case 3168: {
                bl = textures.getTexGenSStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            case 3169: {
                bl = textures.getTexGenTStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            case 3170: {
                bl = textures.getTexGenRStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            case 3171: {
                bl = textures.getTexGenQStates(activeTextureUnit.getValue()).isEnabled();
                break;
            }
            default: {
                bl = GL11.glGetBoolean((int)pname);
            }
        }
        return bl;
    }

    public static void glGetBoolean(int pname, ByteBuffer params) {
        if (GLStateManager.shouldBypassCache()) {
            GL11.glGetBoolean((int)pname, (ByteBuffer)params);
            return;
        }
        switch (pname) {
            case 3107: {
                params.put((byte)(GLStateManager.colorMask.red ? 1 : 0));
                params.put((byte)(GLStateManager.colorMask.green ? 1 : 0));
                params.put((byte)(GLStateManager.colorMask.blue ? 1 : 0));
                params.put((byte)(GLStateManager.colorMask.alpha ? 1 : 0));
                break;
            }
            default: {
                if (!HAS_MULTIPLE_SET.contains(pname)) {
                    params.put(0, (byte)(GLStateManager.glGetBoolean(pname) ? 1 : 0));
                    break;
                }
                GL11.glGetBoolean((int)pname, (ByteBuffer)params);
            }
        }
    }

    public static int getMatrixStackDepth(Matrix4fStack stack) {
        return MAT4_STACK_CURR_DEPTH.invokeExact(stack);
    }

    public static int glGetInteger(int pname) {
        int n;
        if (GLStateManager.shouldBypassCache()) {
            return GL11.glGetInteger((int)pname);
        }
        switch (pname) {
            case 3009: {
                n = alphaState.getFunction();
                break;
            }
            case 2932: {
                n = depthState.getFunc();
                break;
            }
            case 2864: {
                n = glListMode;
                break;
            }
            case 2976: {
                n = matrixMode.getMode();
                break;
            }
            case 2900: {
                n = shadeModelState.getValue();
                break;
            }
            case 32873: {
                n = GLStateManager.getBoundTexture();
                break;
            }
            case 32970: {
                n = blendState.getDstAlpha();
                break;
            }
            case 32968: {
                n = blendState.getDstRgb();
                break;
            }
            case 32971: {
                n = blendState.getSrcAlpha();
                break;
            }
            case 32969: {
                n = blendState.getSrcRgb();
                break;
            }
            case 2901: {
                n = colorMaterialFace.getValue();
                break;
            }
            case 2902: {
                n = colorMaterialParameter.getValue();
                break;
            }
            case 35725: {
                n = activeProgram;
                break;
            }
            case 2979: {
                n = GLStateManager.getMatrixStackDepth(modelViewMatrix);
                break;
            }
            case 2980: {
                n = GLStateManager.getMatrixStackDepth(projectionMatrix);
                break;
            }
            default: {
                n = GL11.glGetInteger((int)pname);
            }
        }
        return n;
    }

    public static void glGetInteger(int pname, IntBuffer params) {
        if (GLStateManager.shouldBypassCache()) {
            GL11.glGetInteger((int)pname, (IntBuffer)params);
            return;
        }
        switch (pname) {
            case 2978: {
                viewportState.get(params);
                break;
            }
            default: {
                if (!HAS_MULTIPLE_SET.contains(pname)) {
                    params.put(0, GLStateManager.glGetInteger(pname));
                    break;
                }
                GL11.glGetInteger((int)pname, (IntBuffer)params);
            }
        }
    }

    public static void glGetMaterial(int face, int pname, FloatBuffer params) {
        MaterialStateStack state;
        if (GLStateManager.shouldBypassCache()) {
            GL11.glGetMaterial((int)face, (int)pname, (FloatBuffer)params);
            return;
        }
        if (face == 1028) {
            state = frontMaterial;
        } else if (face == 1029) {
            state = backMaterial;
        } else {
            throw new RuntimeException("Invalid face parameter specified to glGetMaterial: " + face);
        }
        switch (pname) {
            case 4608: {
                state.ambient.get(0, params);
                break;
            }
            case 4609: {
                state.diffuse.get(0, params);
                break;
            }
            case 4610: {
                state.specular.get(0, params);
                break;
            }
            case 5632: {
                state.emission.get(0, params);
                break;
            }
            case 5633: {
                params.put(state.shininess);
                break;
            }
            case 5635: {
                state.colorIndexes.get(0, params);
                break;
            }
            default: {
                GL11.glGetMaterial((int)face, (int)pname, (FloatBuffer)params);
            }
        }
    }

    public static void glGetLight(int light, int pname, FloatBuffer params) {
        if (GLStateManager.shouldBypassCache()) {
            GL11.glGetLight((int)light, (int)pname, (FloatBuffer)params);
            return;
        }
        LightStateStack state = lightDataStates[light - 16384];
        switch (pname) {
            case 4608: {
                state.ambient.get(0, params);
                break;
            }
            case 4609: {
                state.diffuse.get(0, params);
                break;
            }
            case 4610: {
                state.specular.get(0, params);
                break;
            }
            case 4611: {
                state.position.get(0, params);
                break;
            }
            case 4612: {
                state.spotDirection.get(0, params);
                break;
            }
            case 4613: {
                params.put(state.spotExponent);
                break;
            }
            case 4614: {
                params.put(state.spotCutoff);
                break;
            }
            case 4615: {
                params.put(state.constantAttenuation);
                break;
            }
            case 4616: {
                params.put(state.linearAttenuation);
                break;
            }
            case 4617: {
                params.put(state.quadraticAttenuation);
                break;
            }
            default: {
                GL11.glGetLight((int)light, (int)pname, (FloatBuffer)params);
            }
        }
    }

    public static void glGetFloat(int pname, FloatBuffer params) {
        if (GLStateManager.shouldBypassCache()) {
            GL11.glGetFloat((int)pname, (FloatBuffer)params);
            return;
        }
        switch (pname) {
            case 2982: {
                modelViewMatrix.get(0, params);
                break;
            }
            case 2983: {
                projectionMatrix.get(0, params);
                break;
            }
            case 3106: {
                clearColor.get(params);
                break;
            }
            case 2816: {
                color.get(params);
                break;
            }
            default: {
                if (!HAS_MULTIPLE_SET.contains(pname)) {
                    params.put(0, GLStateManager.glGetFloat(pname));
                    break;
                }
                GL11.glGetFloat((int)pname, (FloatBuffer)params);
            }
        }
    }

    public static float glGetFloat(int pname) {
        return GL11.glGetFloat((int)pname);
    }

    public static void glBlendColor(float red, float green, float blue, float alpha) {
        GL14.glBlendColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void enableBlend() {
        if (AngelicaConfig.enableIris && BlendModeStorage.isBlendLocked()) {
            BlendModeStorage.deferBlendModeToggle(true);
            return;
        }
        blendMode.enable();
    }

    public static void disableBlend() {
        if (AngelicaConfig.enableIris && BlendModeStorage.isBlendLocked()) {
            BlendModeStorage.deferBlendModeToggle(false);
            return;
        }
        blendMode.disable();
    }

    public static void enableScissorTest() {
        scissorTest.enable();
    }

    public static void disableScissorTest() {
        scissorTest.disable();
    }

    public static void glBlendFunc(int srcFactor, int dstFactor) {
        if (AngelicaConfig.enableIris && BlendModeStorage.isBlendLocked()) {
            BlendModeStorage.deferBlendFunc(srcFactor, dstFactor, srcFactor, dstFactor);
            return;
        }
        if (HUDCaching.renderingCacheOverride) {
            blendState.setSrcRgb(srcFactor);
            blendState.setDstRgb(dstFactor);
            blendState.setSrcAlpha(1);
            blendState.setDstAlpha(771);
            OpenGlHelper.func_148821_a((int)srcFactor, (int)dstFactor, (int)1, (int)771);
            return;
        }
        if (GLStateManager.shouldBypassCache() || blendState.getSrcRgb() != srcFactor || blendState.getDstRgb() != dstFactor) {
            blendState.setSrcRgb(srcFactor);
            blendState.setDstRgb(dstFactor);
            GL11.glBlendFunc((int)srcFactor, (int)dstFactor);
        }
        if (blendFuncListener != null) {
            blendFuncListener.run();
        }
    }

    public static void glBlendEquation(int mode) {
        GL14.glBlendEquation((int)mode);
    }

    public static void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        GL20.glBlendEquationSeparate((int)modeRGB, (int)modeAlpha);
    }

    public static void tryBlendFuncSeparate(int srcRgb, int dstRgb, int srcAlpha, int dstAlpha) {
        if (AngelicaConfig.enableIris && BlendModeStorage.isBlendLocked()) {
            BlendModeStorage.deferBlendFunc(srcRgb, dstRgb, srcAlpha, dstAlpha);
            return;
        }
        if (HUDCaching.renderingCacheOverride && dstAlpha != 771) {
            srcAlpha = 1;
            dstAlpha = 771;
        }
        if (GLStateManager.shouldBypassCache() || blendState.getSrcRgb() != srcRgb || blendState.getDstRgb() != dstRgb || blendState.getSrcAlpha() != srcAlpha || blendState.getDstAlpha() != dstAlpha) {
            blendState.setSrcRgb(srcRgb);
            blendState.setDstRgb(dstRgb);
            blendState.setSrcAlpha(srcAlpha);
            blendState.setDstAlpha(dstAlpha);
            OpenGlHelper.func_148821_a((int)srcRgb, (int)dstRgb, (int)srcAlpha, (int)dstAlpha);
        }
        if (blendFuncListener != null) {
            blendFuncListener.run();
        }
    }

    public static void glNormal3b(byte nx, byte ny, byte nz) {
        GL11.glNormal3b((byte)nx, (byte)ny, (byte)nz);
    }

    public static void glNormal3d(double nx, double ny, double nz) {
        GL11.glNormal3d((double)nx, (double)ny, (double)nz);
    }

    public static void glNormal3f(float nx, float ny, float nz) {
        GL11.glNormal3f((float)nx, (float)ny, (float)nz);
    }

    public static void glNormal3i(int nx, int ny, int nz) {
        GL11.glNormal3i((int)nx, (int)ny, (int)nz);
    }

    public static void glDepthFunc(int func) {
        if (GLStateManager.shouldBypassCache() || func != depthState.getFunc()) {
            depthState.setFunc(func);
            GL11.glDepthFunc((int)func);
        }
    }

    public static void glDepthMask(boolean mask) {
        if (AngelicaConfig.enableIris && DepthColorStorage.isDepthColorLocked()) {
            DepthColorStorage.deferDepthEnable(mask);
            return;
        }
        if (GLStateManager.shouldBypassCache() || mask != depthState.isEnabled()) {
            depthState.setEnabled(mask);
            GL11.glDepthMask((boolean)mask);
        }
    }

    public static void glEdgeFlag(boolean flag) {
        GL11.glEdgeFlag((boolean)flag);
    }

    public static void glColor4f(float red, float green, float blue, float alpha) {
        if (GLStateManager.changeColor(red, green, blue, alpha)) {
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    public static void glColor4d(double red, double green, double blue, double alpha) {
        if (GLStateManager.changeColor((float)red, (float)green, (float)blue, (float)alpha)) {
            GL11.glColor4d((double)red, (double)green, (double)blue, (double)alpha);
        }
    }

    public static void glColor4b(byte red, byte green, byte blue, byte alpha) {
        if (GLStateManager.changeColor(GLStateManager.b2f(red), GLStateManager.b2f(green), GLStateManager.b2f(blue), GLStateManager.b2f(alpha))) {
            GL11.glColor4b((byte)red, (byte)green, (byte)blue, (byte)alpha);
        }
    }

    public static void glColor4ub(byte red, byte green, byte blue, byte alpha) {
        if (GLStateManager.changeColor(GLStateManager.ub2f(red), GLStateManager.ub2f(green), GLStateManager.ub2f(blue), GLStateManager.ub2f(alpha))) {
            GL11.glColor4ub((byte)red, (byte)green, (byte)blue, (byte)alpha);
        }
    }

    public static void glColor3f(float red, float green, float blue) {
        if (GLStateManager.changeColor(red, green, blue, 1.0f)) {
            GL11.glColor3f((float)red, (float)green, (float)blue);
        }
    }

    public static void glColor3d(double red, double green, double blue) {
        if (GLStateManager.changeColor((float)red, (float)green, (float)blue, 1.0f)) {
            GL11.glColor3d((double)red, (double)green, (double)blue);
        }
    }

    public static void glColor3b(byte red, byte green, byte blue) {
        if (GLStateManager.changeColor(GLStateManager.b2f(red), GLStateManager.b2f(green), GLStateManager.b2f(blue), 1.0f)) {
            GL11.glColor3b((byte)red, (byte)green, (byte)blue);
        }
    }

    public static void glColor3ub(byte red, byte green, byte blue) {
        if (GLStateManager.changeColor(GLStateManager.ub2f(red), GLStateManager.ub2f(green), GLStateManager.ub2f(blue), 1.0f)) {
            GL11.glColor3ub((byte)red, (byte)green, (byte)blue);
        }
    }

    private static float ub2f(byte b) {
        return (float)(b & 0xFF) / 255.0f;
    }

    private static float b2f(byte b) {
        return (float)(b - -128 & 0xFF) / 255.0f;
    }

    public static float i2f(int i) {
        return (float)(i - Integer.MIN_VALUE & 0xFFFFFF) / 4.2949673E9f;
    }

    private static boolean changeColor(float red, float green, float blue, float alpha) {
        if (GLStateManager.shouldBypassCache() || red != color.getRed() || green != color.getGreen() || blue != color.getBlue() || alpha != color.getAlpha()) {
            color.setRed(red);
            color.setGreen(green);
            color.setBlue(blue);
            color.setAlpha(alpha);
            return true;
        }
        return false;
    }

    public static void clearCurrentColor() {
        color.set(DirtyColor);
    }

    public static void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        if (AngelicaConfig.enableIris && DepthColorStorage.isDepthColorLocked()) {
            DepthColorStorage.deferColorMask(red, green, blue, alpha);
            return;
        }
        if (GLStateManager.shouldBypassCache() || red != GLStateManager.colorMask.red || green != GLStateManager.colorMask.green || blue != GLStateManager.colorMask.blue || alpha != GLStateManager.colorMask.alpha) {
            GLStateManager.colorMask.red = red;
            GLStateManager.colorMask.green = green;
            GLStateManager.colorMask.blue = blue;
            GLStateManager.colorMask.alpha = alpha;
            GL11.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
        }
    }

    public static void glClearColor(float red, float green, float blue, float alpha) {
        if (GLStateManager.shouldBypassCache() || red != clearColor.getRed() || green != clearColor.getGreen() || blue != clearColor.getBlue() || alpha != clearColor.getAlpha()) {
            clearColor.setRed(red);
            clearColor.setGreen(green);
            clearColor.setBlue(blue);
            clearColor.setAlpha(alpha);
            GL11.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    public static void glClearDepth(double depth) {
        GL11.glClearDepth((double)depth);
    }

    public static void enableAlphaTest() {
        if (AngelicaConfig.enableIris && AlphaTestStorage.isAlphaTestLocked()) {
            AlphaTestStorage.deferAlphaTestToggle(true);
            return;
        }
        alphaTest.enable();
    }

    public static void disableAlphaTest() {
        if (AngelicaConfig.enableIris && AlphaTestStorage.isAlphaTestLocked()) {
            AlphaTestStorage.deferAlphaTestToggle(false);
            return;
        }
        alphaTest.disable();
    }

    public static void glAlphaFunc(int function, float reference) {
        if (AngelicaConfig.enableIris && AlphaTestStorage.isAlphaTestLocked()) {
            AlphaTestStorage.deferAlphaFunc(function, reference);
            return;
        }
        alphaState.setFunction(function);
        alphaState.setReference(reference);
        GL11.glAlphaFunc((int)function, (float)reference);
    }

    public static void glActiveTexture(int texture) {
        int newTexture = texture - 33984;
        if (GLStateManager.shouldBypassCache() || GLStateManager.getActiveTextureUnit() != newTexture) {
            activeTextureUnit.setValue(newTexture);
            GL13.glActiveTexture((int)texture);
        }
    }

    public static void glActiveTextureARB(int texture) {
        int newTexture = texture - 33984;
        if (GLStateManager.shouldBypassCache() || GLStateManager.getActiveTextureUnit() != newTexture) {
            activeTextureUnit.setValue(newTexture);
            ARBMultitexture.glActiveTextureARB((int)texture);
        }
    }

    public static int getBoundTexture() {
        return GLStateManager.getBoundTexture(activeTextureUnit.getValue());
    }

    public static int getBoundTexture(int unit) {
        return textures.getTextureUnitBindings(unit).getBinding();
    }

    public static void glBindTexture(int target, int texture) {
        if (target != 3553) {
            GL11.glBindTexture((int)target, (int)texture);
            return;
        }
        TextureBindingStack textureUnit = textures.getTextureUnitBindings(activeTextureUnit.getValue());
        if (GLStateManager.shouldBypassCache() || textureUnit.getBinding() != texture) {
            GL11.glBindTexture((int)target, (int)texture);
            textureUnit.setBinding(texture);
            TextureTracker.INSTANCE.onBindTexture(texture);
        }
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        TextureInfoCache.INSTANCE.onTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
        GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, FloatBuffer pixels) {
        TextureInfoCache.INSTANCE.onTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
        GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (FloatBuffer)pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, DoubleBuffer pixels) {
        TextureInfoCache.INSTANCE.onTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
        GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (DoubleBuffer)pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        TextureInfoCache.INSTANCE.onTexImage2D(target, level, internalformat, width, height, border, format, type, pixels != null ? pixels.asIntBuffer() : (IntBuffer)null);
        GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels_buffer_offset) {
        TextureInfoCache.INSTANCE.onTexImage2D(target, level, internalformat, width, height, border, format, type, pixels_buffer_offset);
        GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (long)pixels_buffer_offset);
    }

    public static void glTexCoord1f(float s) {
        GL11.glTexCoord1f((float)s);
    }

    public static void glTexCoord1d(double s) {
        GL11.glTexCoord1d((double)s);
    }

    public static void glTexCoord2f(float s, float t) {
        GL11.glTexCoord2f((float)s, (float)t);
    }

    public static void glTexCoord2d(double s, double t) {
        GL11.glTexCoord2d((double)s, (double)t);
    }

    public static void glTexCoord3f(float s, float t, float r) {
        GL11.glTexCoord3f((float)s, (float)t, (float)r);
    }

    public static void glTexCoord3d(double s, double t, double r) {
        GL11.glTexCoord3d((double)s, (double)t, (double)r);
    }

    public static void glTexCoord4f(float s, float t, float r, float q) {
        GL11.glTexCoord4f((float)s, (float)t, (float)r, (float)q);
    }

    public static void glTexCoord4d(double s, double t, double r, double q) {
        GL11.glTexCoord4d((double)s, (double)t, (double)r, (double)q);
    }

    public static void glDeleteTextures(int id) {
        GLStateManager.onDeleteTexture(id);
        GL11.glDeleteTextures((int)id);
    }

    public static void glDeleteTextures(IntBuffer ids) {
        for (int i = 0; i < ids.remaining(); ++i) {
            GLStateManager.onDeleteTexture(ids.get(i));
        }
        GL11.glDeleteTextures((IntBuffer)ids);
    }

    public static void enableTexture() {
        int textureUnit = GLStateManager.getActiveTextureUnit();
        if (AngelicaConfig.enableIris) {
            boolean updatePipeline = false;
            if (textureUnit == 0) {
                StateTracker.INSTANCE.albedoSampler = true;
                updatePipeline = true;
            } else if (textureUnit == 1) {
                StateTracker.INSTANCE.lightmapSampler = true;
                updatePipeline = true;
            }
            if (updatePipeline) {
                Iris.getPipelineManager().getPipeline().ifPresent(p -> p.setInputs(StateTracker.INSTANCE.getInputs()));
            }
        }
        textures.getTextureUnitStates(textureUnit).enable();
    }

    public static void disableTexture() {
        int textureUnit = GLStateManager.getActiveTextureUnit();
        if (AngelicaConfig.enableIris) {
            boolean updatePipeline = false;
            if (textureUnit == 0) {
                StateTracker.INSTANCE.albedoSampler = false;
                updatePipeline = true;
            } else if (textureUnit == 1) {
                StateTracker.INSTANCE.lightmapSampler = false;
                updatePipeline = true;
            }
            if (updatePipeline) {
                Iris.getPipelineManager().getPipeline().ifPresent(p -> p.setInputs(StateTracker.INSTANCE.getInputs()));
            }
        }
        textures.getTextureUnitStates(textureUnit).disable();
    }

    public static void glRasterPos2f(float x, float y) {
        GL11.glRasterPos2f((float)x, (float)y);
    }

    public static void glRasterPos2d(double x, double y) {
        GL11.glRasterPos2d((double)x, (double)y);
    }

    public static void glRasterPos2i(int x, int y) {
        GL11.glRasterPos2i((int)x, (int)y);
    }

    public static void glRasterPos3f(float x, float y, float z) {
        GL11.glRasterPos3f((float)x, (float)y, (float)z);
    }

    public static void glRasterPos3d(double x, double y, double z) {
        GL11.glRasterPos3d((double)x, (double)y, (double)z);
    }

    public static void glRasterPos3i(int x, int y, int z) {
        GL11.glRasterPos3i((int)x, (int)y, (int)z);
    }

    public static void glRasterPos4f(float x, float y, float z, float w) {
        GL11.glRasterPos4f((float)x, (float)y, (float)z, (float)w);
    }

    public static void glRasterPos4d(double x, double y, double z, double w) {
        GL11.glRasterPos4d((double)x, (double)y, (double)z, (double)w);
    }

    public static void glRasterPos4i(int x, int y, int z, int w) {
        GL11.glRasterPos4i((int)x, (int)y, (int)z, (int)w);
    }

    public static void setFilter(boolean bilinear, boolean mipmap) {
        int j;
        int i;
        if (bilinear) {
            i = mipmap ? 9987 : 9729;
            j = 9729;
        } else {
            i = mipmap ? 9987 : 9728;
            j = 9728;
        }
        GLStateManager.glTexParameteri(3553, 10241, i);
        GLStateManager.glTexParameteri(3553, 10240, j);
    }

    public static void trySyncProgram() {
        if (AngelicaConfig.enableIris) {
            Iris.getPipelineManager().getPipeline().ifPresent(WorldRenderingPipeline::syncProgram);
        }
    }

    public static void glBegin(int mode) {
        GLStateManager.trySyncProgram();
        GL11.glBegin((int)mode);
    }

    public static void glDrawElements(int mode, ByteBuffer indices) {
        GLStateManager.trySyncProgram();
        GL11.glDrawElements((int)mode, (ByteBuffer)indices);
    }

    public static void glDrawElements(int mode, IntBuffer indices) {
        GLStateManager.trySyncProgram();
        GL11.glDrawElements((int)mode, (IntBuffer)indices);
    }

    public static void glDrawElements(int mode, ShortBuffer indices) {
        GLStateManager.trySyncProgram();
        GL11.glDrawElements((int)mode, (ShortBuffer)indices);
    }

    public static void glDrawElements(int mode, int indices_count, int type, long indices_buffer_offset) {
        GLStateManager.trySyncProgram();
        GL11.glDrawElements((int)mode, (int)indices_count, (int)type, (long)indices_buffer_offset);
    }

    public static void glDrawElements(int mode, int count, int type, ByteBuffer indices) {
        GLStateManager.trySyncProgram();
        GL11.glDrawElements((int)mode, (int)count, (int)type, (ByteBuffer)indices);
    }

    public static void glDrawBuffer(int mode) {
        GLStateManager.trySyncProgram();
        GL11.glDrawBuffer((int)mode);
    }

    public static void glDrawArrays(int mode, int first, int count) {
        GLStateManager.trySyncProgram();
        GL11.glDrawArrays((int)mode, (int)first, (int)count);
    }

    public static void glLogicOp(int opcode) {
        GL11.glLogicOp((int)opcode);
    }

    public static void defaultBlendFunc() {
        GLStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
    }

    public static void enableCull() {
        cullState.enable();
    }

    public static void disableCull() {
        cullState.disable();
    }

    public static void enableDepthTest() {
        depthTest.enable();
    }

    public static void disableDepthTest() {
        depthTest.disable();
    }

    public static void enableLighting() {
        lightingState.enable();
    }

    public static void enableLight(int light) {
        lightStates[light].enable();
    }

    public static void enableColorMaterial() {
        colorMaterial.enable();
        float r = GLStateManager.getColor().getRed();
        float g = GLStateManager.getColor().getGreen();
        float b = GLStateManager.getColor().getBlue();
        float a = GLStateManager.getColor().getAlpha();
        if (colorMaterialFace.getValue() == 1028 || colorMaterialFace.getValue() == 1032) {
            switch (colorMaterialParameter.getValue()) {
                case 5634: {
                    GLStateManager.frontMaterial.ambient.set(r, g, b, a);
                    GLStateManager.frontMaterial.diffuse.set(r, g, b, a);
                    break;
                }
                case 4608: {
                    GLStateManager.frontMaterial.ambient.set(r, g, b, a);
                    break;
                }
                case 4609: {
                    GLStateManager.frontMaterial.diffuse.set(r, g, b, a);
                    break;
                }
                case 4610: {
                    GLStateManager.frontMaterial.specular.set(r, g, b, a);
                    break;
                }
                case 5632: {
                    GLStateManager.frontMaterial.emission.set(r, g, b, a);
                }
            }
        }
        if (colorMaterialFace.getValue() == 1029 || colorMaterialFace.getValue() == 1032) {
            switch (colorMaterialParameter.getValue()) {
                case 5634: {
                    GLStateManager.backMaterial.ambient.set(r, g, b, a);
                    GLStateManager.backMaterial.diffuse.set(r, g, b, a);
                    break;
                }
                case 4608: {
                    GLStateManager.backMaterial.ambient.set(r, g, b, a);
                    break;
                }
                case 4609: {
                    GLStateManager.backMaterial.diffuse.set(r, g, b, a);
                    break;
                }
                case 4610: {
                    GLStateManager.backMaterial.specular.set(r, g, b, a);
                    break;
                }
                case 5632: {
                    GLStateManager.backMaterial.emission.set(r, g, b, a);
                }
            }
        }
    }

    public static void disableColorMaterial() {
        colorMaterial.disable();
    }

    public static void disableLighting() {
        lightingState.disable();
    }

    public static void disableLight(int light) {
        lightStates[light].disable();
    }

    public static void enableRescaleNormal() {
        rescaleNormalState.enable();
    }

    public static void disableRescaleNormal() {
        rescaleNormalState.disable();
    }

    public static void enableFog() {
        fogMode.enable();
        if (fogToggleListener != null) {
            fogToggleListener.run();
        }
    }

    public static void disableFog() {
        fogMode.disable();
        if (fogToggleListener != null) {
            fogToggleListener.run();
        }
    }

    public static void glFog(int pname, FloatBuffer param) {
        if (HAS_MULTIPLE_SET.contains(pname)) {
            GL11.glFog((int)pname, (FloatBuffer)param);
            if (pname == 2918) {
                float red = param.get(0);
                float green = param.get(1);
                float blue = param.get(2);
                fogState.getFogColor().set((double)red, (double)green, (double)blue);
                fogState.setFogAlpha(param.get(3));
                fogState.getFogColorBuffer().clear();
                fogState.getFogColorBuffer().put((FloatBuffer)param.position(0)).flip();
            }
        } else {
            GLStateManager.glFogf(pname, param.get(0));
        }
    }

    public static Vector3d getFogColor() {
        return fogState.getFogColor();
    }

    public static void fogColor(float red, float green, float blue, float alpha) {
        if (GLStateManager.shouldBypassCache() || (double)red != GLStateManager.fogState.getFogColor().x || (double)green != GLStateManager.fogState.getFogColor().y || (double)blue != GLStateManager.fogState.getFogColor().z || alpha != fogState.getFogAlpha()) {
            fogState.getFogColor().set((double)red, (double)green, (double)blue);
            fogState.setFogAlpha(alpha);
            fogState.getFogColorBuffer().clear();
            fogState.getFogColorBuffer().put(red).put(green).put(blue).put(alpha).flip();
            GL11.glFog((int)2918, (FloatBuffer)fogState.getFogColorBuffer());
        }
    }

    public static void glFogf(int pname, float param) {
        GL11.glFogf((int)pname, (float)param);
        switch (pname) {
            case 2914: {
                fogState.setDensity(param);
                if (fogDensityListener == null) break;
                fogDensityListener.run();
                break;
            }
            case 2915: {
                fogState.setStart(param);
                if (fogStartListener == null) break;
                fogStartListener.run();
                break;
            }
            case 2916: {
                fogState.setEnd(param);
                if (fogEndListener == null) break;
                fogEndListener.run();
            }
        }
    }

    public static void glFogi(int pname, int param) {
        GL11.glFogi((int)pname, (int)param);
        if (pname == 2917) {
            fogState.setFogMode(param);
            if (fogModeListener != null) {
                fogModeListener.run();
            }
        }
    }

    public static void setFogBlack() {
        GLStateManager.glFogf(2918, 0.0f);
    }

    public static void glShadeModel(int mode) {
        if (GLStateManager.shouldBypassCache() || shadeModelState.getValue() != mode) {
            shadeModelState.setValue(mode);
            GL11.glShadeModel((int)mode);
        }
    }

    private static void onDeleteTexture(int id) {
        TextureTracker.INSTANCE.onDeleteTexture(id);
        TextureInfoCache.INSTANCE.onDeleteTexture(id);
        if (AngelicaConfig.enableIris) {
            PBRTextureManager.INSTANCE.onDeleteTexture(id);
        }
        for (int i = 0; i < MAX_TEXTURE_UNITS; ++i) {
            if (textures.getTextureUnitBindings(i).getBinding() != id) continue;
            textures.getTextureUnitBindings(i).setBinding(0);
        }
    }

    public static void makeCurrent(Drawable drawable) throws LWJGLException {
        Thread currentThread;
        drawable.makeCurrent();
        CurrentThread = currentThread = Thread.currentThread();
        AngelicaTweaker.LOGGER.info("Current thread: {}", new Object[]{currentThread.getName()});
    }

    public static void glNewList(int list, int mode) {
        if (glListMode > 0) {
            ++glListNesting;
            return;
        }
        glListId = list;
        glListMode = mode;
        GL11.glNewList((int)list, (int)mode);
        List<IStateStack<?>> stacks = Feature.maskToFeatures(1048575);
        int size = stacks.size();
        for (int i = 0; i < size; ++i) {
            IStateStack<?> stack = stacks.get(i);
            glListStates.put(stack, (ISettableState)((ISettableState)stack).copy());
        }
        if (glListMode == 4864) {
            GLStateManager.pushState(1048575);
        }
        color.setRed(-1.0f);
        color.setGreen(-1.0f);
        color.setBlue(-1.0f);
        textures.getTextureUnitBindings(GLStateManager.getActiveTextureUnit()).setBinding(-1);
    }

    public static void glEndList() {
        if (glListNesting > 0) {
            --glListNesting;
            return;
        }
        if (glListMode == 0) {
            throw new RuntimeException("glEndList called outside of a display list!");
        }
        ObjectArraySet changedStates = new ObjectArraySet();
        for (Map.Entry<IStateStack<?>, ISettableState<?>> entry : glListStates.entrySet()) {
            if (((ISettableState)entry.getKey()).sameAs(entry.getValue()) || entry.getKey() instanceof TextureBinding || entry.getKey() instanceof Color4) continue;
            changedStates.add(new AbstractMap.SimpleEntry(entry.getKey(), (ISettableState)((ISettableState)entry.getKey()).copy()));
        }
        TextureBindingStack activeBinding = textures.getTextureUnitBindings(GLStateManager.getActiveTextureUnit());
        if (activeBinding.getBinding() != -1) {
            changedStates.add(new AbstractMap.SimpleEntry<TextureBindingStack, TextureBinding>(activeBinding, activeBinding.copy()));
        } else {
            activeBinding.set(glListStates.get(activeBinding));
        }
        if (color.getRed() != -1.0f || color.getGreen() != -1.0f || color.getBlue() != -1.0f) {
            changedStates.add(new AbstractMap.SimpleEntry<Color4Stack, Color4>(color, color.copy()));
        } else {
            color.set(glListStates.get(color));
        }
        if (!changedStates.isEmpty()) {
            glListChanges.put(glListId, (Object)changedStates);
        }
        if (glListMode == 4864) {
            GLStateManager.popState();
        }
        glListId = -1;
        glListStates.clear();
        glListMode = 0;
        GL11.glEndList();
    }

    public static void glCallList(int list) {
        if (list < 0) {
            VBOManager.get((int)list).render();
        } else {
            GLStateManager.trySyncProgram();
            GL11.glCallList((int)list);
            Set changes = (Set)glListChanges.get(list);
            if (changes != null) {
                for (Map.Entry entry : changes) {
                    ((ISettableState)entry.getKey()).set((ISettableState)entry.getValue());
                }
            }
        }
    }

    public static void pushState(int mask) {
        attribs.push(mask);
        List<IStateStack<?>> stacks = Feature.maskToFeatures(mask);
        int size = stacks.size();
        for (int i = 0; i < size; ++i) {
            stacks.get(i).push();
        }
    }

    public static void popState() {
        int mask = attribs.popInt();
        List<IStateStack<?>> stacks = Feature.maskToFeatures(mask);
        int size = stacks.size();
        for (int i = 0; i < size; ++i) {
            stacks.get(i).pop();
        }
    }

    public static void glClear(int mask) {
        GL11.glClear((int)mask);
    }

    public static void glPushAttrib(int mask) {
        GLStateManager.pushState(mask);
        GL11.glPushAttrib((int)mask);
    }

    public static void glPopAttrib() {
        poppingAttributes = true;
        GLStateManager.popState();
        GL11.glPopAttrib();
        poppingAttributes = false;
    }

    public static void glMatrixMode(int mode) {
        matrixMode.setMode(mode);
    }

    public static void glLoadMatrix(FloatBuffer m) {
        GLStateManager.getMatrixStack().set(m);
        GL11.glLoadMatrix((FloatBuffer)m);
    }

    public static void glLoadMatrix(DoubleBuffer m) {
        conversionMatrix4d.set(m);
        GLStateManager.getMatrixStack().set((Matrix4dc)conversionMatrix4d);
        GL11.glLoadMatrix((DoubleBuffer)m);
    }

    public static Matrix4fStack getMatrixStack() {
        switch (matrixMode.getMode()) {
            case 5888: {
                return modelViewMatrix;
            }
            case 5889: {
                return projectionMatrix;
            }
            case 5890: {
                return textures.getTextureUnitMatrix(GLStateManager.getActiveTextureUnit());
            }
        }
        throw new IllegalStateException("Unknown matrix mode: " + matrixMode.getMode());
    }

    public static void glLoadIdentity() {
        GL11.glLoadIdentity();
        GLStateManager.getMatrixStack().identity();
    }

    public static void glTranslatef(float x, float y, float z) {
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GLStateManager.getMatrixStack().translate(x, y, z);
    }

    public static void glTranslated(double x, double y, double z) {
        GL11.glTranslated((double)x, (double)y, (double)z);
        GLStateManager.getMatrixStack().translate((float)x, (float)y, (float)z);
    }

    public static void glScalef(float x, float y, float z) {
        GL11.glScalef((float)x, (float)y, (float)z);
        GLStateManager.getMatrixStack().scale(x, y, z);
    }

    public static void glScaled(double x, double y, double z) {
        GL11.glScaled((double)x, (double)y, (double)z);
        GLStateManager.getMatrixStack().scale((float)x, (float)y, (float)z);
    }

    public static void glMultMatrix(FloatBuffer floatBuffer) {
        GL11.glMultMatrix((FloatBuffer)floatBuffer);
        tempMatrix4f.set(floatBuffer);
        GLStateManager.getMatrixStack().mul((Matrix4fc)tempMatrix4f);
    }

    public static void glMultMatrix(DoubleBuffer matrix) {
        GL11.glMultMatrix((DoubleBuffer)matrix);
        conversionMatrix4d.set(matrix);
        conversionMatrix4f.set((Matrix4dc)conversionMatrix4d);
        GLStateManager.getMatrixStack().mul((Matrix4fc)conversionMatrix4f);
    }

    public static void glRotatef(float angle, float x, float y, float z) {
        GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
        rotation.set(x, y, z).normalize();
        GLStateManager.getMatrixStack().rotate((float)Math.toRadians(angle), (Vector3fc)rotation);
    }

    public static void glRotated(double angle, double x, double y, double z) {
        GL11.glRotated((double)angle, (double)x, (double)y, (double)z);
        rotation.set(x, y, z).normalize();
        GLStateManager.getMatrixStack().rotate((float)Math.toRadians(angle), (Vector3fc)rotation);
    }

    public static void glOrtho(double left, double right, double bottom, double top, double zNear, double zFar) {
        GL11.glOrtho((double)left, (double)right, (double)bottom, (double)top, (double)zNear, (double)zFar);
        GLStateManager.getMatrixStack().ortho((float)left, (float)right, (float)bottom, (float)top, (float)zNear, (float)zFar);
    }

    public static void glFrustum(double left, double right, double bottom, double top, double zNear, double zFar) {
        GL11.glFrustum((double)left, (double)right, (double)bottom, (double)top, (double)zNear, (double)zFar);
        GLStateManager.getMatrixStack().frustum((float)left, (float)right, (float)bottom, (float)top, (float)zNear, (float)zFar);
    }

    public static void glPushMatrix() {
        block2: {
            GL11.glPushMatrix();
            try {
                GLStateManager.getMatrixStack().pushMatrix();
            }
            catch (IllegalStateException ignored) {
                if (!AngelicaMod.lwjglDebug) break block2;
                AngelicaTweaker.LOGGER.warn("Matrix stack overflow ", new Throwable());
            }
        }
    }

    public static void glPopMatrix() {
        block2: {
            GL11.glPopMatrix();
            try {
                GLStateManager.getMatrixStack().popMatrix();
            }
            catch (IllegalStateException ignored) {
                if (!AngelicaMod.lwjglDebug) break block2;
                AngelicaTweaker.LOGGER.warn("Matrix stack underflow ", new Throwable());
            }
        }
    }

    public static void gluPerspective(float fovy, float aspect, float zNear, float zFar) {
        perspectiveMatrix.identity().perspective((float)Math.toRadians(fovy), aspect, zNear, zFar);
        perspectiveMatrix.get(0, perspectiveBuffer);
        GL11.glMultMatrix((FloatBuffer)perspectiveBuffer);
        GLStateManager.getMatrixStack().mul((Matrix4fc)perspectiveMatrix);
    }

    public static void glViewport(int x, int y, int width, int height) {
        GL11.glViewport((int)x, (int)y, (int)width, (int)height);
        viewportState.setViewPort(x, y, width, height);
    }

    public static int getActiveTextureUnit() {
        return activeTextureUnit.getValue();
    }

    public static int getListMode() {
        return glListMode;
    }

    public static boolean updateTexParameteriCache(int target, int texture, int pname, int param) {
        if (target != 3553) {
            return true;
        }
        TextureInfo info = TextureInfoCache.INSTANCE.getInfo(texture);
        if (info == null) {
            return true;
        }
        switch (pname) {
            case 10241: {
                if (info.getMinFilter() == param && !GLStateManager.shouldBypassCache()) {
                    return false;
                }
                info.setMinFilter(param);
                break;
            }
            case 10240: {
                if (info.getMagFilter() == param && !GLStateManager.shouldBypassCache()) {
                    return false;
                }
                info.setMagFilter(param);
                break;
            }
            case 10242: {
                if (info.getWrapS() == param && !GLStateManager.shouldBypassCache()) {
                    return false;
                }
                info.setWrapS(param);
                break;
            }
            case 10243: {
                if (info.getWrapT() == param && !GLStateManager.shouldBypassCache()) {
                    return false;
                }
                info.setWrapT(param);
                break;
            }
            case 33085: {
                if (info.getMaxLevel() == param && !GLStateManager.shouldBypassCache()) {
                    return false;
                }
                info.setMaxLevel(param);
                break;
            }
            case 33082: {
                if (info.getMinLod() == param && !GLStateManager.shouldBypassCache()) {
                    return false;
                }
                info.setMinLod(param);
                break;
            }
            case 33083: {
                if (info.getMaxLod() == param && !GLStateManager.shouldBypassCache()) {
                    return false;
                }
                info.setMaxLod(param);
            }
        }
        return true;
    }

    public static void glTexParameter(int target, int pname, IntBuffer params) {
        if (target != 3553 || params.remaining() != 1) {
            GL11.glTexParameter((int)target, (int)pname, (IntBuffer)params);
            return;
        }
        if (!GLStateManager.updateTexParameteriCache(target, GLStateManager.getBoundTexture(), pname, params.get(0))) {
            return;
        }
        GL11.glTexParameter((int)target, (int)pname, (IntBuffer)params);
    }

    public static void glTexParameter(int target, int pname, FloatBuffer params) {
        if (target != 3553 || params.remaining() != 1) {
            GL11.glTexParameter((int)target, (int)pname, (FloatBuffer)params);
            return;
        }
        if (!GLStateManager.updateTexParameterfCache(target, GLStateManager.getBoundTexture(), pname, params.get(0))) {
            return;
        }
        GL11.glTexParameter((int)target, (int)pname, (FloatBuffer)params);
    }

    public static void glTexParameteri(int target, int pname, int param) {
        if (target != 3553) {
            GL11.glTexParameteri((int)target, (int)pname, (int)param);
            return;
        }
        if (!GLStateManager.updateTexParameteriCache(target, GLStateManager.getBoundTexture(), pname, param)) {
            return;
        }
        GL11.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public static boolean updateTexParameterfCache(int target, int texture, int pname, float param) {
        if (target != 3553) {
            return true;
        }
        TextureInfo info = TextureInfoCache.INSTANCE.getInfo(texture);
        if (info == null) {
            return true;
        }
        switch (pname) {
            case 34046: {
                if (info.getMaxAnisotropy() == param && !GLStateManager.shouldBypassCache()) {
                    return false;
                }
                info.setMaxAnisotropy(param);
                break;
            }
            case 34049: {
                if (info.getLodBias() == param && !GLStateManager.shouldBypassCache()) {
                    return false;
                }
                info.setLodBias(param);
            }
        }
        return true;
    }

    public static void glTexParameterf(int target, int pname, float param) {
        if (target != 3553) {
            GL11.glTexParameterf((int)target, (int)pname, (float)param);
            return;
        }
        if (!GLStateManager.updateTexParameterfCache(GLStateManager.getActiveTextureUnit(), target, pname, param)) {
            return;
        }
        GL11.glTexParameterf((int)target, (int)pname, (float)param);
    }

    public static int getTexParameterOrDefault(int texture, int pname, IntSupplier defaultSupplier) {
        int n;
        TextureInfo info = TextureInfoCache.INSTANCE.getInfo(texture);
        if (info == null) {
            return defaultSupplier.getAsInt();
        }
        switch (pname) {
            case 10241: {
                n = info.getMinFilter();
                break;
            }
            case 10240: {
                n = info.getMagFilter();
                break;
            }
            case 10242: {
                n = info.getWrapS();
                break;
            }
            case 10243: {
                n = info.getWrapT();
                break;
            }
            case 33085: {
                n = info.getMaxLevel();
                break;
            }
            case 33082: {
                n = info.getMinLod();
                break;
            }
            case 33083: {
                n = info.getMaxLod();
                break;
            }
            default: {
                n = defaultSupplier.getAsInt();
            }
        }
        return n;
    }

    public static int glGetTexParameteri(int target, int pname) {
        if (target != 3553 || GLStateManager.shouldBypassCache()) {
            return GL11.glGetTexParameteri((int)target, (int)pname);
        }
        return GLStateManager.getTexParameterOrDefault(GLStateManager.getBoundTexture(), pname, () -> GL11.glGetTexParameteri((int)target, (int)pname));
    }

    public static float glGetTexParameterf(int target, int pname) {
        float f;
        if (target != 3553 || GLStateManager.shouldBypassCache()) {
            return GL11.glGetTexParameterf((int)target, (int)pname);
        }
        TextureInfo info = TextureInfoCache.INSTANCE.getInfo(GLStateManager.getBoundTexture());
        if (info == null) {
            return GL11.glGetTexParameterf((int)target, (int)pname);
        }
        switch (pname) {
            case 34046: {
                f = info.getMaxAnisotropy();
                break;
            }
            case 34049: {
                f = info.getLodBias();
                break;
            }
            default: {
                f = GL11.glGetTexParameterf((int)target, (int)pname);
            }
        }
        return f;
    }

    public static int glGetTexLevelParameteri(int target, int level, int pname) {
        int n;
        if (target != 3553 || GLStateManager.shouldBypassCache()) {
            return GL11.glGetTexLevelParameteri((int)target, (int)level, (int)pname);
        }
        TextureInfo info = TextureInfoCache.INSTANCE.getInfo(GLStateManager.getBoundTexture());
        if (info == null) {
            return GL11.glGetTexLevelParameteri((int)target, (int)level, (int)pname);
        }
        switch (pname) {
            case 4096: {
                n = info.getWidth();
                break;
            }
            case 4097: {
                n = info.getHeight();
                break;
            }
            case 4099: {
                n = info.getInternalFormat();
                break;
            }
            default: {
                n = GL11.glGetTexLevelParameteri((int)target, (int)level, (int)pname);
            }
        }
        return n;
    }

    private static void glMaterialFront(int pname, FloatBuffer params) {
        switch (pname) {
            case 4608: {
                frontMaterial.setAmbient(params);
                break;
            }
            case 4609: {
                frontMaterial.setDiffuse(params);
                break;
            }
            case 4610: {
                frontMaterial.setSpecular(params);
                break;
            }
            case 5632: {
                frontMaterial.setEmission(params);
                break;
            }
            case 5633: {
                frontMaterial.setShininess(params);
                break;
            }
            case 5634: {
                frontMaterial.setAmbient(params);
                frontMaterial.setDiffuse(params);
                break;
            }
            case 5635: {
                frontMaterial.setColorIndexes(params);
            }
        }
    }

    private static void glMaterialBack(int pname, FloatBuffer params) {
        switch (pname) {
            case 4608: {
                backMaterial.setAmbient(params);
                break;
            }
            case 4609: {
                backMaterial.setDiffuse(params);
                break;
            }
            case 4610: {
                backMaterial.setSpecular(params);
                break;
            }
            case 5632: {
                backMaterial.setEmission(params);
                break;
            }
            case 5633: {
                backMaterial.setShininess(params);
                break;
            }
            case 5634: {
                backMaterial.setAmbient(params);
                backMaterial.setDiffuse(params);
                break;
            }
            case 5635: {
                backMaterial.setColorIndexes(params);
            }
        }
    }

    private static void glMaterialFront(int pname, IntBuffer params) {
        switch (pname) {
            case 4608: {
                frontMaterial.setAmbient(params);
                break;
            }
            case 4609: {
                frontMaterial.setDiffuse(params);
                break;
            }
            case 4610: {
                frontMaterial.setSpecular(params);
                break;
            }
            case 5632: {
                frontMaterial.setEmission(params);
                break;
            }
            case 5633: {
                frontMaterial.setShininess(params);
                break;
            }
            case 5634: {
                frontMaterial.setAmbient(params);
                frontMaterial.setDiffuse(params);
                break;
            }
            case 5635: {
                frontMaterial.setColorIndexes(params);
            }
        }
    }

    private static void glMaterialBack(int pname, IntBuffer params) {
        switch (pname) {
            case 4608: {
                backMaterial.setAmbient(params);
                break;
            }
            case 4609: {
                backMaterial.setDiffuse(params);
                break;
            }
            case 4610: {
                backMaterial.setSpecular(params);
                break;
            }
            case 5632: {
                backMaterial.setEmission(params);
                break;
            }
            case 5633: {
                backMaterial.setShininess(params);
                break;
            }
            case 5634: {
                backMaterial.setAmbient(params);
                backMaterial.setDiffuse(params);
                break;
            }
            case 5635: {
                backMaterial.setColorIndexes(params);
            }
        }
    }

    public static void glMaterial(int face, int pname, FloatBuffer params) {
        if (face == 1028) {
            GLStateManager.glMaterialFront(pname, params);
        } else if (face == 1029) {
            GLStateManager.glMaterialBack(pname, params);
        } else if (face == 1032) {
            GLStateManager.glMaterialFront(pname, params);
            GLStateManager.glMaterialBack(pname, params);
        } else {
            throw new RuntimeException("Unsupported face value for glMaterial: " + face);
        }
    }

    public static void glMaterial(int face, int pname, IntBuffer params) {
        if (face == 1028) {
            GLStateManager.glMaterialFront(pname, params);
        } else if (face == 1029) {
            GLStateManager.glMaterialBack(pname, params);
        } else if (face == 1032) {
            GLStateManager.glMaterialFront(pname, params);
            GLStateManager.glMaterialBack(pname, params);
        } else {
            throw new RuntimeException("Unsupported face value for glMaterial: " + face);
        }
    }

    public static void glMaterialf(int face, int pname, float val) {
        if (pname != 5633) {
            return;
        }
        if (face == 1028) {
            frontMaterial.setShininess(val);
        } else if (face == 1029) {
            backMaterial.setShininess(val);
        } else if (face == 1032) {
            frontMaterial.setShininess(val);
            backMaterial.setShininess(val);
        } else {
            throw new RuntimeException("Unsupported face value for glMaterial: " + face);
        }
    }

    public static void glMateriali(int face, int pname, int val) {
        GLStateManager.glMaterialf(face, pname, val);
    }

    public static void glLight(int light, int pname, FloatBuffer params) {
        LightStateStack lightState = lightDataStates[light - 16384];
        switch (pname) {
            case 4608: {
                lightState.setAmbient(params);
                break;
            }
            case 4609: {
                lightState.setDiffuse(params);
                break;
            }
            case 4610: {
                lightState.setSpecular(params);
                break;
            }
            case 4611: {
                lightState.setPosition(params);
                break;
            }
            case 4612: {
                lightState.setSpotDirection(params);
                break;
            }
            case 4613: {
                lightState.setSpotExponent(params);
                break;
            }
            case 4614: {
                lightState.setSpotCutoff(params);
                break;
            }
            case 4615: {
                lightState.setConstantAttenuation(params);
                break;
            }
            case 4616: {
                lightState.setLinearAttenuation(params);
                break;
            }
            case 4617: {
                lightState.setQuadraticAttenuation(params);
                break;
            }
            default: {
                GL11.glLight((int)light, (int)pname, (FloatBuffer)params);
            }
        }
    }

    public static void glLight(int light, int pname, IntBuffer params) {
        LightStateStack lightState = lightDataStates[light - 16384];
        switch (pname) {
            case 4608: {
                lightState.setAmbient(params);
                break;
            }
            case 4609: {
                lightState.setDiffuse(params);
                break;
            }
            case 4610: {
                lightState.setSpecular(params);
                break;
            }
            case 4611: {
                lightState.setPosition(params);
                break;
            }
            case 4612: {
                lightState.setSpotDirection(params);
                break;
            }
            case 4613: {
                lightState.setSpotExponent(params);
                break;
            }
            case 4614: {
                lightState.setSpotCutoff(params);
                break;
            }
            case 4615: {
                lightState.setConstantAttenuation(params);
                break;
            }
            case 4616: {
                lightState.setLinearAttenuation(params);
                break;
            }
            case 4617: {
                lightState.setQuadraticAttenuation(params);
                break;
            }
            default: {
                GL11.glLight((int)light, (int)pname, (IntBuffer)params);
            }
        }
    }

    public static void glLightf(int light, int pname, float param) {
        LightStateStack lightState = lightDataStates[light - 16384];
        switch (pname) {
            case 4613: {
                lightState.setSpotExponent(param);
                break;
            }
            case 4614: {
                lightState.setSpotCutoff(param);
                break;
            }
            case 4615: {
                lightState.setConstantAttenuation(param);
                break;
            }
            case 4616: {
                lightState.setLinearAttenuation(param);
                break;
            }
            case 4617: {
                lightState.setQuadraticAttenuation(param);
                break;
            }
            default: {
                GL11.glLightf((int)light, (int)pname, (float)param);
            }
        }
    }

    public static void glLighti(int light, int pname, int param) {
        LightStateStack lightState = lightDataStates[light - 16384];
        switch (pname) {
            case 4613: {
                lightState.setSpotExponent(param);
                break;
            }
            case 4614: {
                lightState.setSpotCutoff(param);
                break;
            }
            case 4615: {
                lightState.setConstantAttenuation(param);
                break;
            }
            case 4616: {
                lightState.setLinearAttenuation(param);
                break;
            }
            case 4617: {
                lightState.setQuadraticAttenuation(param);
                break;
            }
            default: {
                GL11.glLighti((int)light, (int)pname, (int)param);
            }
        }
    }

    public static void glLightModel(int pname, FloatBuffer params) {
        switch (pname) {
            case 2899: {
                lightModel.setAmbient(params);
                break;
            }
            case 2897: {
                lightModel.setLocalViewer(params);
                break;
            }
            case 2898: {
                lightModel.setTwoSide(params);
                break;
            }
            default: {
                GL11.glLightModel((int)pname, (FloatBuffer)params);
            }
        }
    }

    public static void glLightModel(int pname, IntBuffer params) {
        switch (pname) {
            case 2899: {
                lightModel.setAmbient(params);
                break;
            }
            case 33272: {
                lightModel.setColorControl(params);
                break;
            }
            case 2897: {
                lightModel.setLocalViewer(params);
                break;
            }
            case 2898: {
                lightModel.setTwoSide(params);
                break;
            }
            default: {
                GL11.glLightModel((int)pname, (IntBuffer)params);
            }
        }
    }

    public static void glLightModelf(int pname, float param) {
        switch (pname) {
            case 2897: {
                lightModel.setLocalViewer(param);
                break;
            }
            case 2898: {
                lightModel.setTwoSide(param);
                break;
            }
            default: {
                GL11.glLightModelf((int)pname, (float)param);
            }
        }
    }

    public static void glLightModeli(int pname, int param) {
        switch (pname) {
            case 33272: {
                lightModel.setColorControl(param);
                break;
            }
            case 2897: {
                lightModel.setLocalViewer(param);
                break;
            }
            case 2898: {
                lightModel.setTwoSide(param);
                break;
            }
            default: {
                GL11.glLightModeli((int)pname, (int)param);
            }
        }
    }

    public static void glColorMaterial(int face, int mode) {
        if (GLStateManager.shouldBypassCache() || colorMaterialFace.getValue() != face || colorMaterialParameter.getValue() != mode) {
            colorMaterialFace.setValue(face);
            colorMaterialParameter.setValue(mode);
            GL11.glColorMaterial((int)face, (int)mode);
        }
    }

    public static void glDepthRange(double near, double far) {
        GL11.glDepthRange((double)near, (double)far);
    }

    public static void glUseProgram(int program) {
        if (program != activeProgram || GLStateManager.shouldBypassCache()) {
            activeProgram = program;
            if (AngelicaMod.lwjglDebug) {
                String programName = GLDebug.getObjectLabel(33506, program);
                GLDebug.debugMessage("Activating Program - " + program + ":" + programName);
            }
            GL20.glUseProgram((int)program);
        }
    }

    public static boolean vendorIsAMD() {
        return VENDOR == Vendor.AMD;
    }

    public static boolean vendorIsIntel() {
        return VENDOR == Vendor.INTEL;
    }

    public static boolean vendorIsMesa() {
        return VENDOR == Vendor.MESA;
    }

    public static boolean vendorIsNVIDIA() {
        return VENDOR == Vendor.NVIDIA;
    }

    @Generated
    public static boolean isPoppingAttributes() {
        return poppingAttributes;
    }

    @Generated
    public static Vendor getVENDOR() {
        return VENDOR;
    }

    @Generated
    public static TextureUnitArray getTextures() {
        return textures;
    }

    @Generated
    public static BlendStateStack getBlendState() {
        return blendState;
    }

    @Generated
    public static BooleanStateStack getBlendMode() {
        return blendMode;
    }

    @Generated
    public static BooleanStateStack getScissorTest() {
        return scissorTest;
    }

    @Generated
    public static DepthStateStack getDepthState() {
        return depthState;
    }

    @Generated
    public static BooleanStateStack getDepthTest() {
        return depthTest;
    }

    @Generated
    public static FogStateStack getFogState() {
        return fogState;
    }

    @Generated
    public static BooleanStateStack getFogMode() {
        return fogMode;
    }

    @Generated
    public static Color4Stack getColor() {
        return color;
    }

    @Generated
    public static Color4Stack getClearColor() {
        return clearColor;
    }

    @Generated
    public static ColorMaskStack getColorMask() {
        return colorMask;
    }

    @Generated
    public static IntegerStateStack getDrawBuffer() {
        return drawBuffer;
    }

    @Generated
    public static BooleanStateStack getCullState() {
        return cullState;
    }

    @Generated
    public static AlphaStateStack getAlphaState() {
        return alphaState;
    }

    @Generated
    public static BooleanStateStack getAlphaTest() {
        return alphaTest;
    }

    @Generated
    public static BooleanStateStack getLightingState() {
        return lightingState;
    }

    @Generated
    public static BooleanStateStack getRescaleNormalState() {
        return rescaleNormalState;
    }

    @Generated
    public static BooleanStateStack getNormalizeState() {
        return normalizeState;
    }

    @Generated
    public static BooleanStateStack getDitherState() {
        return ditherState;
    }

    @Generated
    public static BooleanStateStack getStencilTest() {
        return stencilTest;
    }

    @Generated
    public static BooleanStateStack getLineSmoothState() {
        return lineSmoothState;
    }

    @Generated
    public static BooleanStateStack getLineStippleState() {
        return lineStippleState;
    }

    @Generated
    public static BooleanStateStack getPointSmoothState() {
        return pointSmoothState;
    }

    @Generated
    public static BooleanStateStack getPolygonSmoothState() {
        return polygonSmoothState;
    }

    @Generated
    public static BooleanStateStack getPolygonStippleState() {
        return polygonStippleState;
    }

    @Generated
    public static BooleanStateStack getMultisampleState() {
        return multisampleState;
    }

    @Generated
    public static BooleanStateStack getSampleAlphaToCoverageState() {
        return sampleAlphaToCoverageState;
    }

    @Generated
    public static BooleanStateStack getSampleAlphaToOneState() {
        return sampleAlphaToOneState;
    }

    @Generated
    public static BooleanStateStack getSampleCoverageState() {
        return sampleCoverageState;
    }

    @Generated
    public static BooleanStateStack getColorLogicOpState() {
        return colorLogicOpState;
    }

    @Generated
    public static BooleanStateStack getIndexLogicOpState() {
        return indexLogicOpState;
    }

    @Generated
    public static BooleanStateStack getPolygonOffsetPointState() {
        return polygonOffsetPointState;
    }

    @Generated
    public static BooleanStateStack getPolygonOffsetLineState() {
        return polygonOffsetLineState;
    }

    @Generated
    public static BooleanStateStack getPolygonOffsetFillState() {
        return polygonOffsetFillState;
    }

    @Generated
    public static BooleanStateStack getAutoNormalState() {
        return autoNormalState;
    }

    @Generated
    public static BooleanStateStack getMap1Color4State() {
        return map1Color4State;
    }

    @Generated
    public static BooleanStateStack getMap1IndexState() {
        return map1IndexState;
    }

    @Generated
    public static BooleanStateStack getMap1NormalState() {
        return map1NormalState;
    }

    @Generated
    public static BooleanStateStack getMap1TextureCoord1State() {
        return map1TextureCoord1State;
    }

    @Generated
    public static BooleanStateStack getMap1TextureCoord2State() {
        return map1TextureCoord2State;
    }

    @Generated
    public static BooleanStateStack getMap1TextureCoord3State() {
        return map1TextureCoord3State;
    }

    @Generated
    public static BooleanStateStack getMap1TextureCoord4State() {
        return map1TextureCoord4State;
    }

    @Generated
    public static BooleanStateStack getMap1Vertex3State() {
        return map1Vertex3State;
    }

    @Generated
    public static BooleanStateStack getMap1Vertex4State() {
        return map1Vertex4State;
    }

    @Generated
    public static BooleanStateStack getMap2Color4State() {
        return map2Color4State;
    }

    @Generated
    public static BooleanStateStack getMap2IndexState() {
        return map2IndexState;
    }

    @Generated
    public static BooleanStateStack getMap2NormalState() {
        return map2NormalState;
    }

    @Generated
    public static BooleanStateStack getMap2TextureCoord1State() {
        return map2TextureCoord1State;
    }

    @Generated
    public static BooleanStateStack getMap2TextureCoord2State() {
        return map2TextureCoord2State;
    }

    @Generated
    public static BooleanStateStack getMap2TextureCoord3State() {
        return map2TextureCoord3State;
    }

    @Generated
    public static BooleanStateStack getMap2TextureCoord4State() {
        return map2TextureCoord4State;
    }

    @Generated
    public static BooleanStateStack getMap2Vertex3State() {
        return map2Vertex3State;
    }

    @Generated
    public static BooleanStateStack getMap2Vertex4State() {
        return map2Vertex4State;
    }

    @Generated
    public static BooleanStateStack[] getClipPlaneStates() {
        return clipPlaneStates;
    }

    @Generated
    public static MatrixModeStack getMatrixMode() {
        return matrixMode;
    }

    @Generated
    public static Matrix4fStack getModelViewMatrix() {
        return modelViewMatrix;
    }

    @Generated
    public static Matrix4fStack getProjectionMatrix() {
        return projectionMatrix;
    }

    @Generated
    public static BooleanStateStack[] getLightStates() {
        return lightStates;
    }

    @Generated
    public static LightStateStack[] getLightDataStates() {
        return lightDataStates;
    }

    @Generated
    public static BooleanStateStack getColorMaterial() {
        return colorMaterial;
    }

    @Generated
    public static IntegerStateStack getColorMaterialFace() {
        return colorMaterialFace;
    }

    @Generated
    public static IntegerStateStack getColorMaterialParameter() {
        return colorMaterialParameter;
    }

    @Generated
    public static LightModelStateStack getLightModel() {
        return lightModel;
    }

    @Generated
    public static MaterialStateStack getFrontMaterial() {
        return frontMaterial;
    }

    @Generated
    public static MaterialStateStack getBackMaterial() {
        return backMaterial;
    }

    @Generated
    public static ViewPortStateStack getViewportState() {
        return viewportState;
    }

    @Generated
    public static int getActiveProgram() {
        return activeProgram;
    }

    @Generated
    public static Thread getMainThread() {
        return MainThread;
    }

    @Generated
    public static void setRunningSplash(boolean runningSplash) {
        GLStateManager.runningSplash = runningSplash;
    }

    @Generated
    public static boolean isRunningSplash() {
        return runningSplash;
    }

    static {
        int i;
        BYPASS_CACHE = Boolean.parseBoolean(System.getProperty("angelica.disableGlCache", "false"));
        MAX_ATTRIB_STACK_DEPTH = GL11.glGetInteger((int)3381);
        MAX_MODELVIEW_STACK_DEPTH = GL11.glGetInteger((int)3382);
        MAX_PROJECTION_STACK_DEPTH = GL11.glGetInteger((int)3384);
        MAX_TEXTURE_STACK_DEPTH = GL11.glGetInteger((int)3385);
        MAX_TEXTURE_UNITS = GL11.glGetInteger((int)34930);
        MAX_CLIP_PLANES = GL11.glGetInteger((int)3378);
        HAS_MULTIPLE_SET = new GLFeatureSet();
        DEFAULT_DRAW_BUFFER = GL11.glGetInteger((int)3073);
        attribs = new IntArrayList(MAX_ATTRIB_STACK_DEPTH);
        activeTextureUnit = new IntegerStateStack(0);
        shadeModelState = new IntegerStateStack(7425);
        textures = new TextureUnitArray();
        blendState = new BlendStateStack();
        blendMode = new BooleanStateStack(3042);
        scissorTest = new BooleanStateStack(3089);
        depthState = new DepthStateStack();
        depthTest = new BooleanStateStack(2929);
        fogState = new FogStateStack();
        fogMode = new BooleanStateStack(2912);
        color = new Color4Stack();
        clearColor = new Color4Stack(new Color4(0.0f, 0.0f, 0.0f, 0.0f));
        colorMask = new ColorMaskStack();
        drawBuffer = new IntegerStateStack(DEFAULT_DRAW_BUFFER);
        cullState = new BooleanStateStack(2884);
        alphaState = new AlphaStateStack();
        alphaTest = new BooleanStateStack(3008);
        lightingState = new BooleanStateStack(2896);
        rescaleNormalState = new BooleanStateStack(32826);
        normalizeState = new BooleanStateStack(2977);
        ditherState = new BooleanStateStack(3024, true);
        stencilTest = new BooleanStateStack(2960);
        lineSmoothState = new BooleanStateStack(2848);
        lineStippleState = new BooleanStateStack(2852);
        pointSmoothState = new BooleanStateStack(2832);
        polygonSmoothState = new BooleanStateStack(2881);
        polygonStippleState = new BooleanStateStack(2882);
        multisampleState = new BooleanStateStack(32925, true);
        sampleAlphaToCoverageState = new BooleanStateStack(32926);
        sampleAlphaToOneState = new BooleanStateStack(32927);
        sampleCoverageState = new BooleanStateStack(32928);
        colorLogicOpState = new BooleanStateStack(3058);
        indexLogicOpState = new BooleanStateStack(3057);
        polygonOffsetPointState = new BooleanStateStack(10753);
        polygonOffsetLineState = new BooleanStateStack(10754);
        polygonOffsetFillState = new BooleanStateStack(32823);
        autoNormalState = new BooleanStateStack(3456);
        map1Color4State = new BooleanStateStack(3472);
        map1IndexState = new BooleanStateStack(3473);
        map1NormalState = new BooleanStateStack(3474);
        map1TextureCoord1State = new BooleanStateStack(3475);
        map1TextureCoord2State = new BooleanStateStack(3476);
        map1TextureCoord3State = new BooleanStateStack(3477);
        map1TextureCoord4State = new BooleanStateStack(3478);
        map1Vertex3State = new BooleanStateStack(3479);
        map1Vertex4State = new BooleanStateStack(3480);
        map2Color4State = new BooleanStateStack(3504);
        map2IndexState = new BooleanStateStack(3505);
        map2NormalState = new BooleanStateStack(3506);
        map2TextureCoord1State = new BooleanStateStack(3507);
        map2TextureCoord2State = new BooleanStateStack(3508);
        map2TextureCoord3State = new BooleanStateStack(3509);
        map2TextureCoord4State = new BooleanStateStack(3510);
        map2Vertex3State = new BooleanStateStack(3511);
        map2Vertex4State = new BooleanStateStack(3512);
        clipPlaneStates = new BooleanStateStack[MAX_CLIP_PLANES];
        matrixMode = new MatrixModeStack();
        modelViewMatrix = new Matrix4fStack(MAX_MODELVIEW_STACK_DEPTH);
        projectionMatrix = new Matrix4fStack(MAX_PROJECTION_STACK_DEPTH);
        lightStates = new BooleanStateStack[8];
        lightDataStates = new LightStateStack[8];
        colorMaterial = new BooleanStateStack(2903);
        colorMaterialFace = new IntegerStateStack(1032);
        colorMaterialParameter = new IntegerStateStack(5634);
        lightModel = new LightModelStateStack();
        frontMaterial = new MaterialStateStack(1028);
        backMaterial = new MaterialStateStack(1029);
        for (i = 0; i < lightStates.length; ++i) {
            GLStateManager.lightStates[i] = new BooleanStateStack(16384 + i);
            GLStateManager.lightDataStates[i] = new LightStateStack(16384 + i);
        }
        for (i = 0; i < MAX_CLIP_PLANES; ++i) {
            GLStateManager.clipPlaneStates[i] = new BooleanStateStack(12288 + i);
        }
        try {
            Field curr = ReflectionHelper.findField(Matrix4fStack.class, (String[])new String[]{"curr"});
            curr.setAccessible(true);
            MAT4_STACK_CURR_DEPTH = MethodHandles.lookup().unreflectGetter(curr);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        viewportState = new ViewPortStateStack();
        activeProgram = 0;
        blendFuncListener = null;
        fogToggleListener = null;
        fogModeListener = null;
        fogStartListener = null;
        fogEndListener = null;
        fogDensityListener = null;
        CurrentThread = MainThread = Thread.currentThread();
        runningSplash = true;
        glListMode = 0;
        glListNesting = 0;
        glListId = -1;
        glListStates = new Object2ObjectArrayMap();
        glListChanges = new Int2ObjectOpenHashMap();
        DirtyColor = new Color4(-1.0f, -1.0f, -1.0f, -1.0f);
        tempMatrix4f = new Matrix4f();
        conversionMatrix4d = new Matrix4d();
        conversionMatrix4f = new Matrix4f();
        rotation = new Vector3f();
        perspectiveMatrix = new Matrix4f();
        perspectiveBuffer = BufferUtils.createFloatBuffer((int)16);
    }

    public static class GLFeatureSet
    extends IntOpenHashSet {
        private static final long serialVersionUID = 8558779940775721010L;

        public GLFeatureSet addFeature(int feature) {
            super.add(feature);
            return this;
        }
    }
}

