/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.loading.fml.compat;

import com.gtnewhorizons.angelica.config.CompatConfig;
import com.gtnewhorizons.angelica.loading.fml.compat.ICompatHandler;
import com.gtnewhorizons.angelica.loading.fml.compat.handlers.ExtraUtilsCompatHandler;
import com.gtnewhorizons.angelica.loading.fml.compat.handlers.ImmersiveEngineeringCompatHandler;
import com.gtnewhorizons.angelica.loading.fml.compat.handlers.StacksOnStacksCompatHandler;
import com.gtnewhorizons.angelica.loading.fml.compat.handlers.ThaumcraftCompatHandler;
import com.gtnewhorizons.angelica.loading.fml.compat.handlers.ThaumicHorizonsCompatHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public enum CompatHandlers {
    STACKS_ON_STACKS(() -> CompatConfig.fixStacksOnStacks, new StacksOnStacksCompatHandler()),
    EXTRA_UTILS(() -> CompatConfig.fixExtraUtils, new ExtraUtilsCompatHandler()),
    IMMERSIVE_ENGINEERING(() -> CompatConfig.fixImmersiveEngineering, new ImmersiveEngineeringCompatHandler()),
    THAUMCRAFT(() -> CompatConfig.fixThaumcraft, new ThaumcraftCompatHandler()),
    THAUMIC_HORIZONS(() -> CompatConfig.fixThaumicHorizons, new ThaumicHorizonsCompatHandler());

    private final Supplier<Boolean> applyIf;
    private final ICompatHandler handler;
    private static List<ICompatHandler> compatHandlers;

    private CompatHandlers(Supplier<Boolean> applyIf, ICompatHandler handler) {
        this.applyIf = applyIf;
        this.handler = handler;
    }

    public static List<ICompatHandler> getHandlers() {
        if (compatHandlers != null) {
            return compatHandlers;
        }
        compatHandlers = new ArrayList<ICompatHandler>();
        for (CompatHandlers value : CompatHandlers.values()) {
            if (!value.applyIf.get().booleanValue()) continue;
            compatHandlers.add(value.handler);
        }
        return compatHandlers;
    }

    public static List<String> getTransformers() {
        List<ICompatHandler> handlers = CompatHandlers.getHandlers();
        if (handlers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> transformers = new ArrayList<String>();
        for (ICompatHandler handler : handlers) {
            if (handler.extraTransformers() == null) continue;
            transformers.addAll(handler.extraTransformers());
        }
        transformers.add("com.gtnewhorizons.angelica.loading.fml.transformers.GenericCompatTransformer");
        return transformers;
    }

    static {
        compatHandlers = null;
    }
}

