/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.util;

import java.awt.Color;
import java.util.Random;
import makeo.gadomancy.common.utils.MiscUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;

public class UtilsFX {
    private static final Color[] RUNE_COLORS_RED = new Color[]{new Color(11929351), new Color(15611778), new Color(15956768), new Color(16738082), new Color(16739632), new Color(0xFF0000)};
    private static final Color[] RUNE_COLORS_GREEN = new Color[]{new Color(87593), new Color(957440), new Color(65536), new Color(130816), new Color(85054)};
    private static final Color[] RUNE_COLORS_BLUE = new Color[]{new Color(395606), new Color(75128), new Color(791894), new Color(65791), new Color(65932)};

    public static void doRuneEffects(World world, int x, int y, int z, int colorFlag) {
        if (world.field_72995_K) {
            int cnt = 20;
            while (cnt > 0) {
                --cnt;
                Color rand = UtilsFX.evaluateRandomColor(world.field_73012_v, colorFlag);
                Thaumcraft.proxy.blockRunes(world, (double)((float)x + UtilsFX.randomOffset(world)), (double)((float)y + UtilsFX.randomOffset(world)), (double)((float)z + UtilsFX.randomOffset(world)), (float)rand.getRed() / 255.0f, (float)rand.getGreen() / 255.0f, (float)rand.getBlue() / 255.0f, world.field_73012_v.nextInt(10) + 30, -0.01f - (world.field_73012_v.nextBoolean() ? (world.field_73012_v.nextBoolean() ? 0.02f : 0.01f) : 0.0f));
            }
        }
    }

    private static Color evaluateRandomColor(Random rand, int colorFlag) {
        Color[] possibleColors = colorFlag == 1 ? RUNE_COLORS_BLUE : RUNE_COLORS_RED;
        return possibleColors[rand.nextInt(possibleColors.length)];
    }

    private static float randomOffset(World worldObj) {
        return worldObj.field_73012_v.nextFloat() * (float)(worldObj.field_73012_v.nextBoolean() ? 1 : -1) / 2.0f;
    }

    public static void doSparkleEffectsAround(World world, int x, int y, int z) {
        for (ChunkCoordinates cc : MiscUtils.getCoordinatesAround(new ChunkCoordinates(x, y, z))) {
            UtilsFX.doSparkleEffects(world, cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
        }
    }

    public static void doSparkleEffects(World world, int x, int y, int z) {
        Thaumcraft.proxy.blockSparkle(world, x, y, z, -9999, 10);
    }

    public static void doSmokeEffects(World world, int x, int y, int z, float size) {
        int count = world.field_73012_v.nextInt(6) + 2;
        for (int i = 0; i < count; ++i) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntitySmokeFX(world, (double)x + 0.5 + UtilsFX.randEffectOffset(world.field_73012_v), (double)y + 0.5 + UtilsFX.randEffectOffset(world.field_73012_v), (double)z + 0.5 + UtilsFX.randEffectOffset(world.field_73012_v), UtilsFX.randEffectOffset(world.field_73012_v) * (double)0.01f, UtilsFX.randEffectOffset(world.field_73012_v) * (double)0.1f, UtilsFX.randEffectOffset(world.field_73012_v) * (double)0.01f, size));
        }
    }

    public static void doSmokeEffectsAround(World world, int x, int y, int z, float size) {
        for (ChunkCoordinates cc : MiscUtils.getCoordinatesAround(new ChunkCoordinates(x, y, z))) {
            UtilsFX.doSmokeEffects(world, cc.field_71574_a, cc.field_71572_b, cc.field_71573_c, size);
        }
    }

    private static double randEffectOffset(Random rand) {
        return rand.nextDouble() * (double)(rand.nextBoolean() ? -1 : 1);
    }
}

