/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.gui.controls;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityHowlerAlarm;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearNetworkHelper;

@SideOnly(value=Side.CLIENT)
public class GuiHowlerAlarmListBox
extends GuiButton {
    private static final String TEXTURE_FILE = "nuclearcontrol:textures/gui/GUIHowlerAlarm.png";
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("nuclearcontrol:textures/gui/GUIHowlerAlarm.png");
    private static final int BASIC_X_OFFSET = 2;
    private static final int BASIC_Y_OFFSET = 2;
    private static final int SCROLL_WIDTH = 10;
    private static final int SCROLL_BUTTON_HEIGHT = 8;
    public int fontColor;
    public int selectedColor;
    public int selectedFontColor;
    private int scrollTop;
    private List<String> items;
    private TileEntityHowlerAlarm alarm;
    public int lineHeight;
    private int sliderHeight;
    public boolean dragging;
    private int sliderY;
    private int dragDelta;

    public GuiHowlerAlarmListBox(int id, int left, int top, int width, int height, List<String> items, TileEntityHowlerAlarm alarm) {
        super(id, left, top, width, height, "");
        this.items = items;
        this.alarm = alarm;
        this.fontColor = 0x404040;
        this.selectedColor = -12566464;
        this.selectedFontColor = 0xA0A0A0;
        this.scrollTop = 0;
        this.lineHeight = 0;
        this.sliderHeight = 0;
        this.dragging = false;
        this.dragDelta = 0;
    }

    private void scrollTo(int pos) {
        int max;
        this.scrollTop = pos;
        if (this.scrollTop < 0) {
            this.scrollTop = 0;
        }
        if ((max = this.lineHeight * this.items.size() + 2 - this.field_146121_g) < 0) {
            max = 0;
        }
        if (this.scrollTop > max) {
            this.scrollTop = max;
        }
    }

    public void scrollUp() {
        this.scrollTop -= 8;
        if (this.scrollTop < 0) {
            this.scrollTop = 0;
        }
    }

    public void scrollDown() {
        this.scrollTop += 8;
        int max = this.lineHeight * this.items.size() + 2 - this.field_146121_g;
        if (max < 0) {
            max = 0;
        }
        if (this.scrollTop > max) {
            this.scrollTop = max;
        }
    }

    public void func_146112_a(Minecraft minecraft, int cursorX, int cursorY) {
        if (this.dragging) {
            int pos = (cursorY - this.field_146129_i - 8 - this.dragDelta) * (this.lineHeight * this.items.size() + 2 - this.field_146121_g) / Math.max(this.field_146121_g - 16 - this.sliderHeight, 1);
            this.scrollTo(pos);
        }
        FontRenderer fontRenderer = minecraft.field_71466_p;
        String currentItem = this.alarm.getSoundName();
        if (this.lineHeight == 0) {
            float scale;
            this.lineHeight = fontRenderer.field_78288_b + 2;
            if (this.scrollTop == 0) {
                int rowsPerHeight = this.field_146121_g / this.lineHeight;
                int currentIndex = this.items.indexOf(currentItem);
                if (currentIndex >= rowsPerHeight) {
                    this.scrollTop = (currentIndex + 1) * this.lineHeight + 2 - this.field_146121_g;
                }
            }
            if ((scale = (float)this.field_146121_g / ((float)this.lineHeight * (float)this.items.size() + 2.0f)) > 1.0f) {
                scale = 1.0f;
            }
            this.sliderHeight = Math.round(scale * (float)(this.field_146121_g - 16));
            if (this.sliderHeight < 4) {
                this.sliderHeight = 4;
            }
        }
        int rowTop = 2;
        GL11.glEnable((int)3089);
        Minecraft mc = FMLClientHandler.instance().getClient();
        ScaledResolution scaler = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        GL11.glScissor((int)(this.field_146128_h * scaler.func_78325_e()), (int)(mc.field_71440_d - (this.field_146129_i + this.field_146121_g) * scaler.func_78325_e()), (int)((this.field_146120_f - 10) * scaler.func_78325_e()), (int)(this.field_146121_g * scaler.func_78325_e()));
        for (String row : this.items) {
            if (row.equals(currentItem)) {
                GuiHowlerAlarmListBox.func_73734_a((int)this.field_146128_h, (int)(this.field_146129_i + rowTop - this.scrollTop - 1), (int)(this.field_146128_h + this.field_146120_f - 10), (int)(this.field_146129_i + rowTop - this.scrollTop + this.lineHeight - 1), (int)this.selectedColor);
                fontRenderer.func_78276_b(row, this.field_146128_h + 2, this.field_146129_i + rowTop - this.scrollTop, this.selectedFontColor);
            } else {
                fontRenderer.func_78276_b(row, this.field_146128_h + 2, this.field_146129_i + rowTop - this.scrollTop, this.fontColor);
            }
            rowTop += this.lineHeight;
        }
        GL11.glDisable((int)3089);
        int sliderX = this.field_146128_h + this.field_146120_f - 10 + 1;
        this.sliderY = this.field_146129_i + 8 + (this.field_146121_g - 16 - this.sliderHeight) * this.scrollTop / (this.lineHeight * this.items.size() + 2 - this.field_146121_g);
        GL11.glBindTexture((int)3553, (int)minecraft.field_71446_o.func_110581_b(TEXTURE_LOCATION).func_110552_b());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(sliderX, this.sliderY, 131, 16, 9, 1);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)sliderX, (double)(this.sliderY + this.sliderHeight - 1), (double)this.field_73735_i, 0.51171875, 0.0703125);
        tessellator.func_78374_a((double)(sliderX + 10 - 1), (double)(this.sliderY + this.sliderHeight - 1), (double)this.field_73735_i, 0.546875, 0.0703125);
        tessellator.func_78374_a((double)(sliderX + 10 - 1), (double)(this.sliderY + 1), (double)this.field_73735_i, 0.546875, 0.06640625);
        tessellator.func_78374_a((double)sliderX, (double)(this.sliderY + 1), (double)this.field_73735_i, 0.51171875, 0.06640625);
        tessellator.func_78381_a();
        this.func_73729_b(sliderX, this.sliderY + this.sliderHeight - 1, 131, 19, 9, 1);
    }

    private void setCurrent(int targetY) {
        String newSound;
        if (this.lineHeight == 0) {
            return;
        }
        int itemIndex = (targetY - 2 - this.field_146129_i + this.scrollTop) / this.lineHeight;
        if (itemIndex >= this.items.size()) {
            itemIndex = this.items.size() - 1;
        }
        if (!(newSound = this.items.get(itemIndex)).equals(this.alarm.getSoundName())) {
            if (this.alarm.func_145831_w().field_72995_K) {
                NuclearNetworkHelper.setNewAlarmSound(this.alarm.field_145851_c, this.alarm.field_145848_d, this.alarm.field_145849_e, (byte)0, newSound);
            }
            this.alarm.setSoundName(newSound);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_146116_c(Minecraft minecraft, int targetX, int targetY) {
        if (!super.func_146116_c(minecraft, targetX, targetY)) return false;
        if (targetX > this.field_146128_h + this.field_146120_f - 10) {
            if (targetY - this.field_146129_i < 8) {
                this.scrollUp();
                return false;
            } else if (this.field_146121_g + this.field_146129_i - targetY < 8) {
                this.scrollDown();
                return false;
            } else {
                if (targetY < this.sliderY || targetY > this.sliderY + this.sliderHeight) return false;
                this.dragging = true;
                this.dragDelta = targetY - this.sliderY;
            }
            return false;
        } else {
            this.setCurrent(targetY);
            return true;
        }
    }

    public void func_146118_a(int i, int j) {
        super.func_146118_a(i, j);
        this.dragging = false;
    }
}

