/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.abstracts;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicCrop;
import ic2.api.crops.ICropTile;
import java.util.Arrays;
import java.util.List;

public abstract class BasicBerryCrop
extends BasicCrop {
    public int tier() {
        return 2;
    }

    public int stat(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    @Override
    public List<String> getCropInformation() {
        return Arrays.asList("Has increased Nutrient requirements (x1.2)", "Has decreased humidity and air requirements (x0.9)");
    }

    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)((double)humidity / 0.9 + (double)nutrients / 1.2 + (double)air / 0.9);
    }

    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        if (crop.getSize() >= this.maxSize() - 1) {
            return 200;
        }
        return 700;
    }

    public byte getSizeAfterHarvest(ICropTile crop) {
        return 2;
    }

    public int maxSize() {
        return 3;
    }

    @Override
    public String discoveredBy() {
        return "bartimaeusnek";
    }
}

