/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.savedata.types;

import chylex.hee.system.savedata.WorldSavefile;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;

public class ApocalypseSavefile
extends WorldSavefile {
    private Map<String, byte[]> rituals = new HashMap<String, byte[]>();
    private TObjectIntHashMap<String> times = new TObjectIntHashMap();

    public ApocalypseSavefile(String filename) {
        super(filename);
    }

    public boolean addRitual(String username, byte biomeId) {
        byte[] ritualArray = this.rituals.get(username);
        if (ritualArray == null) {
            ritualArray = new byte[]{biomeId};
            this.rituals.put(username, ritualArray);
        } else if (!ArrayUtils.contains((byte[])ritualArray, (byte)biomeId)) {
            ArrayUtils.add((byte[])ritualArray, (byte)biomeId);
        }
        if (ritualArray.length >= IslandBiomeBase.biomeList.size()) {
            this.addApocalypseTime(username);
            return true;
        }
        return false;
    }

    public boolean hasFinishedRitual(String username, byte biomeId) {
        return ArrayUtils.contains((byte[])this.rituals.get(username), (byte)biomeId);
    }

    public boolean isMidApocalypse(String username) {
        return this.times.containsKey((Object)username);
    }

    public void addApocalypseTime(String username) {
        this.times.adjustOrPutValue((Object)username, 1, 1);
    }

    public int getApocalypseTime(String username) {
        int time = this.times.get((Object)username);
        return time == this.times.getNoEntryValue() ? 0 : time;
    }

    public void resetApocalypseTime(String username) {
        this.times.remove((Object)username);
    }

    @Override
    protected void onSave(NBTTagCompound nbt) {
        NBTTagCompound ritualTag = nbt.func_74775_l("rituals");
        for (Map.Entry<String, byte[]> entry : this.rituals.entrySet()) {
            ritualTag.func_74773_a(entry.getKey(), entry.getValue());
        }
        nbt.func_74782_a("rituals", (NBTBase)ritualTag);
        NBTTagCompound timeTag = nbt.func_74775_l("times");
        for (String username : this.times.keySet()) {
            timeTag.func_74777_a(username, (short)this.times.get((Object)username));
        }
        nbt.func_74782_a("times", (NBTBase)timeTag);
    }

    @Override
    protected void onLoad(NBTTagCompound nbt) {
        NBTTagCompound ritualTag = nbt.func_74775_l("rituals");
        for (String key : ritualTag.func_150296_c()) {
            this.rituals.put(key, ritualTag.func_74770_j(key));
        }
        NBTTagCompound timeTag = nbt.func_74775_l("times");
        for (String key : timeTag.func_150296_c()) {
            this.times.put((Object)key, (int)timeTag.func_74765_d(key));
        }
    }
}

