/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.Frame;
import openmods.calc.ICallable;
import openmods.utils.OptionalInt;
import openmods.utils.StackValidationException;

public abstract class FixedCallable<E>
implements ICallable<E> {
    protected final int argCount;
    protected final int resultCount;

    public FixedCallable(int argCount, int resultCount) {
        this.argCount = argCount;
        this.resultCount = resultCount;
    }

    @Override
    public final void call(Frame<E> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
        if (!argumentsCount.compareIfPresent(this.argCount)) {
            throw new StackValidationException("Expected %s argument(s) but got %s", this.argCount, argumentsCount.get());
        }
        if (!returnsCount.compareIfPresent(this.resultCount)) {
            throw new StackValidationException("Has %s result(s) but expected %s", this.resultCount, returnsCount.get());
        }
        this.call(frame);
    }

    public abstract void call(Frame<E> var1);
}

