/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.client.gui;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.client.gui.GuiContainerTabbed;
import de.katzenpapst.amunra.client.gui.tabs.AbstractTab;
import de.katzenpapst.amunra.client.gui.tabs.TabMothershipCustom;
import de.katzenpapst.amunra.client.gui.tabs.TabMothershipLanding;
import de.katzenpapst.amunra.client.gui.tabs.TabMothershipUsage;
import de.katzenpapst.amunra.inventory.ContainerMothershipSettings;
import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.network.packet.PacketSimpleAR;
import de.katzenpapst.amunra.tile.TileEntityMothershipSettings;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiMothershipSettings
extends GuiContainerTabbed {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("amunra", "textures/gui/ms_settings.png");
    private final TileEntityMothershipSettings tile;
    private final Mothership ship;
    protected List<ResourceLocation> mothershipTextures;

    public GuiMothershipSettings(InventoryPlayer par1InventoryPlayer, TileEntityMothershipSettings tile) {
        super(new ContainerMothershipSettings(par1InventoryPlayer, tile));
        this.field_147000_g = 201;
        this.field_146999_f = 176;
        this.tile = tile;
        this.mothershipTextures = AmunRa.instance.getPossibleMothershipTextures();
        this.ship = tile.getMothership();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GUI_TEXTURE);
        int xOffset = (this.field_146294_l - this.field_146999_f) / 2;
        int yOffset = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xOffset, yOffset, 0, 0, this.field_146999_f, this.field_147000_g);
        GL11.glPopMatrix();
    }

    public void mothershipOperationFailed(String message) {
        AbstractTab curTab = this.getActiveTab();
        if (curTab instanceof IMothershipSettingsTab) {
            ((IMothershipSettingsTab)((Object)curTab)).mothershipOperationFailed(message);
        }
    }

    public void mothershipResponsePacketRecieved() {
        AbstractTab curTab = this.getActiveTab();
        if (curTab instanceof IMothershipSettingsTab) {
            ((IMothershipSettingsTab)((Object)curTab)).mothershipResponsePacketRecieved();
        }
    }

    public void sendMothershipSettingsPacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.ship.writeSettingsToNBT(nbt);
        AmunRa.packetPipeline.sendToServer(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.S_SET_MOTHERSHIP_SETTINGS, this.ship.getID(), nbt));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab(new TabMothershipCustom(this.tile, this, this.field_146297_k, this.field_146294_l, this.field_146295_m, this.field_146999_f, this.field_147000_g));
        this.addTab(new TabMothershipLanding(this.tile, this, this.field_146297_k, this.field_146294_l, this.field_146295_m, this.field_146999_f, this.field_147000_g));
        this.addTab(new TabMothershipUsage(this.tile, this, this.field_146297_k, this.field_146294_l, this.field_146295_m, this.field_146999_f, this.field_147000_g));
    }

    public static interface IMothershipSettingsTab {
        public void mothershipResponsePacketRecieved();

        public void mothershipOperationFailed(String var1);
    }
}

