/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees.allele.effect;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import magicbees.bees.AlleleEffect;
import magicbees.bees.BeeManager;
import magicbees.bees.allele.effect.EffectData;
import magicbees.bees.allele.effect.TransmutationEffectController;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class AlleleEffectTransmuting
extends AlleleEffect {
    private TransmutationEffectController transmutationController;

    public AlleleEffectTransmuting(String id, boolean isDominant, TransmutationEffectController effectController, int timeoutBeeTicks) {
        super(id, isDominant, timeoutBeeTicks);
        this.transmutationController = effectController;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    protected IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        ChunkCoordinates coords = housing.getCoordinates();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int[] randomCoords = new int[3];
        for (int i = 0; i < 3; ++i) {
            int range = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[i]);
            if (range <= 0) continue;
            randomCoords[i] = world.field_73012_v.nextInt(range) - range / 2;
        }
        int xCoord = coords.field_71574_a + randomCoords[0];
        int yCoord = coords.field_71572_b + randomCoords[1];
        int zCoord = coords.field_71573_c + randomCoords[2];
        BiomeGenBase biome = world.func_72807_a(xCoord, zCoord);
        this.transmutationController.attemptTransmutations(world, biome, new ItemStack(world.func_147439_a(xCoord, yCoord, zCoord), 1, world.func_72805_g(xCoord, yCoord, zCoord)), xCoord, yCoord, zCoord);
        storedData.setInteger(0, 0);
        return storedData;
    }
}

