/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.BeeManager;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import java.io.File;
import java.lang.reflect.Field;
import magicbees.block.BlockApimancersDrainer;
import magicbees.block.BlockEffectJar;
import magicbees.block.BlockEnchantedEarth;
import magicbees.block.BlockHive;
import magicbees.block.BlockMagicApiary;
import magicbees.block.BlockManaAuraProvider;
import magicbees.block.BlockVisAuraProvider;
import magicbees.block.types.HiveType;
import magicbees.item.ItemCapsule;
import magicbees.item.ItemComb;
import magicbees.item.ItemDrop;
import magicbees.item.ItemMagicHive;
import magicbees.item.ItemMagicHiveFrame;
import magicbees.item.ItemManasteelGrafter;
import magicbees.item.ItemManasteelScoop;
import magicbees.item.ItemMiscResources;
import magicbees.item.ItemMoonDial;
import magicbees.item.ItemMysteriousMagnet;
import magicbees.item.ItemNugget;
import magicbees.item.ItemPollen;
import magicbees.item.ItemPropolis;
import magicbees.item.ItemThaumiumGrafter;
import magicbees.item.ItemThaumiumScoop;
import magicbees.item.ItemVoidGrafter;
import magicbees.item.ItemVoidScoop;
import magicbees.item.ItemWax;
import magicbees.item.types.CapsuleType;
import magicbees.item.types.HiveFrameType;
import magicbees.item.types.NuggetType;
import magicbees.item.types.ResourceType;
import magicbees.item.types.WaxType;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.LogHelper;
import magicbees.main.utils.compat.BotaniaHelper;
import magicbees.main.utils.compat.ThaumcraftHelper;
import magicbees.storage.BackpackDefinition;
import magicbees.tileentity.TileEntityApimancersDrainerGT;
import magicbees.tileentity.TileEntityEffectJar;
import magicbees.tileentity.TileEntityMagicApiary;
import magicbees.tileentity.TileEntityManaAuraProvider;
import magicbees.tileentity.TileEntityVisAuraProvider;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;
import thaumicenergistics.implementaion.ThEAPIImplementation;

public class Config {
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_CLIENT = "client";
    public static final String CATEGORY_DEBUG = "debug";
    public static final String CATEGORY_MODULES = "modules";
    public static final String CATEGORY_BOTANIA = "botaniaPlugin";
    public static boolean drawParticleEffects;
    public static boolean beeInfusionsAdded;
    public static boolean thaumaturgeBackpackActive;
    public static boolean addThaumcraftItemsToBackpacks;
    public static boolean disableUpdateNotification;
    public static boolean areMagicPlanksFlammable;
    public static boolean useImpregnatedStickInTools;
    public static boolean moonDialShowsPhaseInText;
    public static boolean doSpecialHiveGen;
    public static String thaumaturgeExtraItems;
    public static int capsuleStackSizeMax;
    public static boolean logHiveSpawns;
    public static double thaumcraftSaplingDroprate;
    public static int aromaticLumpSwarmerRate;
    public static int thaumcraftNodeMaxSize;
    public static int drainerTimeBetween;
    public static int drainerAmount;
    public static int drainerCapacity;
    public static boolean arsMagicaActive;
    public static boolean baublesActive;
    public static boolean bloodMagicActive;
    public static boolean equivalentExchangeActive;
    public static boolean extraBeesActive;
    public static boolean redstoneArsenalActive;
    public static boolean thaumcraftActive;
    public static boolean thaumicHorizonsActive;
    public static boolean thermalFoundationActive;
    public static boolean botaniaActive;
    public static boolean ae2Active;
    public static float magnetBaseRange;
    public static float magnetLevelMultiplier;
    public static int magnetMaxLevel;
    public static boolean forestryDebugEnabled;
    public static BlockEnchantedEarth enchantedEarth;
    public static BlockEffectJar effectJar;
    public static BlockHive hive;
    public static BlockMagicApiary magicApiary;
    public static BlockApimancersDrainer apimancersDrainer;
    public static BlockManaAuraProvider manaAuraProvider;
    public static BlockVisAuraProvider visAuraProvider;
    public static ItemComb combs;
    public static ItemWax wax;
    public static ItemPropolis propolis;
    public static ItemDrop drops;
    public static ItemPollen pollen;
    public static ItemMiscResources miscResources;
    public static ItemFood jellyBaby;
    public static Item manasteelScoop;
    public static Item thaumiumScoop;
    public static Item manasteelGrafter;
    public static Item thaumiumGrafter;
    public static ItemNugget nuggets;
    public static ItemMoonDial moonDial;
    public static ItemMysteriousMagnet magnet;
    public static Item voidScoop;
    public static Item voidGrafter;
    public static boolean disableMagnetSound;
    public static ItemCapsule magicCapsule;
    public static ItemCapsule voidCapsule;
    public static ItemMagicHiveFrame hiveFrameMagic;
    public static ItemMagicHiveFrame hiveFrameResilient;
    public static ItemMagicHiveFrame hiveFrameGentle;
    public static ItemMagicHiveFrame hiveFrameMetabolic;
    public static ItemMagicHiveFrame hiveFrameNecrotic;
    public static ItemMagicHiveFrame hiveFrameTemporal;
    public static ItemMagicHiveFrame hiveFrameOblivion;
    public static Item thaumaturgeBackpackT1;
    public static Item thaumaturgeBackpackT2;
    public static BackpackDefinition thaumaturgeBackpackDef;
    public static Configuration configuration;
    public static boolean isGTLoaded;
    public static boolean isGTNHCoreModLoaded;
    public static boolean isThaumicEnergisticsLoaded;

    public Config(File configFile) {
        configuration = new Configuration(configFile);
        configuration.load();
        this.processConfigFile();
        forestryDebugEnabled = new File("./config/forestry/DEBUG.ON").exists();
        configuration.save();
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("MagicBees")) {
            if (configuration.hasChanged()) {
                configuration.save();
            }
            this.syncConfigs();
        }
    }

    public void saveConfigs() {
        configuration.save();
    }

    public void setupBlocks() {
        enchantedEarth = new BlockEnchantedEarth();
        GameRegistry.registerBlock((Block)enchantedEarth, (String)"magicbees.enchantedEarth");
        this.setupHives();
        this.setupEffectJar();
        this.setupApiary();
        this.setupBotaniaBlocks();
        this.setupThaumcraftBlocks();
    }

    public void setupItems() {
        combs = new ItemComb();
        wax = new ItemWax();
        propolis = new ItemPropolis();
        drops = new ItemDrop();
        miscResources = new ItemMiscResources();
        pollen = new ItemPollen();
        moonDial = new ItemMoonDial();
        this.setupJellyBaby();
        this.setupNuggets();
        this.setupMysteriousMagnet();
        this.setupFrames();
        magicCapsule = new ItemCapsule(CapsuleType.MAGIC, capsuleStackSizeMax);
        voidCapsule = new ItemCapsule(CapsuleType.VOID, capsuleStackSizeMax);
        this.setupThaumcraftItems();
        this.setupBotaniaItems();
        this.setupOreDictionaryEntries();
        this.setupMiscForestryItemHooks();
    }

    public void setupThaumicEnergistics() {
        if (isThaumicEnergisticsLoaded) {
            try {
                Class<? extends TileEntity> c = BlockApimancersDrainer.drainer;
                ThEAPIImplementation.instance().transportPermissions().addAspectStorageTileToExtractPermissions(c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processConfigFile() {
        try {
            Field f = Class.forName("forestry.core.config.Config").getField("enableParticleFX");
            drawParticleEffects = f.getBoolean(null);
        }
        catch (Exception e) {
            LogHelper.warn("Failed to retrieve Forestry's bee particle FX setting. This is not critical, but should be reported so it can be fixed.");
            LogHelper.debug(e);
        }
        this.syncConfigs();
    }

    private void syncConfigs() {
        this.doGeneralConfigs();
        this.doModuleConfigs();
        this.doDebugConfigs();
    }

    private void doDebugConfigs() {
        Property p = configuration.get(CATEGORY_DEBUG, "logHiveSpawns", false);
        p.comment = "Enable to see exact locations of MagicBees hive spawns.";
        logHiveSpawns = p.getBoolean();
    }

    private void doModuleConfigs() {
        Property p = configuration.get(CATEGORY_MODULES, "ArsMagica", true);
        arsMagicaActive = p.getBoolean();
        p = configuration.get(CATEGORY_MODULES, "Baubles", true);
        baublesActive = p.getBoolean();
        p = configuration.get(CATEGORY_MODULES, "BloodMagic", true);
        bloodMagicActive = p.getBoolean();
        p = configuration.get(CATEGORY_MODULES, "EquivalentExchange", true);
        equivalentExchangeActive = p.getBoolean();
        p = configuration.get(CATEGORY_MODULES, "ExtraBees", true);
        extraBeesActive = p.getBoolean();
        p = configuration.get(CATEGORY_MODULES, "RedstoneArsenal", true);
        redstoneArsenalActive = p.getBoolean();
        p = configuration.get(CATEGORY_MODULES, "Thaumcraft", true);
        thaumcraftActive = p.getBoolean();
        p = configuration.get(CATEGORY_MODULES, "ThaumicHorizons", true);
        thaumicHorizonsActive = p.getBoolean();
        p = configuration.get(CATEGORY_MODULES, "ThermalExpansion", true);
        thermalFoundationActive = p.getBoolean();
        p = configuration.get(CATEGORY_MODULES, "Botania", true);
        botaniaActive = p.getBoolean();
        BotaniaHelper.doBotaniaModuleConfigs(configuration);
        p = configuration.get(CATEGORY_MODULES, "AppliedEnergistics2", true);
        ae2Active = p.getBoolean();
    }

    private void doGeneralConfigs() {
        Property p = configuration.get(CATEGORY_GENERAL, "backpack.thaumaturge.active", true);
        p.comment = "Set to false to disable the Thaumaturge backpack";
        thaumaturgeBackpackActive = p.getBoolean(true);
        p = configuration.get(CATEGORY_GENERAL, "backpack.thaumaturge.additionalItems", "");
        p.comment = "Add additional items to the Thaumaturge's Backpack.\n Format is the same as Forestry's: id:meta;id;id:meta (etc)";
        thaumaturgeExtraItems = p.getString();
        p = configuration.get(CATEGORY_GENERAL, "backpack.forestry.addThaumcraftItems", true);
        p.comment = "Set to true if you want MagicBees to add several Thaumcraft blocks & items to Forestry backpacks.\n Set to false to disable.";
        addThaumcraftItemsToBackpacks = p.getBoolean(true);
        p = configuration.get(CATEGORY_GENERAL, "capsuleStackSize", 64);
        p.comment = "Allows you to edit the stack size of the capsules in MagicBees if using GregTech, \nor the reduced capsule size in Forestry & Railcraft. Default: 64";
        capsuleStackSizeMax = p.getInt();
        p = configuration.get(CATEGORY_GENERAL, "disableVersionNotification", false);
        p.comment = "Set to true to stop Magic Bees from notifying you when new updates are available. (Does not supress critical updates)";
        disableUpdateNotification = p.getBoolean(false);
        p = configuration.get(CATEGORY_GENERAL, "areMagicPlanksFlammable", false);
        p.comment = "Set to true to allow Greatwood & Silverwood planks to burn in a fire.";
        areMagicPlanksFlammable = p.getBoolean(false);
        p = configuration.get(CATEGORY_GENERAL, "useImpregnatedStickInTools", false);
        p.comment = "Set to true to make Thaumium Grafter & Scoop require impregnated sticks in the recipe.";
        useImpregnatedStickInTools = p.getBoolean(false);
        p = configuration.get(CATEGORY_GENERAL, "thaumcraftSaplingDroprate", 0.1, "The chance for thaumcraft saplings using the thaumium grafter", 0.0, 1.0);
        thaumcraftSaplingDroprate = p.getDouble(0.1);
        p = configuration.get(CATEGORY_GENERAL, "thaumcraftNodeMaxSize", 256, "The maximum aspect amount Nexus bees can grow a node to", 64, Short.MAX_VALUE);
        thaumcraftNodeMaxSize = p.getInt(256);
        p = configuration.get(CATEGORY_GENERAL, "drainerTimeBetween", 200, "The time in ticks between Apimancer's Drainer essentia generation", 1, Short.MAX_VALUE);
        drainerTimeBetween = p.getInt(200);
        p = configuration.get(CATEGORY_GENERAL, "drainerAmount", 1, "The amount that the Apimancer's Drainer generates on every round", 1, Short.MAX_VALUE);
        drainerAmount = p.getInt(1);
        p = configuration.get(CATEGORY_GENERAL, "drainerCapacity", 512, "The amount that the Apimancer's Drainer can hold of each aspect", 1, Short.MAX_VALUE);
        drainerCapacity = p.getInt(512);
        p = configuration.get(CATEGORY_GENERAL, "moonDialShowText", false);
        p.comment = "set to true to show the current moon phase in mouse-over text.";
        moonDialShowsPhaseInText = p.getBoolean(false);
        p = configuration.get(CATEGORY_GENERAL, "doSpecialHiveGen", true);
        p.comment = "Set to false if you hate fun and do not want special hives generating in Magic biomes.";
        doSpecialHiveGen = p.getBoolean(true);
        p = configuration.get(CATEGORY_GENERAL, "magnetRangeBase", 3.0);
        p.comment = "Base range (in blocks) of the Mysterious Magnet";
        magnetBaseRange = (float)p.getDouble(3.0);
        p = configuration.get(CATEGORY_GENERAL, "magnetRangeMultiplier", 0.75);
        p.comment = "Range multiplier per level of the Mysterious Magnet. Total range = base range + level * multiplier";
        magnetLevelMultiplier = (float)p.getDouble(0.75);
        p = configuration.get(CATEGORY_GENERAL, "magnetMaximumLevel", 8);
        p.comment = "Maximum level of the magnets.";
        magnetMaxLevel = p.getInt();
        p = configuration.get(CATEGORY_GENERAL, "aromaticLumpSwarmerRate", 95);
        p.comment = "Aromatic lump swarmer rate. Final value is X/1000. 0 will disable, values outside of [0,1000] will be clamped to range. Default: 95";
        aromaticLumpSwarmerRate = p.getInt();
        p = configuration.get(CATEGORY_CLIENT, "disableMagnetSound", false);
        p.comment = "set to true to disable the magnet from making noise on item pickup";
        disableMagnetSound = p.getBoolean();
    }

    private void setupEffectJar() {
        effectJar = new BlockEffectJar();
        GameRegistry.registerBlock((Block)effectJar, (String)"effectJar");
        GameRegistry.registerTileEntity(TileEntityEffectJar.class, (String)"magicbees.effectJar");
    }

    private void setupApiary() {
        magicApiary = new BlockMagicApiary();
        GameRegistry.registerBlock((Block)magicApiary, (String)"magicApiary");
        GameRegistry.registerTileEntity(TileEntityMagicApiary.class, (String)"magicbees.magicApiary");
    }

    private void setupFrames() {
        hiveFrameMagic = new ItemMagicHiveFrame(HiveFrameType.MAGIC);
        hiveFrameResilient = new ItemMagicHiveFrame(HiveFrameType.RESILIENT);
        hiveFrameGentle = new ItemMagicHiveFrame(HiveFrameType.GENTLE);
        hiveFrameMetabolic = new ItemMagicHiveFrame(HiveFrameType.METABOLIC);
        hiveFrameNecrotic = new ItemMagicHiveFrame(HiveFrameType.NECROTIC);
        hiveFrameTemporal = new ItemMagicHiveFrame(HiveFrameType.TEMPORAL);
        hiveFrameOblivion = new ItemMagicHiveFrame(HiveFrameType.OBLIVION);
        ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack((Item)hiveFrameOblivion), 1, 1, 18));
        ChestGenHooks.addItem((String)"strongholdLibrary", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack((Item)hiveFrameOblivion), 1, 3, 23));
    }

    private void setupHives() {
        hive = new BlockHive();
        GameRegistry.registerBlock((Block)hive, ItemMagicHive.class, (String)"hive");
        for (HiveType t : HiveType.values()) {
            hive.setHarvestLevel("scoop", 0, t.ordinal());
        }
    }

    private void setupMysteriousMagnet() {
        magnet = new ItemMysteriousMagnet();
        GameRegistry.registerItem((Item)magnet, (String)"magnet", (String)"magicbees");
    }

    private void setupJellyBaby() {
        jellyBaby = new ItemFood(1, false).func_77848_i().func_77844_a(Potion.field_76424_c.field_76415_H, 5, 1, 1.0f);
        jellyBaby.func_77655_b("magicbees:jellyBabies").func_111206_d("magicbees:jellyBabies");
        GameRegistry.registerItem((Item)jellyBaby, (String)"jellyBabies");
    }

    private void setupNuggets() {
        nuggets = new ItemNugget();
        for (NuggetType type : NuggetType.values()) {
            LogHelper.info("Found nugget of type " + type.toString());
            String item = type.toString().toLowerCase();
            item = Character.toString(item.charAt(0)).toUpperCase() + item.substring(1);
            if (OreDictionary.getOres((String)("ingot" + item)).size() > 0 || OreDictionary.getOres((String)("nugget" + item)).size() > 0) continue;
            LogHelper.info("Disabled nugget " + type.toString());
            type.setInactive();
        }
        GameRegistry.registerItem((Item)nuggets, (String)"beeNugget");
    }

    private void setupOreDictionaryEntries() {
        for (int level = 0; level <= 8; ++level) {
            OreDictionary.registerOre((String)("mb.magnet.level" + level), (ItemStack)new ItemStack((Item)magnet, 1, level * 2));
            OreDictionary.registerOre((String)("mb.magnet.level" + level), (ItemStack)new ItemStack((Item)magnet, 1, level * 2 + 1));
        }
        OreDictionary.registerOre((String)"beeComb", (ItemStack)new ItemStack((Item)combs, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"waxMagical", (ItemStack)wax.getStackForType(WaxType.MAGIC));
        OreDictionary.registerOre((String)"waxMagical", (ItemStack)wax.getStackForType(WaxType.AMNESIC));
        OreDictionary.registerOre((String)"nuggetIron", (ItemStack)nuggets.getStackForType(NuggetType.IRON));
        OreDictionary.registerOre((String)"nuggetCopper", (ItemStack)nuggets.getStackForType(NuggetType.COPPER));
        OreDictionary.registerOre((String)"nuggetTin", (ItemStack)nuggets.getStackForType(NuggetType.TIN));
        OreDictionary.registerOre((String)"nuggetSilver", (ItemStack)nuggets.getStackForType(NuggetType.SILVER));
        OreDictionary.registerOre((String)"nuggetLead", (ItemStack)nuggets.getStackForType(NuggetType.LEAD));
        OreDictionary.registerOre((String)"nuggetDiamond", (ItemStack)nuggets.getStackForType(NuggetType.DIAMOND));
        OreDictionary.registerOre((String)"nuggetEmerald", (ItemStack)nuggets.getStackForType(NuggetType.EMERALD));
        OreDictionary.registerOre((String)"nuggetApatite", (ItemStack)nuggets.getStackForType(NuggetType.APATITE));
    }

    private void setupBotaniaItems() {
        if (BotaniaHelper.isActive()) {
            manasteelScoop = new ItemManasteelScoop();
            GameRegistry.registerItem((Item)manasteelScoop, (String)manasteelScoop.func_77658_a(), (String)"magicbees");
            manasteelGrafter = new ItemManasteelGrafter();
            GameRegistry.registerItem((Item)manasteelGrafter, (String)manasteelGrafter.func_77658_a(), (String)"magicbees");
        }
    }

    private void setupBotaniaBlocks() {
        if (BotaniaHelper.isActive()) {
            manaAuraProvider = new BlockManaAuraProvider();
            GameRegistry.registerBlock((Block)manaAuraProvider, (String)"manaAuraProvider");
            GameRegistry.registerTileEntity(TileEntityManaAuraProvider.class, (String)"manaAuraProvider");
        }
    }

    private void setupThaumcraftBlocks() {
        if (ThaumcraftHelper.isActive()) {
            visAuraProvider = new BlockVisAuraProvider();
            GameRegistry.registerBlock((Block)visAuraProvider, (String)"visAuraProvider");
            GameRegistry.registerTileEntity(TileEntityVisAuraProvider.class, (String)"visAuraProvider");
            if (isGTNHCoreModLoaded) {
                BlockApimancersDrainer.drainer = TileEntityApimancersDrainerGT.class;
            }
            apimancersDrainer = new BlockApimancersDrainer();
            GameRegistry.registerBlock((Block)apimancersDrainer, (String)"apimancersDrainer");
            GameRegistry.registerTileEntity(BlockApimancersDrainer.drainer, (String)"apimancersDrainer");
        }
    }

    private void setupThaumcraftItems() {
        if (ThaumcraftHelper.isActive()) {
            this.setupThaumcraftBackpacks();
            thaumiumScoop = new ItemThaumiumScoop();
            GameRegistry.registerItem((Item)thaumiumScoop, (String)thaumiumScoop.func_77658_a(), (String)"magicbees");
            thaumiumGrafter = new ItemThaumiumGrafter();
            GameRegistry.registerItem((Item)thaumiumGrafter, (String)thaumiumGrafter.func_77658_a(), (String)"magicbees");
            voidScoop = new ItemVoidScoop();
            GameRegistry.registerItem((Item)voidScoop, (String)voidScoop.func_77658_a(), (String)"magicbees");
            voidGrafter = new ItemVoidGrafter();
            GameRegistry.registerItem((Item)voidGrafter, (String)voidGrafter.func_77658_a(), (String)"magicbees");
        }
    }

    private void setupThaumcraftBackpacks() {
        try {
            String backpackName = LocalizationManager.getLocalizedString("backpack.thaumaturge");
            BackpackDefinition def = new BackpackDefinition("thaumaturge", backpackName, 8847558);
            thaumaturgeBackpackT1 = BackpackManager.backpackInterface.addBackpack((IBackpackDefinition)def, EnumBackpackType.T1);
            thaumaturgeBackpackT1.func_77655_b("backpack.thaumaturgeT1");
            GameRegistry.registerItem((Item)thaumaturgeBackpackT1, (String)"backpack.thaumaturgeT1");
            thaumaturgeBackpackT2 = BackpackManager.backpackInterface.addBackpack((IBackpackDefinition)def, EnumBackpackType.T2);
            thaumaturgeBackpackT2.func_77655_b("backpack.thaumaturgeT2");
            GameRegistry.registerItem((Item)thaumaturgeBackpackT2, (String)"backpack.thaumaturgeT2");
            if (thaumaturgeExtraItems.length() > 0) {
                LogHelper.info("Attempting to add extra items to Thaumaturge's backpack. If you get an error, check your MagicBees.conf.");
                FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)("thaumaturge@" + thaumaturgeExtraItems));
            }
        }
        catch (Exception e) {
            LogHelper.error("MagicBees encountered a problem during loading!");
            LogHelper.error("Could not register backpacks via Forestry. Check your FML Client log and see if Forestry crashed silently.");
        }
    }

    private void setupMiscForestryItemHooks() {
        if (aromaticLumpSwarmerRate > 0) {
            aromaticLumpSwarmerRate = Math.min(aromaticLumpSwarmerRate, 1000);
            BeeManager.inducers.put(miscResources.getStackForType(ResourceType.AROMATIC_LUMP), aromaticLumpSwarmerRate);
        }
    }

    static {
        isGTLoaded = Loader.isModLoaded((String)"gregtech");
        isGTNHCoreModLoaded = Loader.isModLoaded((String)"gregtech") && Loader.isModLoaded((String)"dreamcraft");
        isThaumicEnergisticsLoaded = Loader.isModLoaded((String)"thaumicenergistics");
    }
}

