/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.IRunicArmor;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.item.ItemMod;

@Optional.Interface(modid="Thaumcraft", iface="thaumcraft.api.IRunicArmor")
public abstract class ItemBauble
extends ItemMod
implements IBauble,
ICosmeticAttachable,
IPhantomInkable,
IRunicArmor {
    private static final String TAG_BAUBLE_UUID_MOST = "baubleUUIDMost";
    private static final String TAG_BAUBLE_UUID_LEAST = "baubleUUIDLeast";
    private static final String TAG_COSMETIC_ITEM = "cosmeticItem";
    private static final String TAG_PHANTOM_INK = "phantomInk";

    public ItemBauble(String name) {
        this.func_77625_d(1);
        this.func_77655_b(name);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!EntityDoppleganger.isTruePlayer((Entity)player)) {
            return stack;
        }
        if (this.canEquip(stack, (EntityLivingBase)player)) {
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack stackInSlot;
                if (!baubles.func_94041_b(i, stack) || (stackInSlot = baubles.func_70301_a(i)) != null && !((IBauble)stackInSlot.func_77973_b()).canUnequip(stackInSlot, (EntityLivingBase)player)) continue;
                if (!world.field_72995_K) {
                    baubles.func_70299_a(i, stack.func_77946_l());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                }
                if (stackInSlot == null) break;
                ((IBauble)stackInSlot.func_77973_b()).onUnequipped(stackInSlot, (EntityLivingBase)player);
                return stackInSlot.func_77946_l();
            }
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> infoList, boolean advanced) {
        if (GuiScreen.func_146272_n()) {
            this.addHiddenTooltip(stack, player, infoList, advanced);
        } else {
            this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.shiftinfo"), infoList);
        }
    }

    public void addHiddenTooltip(ItemStack stack, EntityPlayer player, List<String> infoList, boolean adv) {
        ItemStack cosmetic;
        BaubleType type = this.getBaubleType(stack);
        this.addStringToTooltip(StatCollector.func_74838_a((String)("botania.baubletype." + type.name().toLowerCase())), infoList);
        String key = RenderHelper.getKeyDisplayString("Baubles Inventory");
        if (key != null && !key.equals("NONE")) {
            this.addStringToTooltip(StatCollector.func_74838_a((String)"botania.baubletooltip").replaceAll("%key%", key), infoList);
        }
        if ((cosmetic = this.getCosmeticItem(stack)) != null) {
            this.addStringToTooltip(String.format(StatCollector.func_74838_a((String)"botaniamisc.hasCosmetic"), cosmetic.func_82833_r()), infoList);
        }
        if (this.hasPhantomInk(stack)) {
            this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.hasPhantomInk"), infoList);
        }
    }

    public void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
    }

    public void onPlayerLoad(ItemStack stack, EntityLivingBase player) {
        this.onEquippedOrLoadedIntoWorld(stack, player);
    }

    public void onEquipped(ItemStack stack, EntityLivingBase player) {
        if (player != null) {
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_72956_a((Entity)player, "botania:equipBauble", 0.1f, 1.3f);
            }
            if (player instanceof EntityPlayer) {
                ((EntityPlayer)player).func_71064_a((StatBase)ModAchievements.baubleWear, 1);
            }
            this.onEquippedOrLoadedIntoWorld(stack, player);
        }
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
    }

    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
    }

    @Override
    public ItemStack getCosmeticItem(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_COSMETIC_ITEM, true);
        if (cmp == null) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)cmp);
    }

    @Override
    public void setCosmeticItem(ItemStack stack, ItemStack cosmetic) {
        NBTTagCompound cmp = new NBTTagCompound();
        if (cosmetic != null) {
            cosmetic.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_COSMETIC_ITEM, cmp);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getContainerItem(stack) != null;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return this.getCosmeticItem(itemStack);
    }

    public boolean func_77630_h(ItemStack stack) {
        return false;
    }

    public static UUID getBaubleUUID(ItemStack stack) {
        long most = ItemNBTHelper.getLong(stack, TAG_BAUBLE_UUID_MOST, 0L);
        if (most == 0L) {
            UUID uuid = UUID.randomUUID();
            ItemNBTHelper.setLong(stack, TAG_BAUBLE_UUID_MOST, uuid.getMostSignificantBits());
            ItemNBTHelper.setLong(stack, TAG_BAUBLE_UUID_LEAST, uuid.getLeastSignificantBits());
            return ItemBauble.getBaubleUUID(stack);
        }
        long least = ItemNBTHelper.getLong(stack, TAG_BAUBLE_UUID_LEAST, 0L);
        return new UUID(most, least);
    }

    @Override
    public boolean hasPhantomInk(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_PHANTOM_INK, false);
    }

    @Override
    public void setPhantomInk(ItemStack stack, boolean ink) {
        ItemNBTHelper.setBoolean(stack, TAG_PHANTOM_INK, ink);
    }

    @Optional.Method(modid="Thaumcraft")
    public int getRunicCharge(ItemStack itemstack) {
        return 0;
    }
}

